/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentProperty;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.Text;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Vector;

public class DocumentWriter {
    protected static int writeToDatabase(Document document) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("DELETE FROM TIGRIS.CATEGORY WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (DocumentWriter.writeBaseInfo(document, stringBuffer)) {
            if (DocumentWriter.writeGraphics(document, stringBuffer)) {
                if (DocumentWriter.writeLocale(document, stringBuffer)) {
                    if (DocumentWriter.writeCategories(document, stringBuffer)) {
                        if (DocumentWriter.writeFileAttachments(document, stringBuffer)) {
                            if (DocumentWriter.writeStatus(document, stringBuffer)) {
                                if (DocumentWriter.writeProperties(document, stringBuffer)) {
                                    if (DocumentWriter.writeBFTM(document, stringBuffer)) {
                                        if (DocumentWriter.writeQueryText(document, stringBuffer)) {
                                            if (stringBuffer.length() > 1 && (n = SqlRunner.sqlRunnerCode(1, stringBuffer.toString())) == 0) {
                                                if (document.getDocumentType() == 9) {
                                                    DocumentWriter.writeAdditionalInfo(document);
                                                } else {
                                                    DocumentWriter.writeBody(document);
                                                }
                                            }
                                        } else {
                                            n = -10;
                                        }
                                    } else {
                                        n = -9;
                                    }
                                } else {
                                    n = -11;
                                }
                            } else {
                                n = -8;
                            }
                        } else {
                            n = -7;
                        }
                    } else {
                        n = -5;
                    }
                } else {
                    n = -4;
                }
            } else {
                n = -3;
            }
        } else {
            n = -2;
        }
        return n;
    }

    private static final boolean writeBaseInfo(Document document, StringBuffer stringBuffer) {
        boolean bl = true;
        String string = Text.cleanNullableDBString(document.getEMailableDate());
        String string2 = Text.cleanNullableDBString(document.getPartNumber());
        String string3 = Text.cleanNullableDBString(document.getHotNewsDate());
        switch (document.getRecStatus()) {
            case 3: {
                stringBuffer.append("UPDATE TIGRIS.DOCUMENTS " + "SET PUBLISH     = 'N', " + "    RECYCLED    = 'Y', " + "    DBUSER      = '" + document.getLastTouchedBy() + "', " + "    CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
                break;
            }
            case 1: {
                stringBuffer.append("UPDATE TIGRIS.DOCUMENTS " + "SET PUBLISH       = 'Y', " + "    RECYCLED      = 'N', " + "    DBUSER        = '" + document.getLastTouchedBy() + "', " + "    CHANGEDTIME   = CURRENT TIMESTAMP, " + "    DOCTYPEIND    = " + document.getDocumentType() + ", " + "    DOCCLASSIND   = " + document.getDocumentClass() + ", " + "    TITLE         = '" + Text.cleanDBString(document.getTitle()) + "', " + "    OWNER         = '" + Text.cleanDBString(document.getOwner()) + "', " + "    REVIEWPERIOD  = " + document.getMonthsToReview() + ", " + "    AUTHIND       = 0, " + "    KNOWLEDGEBASE = '" + Text.getYN(document.getKnowledgeBase()) + "', " + "    WEBABLE       = '" + Text.getYN(document.getWebable()) + "', " + "    WEBONLY       = '" + Text.getYN(document.getWebOnly()) + "', " + "    FAXABLE       = '" + Text.getYN(document.getFaxable()) + "', " + "    FLASHNEWS     = '" + Text.getYN(document.getHotNews()) + "', " + "    FLASHDATE     = " + string3 + ", " + "    FAQ           = '" + Text.getYN(document.getFaq()) + "', " + "    EMAILABLE     = '" + Text.getYN(document.getEMailable()) + "', " + "    EMAILABLEDATE = " + string + ", " + "    SUMMARY       = '" + Text.cleanDBString(document.getEMailComments()) + "', " + "    METRICIND     = " + document.getMetric() + ", " + "    PARTNUM       = " + string2 + ", " + "    PUBTYPE       = " + document.getPublicationType() + ", " + "    LNDOCID       = '" + Text.cleanDBString(document.getFilename()) + "', " + "    SOURCE        = '" + Text.cleanDBString(document.getSource()) + "', " + "    SHOW          = 'N', " + "    WORKIND       = 2, " + "    MAINTLOCK     = 'N' " + "WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
                break;
            }
            case 2: {
                stringBuffer.append("INSERT INTO TIGRIS.DOCUMENTS " + "( DOCIND, " + "  PUBLISH, " + "  RECYCLED, " + "  DBUSER, " + "  CHANGEDTIME, " + "  DOCTYPEIND, " + "  DOCCLASSIND, " + "  TITLE, " + "  OWNER, " + "  REVIEWPERIOD, " + "  AUTHIND, " + "  KNOWLEDGEBASE, " + "  WEBABLE, " + "  WEBONLY, " + "  FAXABLE, " + "  FLASHNEWS, " + "  FLASHDATE, " + "  FAQ, " + "  EMAILABLE, " + "  EMAILABLEDATE, " + "  SUMMARY, " + "  METRICIND, " + "  PARTNUM, " + "  PUBTYPE, " + "  LNDOCID, " + "  SOURCE, " + "  SHOW, " + "  WORKIND, " + "  MAINTLOCK ) values " + "(    " + document.getDocInd() + ", " + "     'Y', " + "     'N', " + "     '" + document.getLastTouchedBy() + "', " + "     CURRENT TIMESTAMP, " + "     " + document.getDocumentType() + ", " + "     " + document.getDocumentClass() + ", " + "     '" + Text.cleanDBString(document.getTitle()) + "', " + "     '" + Text.cleanDBString(document.getOwner()) + "', " + "     " + document.getMonthsToReview() + ", " + "     0, " + "     '" + Text.getYN(document.getKnowledgeBase()) + "', " + "     '" + Text.getYN(document.getWebable()) + "', " + "     '" + Text.getYN(document.getWebOnly()) + "', " + "     '" + Text.getYN(document.getFaxable()) + "', " + "     '" + Text.getYN(document.getHotNews()) + "', " + "     " + string3 + ", " + "     '" + Text.getYN(document.getFaq()) + "', " + "     '" + Text.getYN(document.getEMailable()) + "', " + "     " + string + ", " + "     '" + Text.cleanDBString(document.getEMailComments()) + "', " + "     " + document.getMetric() + ", " + "     " + string2 + ", " + "     " + document.getPublicationType() + ", " + "     '" + Text.cleanDBString(document.getFilename()) + "', " + "     '" + Text.cleanDBString(document.getSource()) + "', " + "     'N', " + "     2, " + "     'N' ) " + SqlRunner.END_DELIM);
                break;
            }
        }
        return bl;
    }

    private static final boolean writeGraphics(Document document, StringBuffer stringBuffer) {
        boolean bl = true;
        Vector vector = document.getGraphics();
        stringBuffer.append("DELETE FROM TIGNEW.GRAPHICS WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (vector != null && vector.size() > 0) {
            DocumentGraphic documentGraphic = null;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (documentGraphic != null && documentGraphic.valid()) {
                    stringBuffer.append("INSERT INTO TIGNEW.GRAPHICS " + "( DOCIND, FILENAME ) " + "values " + "( " + document.getDocInd() + ", " + "  '" + documentGraphic.getFilename() + "')" + SqlRunner.END_DELIM);
                }
                ++n;
            }
        }
        return bl;
    }

    private static final boolean writeLocale(Document document, StringBuffer stringBuffer) {
        LocaleRec localeRec = document.getLocale();
        boolean bl = false;
        stringBuffer.append("DELETE FROM TIGRIS.DOCGEO     WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM TIGRIS.DOCCOUNTRY WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (localeRec != null) {
            Object var4_4 = null;
            Object var5_5 = null;
            if (localeRec.isWorldWide()) {
                stringBuffer.append("INSERT INTO TIGRIS.DOCGEO " + "( DOCIND, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + " ( " + document.getDocInd() + ", " + "   6, " + "   '" + document.getLastTouchedBy() + "', " + "   CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
            } else {
                int n;
                Vector vector = localeRec.getGeoListContainingAll();
                Vector vector2 = localeRec.getSingleCountryList();
                int n2 = 0;
                if (vector != null && vector.size() > 0) {
                    n = vector.size();
                    while (n2 < n) {
                        stringBuffer.append("INSERT INTO TIGRIS.DOCGEO " + "(DOCIND, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + " ( " + document.getDocInd() + ", " + "   " + ((TypeGeoRec)vector.elementAt(n2)).getInd() + "," + "   '" + document.getLastTouchedBy() + "', " + "   CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                        ++n2;
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n = vector2.size();
                    n2 = 0;
                    while (n2 < n) {
                        stringBuffer.append("INSERT INTO TIGRIS.DOCCOUNTRY " + "(DOCIND, COUNTRYCODEIND, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + document.getDocInd() + ", " + "  " + ((TypeCountryCodeRec)vector2.elementAt(n2)).getInd() + ", " + "  '" + document.getLastTouchedBy() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                        ++n2;
                    }
                }
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean writeCategories(Document document, StringBuffer stringBuffer) {
        boolean bl = false;
        Vector vector = document.getCategory();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            TypeCategoryRec typeCategoryRec = null;
            while (n < n2) {
                typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                stringBuffer.append("INSERT INTO TIGRIS.CATEGORY " + "(DOCIND, TYPECATIND )" + "values " + "( " + document.getDocInd() + ", " + "  " + typeCategoryRec.getInd() + ")" + SqlRunner.END_DELIM);
                ++n;
            }
        }
        bl = true;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean writeBody(Document document) throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "writeBody", 5);
        DocumentBody documentBody = document.getDocumentBody();
        boolean bl = true;
        Statement statement = sQLMethod.createStatement();
        try {
            Vector vector;
            statement.executeUpdate("DELETE FROM TIGRIS.DOCBODY WHERE DOCIND = " + document.getDocInd());
            statement.close();
            if (documentBody != null && (documentBody.getRecStatus() == 2 || documentBody.getRecStatus() == 1) && (vector = documentBody.getBodyChunks()) != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    PreparedStatement preparedStatement = sQLMethod.createPreparedStatement("INSERT INTO TIGRIS.DOCBODY " + "(DOCIND, recnum, BODY, DBUSER, CHANGEDTIME) " + "values ( " + document.getDocInd() + ", " + "         " + (n + 1) + ", " + "         ?, " + "         '" + document.getLastTouchedBy() + "', " + "         CURRENT TIMESTAMP )");
                    preparedStatement.setString(1, (String)vector.elementAt(n));
                    preparedStatement.execute();
                    preparedStatement.close();
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw exception;
        }
        sQLMethod.close();
        return bl;
    }

    private static final boolean writeFileAttachments(Document document, StringBuffer stringBuffer) throws Exception {
        boolean bl = true;
        Vector vector = document.getFileAttachments();
        stringBuffer.append("DELETE FROM TIGRIS.DOCFILES WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            DocumentFile documentFile = null;
            while (n < n2) {
                documentFile = (DocumentFile)vector.elementAt(n);
                if (documentFile != null && documentFile.valid()) {
                    stringBuffer.append("INSERT INTO TIGRIS.DOCFILES (DOCIND, FILENAME, DESCRIPT, SIZE, URL, VERSION, FTPMODE, ORDERNUM) " + "values " + "( " + document.getDocInd() + ", " + "  '" + Text.cleanDBString(documentFile.getFilename()) + "', " + "  '" + Text.cleanDBString(documentFile.getDescription()) + "', " + "  " + documentFile.getSize() + ", " + "  '" + Text.cleanDBString(documentFile.getURL()) + "', " + "  '" + Text.cleanDBString(documentFile.getVersion()) + "', " + "  " + documentFile.getFTPMode() + ", " + "  " + documentFile.getOrderNum() + " )" + SqlRunner.END_DELIM);
                }
                ++n;
            }
        }
        return bl;
    }

    private static final boolean writeStatus(Document document, StringBuffer stringBuffer) {
        if (document.getStatus() != null) {
            document.getStatus().setDocInd(document.getDocInd());
            stringBuffer.append(document.getStatus().toSQL());
        }
        return true;
    }

    private static final boolean writeQueryText(Document document, StringBuffer stringBuffer) {
        stringBuffer.append("DELETE FROM TIGRIS.DOCQUERYTEXT WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (document.getQueryText() != null && document.getQueryText().toString().length() > 0) {
            stringBuffer.append("INSERT INTO TIGRIS.DOCQUERYTEXT " + "values ( " + document.getDocInd() + ", " + "         '" + Text.cleanDBString(document.getQueryText().toString()) + "', " + "         'QUEST', " + "         CURRENT TIMESTAMP)" + SqlRunner.END_DELIM);
        }
        return true;
    }

    private static final boolean writeBFTM(Document document, StringBuffer stringBuffer) {
        int n;
        int n2;
        Vector vector = document.getBrands();
        Vector vector2 = document.getFamilies();
        Vector vector3 = document.getModels();
        Vector vector4 = document.getMachines();
        Vector vector5 = new Vector();
        if (vector != null && vector.size() > 0) {
            n2 = 0;
            n = vector.size();
            while (n2 < n) {
                if (!vector5.contains(vector.elementAt(n2))) {
                    vector5.addElement(vector.elementAt(n2));
                }
                ++n2;
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            n2 = 0;
            n = vector2.size();
            while (n2 < n) {
                if (!vector5.contains(vector2.elementAt(n2))) {
                    vector5.addElement(vector2.elementAt(n2));
                }
                ++n2;
            }
        }
        if (vector3 != null && vector3.size() > 0) {
            n2 = 0;
            n = vector3.size();
            while (n2 < n) {
                if (!vector5.contains(vector3.elementAt(n2))) {
                    vector5.addElement(vector3.elementAt(n2));
                }
                ++n2;
            }
        }
        if (vector4 != null && vector4.size() > 0) {
            n2 = 0;
            n = vector4.size();
            while (n2 < n) {
                if (!vector5.contains(vector4.elementAt(n2))) {
                    vector5.addElement(vector4.elementAt(n2));
                }
                ++n2;
            }
        }
        if (vector5.size() > 0) {
            n2 = 0;
            n = vector5.size();
            while (n2 < n) {
                stringBuffer.append("INSERT INTO TIGRIS.CATEGORY (DOCIND, TYPECATIND) " + "VALUES ( " + document.getDocInd() + ", " + ((TypeCategoryRec)vector5.elementAt(n2)).getInd() + ")" + SqlRunner.END_DELIM);
                ++n2;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean writeAdditionalInfo(Document document) throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "writeAddInfo", 5);
        String string = document.getAdditionalInfo();
        boolean bl = true;
        Statement statement = sQLMethod.createStatement();
        try {
            PreparedStatement preparedStatement = sQLMethod.createPreparedStatement("UPDATE TIGRIS.DOCUMENTS " + "SET ADDINFO = ? " + "WHERE DOCIND = " + document.getDocInd());
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw exception;
        }
        sQLMethod.close();
        return bl;
    }

    private static final boolean writeProperties(Document document, StringBuffer stringBuffer) {
        Vector vector = document.getProperties();
        stringBuffer.append("DELETE FROM TIGRIS.DOCPROPERTIES WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            DocumentProperty documentProperty = null;
            while (n < n2) {
                documentProperty = (DocumentProperty)vector.elementAt(n);
                if (documentProperty.getValue() != null) {
                    stringBuffer.append("INSERT INTO TIGRIS.DOCPROPERTIES VALUES (" + "" + document.getDocInd() + ", " + "" + documentProperty.getPropertyInd() + ", " + "" + documentProperty.getOrderNum() + ", " + "'" + Text.cleanDBString(documentProperty.getValue()) + "', " + "USER, " + "CURRENT TIMESTAMP)" + SqlRunner.END_DELIM);
                }
                ++n;
            }
        }
        return true;
    }
}

