/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.DraftObject;
import com.ibm.nzna.projects.common.quest.oa.OAMode;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.oaValidate.ValidationRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Statement;
import java.util.Vector;

public class ActionDraft
extends Action
implements DraftObject {
    static final long serialVersionUID = 1000000L;
    private int activeActionInd_ = 0;
    private boolean maintLock_;
    private String startDate_ = "";
    private String stopDate_ = null;
    private boolean recycled_;
    private TypeWorkRec typeWork_ = null;
    private String comments_ = "";

    public int getActiveActionInd() {
        return this.activeActionInd_;
    }

    public void setActiveActionInd(int n) {
        this.activeActionInd_ = n;
    }

    public boolean getMaintLock() {
        return this.maintLock_;
    }

    public void setMaintLock(boolean bl) {
        this.maintLock_ = bl;
        this.updateRecStatus(1);
    }

    public String getStartDate() {
        return this.startDate_;
    }

    public void setStartDate(String string) {
        this.startDate_ = string;
    }

    public String getStopDate() {
        return this.stopDate_;
    }

    public void setStopDate(String string) {
        this.stopDate_ = string;
    }

    public boolean isRecycled() {
        return this.recycled_;
    }

    public void setRecycled(boolean bl) {
        this.recycled_ = bl;
        this.updateRecStatus(1);
    }

    public TypeWorkRec getTypeWorkRequired() {
        return this.typeWork_;
    }

    public void setTypeWorkRequired(TypeWorkRec typeWorkRec) {
        this.typeWork_ = typeWorkRec;
        this.updateRecStatus(1);
    }

    public ValidationRec validate() {
        LogSystem.log(2, ">>> Starting ActionDraft.validate()");
        SQLMethod sQLMethod = new SQLMethod(1, "", 10);
        ValidationRec validationRec = null;
        try {
            block5: {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAValidate", 3);
                    callableStatement.registerOutParameter(3, -4);
                    callableStatement.setInt(1, this.getInd());
                    callableStatement.setInt(2, 100);
                    callableStatement.execute();
                    validationRec = (ValidationRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    callableStatement.close();
                    if (validationRec == null) {
                        LogSystem.log(2, "ValidationRec was returned null");
                    }
                    if (validationRec == null || !validationRec.error) break block5;
                    LogSystem.log(2, validationRec.errorStr);
                    validationRec = null;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    validationRec = null;
                    Object var4_6 = null;
                    sQLMethod.close();
                }
            }
            Object var4_5 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> ActionDraft.validate() complete");
        return validationRec;
    }

    boolean assignMyDatabaseKey() {
        boolean bl = true;
        if (this.actionInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for ActionDraft");
            this.actionInd_ = Counter.getCounter(LogSystem.getInstance(), "DACTNIND");
            if (this.actionInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for ActionDraft");
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        int n;
        block15: {
            SQLMethod sQLMethod;
            block14: {
                LogSystem.log(2, ">>> Starting ActionDraft.writeToDatabase()");
                if (!this.assignDatabaseKeys()) {
                    return -1;
                }
                sQLMethod = new SQLMethod(1, "ActionDraft.writeToDatabase()", 10);
                n = 0;
                StoredProcRec storedProcRec = null;
                try {
                    try {
                        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ExtSqlRunner", 3);
                        String string = ActionDraftWriter.getSQL(this);
                        if (string.length() == 0) {
                            LogSystem.log(1, "No changes to be written");
                            int n2 = 0;
                            Object var5_8 = null;
                            sQLMethod.close();
                            return n2;
                        }
                        String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
                        LogSystem.log(1, "Starting to send statements to EXTSQLRUNNER");
                        LogSystem.log(1, string2);
                        callableStatement.registerOutParameter(3, -4);
                        callableStatement.setBytes(1, string.getBytes());
                        callableStatement.setInt(2, 0);
                        callableStatement.execute();
                        storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                        callableStatement.close();
                        if (storedProcRec == null) {
                            LogSystem.log(2, "StoredProcRec is null - error status unknown");
                        }
                        if (storedProcRec != null && storedProcRec.error) {
                            LogSystem.log(2, storedProcRec.errorStr);
                            n = storedProcRec.sqlCode;
                            if (n == 0) {
                                n = -1;
                            }
                            break block14;
                        }
                        Statement statement = null;
                        Vector vector = super.getAdditionalInfo();
                        int n3 = 0;
                        while (true) {
                            if (vector == null || n3 >= vector.size()) {
                                if (statement != null) {
                                    statement.close();
                                }
                                break;
                            }
                            AddtlInfo addtlInfo = (AddtlInfo)vector.elementAt(n3);
                            int n4 = addtlInfo.getRecStatus();
                            if (n4 == 2 || n4 == 1) {
                                LogSystem.log(1, "Updating additional information text for " + addtlInfo.getInd());
                                if (statement == null) {
                                    statement = sQLMethod.createPreparedStatement("UPDATE oadraft.actionAddInfo SET addInfo=? WHERE actionAddInfoInd=?AND languageInd=?");
                                }
                                statement.setString(1, addtlInfo.getAddtlInfo());
                                statement.setInt(2, addtlInfo.getInd());
                                statement.setInt(3, addtlInfo.getLanguage().getInd());
                                statement.executeUpdate();
                            }
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        sQLMethod.rollBack();
                        LogSystem.log(3, exception);
                        n = -1;
                        Object var5_10 = null;
                        sQLMethod.close();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    sQLMethod.close();
                    throw throwable;
                }
            }
            Object var5_9 = null;
            sQLMethod.close();
        }
        LogSystem.log(2, ">>> ActionDraft.writeToDatabase() complete");
        return n;
    }

    public boolean publish() {
        LogSystem.log(2, ">>> Starting ActionDraft.publish()");
        SQLMethod sQLMethod = new SQLMethod(1, "ActionDraft.publish()", 10);
        boolean bl = true;
        StoredProcRec storedProcRec = null;
        try {
            block7: {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAPublish", 3);
                    callableStatement.registerOutParameter(3, -4);
                    callableStatement.setInt(1, this.getInd());
                    callableStatement.setInt(2, 0);
                    callableStatement.execute();
                    storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    callableStatement.close();
                    if (storedProcRec == null) {
                        LogSystem.log(2, "StoredProcRec is null - error status unknown");
                    } else if (storedProcRec.userError.length() > 0) {
                        LogSystem.log(1, "Publish SQL:");
                        LogSystem.log(2, storedProcRec.userError);
                    }
                    if (storedProcRec == null || !storedProcRec.error) break block7;
                    LogSystem.log(2, storedProcRec.errorStr);
                    bl = false;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    bl = false;
                    Object var5_7 = null;
                    sQLMethod.close();
                }
            }
            Object var5_6 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> ActionDraft.publish() complete");
        return bl;
    }

    public static Action readFromDatabase(int n, int n2) {
        LogSystem.log(2, ">>> Starting ActionDraft.readFromDatabase()");
        SQLMethod sQLMethod = new SQLMethod(1, "ActionDraft.readFromDatabase()", 5);
        StoredProcRec storedProcRec = null;
        ActionDraft actionDraft = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 0);
            callableStatement.setInt(3, 1);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            actionDraft = (ActionDraft)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        LogSystem.log(2, ">>> ActionDraft.readFromDatabase() completed");
        if (actionDraft != null) {
            actionDraft.updateTypeRecData();
            actionDraft.setRecNoChange();
        } else {
            LogSystem.log(2, "No object found for indicator " + n);
        }
        return actionDraft;
    }

    public static ActionDraft getDraft(int n, int n2, TypeWorkRec typeWorkRec) throws PendingDraftException {
        LogSystem.log(2, ">>> Starting ActionDraft.getDraft()");
        SQLMethod sQLMethod = new SQLMethod(1, "ActionDraft.getDraft()", 5);
        StoredProcRec storedProcRec = null;
        ActionDraft actionDraft = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 0);
            callableStatement.setInt(3, 2);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            actionDraft = (ActionDraft)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            } else if (actionDraft != null) {
                if (actionDraft.getRecStatus() == 2) {
                    actionDraft.setTypeWorkRequired(typeWorkRec);
                } else {
                    actionDraft.setRecNoChange();
                }
                actionDraft.updateTypeRecData();
            } else {
                LogSystem.log(2, "No object found for indicator " + n);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        LogSystem.log(2, ">>> ActionDraft.getDraft() completed");
        if (storedProcRec != null && storedProcRec.error && storedProcRec.sqlCode == 100) {
            throw new PendingDraftException();
        }
        return actionDraft;
    }

    void updateTypeRecData() {
        super.updateTypeRecData();
        TypeList typeList = TypeList.getInstance();
        TypeWorkRec typeWorkRec = (TypeWorkRec)typeList.objectFromInd(this.typeWork_.getInd(), 14);
        if (typeWorkRec != null) {
            this.typeWork_ = typeWorkRec;
        }
    }

    public void setComments(String string) {
        if (string == null) {
            string = "";
        }
        this.comments_ = string;
        this.updateRecStatus(1);
    }

    public String getComments() {
        return this.comments_;
    }

    public static void forceCloseDraft(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "forceCloseDraft", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("UPDATE oa.action SET openDraft='N' " + "WHERE actionInd=" + n + " " + "AND (" + "SELECT actionInd FROM oadraft.action " + "WHERE activeActionInd=" + n + " " + "AND stopDate IS NULL" + ") IS NULL");
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
    }

    public ActionDraft() {
        super(0);
        TypeList typeList = TypeList.getInstance();
        this.typeWork_ = (TypeWorkRec)typeList.objectFromInd(1, 14);
    }

    public ActionDraft(int n) {
        super(n);
    }

    ActionDraft(Action action) {
        super(action);
        this.activeActionInd_ = action.actionInd_;
    }
}

