/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ActionReader;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfoReader;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLinkReader;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.oa.TitleReader;
import com.ibm.nzna.projects.common.quest.type.TypeActionRec;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ActionDraftReader {
    public static boolean readFromDB(Connection connection, ActionDraft actionDraft, int n) throws SQLException {
        boolean bl;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "activeActionInd, actionTypeInd, " + "brandInd, typeWorkInd, docClassInd, " + "maintLock, startDate, stopDate, recycled, " + "archived, created, dbUser, changedTime, comments " + "FROM oadraft.action " + "WHERE actionInd=" + actionDraft.getInd() + " " + "FOR FETCH ONLY");
        if (!resultSet.next()) {
            bl = false;
            statement.close();
        } else {
            bl = true;
            actionDraft.setActiveActionInd(resultSet.getInt(1));
            actionDraft.setActionType(new TypeActionRec(resultSet.getShort(2), ""));
            actionDraft.setBrand(new TypeBrandRec(resultSet.getInt(3), "", 0));
            actionDraft.setTypeWorkRequired(new TypeWorkRec(resultSet.getInt(4), ""));
            actionDraft.setDocClass(new TypeDocClassRec(resultSet.getShort(5), ""));
            actionDraft.setMaintLock(DatabaseUtil.booleanFromDB(resultSet.getString(6)));
            actionDraft.setStartDate(resultSet.getString(7));
            actionDraft.setStopDate(resultSet.getString(8));
            actionDraft.setRecycled(DatabaseUtil.booleanFromDB(resultSet.getString(9)));
            actionDraft.setArchived(DatabaseUtil.booleanFromDB(resultSet.getString(10)));
            actionDraft.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(11)));
            actionDraft.setDbUser(resultSet.getString(12).trim());
            actionDraft.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(13)));
            actionDraft.setComments(resultSet.getString(14));
            if (resultSet.wasNull()) {
                actionDraft.setComments("");
            }
            statement.close();
            actionDraft.setCountryList(CountryReader.readCountries(connection, "oadraft.actionCountry", "actionInd", actionDraft.getInd()));
            TitleReader.readActionDraftTitles(connection, actionDraft, n);
            AddtlInfoReader.readActionDraftAddtlInfo(connection, actionDraft, n, 0);
            DocLinkReader.readActionDraftDocLinks(connection, actionDraft);
            actionDraft.updateRecStatus(0);
        }
        return bl;
    }

    public static ActionDraft getDraft(Connection connection, int n, int n2) throws SQLException, PendingDraftException {
        Statement statement = connection.createStatement();
        ActionDraft actionDraft = null;
        ResultSet resultSet = statement.executeQuery("SELECT actionInd " + "FROM oadraft.action " + "WHERE stopDate IS NULL AND activeActionInd=" + n + " " + "FOR FETCH ONLY");
        if (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            resultSet.close();
            ActionDraft actionDraft2 = new ActionDraft(n3);
            if (ActionDraftReader.readFromDB(connection, actionDraft2, n2)) {
                actionDraft = actionDraft2;
            }
        } else {
            resultSet.close();
            Action action = new Action(n);
            if (ActionReader.readFromDB(connection, action, n2, 0)) {
                ActionDraft actionDraft3;
                if (action.hasOpenDraft()) {
                    throw new PendingDraftException();
                }
                actionDraft = actionDraft3 = new ActionDraft(action);
                statement.executeUpdate("UPDATE oa.action " + "SET openDraft='Y' " + "WHERE actionInd=" + n);
            }
        }
        statement.close();
        return actionDraft;
    }
}

