/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ActionInfoDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.ActionLinkDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.ActionTitleDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class ActionDraftWriter {
    static String getSQL(ActionDraft actionDraft) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ActionDraftWriter.getActionDraftSQL(actionDraft));
        if (actionDraft.valid()) {
            stringBuffer.append(ActionDraftWriter.getObjectSQL(actionDraft));
        }
        if (!actionDraft.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oadraft.action SET changedTime=CURRENT TIMESTAMP WHERE actionInd=").append(actionDraft.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(ActionDraft actionDraft) {
        ConditionalObject conditionalObject;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = actionDraft.getTitles();
        if (vector != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (Title)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((Title)conditionalObject).setParentInd(actionDraft.getInd());
                    conditionalObject.setDbUser(actionDraft.getDbUser());
                }
                stringBuffer.append(ActionTitleDraftWriter.getSQL((Title)conditionalObject));
                ++n;
            }
        }
        if ((vector = actionDraft.getAdditionalInfo()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (AddtlInfo)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((AddtlInfo)conditionalObject).setParentInd(actionDraft.getInd());
                    conditionalObject.setDbUser(actionDraft.getDbUser());
                }
                stringBuffer.append(ActionInfoDraftWriter.getSQL((AddtlInfo)conditionalObject));
                ++n;
            }
        }
        if ((vector = actionDraft.getDocLinks()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (DocLink)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((DocLink)conditionalObject).setParentInd(actionDraft.getInd());
                    conditionalObject.setDbUser(actionDraft.getDbUser());
                }
                stringBuffer.append(ActionLinkDraftWriter.getSQL((DocLink)conditionalObject));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getActionDraftSQL(ActionDraft actionDraft) {
        String string;
        switch (actionDraft.getRecStatus()) {
            case 2: {
                string = ActionDraftWriter.getInsertSQL(actionDraft);
                break;
            }
            case 1: {
                string = ActionDraftWriter.getUpdateSQL(actionDraft);
                break;
            }
            case 3: {
                string = ActionDraftWriter.getDeleteSQL(actionDraft);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(ActionDraft actionDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.action (actionInd, activeActionInd, actionTypeInd, brandInd, typeWorkInd, docClassInd, comments, maintLock, startDate, stopDate, recycled, archived, created, dbUser, changedTime) VALUES (");
        stringBuffer.append(actionDraft.getInd()).append(',');
        if (actionDraft.getActiveActionInd() == 0) {
            stringBuffer.append("NULL").append(',');
        } else {
            stringBuffer.append(actionDraft.getActiveActionInd()).append(',');
        }
        stringBuffer.append(actionDraft.getActionType().getInd()).append(',');
        stringBuffer.append(actionDraft.getBrand().getInd()).append(',');
        stringBuffer.append(actionDraft.getTypeWorkRequired().getInd()).append(',');
        stringBuffer.append(actionDraft.getDocClass().getInd()).append(',');
        String string = actionDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL,");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string)).append(',');
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(actionDraft.getMaintLock())).append(',');
        stringBuffer.append("CURRENT DATE").append(',');
        stringBuffer.append("NULL").append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(actionDraft.isRecycled())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(actionDraft.isArchived())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP").append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(actionDraft.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oadraft.actionCountry", actionDraft.getInd(), actionDraft.getCountryList(), actionDraft.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(ActionDraft actionDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oadraft.action SET");
        stringBuffer.append(" actionTypeInd=").append(actionDraft.getActionType().getInd());
        stringBuffer.append(",brandInd=").append(actionDraft.getBrand().getInd());
        stringBuffer.append(",typeWorkInd=").append(actionDraft.getTypeWorkRequired().getInd());
        stringBuffer.append(",docClassInd=").append(actionDraft.getDocClass().getInd());
        stringBuffer.append(",comments=");
        String string = actionDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string));
        }
        stringBuffer.append(",maintLock=").append(DatabaseUtil.booleanToDB(actionDraft.getMaintLock()));
        stringBuffer.append(",recycled=").append(DatabaseUtil.booleanToDB(actionDraft.isRecycled()));
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(actionDraft.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(actionDraft.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE actionInd=").append(actionDraft.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oadraft.actionCountry", "actionInd", actionDraft.getInd(), actionDraft.getCountryList(), actionDraft.getOriginalCountryList(), actionDraft.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(ActionDraft actionDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        int n = actionDraft.getInd();
        stringBuffer.append(ActionTitleDraftWriter.getDeleteAllForActionSQL(n));
        stringBuffer.append(ActionInfoDraftWriter.getDeleteAllForActionSQL(n));
        stringBuffer.append(ActionLinkDraftWriter.getDeleteAllForActionSQL(n));
        stringBuffer.append("DELETE from oadraft.actioncountry where actionind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.action where actionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    ActionDraftWriter() {
    }
}

