/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;

class ActionLinkWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(DocLink docLink) {
        String string;
        switch (docLink.getRecStatus()) {
            case 2: {
                string = ActionLinkWriter.getInsertSQL(docLink, SCHEMA);
                break;
            }
            case 1: {
                string = ActionLinkWriter.getUpdateSQL(docLink, SCHEMA);
                break;
            }
            case 3: {
                string = ActionLinkWriter.getDeleteSQL(docLink, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(DocLink docLink, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".actionLink " + "(actionLinkInd, actionInd, sortOrder, linkInd, linkGroupInd, " + "docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(docLink.getInd()).append(',');
        stringBuffer.append(docLink.getParentInd()).append(',');
        stringBuffer.append(docLink.getSortOrder()).append(',');
        if (docLink.hasLinkGroup()) {
            stringBuffer.append("NULL,");
            stringBuffer.append(docLink.getLinkGroupInd()).append(',');
        } else {
            stringBuffer.append(docLink.getLinkInd()).append(',');
            stringBuffer.append("NULL,");
        }
        stringBuffer.append(docLink.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(docLink.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL(string + ".actionLinkCountry", docLink.getInd(), docLink.getCountryList(), docLink.getDbUser()));
        stringBuffer.append(ConditionWriter.getInsertSQL(string + ".actionLinkCond", docLink.getInd(), docLink.getConditions(), docLink.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(DocLink docLink, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE " + string + ".actionLink SET");
        stringBuffer.append(" sortOrder=").append(docLink.getSortOrder());
        stringBuffer.append(",docClassInd=").append(docLink.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(docLink.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE actionLinkInd=").append(docLink.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL(string + ".actionLinkCountry", "actionLinkInd", docLink.getInd(), docLink.getCountryList(), docLink.getOriginalCountryList(), docLink.getDbUser()));
        stringBuffer.append(ConditionWriter.getUpdateSQL(string + ".actionLinkCond", "actionLinkInd", docLink.getInd(), docLink.getConditions(), docLink.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(DocLink docLink, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".actionLinkCountry", "actionLinkInd", docLink.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".actionLinkCond", "actionLinkInd", docLink.getInd()));
        stringBuffer.append("DELETE FROM " + string + ".actionLink WHERE actionLinkInd=").append(docLink.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForActionSQL(int n) {
        return ActionLinkWriter.getDeleteAllForActionSQL(n, SCHEMA);
    }

    static String getDeleteAllForActionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".actionlinkcond where actionlinkind in " + "(select distinct actionlinkind " + "from " + string + ".actionlink where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actionlinkcountry where actionlinkind in " + "(select distinct actionlinkind " + "from " + string + ".actionlink where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actionlink where actionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    ActionLinkWriter() {
    }
}

