/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ActionInfoWriter;
import com.ibm.nzna.projects.common.quest.oa.ActionLinkWriter;
import com.ibm.nzna.projects.common.quest.oa.ActionTitleWriter;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.sql.Connection;
import java.util.Vector;

public class ActionWriter {
    static String getSQL(Action action) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ActionWriter.getActionSQL(action));
        if (action.valid()) {
            stringBuffer.append(ActionWriter.getObjectSQL(action));
        }
        if (!action.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oa.action SET changedTime=CURRENT TIMESTAMP WHERE actionInd=").append(action.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(Action action) {
        ConditionalObject conditionalObject;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = action.getTitles();
        if (vector != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (Title)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((Title)conditionalObject).setParentInd(action.getInd());
                    conditionalObject.setDbUser(action.getDbUser());
                }
                stringBuffer.append(ActionTitleWriter.getSQL((Title)conditionalObject));
                ++n;
            }
        }
        if ((vector = action.getAdditionalInfo()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (AddtlInfo)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((AddtlInfo)conditionalObject).setParentInd(action.getInd());
                    conditionalObject.setDbUser(action.getDbUser());
                }
                stringBuffer.append(ActionInfoWriter.getSQL((AddtlInfo)conditionalObject));
                ++n;
            }
        }
        if ((vector = action.getDocLinks()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (DocLink)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((DocLink)conditionalObject).setParentInd(action.getInd());
                    conditionalObject.setDbUser(action.getDbUser());
                }
                stringBuffer.append(ActionLinkWriter.getSQL((DocLink)conditionalObject));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getActionSQL(Action action) {
        String string;
        switch (action.getRecStatus()) {
            case 2: {
                string = ActionWriter.getInsertSQL(action);
                break;
            }
            case 1: {
                string = ActionWriter.getUpdateSQL(action);
                break;
            }
            case 3: {
                string = ActionWriter.getDeleteSQL(action);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Action action) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.action (actionInd, actionTypeInd, brandInd, docClassInd, archived, dbUser, changedTime, openDraft) VALUES (");
        stringBuffer.append(action.getInd()).append(',');
        stringBuffer.append(action.getActionType().getInd()).append(',');
        stringBuffer.append(action.getBrand().getInd()).append(',');
        stringBuffer.append(action.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(action.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(action.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, 'N')").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oa.actionCountry", action.getInd(), action.getCountryList(), action.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Action action) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.action SET");
        stringBuffer.append(" actionTypeInd=").append(action.getActionType().getInd());
        stringBuffer.append(",brandInd=").append(action.getBrand().getInd());
        stringBuffer.append(",docClassInd=").append(action.getDocClass().getInd());
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(action.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(action.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE actionInd=").append(action.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oa.actionCountry", "actionInd", action.getInd(), action.getCountryList(), action.getOriginalCountryList(), action.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Action action) {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = action.getInd();
        stringBuffer.append(ActionTitleWriter.getDeleteAllForActionSQL(n));
        stringBuffer.append(ActionInfoWriter.getDeleteAllForActionSQL(n));
        stringBuffer.append(ActionLinkWriter.getDeleteAllForActionSQL(n));
        stringBuffer.append("DELETE from oa.actioncountry where actionind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.action where actionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    public static String getPublishSQL(Connection connection, ActionDraft actionDraft) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(500);
        Action action = new Action(actionDraft);
        action.assignDatabaseKeys(connection);
        if (action.getRecStatus() == 1) {
            int n = action.getInd();
            stringBuffer.append(ActionTitleWriter.getDeleteAllForActionSQL(n));
            stringBuffer.append(ActionInfoWriter.getDeleteAllForActionSQL(n));
            stringBuffer.append(ActionLinkWriter.getDeleteAllForActionSQL(n));
        }
        stringBuffer.append(ActionWriter.getSQL(action));
        stringBuffer.append("DELETE FROM oa.actionResponse WHERE actionInd=").append(action.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("INSERT INTO oa.actionResponse " + "SELECT DISTINCT " + "a.actionInd, ac.countryInd, 'N', a.dbUser, a.changedTime " + "FROM oa.action a, oa.actionCountry ac " + "WHERE a.actionInd=" + action.getInd() + "  AND ac.actionInd=a.actionInd").append(SqlRunner.END_DELIM);
        if (action.getRecStatus() == 2) {
            stringBuffer.append("UPDATE oadraft.node " + "SET activeActionInd=" + action.getInd() + " " + "WHERE draftActionInd=" + actionDraft.getInd()).append(SqlRunner.END_DELIM);
            stringBuffer.append("UPDATE oadraft.edgePreanswer " + "SET activeActionInd=" + action.getInd() + " " + "WHERE draftActionInd=" + actionDraft.getInd()).append(SqlRunner.END_DELIM);
        }
        stringBuffer.append("UPDATE oa.action SET openDraft='N' WHERE actionInd=").append(action.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("UPDATE oadraft.action " + "SET stopDate=CURRENT DATE, " + "changedTime=CURRENT TIMESTAMP, " + "activeActionInd=" + action.getInd() + " " + "WHERE actionInd=" + actionDraft.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }
}

