/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.AnswerConclDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.AnswerTitleDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class AnswerDraftWriter {
    static String getSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AnswerDraftWriter.getAnswerDraftSQL(answer));
        if (answer.valid()) {
            stringBuffer.append(AnswerDraftWriter.getObjectSQL(answer));
        }
        if (!answer.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oadraft.answer SET changedTime=CURRENT TIMESTAMP WHERE answerInd=").append(answer.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(Answer answer) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = answer.getTitles();
        if (vector != null) {
            n = 1;
            int n2 = 0;
            while (n2 < vector.size()) {
                Title title = (Title)vector.elementAt(n2);
                if (title.valid()) {
                    title.setSortOrder(n++);
                    title.setParentInd(answer.getInd());
                    title.setDbUser(answer.getDbUser());
                }
                stringBuffer.append(AnswerTitleDraftWriter.getSQL(title));
                ++n2;
            }
        }
        if ((vector = answer.getConclusions()) != null) {
            n = 0;
            while (n < vector.size()) {
                AnswerConcl answerConcl = (AnswerConcl)vector.elementAt(n);
                if (answerConcl.valid()) {
                    answerConcl.setFromAnswerInd(answer.getInd());
                    answerConcl.setDbUser(answer.getDbUser());
                }
                stringBuffer.append(AnswerConclDraftWriter.getSQL(answerConcl));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getAnswerDraftSQL(Answer answer) {
        String string;
        switch (answer.getRecStatus()) {
            case 2: {
                string = AnswerDraftWriter.getInsertSQL(answer);
                break;
            }
            case 1: {
                string = AnswerDraftWriter.getUpdateSQL(answer);
                break;
            }
            case 3: {
                string = AnswerDraftWriter.getDeleteSQL(answer);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.answer (answerInd, activeAnswerInd, questionInd, sortOrder, docClassInd, dbUser, changedTime) VALUES (");
        stringBuffer.append(answer.getInd()).append(',');
        if (answer.getActiveAnswerInd() == 0) {
            stringBuffer.append("NULL").append(',');
        } else {
            stringBuffer.append(answer.getActiveAnswerInd()).append(',');
        }
        stringBuffer.append(answer.getParentInd()).append(',');
        stringBuffer.append(answer.getSortOrder()).append(',');
        stringBuffer.append(answer.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(answer.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oadraft.answerCountry", answer.getInd(), answer.getCountryList(), answer.getDbUser()));
        stringBuffer.append(ConditionWriter.getInsertSQL("oadraft.answerCond", answer.getInd(), answer.getConditions(), answer.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oadraft.answer SET");
        stringBuffer.append(" sortOrder=").append(answer.getSortOrder());
        stringBuffer.append(",docClassInd=").append(answer.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(answer.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE answerInd=").append(answer.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oadraft.answerCountry", "answerInd", answer.getInd(), answer.getCountryList(), answer.getOriginalCountryList(), answer.getDbUser()));
        stringBuffer.append(ConditionWriter.getUpdateSQL("oadraft.answerCond", "parentAnswerInd", answer.getInd(), answer.getConditions(), answer.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(AnswerConclDraftWriter.getDeleteAllForAnswerSQL(answer.getInd()));
        stringBuffer.append(AnswerTitleDraftWriter.getDeleteAllForAnswerSQL(answer.getInd()));
        stringBuffer.append(CountryWriter.getDeleteSQL("oadraft.answerCountry", "answerInd", answer.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL("oadraft.answerCond", "parentAnswerInd", answer.getInd()));
        stringBuffer.append("DELETE FROM oadraft.answer WHERE answerInd=").append(answer.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForQuestionSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(AnswerConclDraftWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(AnswerTitleDraftWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append("DELETE from oadraft.answercond where parentanswerind in (select distinct answerind from oadraft.answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.answercountry where answerind in (select distinct answerind from oadraft.answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.answer where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    AnswerDraftWriter() {
    }
}

