/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;

class AnswerTitleWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(Title title) {
        String string;
        switch (title.getRecStatus()) {
            case 2: {
                string = AnswerTitleWriter.getInsertSQL(title, SCHEMA);
                break;
            }
            case 1: {
                string = AnswerTitleWriter.getUpdateSQL(title, SCHEMA);
                break;
            }
            case 3: {
                string = AnswerTitleWriter.getDeleteSQL(title, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".answerTitle " + "(answerTitleInd, answerInd, sortOrder, title, languageInd, " + "lastTranslated, docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(title.getInd()).append(',');
        stringBuffer.append(title.getParentInd()).append(',');
        stringBuffer.append(title.getSortOrder()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(title.getTitle())).append(',');
        stringBuffer.append(title.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(title.getLastTranslationDate())).append(',');
        stringBuffer.append(title.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(title.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        if (title.getLanguage().getInd() == 1) {
            stringBuffer.append(CountryWriter.getInsertSQL(string + ".answerTitleCountry", title.getInd(), title.getCountryList(), title.getDbUser()));
            stringBuffer.append(ConditionWriter.getInsertSQL(string + ".answerTitleCond", title.getInd(), title.getConditions(), title.getDbUser()));
        }
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".answerTitleCond WHERE answerTitleInd = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".answerTitleCountry WHERE answerTitleInd = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".answerTitle WHERE answerTitleInd = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append(AnswerTitleWriter.getInsertSQL(title, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".answerTitleCountry", "answerTitleInd", title.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".answerTitleCond", "answerTitleInd", title.getInd()));
        stringBuffer.append("DELETE FROM " + string + ".answerTitle WHERE answerTitleInd=").append(title.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForQuestionSQL(int n) {
        return AnswerTitleWriter.getDeleteAllForQuestionSQL(n, SCHEMA);
    }

    static String getDeleteAllForQuestionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".answertitlecond where answertitleind in " + "(select distinct answertitleind " + "from " + string + ".answertitle t, " + string + ".answer a " + "where t.answerind = a.answerind " + "and   a.questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answertitlecountry where answertitleind in " + "(select distinct answertitleind " + "from " + string + ".answertitle t, " + string + ".answer a " + "where t.answerind = a.answerind " + "and   a.questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answertitle where answerind in " + "(select distinct answerind " + "from " + string + ".answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForAnswerSQL(int n) {
        return AnswerTitleWriter.getDeleteAllForAnswerSQL(n, SCHEMA);
    }

    static String getDeleteAllForAnswerSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".answertitlecond where answertitleind in " + "(select distinct answertitleind " + "from " + string + ".answertitle where answerind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answertitlecountry where answertitleind in " + "(select distinct answertitleind " + "from " + string + ".answertitle where answerind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answertitle where answerind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    AnswerTitleWriter() {
    }
}

