/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.AnswerConclWriter;
import com.ibm.nzna.projects.common.quest.oa.AnswerTitleWriter;
import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class AnswerWriter {
    static String getSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AnswerWriter.getAnswerSQL(answer));
        if (answer.valid()) {
            stringBuffer.append(AnswerWriter.getObjectSQL(answer));
        }
        if (!answer.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oa.answer SET changedTime=CURRENT TIMESTAMP WHERE answerInd=").append(answer.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(Answer answer) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = answer.getTitles();
        if (vector != null) {
            n = 1;
            int n2 = 0;
            while (n2 < vector.size()) {
                Title title = (Title)vector.elementAt(n2);
                if (title.valid()) {
                    title.setSortOrder(n++);
                    title.setParentInd(answer.getInd());
                    title.setDbUser(answer.getDbUser());
                }
                stringBuffer.append(AnswerTitleWriter.getSQL(title));
                ++n2;
            }
        }
        if ((vector = answer.getConclusions()) != null) {
            n = 0;
            while (n < vector.size()) {
                AnswerConcl answerConcl = (AnswerConcl)vector.elementAt(n);
                if (answerConcl.valid()) {
                    answerConcl.setFromAnswerInd(answer.getInd());
                    answerConcl.setDbUser(answer.getDbUser());
                }
                stringBuffer.append(AnswerConclWriter.getSQL(answerConcl));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getAnswerSQL(Answer answer) {
        String string;
        switch (answer.getRecStatus()) {
            case 2: {
                string = AnswerWriter.getInsertSQL(answer);
                break;
            }
            case 1: {
                string = AnswerWriter.getUpdateSQL(answer);
                break;
            }
            case 3: {
                string = AnswerWriter.getDeleteSQL(answer);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.answer (answerInd, questionInd, sortOrder, docClassInd, dbUser, changedTime) VALUES (");
        stringBuffer.append(answer.getInd()).append(',');
        stringBuffer.append(answer.getParentInd()).append(',');
        stringBuffer.append(answer.getSortOrder()).append(',');
        stringBuffer.append(answer.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(answer.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oa.answerCountry", answer.getInd(), answer.getCountryList(), answer.getDbUser()));
        stringBuffer.append(ConditionWriter.getInsertSQL("oa.answerCond", answer.getInd(), answer.getConditions(), answer.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.answer SET");
        stringBuffer.append(" sortOrder=").append(answer.getSortOrder());
        stringBuffer.append(",docClassInd=").append(answer.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(answer.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE answerInd=").append(answer.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oa.answerCountry", "answerInd", answer.getInd(), answer.getCountryList(), answer.getOriginalCountryList(), answer.getDbUser()));
        stringBuffer.append(ConditionWriter.getUpdateSQL("oa.answerCond", "parentAnswerInd", answer.getInd(), answer.getConditions(), answer.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Answer answer) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(AnswerConclWriter.getDeleteAllForAnswerSQL(answer.getInd()));
        stringBuffer.append(AnswerTitleWriter.getDeleteAllForAnswerSQL(answer.getInd()));
        stringBuffer.append(CountryWriter.getDeleteSQL("oa.answerCountry", "answerInd", answer.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL("oa.answerCond", "parentAnswerInd", answer.getInd()));
        stringBuffer.append("DELETE FROM oa.answer WHERE answerInd=").append(answer.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForQuestionSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(AnswerConclWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(AnswerTitleWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append("DELETE from oa.answercond where parentanswerind in (select distinct answerind from oa.answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.answercountry where answerind in (select distinct answerind from oa.answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.answer where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAnswerDataForQuestionSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(AnswerConclWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(AnswerTitleWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append("DELETE from oa.answercond where parentanswerind in (select distinct answerind from oa.answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.answercountry where answerind in (select distinct answerind from oa.answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    AnswerWriter() {
    }
}

