/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ConditionReader;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class DocLinkReader {
    private static final String ACTIVE_SCHEMA = "oa";
    private static final String DRAFT_SCHEMA = "oadraft";

    static void readActionDocLinks(Connection connection, Action action) throws SQLException {
        DocLinkReader.readActionDocLinks(connection, action, ACTIVE_SCHEMA);
    }

    static void readActionDraftDocLinks(Connection connection, Action action) throws SQLException {
        DocLinkReader.readActionDocLinks(connection, action, DRAFT_SCHEMA);
    }

    private static void readActionDocLinks(Connection connection, Action action, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "actionLinkInd, sortOrder, linkInd, linkGroupInd, " + "docClassInd, created, dbUser, changedTime " + "FROM " + string + ".actionLink " + "WHERE actionInd=" + action.getInd() + " " + "ORDER BY sortOrder " + "FOR FETCH ONLY");
        Vector<DocLink> vector = new Vector<DocLink>();
        while (resultSet.next()) {
            DocLink docLink = new DocLink(resultSet.getInt(1));
            docLink.setParentInd(action.getInd());
            docLink.setSortOrder(resultSet.getShort(2));
            docLink.setLinkInd(resultSet.getInt(3));
            docLink.setLinkGroupInd(resultSet.getInt(4));
            docLink.setDocClass(new TypeDocClassRec(resultSet.getShort(5), ""));
            docLink.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(6)));
            docLink.setDbUser(resultSet.getString(7).trim());
            docLink.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(8)));
            docLink.updateRecStatus(0);
            vector.addElement(docLink);
        }
        resultSet.close();
        statement.close();
        action.setDocumentLinks(vector);
        if (vector.size() > 0) {
            ConditionReader.readAllActionDocLinkConditions(connection, action, string);
            CountryReader.readAllActionDocLinkCountries(connection, action, string);
        }
    }

    static void readQuestionDocLinks(Connection connection, Question question) throws SQLException {
        DocLinkReader.readQuestionDocLinks(connection, question, ACTIVE_SCHEMA);
    }

    static void readQuestionDraftDocLinks(Connection connection, Question question) throws SQLException {
        DocLinkReader.readQuestionDocLinks(connection, question, DRAFT_SCHEMA);
    }

    private static void readQuestionDocLinks(Connection connection, Question question, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "questionLinkInd, sortOrder, linkInd, linkGroupInd, " + "docClassInd, created, dbUser, changedTime " + "FROM " + string + ".questionLink " + "WHERE questionInd=" + question.getInd() + " " + "ORDER BY sortOrder " + "FOR FETCH ONLY");
        Vector<DocLink> vector = new Vector<DocLink>();
        while (resultSet.next()) {
            DocLink docLink = new DocLink(resultSet.getInt(1));
            docLink.setParentInd(question.getInd());
            docLink.setSortOrder(resultSet.getShort(2));
            docLink.setLinkInd(resultSet.getInt(3));
            docLink.setLinkGroupInd(resultSet.getInt(4));
            docLink.setDocClass(new TypeDocClassRec(resultSet.getShort(5), ""));
            docLink.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(6)));
            docLink.setDbUser(resultSet.getString(7).trim());
            docLink.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(8)));
            docLink.updateRecStatus(0);
            vector.addElement(docLink);
        }
        resultSet.close();
        statement.close();
        question.setDocLinks(vector);
        if (vector.size() > 0) {
            ConditionReader.readAllQuestionDocLinkConditions(connection, question, string);
            CountryReader.readAllQuestionDocLinkCountries(connection, question, string);
        }
    }

    DocLinkReader() {
    }
}

