/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgeObject;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeReturn;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class Edge
extends ConditionalObject {
    static final long serialVersionUID = 1000000L;
    public static final short EDGE_TYPE_ANSWER = 0;
    public static final short EDGE_TYPE_OTHER = 1;
    private int edgeInd_ = 0;
    private int edgeGroupInd_ = 0;
    private short edgeType_ = 0;
    private Vector preanswers_ = null;
    private Vector actionList_ = null;
    private Vector unanswers_ = null;
    private EdgeReturn edgeReturn_ = null;
    EdgeReturn originalReturnNode = null;
    private int activeQuestionInd_ = 0;
    private int activeAnswerInd_ = 0;
    private int draftQuestionInd_ = 0;
    private int draftAnswerInd_ = 0;
    private String defaultAnswerTitle_ = null;

    public int getInd() {
        return this.edgeInd_;
    }

    void setInd(int n) {
        this.edgeInd_ = n;
    }

    boolean assignDatabaseKeys(boolean bl) {
        EdgeObject edgeObject;
        int n;
        boolean bl2 = this.assignDatabaseKey(bl);
        if (this.preanswers_ != null) {
            n = 0;
            while (n < this.preanswers_.size() && bl2) {
                edgeObject = (EdgePreanswer)this.preanswers_.elementAt(n);
                bl2 = edgeObject.assignDatabaseKey(bl);
                ++n;
            }
        }
        if (this.actionList_ != null) {
            n = 0;
            while (n < this.actionList_.size() && bl2) {
                edgeObject = (EdgeAlist)this.actionList_.elementAt(n);
                bl2 = edgeObject.assignDatabaseKey(bl);
                ++n;
            }
        }
        if (this.unanswers_ != null) {
            n = 0;
            while (n < this.unanswers_.size() && bl2) {
                edgeObject = (EdgeUnanswer)this.unanswers_.elementAt(n);
                bl2 = edgeObject.assignDatabaseKey(bl);
                ++n;
            }
        }
        if (this.edgeReturn_ != null) {
            bl2 = this.edgeReturn_.assignDatabaseKey(bl);
        }
        return bl2;
    }

    void assignDatabaseKeys(Connection connection, boolean bl) throws Exception {
        EdgeObject edgeObject;
        int n;
        this.assignDatabaseKey(connection, bl);
        if (this.preanswers_ != null) {
            n = 0;
            while (n < this.preanswers_.size()) {
                edgeObject = (EdgePreanswer)this.preanswers_.elementAt(n);
                edgeObject.assignDatabaseKey(connection, bl);
                ++n;
            }
        }
        if (this.actionList_ != null) {
            n = 0;
            while (n < this.actionList_.size()) {
                edgeObject = (EdgeAlist)this.actionList_.elementAt(n);
                edgeObject.assignDatabaseKey(connection, bl);
                ++n;
            }
        }
        if (this.unanswers_ != null) {
            n = 0;
            while (n < this.unanswers_.size()) {
                edgeObject = (EdgeUnanswer)this.unanswers_.elementAt(n);
                edgeObject.assignDatabaseKey(connection, bl);
                ++n;
            }
        }
        if (this.edgeReturn_ != null) {
            this.edgeReturn_.assignDatabaseKey(connection, bl);
        }
    }

    private boolean assignDatabaseKey(boolean bl) {
        boolean bl2 = true;
        String string = bl ? "DEDGEIND" : "EDGEIND";
        if (this.edgeInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for Edge: " + string);
            this.edgeInd_ = Counter.getCounter(LogSystem.getInstance(), string);
            if (this.edgeInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Edge");
                bl2 = false;
            }
        }
        return bl2;
    }

    private void assignDatabaseKey(Connection connection, boolean bl) throws Exception {
        String string = bl ? "DEDGEIND" : "EDGEIND";
        if (this.edgeInd_ == 0) {
            this.edgeInd_ = Counter.getCounter(connection, string);
            if (this.edgeInd_ == 0) {
                throw new Exception("Failed to get database key for Edge");
            }
        }
    }

    void resetNew() {
        EdgeObject edgeObject;
        int n;
        this.setInd(0);
        this.updateRecStatus(2);
        if (this.preanswers_ != null) {
            n = 0;
            while (n < this.preanswers_.size()) {
                edgeObject = (EdgePreanswer)this.preanswers_.elementAt(n);
                edgeObject.resetNew();
                ++n;
            }
        }
        if (this.actionList_ != null) {
            n = 0;
            while (n < this.actionList_.size()) {
                edgeObject = (EdgeAlist)this.actionList_.elementAt(n);
                edgeObject.resetNew();
                ++n;
            }
        }
        if (this.unanswers_ != null) {
            n = 0;
            while (n < this.unanswers_.size()) {
                edgeObject = (EdgeUnanswer)this.unanswers_.elementAt(n);
                edgeObject.resetNew();
                ++n;
            }
        }
        if (this.edgeReturn_ != null) {
            this.edgeReturn_.resetNew();
        }
    }

    int getEdgeGroupInd() {
        return this.edgeGroupInd_;
    }

    void setEdgeGroupInd(int n) {
        this.edgeGroupInd_ = n;
    }

    public short getEdgeType() {
        return this.edgeType_;
    }

    void setEdgeType(short s) {
        this.edgeType_ = s;
    }

    public boolean isAnswerEdge() {
        return this.edgeType_ == 0;
    }

    public int getAnswerInd() {
        return this.activeAnswerInd_;
    }

    void setAnswerInd(int n) {
        this.activeAnswerInd_ = n;
    }

    public int getQuestionInd() {
        return this.activeQuestionInd_;
    }

    void setQuestionInd(int n) {
        this.activeQuestionInd_ = n;
    }

    public int getActiveAnswerInd() {
        return this.activeAnswerInd_;
    }

    void setActiveAnswerInd(int n) {
        this.activeAnswerInd_ = n;
    }

    public int getActiveQuestionInd() {
        return this.activeQuestionInd_;
    }

    void setActiveQuestionInd(int n) {
        this.activeQuestionInd_ = n;
    }

    public int getDraftAnswerInd() {
        return this.draftAnswerInd_;
    }

    public void setDraftAnswerInd(int n) {
        this.draftAnswerInd_ = n;
    }

    public int getDraftQuestionInd() {
        return this.draftQuestionInd_;
    }

    public void setDraftQuestionInd(int n) {
        this.draftQuestionInd_ = n;
    }

    public Vector getPreanswers() {
        if (this.preanswers_ == null) {
            this.preanswers_ = new Vector(1, 3);
        }
        return this.preanswers_;
    }

    public void setPreanswers(Vector vector) {
        this.preanswers_ = vector;
    }

    public void addPreanswer(EdgePreanswer edgePreanswer) {
        Vector vector = this.getPreanswers();
        vector.addElement(edgePreanswer);
    }

    public Vector getActionList() {
        if (this.actionList_ == null) {
            this.actionList_ = new Vector(1, 3);
        }
        return this.actionList_;
    }

    public void setActionList(Vector vector) {
        this.actionList_ = vector;
    }

    public void addActionList(EdgeAlist edgeAlist) {
        Vector vector = this.getActionList();
        vector.addElement(edgeAlist);
    }

    public Vector getUnanswers() {
        if (this.unanswers_ == null) {
            this.unanswers_ = new Vector(1, 3);
        }
        return this.unanswers_;
    }

    public void setUnanswers(Vector vector) {
        this.unanswers_ = vector;
    }

    public void addUnanswer(EdgeUnanswer edgeUnanswer) {
        Vector vector = this.getUnanswers();
        vector.addElement(edgeUnanswer);
    }

    public EdgeReturn getReturnNode() {
        return this.edgeReturn_;
    }

    public void setReturnNode(EdgeReturn edgeReturn) {
        this.edgeReturn_ = edgeReturn;
    }

    public String toString() {
        return this.getDefaultAnswerTitle();
    }

    void setRecNoChange() {
        EdgeObject edgeObject;
        int n;
        super.setRecNoChange();
        if (this.preanswers_ != null) {
            n = 0;
            while (n < this.preanswers_.size()) {
                edgeObject = (EdgePreanswer)this.preanswers_.elementAt(n);
                edgeObject.updateRecStatus(0);
                ++n;
            }
        }
        if (this.actionList_ != null) {
            n = 0;
            while (n < this.actionList_.size()) {
                edgeObject = (EdgeAlist)this.actionList_.elementAt(n);
                edgeObject.updateRecStatus(0);
                ++n;
            }
        }
        if (this.unanswers_ != null) {
            n = 0;
            while (n < this.unanswers_.size()) {
                edgeObject = (EdgeUnanswer)this.unanswers_.elementAt(n);
                edgeObject.updateRecStatus(0);
                ++n;
            }
        }
        if (this.edgeReturn_ != null) {
            this.edgeReturn_.updateRecStatus(0);
        }
    }

    public void setDefaultAnswerTitle(String string) {
        this.defaultAnswerTitle_ = string;
    }

    public String getDefaultAnswerTitle() {
        if (this.defaultAnswerTitle_ == null) {
            SQLMethod sQLMethod = new SQLMethod(1, "Edge.getDefaultAnswerTitle", 5);
            int n = 0;
            String string = null;
            if (this.draftAnswerInd_ == 0) {
                n = this.activeAnswerInd_;
                string = "OA";
            } else {
                n = this.draftAnswerInd_;
                string = "OADRAFT";
            }
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT TITLE " + "FROM " + string + ".ANSWERTITLE " + "WHERE ANSWERIND = " + n + " AND " + "      SORTORDER = (SELECT MAX(SORTORDER) FROM " + string + ".ANSWERTITLE WHERE ANSWERIND = " + n + ") " + "FOR FETCH ONLY");
                if (resultSet.next()) {
                    this.defaultAnswerTitle_ = resultSet.getString(1).trim();
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception);
            }
            sQLMethod.close();
        }
        return this.defaultAnswerTitle_;
    }

    public Edge(Question question, Answer answer) {
        this.edgeType_ = 0;
        if (question instanceof QuestionDraft) {
            QuestionDraft questionDraft = (QuestionDraft)question;
            this.activeQuestionInd_ = questionDraft.getActiveQuestionInd();
            this.draftQuestionInd_ = questionDraft.getInd();
            this.activeAnswerInd_ = answer.getActiveAnswerInd();
            this.draftAnswerInd_ = answer.getInd();
        } else {
            this.activeQuestionInd_ = question.getInd();
            this.activeAnswerInd_ = answer.getInd();
        }
        if (this.activeQuestionInd_ == 0 && this.draftQuestionInd_ == 0) {
            throw new IllegalArgumentException("questionInd is 0");
        }
        if (this.activeAnswerInd_ == 0 && this.draftAnswerInd_ == 0) {
            throw new IllegalArgumentException("answerInd is 0");
        }
        this.updateRecStatus(2);
    }

    public Edge(Question question) {
        this.edgeType_ = 1;
        if (question instanceof QuestionDraft) {
            QuestionDraft questionDraft = (QuestionDraft)question;
            this.activeQuestionInd_ = questionDraft.getActiveQuestionInd();
            this.draftQuestionInd_ = questionDraft.getInd();
        } else {
            this.activeQuestionInd_ = question.getInd();
        }
        if (this.activeQuestionInd_ == 0 && this.draftQuestionInd_ == 0) {
            throw new IllegalArgumentException("questionInd is 0");
        }
        this.updateRecStatus(2);
    }

    public Edge(int n, int n2) {
        this.edgeGroupInd_ = 0;
        this.edgeType_ = 0;
        this.activeQuestionInd_ = n;
        this.activeAnswerInd_ = n2;
        if (this.activeQuestionInd_ == 0) {
            throw new IllegalArgumentException("questionInd is 0");
        }
        if (this.activeAnswerInd_ == 0) {
            throw new IllegalArgumentException("answerInd is 0");
        }
        this.updateRecStatus(2);
    }

    public Edge(int n) {
        this.edgeGroupInd_ = 0;
        this.edgeType_ = 1;
        this.activeQuestionInd_ = n;
        this.activeAnswerInd_ = 0;
        if (this.activeQuestionInd_ == 0) {
            throw new IllegalArgumentException("questionInd is 0");
        }
        this.updateRecStatus(2);
    }

    Edge() {
    }
}

