/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionReader;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.EdgeObject;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeReturn;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.shared.pom.PersistentRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class EdgeDraftReader {
    static void readAllEdgesForSymptom(Connection connection, Symptom symptom) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "e.edgeInd, e.edgeType, e.activeAnswerInd, e.draftAnswerInd, " + "e.docClassInd, e.created, e.dbUser, e.changedTime, g.edgeGroupInd " + "FROM   oadraft.edge e, oadraft.edgeGroup g " + "WHERE  e.edgeGroupInd = g.edgeGroupInd " + "AND    g.symptomInd =" + symptom.getInd() + " " + "ORDER BY g.edgeGroupInd " + "FOR FETCH ONLY");
        int n = 0;
        int n2 = -99;
        Vector<Edge> vector = null;
        EdgeGroup edgeGroup = null;
        while (resultSet.next()) {
            n = resultSet.getInt(9);
            if (n != n2) {
                if (vector != null) {
                    edgeGroup.setEdges(vector);
                }
                vector = new Vector<Edge>(2, 5);
                n2 = n;
                edgeGroup = EdgeGroup.findEdgeGroupInVector(n, symptom.getEdgeGroups());
            }
            Edge edge = new Edge();
            edge.setInd(resultSet.getInt(1));
            edge.setEdgeType(resultSet.getShort(2));
            edge.setActiveAnswerInd(resultSet.getInt(3));
            edge.setDraftAnswerInd(resultSet.getInt(4));
            edge.setActiveQuestionInd(edgeGroup.getHeadNode().getActiveObjectInd());
            edge.setDraftQuestionInd(edgeGroup.getHeadNode().getDraftObjectInd());
            edge.setEdgeGroupInd(edgeGroup.getInd());
            edge.setDocClass(new TypeDocClassRec(resultSet.getShort(5), ""));
            edge.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(6)));
            edge.setDbUser(resultSet.getString(7).trim());
            edge.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(8)));
            EdgeDraftReader.readDefaultAnswerTitle(connection, edge);
            edge.updateRecStatus(0);
            vector.addElement(edge);
        }
        resultSet.close();
        statement.close();
        if (vector != null) {
            edgeGroup.setEdges(vector);
        }
        ConditionReader.readAllEdgeConditions(connection, symptom, "oadraft");
        CountryReader.readAllEdgeCountries(connection, symptom, "oadraft");
        EdgeDraftReader.readPreanswerTableForAllEdges(connection, symptom);
    }

    private static void readDefaultAnswerTitle(Connection connection, Edge edge) throws SQLException {
        if (edge.getEdgeType() == 1) {
            edge.setDefaultAnswerTitle("OTHER");
        } else {
            String string;
            int n;
            Statement statement = connection.createStatement();
            if (edge.getDraftAnswerInd() == 0) {
                n = edge.getActiveAnswerInd();
                string = "oa";
            } else {
                n = edge.getDraftAnswerInd();
                string = "oadraft";
            }
            ResultSet resultSet = statement.executeQuery("SELECT title " + "FROM " + string + ".answerTitle " + "WHERE answerInd=" + n + " " + "AND sortOrder=(" + "SELECT MAX(sortOrder) " + "FROM " + string + ".answerTitle " + "WHERE answerInd=" + n + ") " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                edge.setDefaultAnswerTitle(resultSet.getString(1));
            } else {
                edge.setDefaultAnswerTitle("N/A");
            }
            resultSet.close();
            statement.close();
        }
    }

    private static void readPreanswerTableForAllEdges(Connection connection, Symptom symptom) throws SQLException {
        Statement statement = connection.createStatement();
        Statement statement2 = null;
        Statement statement3 = null;
        ResultSet resultSet = statement.executeQuery("SELECT " + "ep.edgePreanswerInd, ep.preanswerType, " + "ep.activeAnswerInd, ep.draftAnswerInd, " + "ep.activeActionInd, ep.draftActionInd, " + "ep.activeQuestionInd, ep.draftQuestionInd, " + "ep.nodeInd, ep.edgeInd " + "FROM oadraft.edgePreanswer ep, oadraft.edge e, oadraft.edgeGroup eg " + "WHERE ep.edgeInd = e.edgeInd " + " AND  e.edgeGroupInd = eg.edgeGroupInd " + " AND  eg.symptomInd = " + symptom.getInd() + " " + "ORDER BY ep.edgeInd " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            Edge edge = symptom.getEdgeByInd(resultSet.getInt(10));
            int n = resultSet.getInt(1);
            short s = resultSet.getShort(2);
            switch (s) {
                case 0: {
                    Object object;
                    int n2 = resultSet.getInt(3);
                    int n3 = resultSet.getInt(4);
                    int n4 = 0;
                    int n5 = 0;
                    if (n2 != 0) {
                        if (statement2 == null) {
                            statement2 = connection.prepareStatement("SELECT questionInd FROM oa.answer WHERE answerInd=? FOR FETCH ONLY");
                        }
                        statement2.setInt(1, n2);
                        object = statement2.executeQuery();
                        object.next();
                        n4 = object.getInt(1);
                        object.close();
                    }
                    if (n3 != 0) {
                        if (statement3 == null) {
                            statement3 = connection.prepareStatement("SELECT questionInd FROM oadraft.answer WHERE answerInd=? FOR FETCH ONLY");
                        }
                        statement3.setInt(1, n3);
                        object = statement3.executeQuery();
                        object.next();
                        n5 = object.getInt(1);
                        object.close();
                    }
                    object = new EdgePreanswer(n4, n2, n5, n3);
                    ((EdgeObject)object).setInd(n);
                    ((EdgeObject)object).setEdgeInd(edge.getInd());
                    ((PersistentRec)object).updateRecStatus(0);
                    edge.addPreanswer((EdgePreanswer)object);
                    break;
                }
                case 1: {
                    int n2 = resultSet.getInt(5);
                    int n6 = resultSet.getInt(6);
                    EdgeAlist edgeAlist = new EdgeAlist(n2, n6);
                    edgeAlist.setInd(n);
                    edgeAlist.setEdgeInd(edge.getInd());
                    edgeAlist.updateRecStatus(0);
                    edge.addActionList(edgeAlist);
                    break;
                }
                case 2: {
                    int n2 = resultSet.getInt(7);
                    int n7 = resultSet.getInt(8);
                    EdgeUnanswer edgeUnanswer = new EdgeUnanswer(n2, n7);
                    edgeUnanswer.setInd(n);
                    edgeUnanswer.setEdgeInd(edge.getInd());
                    edgeUnanswer.updateRecStatus(0);
                    edge.addUnanswer(edgeUnanswer);
                    break;
                }
                case 3: {
                    int n2 = resultSet.getInt(9);
                    EdgeReturn edgeReturn = new EdgeReturn(symptom.getNodeByInd(n2));
                    edgeReturn.setInd(n);
                    edgeReturn.setEdgeInd(edge.getInd());
                    edgeReturn.updateRecStatus(0);
                    edge.setReturnNode(edgeReturn);
                    edge.originalReturnNode = edgeReturn;
                    break;
                }
            }
        }
        resultSet.close();
        statement.close();
        if (statement2 != null) {
            statement2.close();
        }
        if (statement3 != null) {
            statement3.close();
        }
    }

    EdgeDraftReader() {
    }
}

