/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgeObject;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeReturn;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class EdgeDraftWriter {
    static String getSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EdgeDraftWriter.getEdgeSQL(edge));
        if (edge.getRecStatus() != 3) {
            stringBuffer.append(EdgeDraftWriter.getPreanswerTableSQL(edge));
        }
        return stringBuffer.toString();
    }

    static String getEdgeSQL(Edge edge) {
        String string;
        switch (edge.getRecStatus()) {
            case 2: {
                string = EdgeDraftWriter.getInsertSQL(edge);
                break;
            }
            case 1: {
                string = EdgeDraftWriter.getUpdateSQL(edge);
                break;
            }
            case 3: {
                string = EdgeDraftWriter.getDeleteSQL(edge);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.edge (edgeInd, edgeGroupInd, edgeType, activeAnswerInd, draftAnswerInd, docClassInd, dbUser, changedTime) VALUES (");
        stringBuffer.append(edge.getInd()).append(',');
        stringBuffer.append(edge.getEdgeGroupInd()).append(',');
        stringBuffer.append(edge.getEdgeType()).append(',');
        if (edge.getEdgeType() == 0) {
            if (edge.getActiveAnswerInd() != 0) {
                stringBuffer.append(edge.getActiveAnswerInd()).append(',');
            } else {
                stringBuffer.append("NULL,");
            }
            if (edge.getDraftAnswerInd() != 0) {
                stringBuffer.append(edge.getDraftAnswerInd()).append(',');
            } else {
                stringBuffer.append("NULL,");
            }
        } else {
            stringBuffer.append("NULL,NULL,");
        }
        stringBuffer.append(edge.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(edge.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oadraft.edgeCountry", edge.getInd(), edge.getCountryList(), edge.getDbUser()));
        stringBuffer.append(ConditionWriter.getInsertSQL("oadraft.edgeCond", edge.getInd(), edge.getConditions(), edge.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oadraft.edge SET");
        stringBuffer.append(" docClassInd=").append(edge.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(edge.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE edgeInd=").append(edge.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oadraft.edgeCountry", "edgeInd", edge.getInd(), edge.getCountryList(), edge.getOriginalCountryList(), edge.getDbUser()));
        stringBuffer.append(ConditionWriter.getUpdateSQL("oadraft.edgeCond", "edgeInd", edge.getInd(), edge.getConditions(), edge.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL("oadraft.edgeCountry", "edgeInd", edge.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL("oadraft.edgeCond", "edgeInd", edge.getInd()));
        stringBuffer.append("DELETE FROM oadraft.edgePreanswer where edgeInd=").append(edge.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM oadraft.edge WHERE edgeInd=").append(edge.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getPreanswerTableSQL(Edge edge) {
        String string;
        int n;
        EdgeObject edgeObject;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = edge.getPreanswers();
        if (vector != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                edgeObject = (EdgePreanswer)vector.elementAt(n2);
                n = edgeObject.getRecStatus();
                if (n == 3) {
                    stringBuffer.append(EdgeDraftWriter.deleteFromPreanswerTable(edgeObject.getInd()));
                } else if (n == 2) {
                    string = EdgeDraftWriter.createPreanswerSQL((short)0, ((EdgePreanswer)edgeObject).getActiveAnswerInd(), ((EdgePreanswer)edgeObject).getDraftAnswerInd());
                    stringBuffer.append(EdgeDraftWriter.insertIntoPreanswerTable(edge, edgeObject.getInd(), string));
                }
                ++n2;
            }
        }
        if ((vector = edge.getActionList()) != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                edgeObject = (EdgeAlist)vector.elementAt(n2);
                n = edgeObject.getRecStatus();
                if (n == 3) {
                    stringBuffer.append(EdgeDraftWriter.deleteFromPreanswerTable(edgeObject.getInd()));
                } else if (n == 2) {
                    string = EdgeDraftWriter.createPreanswerSQL((short)1, ((EdgeAlist)edgeObject).getActiveActionInd(), ((EdgeAlist)edgeObject).getDraftActionInd());
                    stringBuffer.append(EdgeDraftWriter.insertIntoPreanswerTable(edge, edgeObject.getInd(), string));
                }
                ++n2;
            }
        }
        if ((vector = edge.getUnanswers()) != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                edgeObject = (EdgeUnanswer)vector.elementAt(n2);
                n = edgeObject.getRecStatus();
                if (n == 3) {
                    stringBuffer.append(EdgeDraftWriter.deleteFromPreanswerTable(edgeObject.getInd()));
                } else if (n == 2) {
                    string = EdgeDraftWriter.createPreanswerSQL((short)2, ((EdgeUnanswer)edgeObject).getActiveQuestionInd(), ((EdgeUnanswer)edgeObject).getDraftQuestionInd());
                    stringBuffer.append(EdgeDraftWriter.insertIntoPreanswerTable(edge, edgeObject.getInd(), string));
                }
                ++n2;
            }
        }
        EdgeReturn edgeReturn = edge.getReturnNode();
        if (edge.originalReturnNode != null && edge.originalReturnNode != edgeReturn) {
            stringBuffer.append(EdgeDraftWriter.deleteFromPreanswerTable(edge.originalReturnNode.getInd()));
        }
        if (edgeReturn != null) {
            int n3 = edgeReturn.getRecStatus();
            if (n3 == 3) {
                stringBuffer.append(EdgeDraftWriter.deleteFromPreanswerTable(edgeReturn.getInd()));
            } else if (n3 == 2) {
                String string2 = EdgeDraftWriter.createPreanswerSQL((short)3, edgeReturn.getNodeInd(), 0);
                stringBuffer.append(EdgeDraftWriter.insertIntoPreanswerTable(edge, edgeReturn.getInd(), string2));
            }
        }
        return stringBuffer.toString();
    }

    private static String createPreanswerSQL(short s, int n, int n2) {
        String string = s + ",";
        String string2 = n != 0 ? n + "," : "NULL,";
        String string3 = n2 != 0 ? n2 + "," : "NULL,";
        switch (s) {
            case 0: {
                string = string + string2 + string3 + "NULL,NULL,NULL,NULL,NULL,";
                break;
            }
            case 1: {
                string = string + "NULL,NULL," + string2 + string3 + "NULL,NULL,NULL,";
                break;
            }
            case 2: {
                string = string + "NULL,NULL,NULL,NULL," + string2 + string3 + "NULL,";
                break;
            }
            case 3: {
                string = string + "NULL,NULL,NULL,NULL,NULL,NULL," + string2;
                break;
            }
        }
        return string;
    }

    private static String insertIntoPreanswerTable(Edge edge, int n, String string) {
        String string2 = DatabaseUtil.stringToDB(edge.getDbUser());
        return "INSERT INTO oadraft.edgePreanswer VALUES (" + n + "," + edge.getInd() + "," + string + string2 + "," + "CURRENT TIMESTAMP" + ")" + SqlRunner.END_DELIM;
    }

    private static String deleteFromPreanswerTable(int n) {
        return "DELETE FROM oadraft.edgePreanswer WHERE edgePreanswerInd=" + n + SqlRunner.END_DELIM;
    }

    static String getDeleteAllForSymptomSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from oadraft.edgeCond where edgeind in (select distinct edgeind from oadraft.edge e, oadraft.edgegroup g where e.edgegroupind = g.edgegroupind and   g.symptomind = ").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.edgeCountry where edgeind in (select distinct edgeind from oadraft.edge e, oadraft.edgegroup g where e.edgegroupind = g.edgegroupind and   g.symptomind = ").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.edgePreanswer where edgeind in (select distinct edgeind from oadraft.edge e, oadraft.edgegroup g where e.edgegroupind = g.edgegroupind and   g.symptomind = ").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.edge where edgegroupind in (select distinct edgegroupind from oadraft.edgegroup where symptomind=").append(n).append(')').append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForEdgeGroupSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from oadraft.edgeCond where edgeind in (select distinct edgeind from oadraft.edgegroup where edgegroupind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.edgeCountry where edgeind in (select distinct edgeind from oadraft.edgegroup where edgegroupind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.edgePreanswer where edgeind in (select distinct edgeind from oadraft.edgegroup where edgegroupind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.edge where edgegroupind = ").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    EdgeDraftWriter() {
    }
}

