/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.Constants;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;
import java.util.Vector;

public class EdgeGroup
extends PersistentRec {
    static final long serialVersionUID = 1000000L;
    private int edgeGroupInd_;
    private int symptomInd_;
    private Node headNode_;
    private Node tailNode_;
    private Vector edges_;
    private int xPos_ = 0;
    private int yPos_ = 0;
    private int cxPos_ = 0;
    private int cyPos_ = 0;
    private int zOrder_ = 0;
    private String dbUser_ = null;
    private String changedTime_ = null;

    public int getInd() {
        return this.edgeGroupInd_;
    }

    void setInd(int n) {
        this.edgeGroupInd_ = n;
    }

    boolean assignDatabaseKeys(boolean bl) {
        boolean bl2 = this.assignDatabaseKey(bl);
        if (this.edges_ != null) {
            int n = 0;
            while (n < this.edges_.size() && bl2) {
                Edge edge = (Edge)this.edges_.elementAt(n);
                bl2 = edge.assignDatabaseKeys(bl);
                ++n;
            }
        }
        return bl2;
    }

    void assignDatabaseKeys(Connection connection, boolean bl) throws Exception {
        this.assignDatabaseKey(connection, bl);
        if (this.edges_ != null) {
            int n = 0;
            while (n < this.edges_.size()) {
                Edge edge = (Edge)this.edges_.elementAt(n);
                edge.assignDatabaseKeys(connection, bl);
                ++n;
            }
        }
    }

    private boolean assignDatabaseKey(boolean bl) {
        boolean bl2 = true;
        String string = bl ? "DEDGGRPIND" : "EDGEGRPIND";
        if (this.edgeGroupInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for EdgeGroup: " + string);
            this.edgeGroupInd_ = Counter.getCounter(LogSystem.getInstance(), string);
            if (this.edgeGroupInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for EdgeGroup");
                bl2 = false;
            }
        }
        return bl2;
    }

    private void assignDatabaseKey(Connection connection, boolean bl) throws Exception {
        String string = bl ? "DEDGGRPIND" : "EDGEGRPIND";
        if (this.edgeGroupInd_ == 0) {
            this.edgeGroupInd_ = Counter.getCounter(connection, string);
            if (this.edgeGroupInd_ == 0) {
                throw new Exception("Failed to get database key for EdgeGroup");
            }
        }
    }

    void resetNew() {
        this.setInd(0);
        this.setSymptomInd(0);
        this.updateRecStatus(2);
        if (this.edges_ != null) {
            int n = 0;
            while (n < this.edges_.size()) {
                Edge edge = (Edge)this.edges_.elementAt(n);
                edge.resetNew();
                ++n;
            }
        }
    }

    int getSymptomInd() {
        return this.symptomInd_;
    }

    void setSymptomInd(int n) {
        this.symptomInd_ = n;
    }

    public int getHeadNodeInd() {
        return this.headNode_.getInd();
    }

    public Node getHeadNode() {
        return this.headNode_;
    }

    public int getTailNodeInd() {
        return this.tailNode_.getInd();
    }

    public Node getTailNode() {
        return this.tailNode_;
    }

    public Vector getEdges() {
        return this.edges_;
    }

    public void setEdges(Vector vector) {
        this.edges_ = vector;
    }

    public boolean isGuiDataValid() {
        return this.xPos_ != 0 && this.yPos_ != 0 && this.cxPos_ != 0 && this.cyPos_ != 0 && this.zOrder_ != 0;
    }

    public int getXPos() {
        return this.xPos_;
    }

    public int getYPos() {
        return this.yPos_;
    }

    public int getcXPos() {
        return this.cxPos_;
    }

    public int getcYPos() {
        return this.cyPos_;
    }

    public int getZOrder() {
        return this.zOrder_;
    }

    public void setGuiData(int n, int n2, int n3, int n4, int n5) {
        if (this.xPos_ != n || this.yPos_ != n2 || this.cxPos_ != n3 || this.cyPos_ != n4 || this.zOrder_ != n5) {
            this.updateRecStatus(1);
            this.xPos_ = n;
            this.yPos_ = n2;
            this.cxPos_ = n3;
            this.cyPos_ = n4;
            this.zOrder_ = n5;
        }
    }

    public String getChangedTime() {
        return this.changedTime_;
    }

    void setChangedTime(String string) {
        this.changedTime_ = string;
    }

    public String getDbUser() {
        return this.dbUser_;
    }

    void setDbUser(String string) {
        this.dbUser_ = string;
    }

    public int hashCode() {
        if (this.edgeGroupInd_ == 0) {
            throw new IllegalStateException("hashCode(): EdgeGroup is new");
        }
        return this.getInd();
    }

    public boolean equals(Object object) {
        if (this.edgeGroupInd_ == 0) {
            throw new IllegalStateException("equals(): EdgeGroup is new");
        }
        return object instanceof EdgeGroup && ((EdgeGroup)object).getInd() == this.getInd();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EdgeGroup ").append(this.edgeGroupInd_).append(": ");
        stringBuffer.append(Constants.NL);
        stringBuffer.append("\tHead Node = ").append(this.headNode_.getInd());
        stringBuffer.append(Constants.NL);
        stringBuffer.append("\tTail Node = ").append(this.tailNode_.getInd());
        stringBuffer.append(Constants.NL);
        stringBuffer.append("\tEdge Count = ");
        if (this.edges_ != null) {
            stringBuffer.append(this.edges_.size());
        } else {
            stringBuffer.append(0);
        }
        return stringBuffer.toString();
    }

    void setRecNoChange() {
        this.updateRecStatus(0);
        if (this.edges_ != null) {
            int n = 0;
            while (n < this.edges_.size()) {
                Edge edge = (Edge)this.edges_.elementAt(n);
                edge.setRecNoChange();
                ++n;
            }
        }
    }

    public static EdgeGroup findEdgeGroupInVector(int n, Vector vector) {
        EdgeGroup edgeGroup = null;
        int n2 = 0;
        while (edgeGroup == null && n2 < vector.size()) {
            EdgeGroup edgeGroup2 = (EdgeGroup)vector.elementAt(n2);
            if (edgeGroup2.getInd() == n) {
                edgeGroup = edgeGroup2;
            }
            ++n2;
        }
        return edgeGroup;
    }

    public EdgeGroup(Node node, Node node2) {
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Invalid headNode -- it is not a Question Node");
        }
        this.headNode_ = node;
        this.tailNode_ = node2;
        this.updateRecStatus(2);
    }

    EdgeGroup(int n, Node node, Node node2) {
        this.edgeGroupInd_ = n;
        this.headNode_ = node;
        this.tailNode_ = node2;
    }
}

