/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.DraftObject;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.OAMode;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.oaValidate.ValidationRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Statement;

public class LinkGroupDraft
extends LinkGroup
implements DraftObject {
    static final long serialVersionUID = 1000000L;
    private int activeLinkGroupInd_ = 0;
    private boolean maintLock_ = false;
    private String startDate_ = "";
    private String stopDate_ = null;
    private boolean recycled_ = false;
    private TypeWorkRec typeWork_ = null;
    private String comments_ = "";

    public int getActiveLinkGroupInd() {
        return this.activeLinkGroupInd_;
    }

    public void setActiveLinkGroupInd(int n) {
        this.activeLinkGroupInd_ = n;
    }

    public boolean getMaintLock() {
        return this.maintLock_;
    }

    public void setMaintLock(boolean bl) {
        this.maintLock_ = bl;
        this.updateRecStatus(1);
    }

    public String getStartDate() {
        return this.startDate_;
    }

    public void setStartDate(String string) {
        this.startDate_ = string;
    }

    public String getStopDate() {
        return this.stopDate_;
    }

    public void setStopDate(String string) {
        this.stopDate_ = string;
    }

    public boolean isRecycled() {
        return this.recycled_;
    }

    public void setRecycled(boolean bl) {
        this.recycled_ = bl;
        this.updateRecStatus(1);
    }

    public TypeWorkRec getTypeWorkRequired() {
        return this.typeWork_;
    }

    public void setTypeWorkRequired(TypeWorkRec typeWorkRec) {
        this.typeWork_ = typeWorkRec;
        this.updateRecStatus(1);
    }

    public boolean assignDatabaseKeys() {
        boolean bl = true;
        if (this.linkGroupInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for LinkGroupDraft");
            this.linkGroupInd_ = Counter.getCounter(LogSystem.getInstance(), "DLNKGRPIND");
            if (this.linkGroupInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for LinkGroupDraft");
                bl = false;
            }
        }
        return bl;
    }

    void assignDatabaseKeys(Connection connection) throws Exception {
        if (this.linkGroupInd_ == 0) {
            this.linkGroupInd_ = Counter.getCounter(connection, "DLNKGRPIND");
            if (this.linkGroupInd_ == 0) {
                throw new Exception("Failed to get database key for LinkGroupDraft");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        LogSystem.log(2, ">>> Starting LinkGroupDraft.writeToDatabase()");
        if (!this.assignDatabaseKeys()) {
            return -1;
        }
        int n2 = 0;
        while (this.links_ != null && n2 < this.links_.size()) {
            Link link = (Link)this.links_.elementAt(n2);
            if (link.getInd() == 0) {
                LogSystem.log(2, "Link " + n2 + " does not have a valid indicator");
                return -1;
            }
            ++n2;
        }
        SQLMethod sQLMethod = new SQLMethod(1, "LinkGroupDraft.writeToDatabase()", 5);
        int n = 0;
        StoredProcRec storedProcRec = null;
        try {
            block9: {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.sqlRunner", 2);
                    String string = LinkGroupDraftWriter.getSQL(this);
                    if (string.length() == 0) {
                        LogSystem.log(1, "No changes to be written");
                        int n3 = 0;
                        Object var5_10 = null;
                        sQLMethod.close();
                        return n3;
                    }
                    String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
                    LogSystem.log(1, "Starting to send statements to SQLRUNNER");
                    LogSystem.log(1, string2);
                    callableStatement.registerOutParameter(1, -4);
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.setBytes(1, string.getBytes());
                    callableStatement.execute();
                    storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
                    callableStatement.close();
                    if (storedProcRec == null) {
                        LogSystem.log(2, "StoredProcRec is null - error status unknown");
                    }
                    if (storedProcRec == null || !storedProcRec.error) break block9;
                    LogSystem.log(2, storedProcRec.errorStr);
                    n = storedProcRec.sqlCode;
                    if (n != 0) break block9;
                    n = -1;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    n = -1;
                    Object var5_12 = null;
                    sQLMethod.close();
                }
            }
            Object var5_11 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> LinkGroupDraft.writeToDatabase() complete");
        return n;
    }

    public ValidationRec validate() {
        LogSystem.log(2, ">>> Starting LinkDraft.validate()");
        SQLMethod sQLMethod = new SQLMethod(1, "", 10);
        ValidationRec validationRec = null;
        try {
            block5: {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAValidate", 3);
                    callableStatement.registerOutParameter(3, -4);
                    callableStatement.setInt(1, this.getInd());
                    callableStatement.setInt(2, 104);
                    callableStatement.execute();
                    validationRec = (ValidationRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    callableStatement.close();
                    if (validationRec == null) {
                        LogSystem.log(2, "ValidationRec was returned null");
                    }
                    if (validationRec == null || !validationRec.error) break block5;
                    LogSystem.log(2, validationRec.errorStr);
                    validationRec = null;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    validationRec = null;
                    Object var4_6 = null;
                    sQLMethod.close();
                }
            }
            Object var4_5 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> LinkDraft.validate() complete");
        return validationRec;
    }

    public boolean publish() {
        LogSystem.log(2, ">>> Starting LinkGroupDraft.publish()");
        SQLMethod sQLMethod = new SQLMethod(1, "LinkGroupDraft.publish()", 10);
        boolean bl = true;
        StoredProcRec storedProcRec = null;
        try {
            block7: {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAPublish", 3);
                    callableStatement.registerOutParameter(3, -4);
                    callableStatement.setInt(1, this.getInd());
                    callableStatement.setInt(2, 4);
                    callableStatement.execute();
                    storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    callableStatement.close();
                    if (storedProcRec == null) {
                        LogSystem.log(2, "StoredProcRec is null - error status unknown");
                    } else if (storedProcRec.userError.length() > 0) {
                        LogSystem.log(1, "Publish SQL:");
                        LogSystem.log(2, storedProcRec.userError);
                    }
                    if (storedProcRec == null || !storedProcRec.error) break block7;
                    LogSystem.log(2, storedProcRec.errorStr);
                    bl = false;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    bl = false;
                    Object var5_7 = null;
                    sQLMethod.close();
                }
            }
            Object var5_6 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> LinkGroupDraft.publish() complete");
        return bl;
    }

    public static LinkGroup readFromDatabase(int n, int n2) {
        LogSystem.log(2, ">>> Starting LinkGroupDraft.readFromDatabase()");
        SQLMethod sQLMethod = new SQLMethod(1, "LinkGroupDraft.readFromDatabase()", 5);
        StoredProcRec storedProcRec = null;
        LinkGroup linkGroup = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 4);
            callableStatement.setInt(3, 1);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            linkGroup = (LinkGroupDraft)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        LogSystem.log(2, ">>> LinkGroupDraft.readFromDatabase() completed");
        if (linkGroup != null) {
            linkGroup.updateTypeRecData();
        } else {
            LogSystem.log(2, "No object found for indicator " + n);
        }
        return linkGroup;
    }

    public static LinkGroupDraft getDraft(int n, int n2, TypeWorkRec typeWorkRec) throws PendingDraftException {
        LogSystem.log(2, ">>> Starting LinkGroupDraft.getDraft()");
        SQLMethod sQLMethod = new SQLMethod(1, "LinkGroupDraft.getDraft()", 5);
        StoredProcRec storedProcRec = null;
        LinkGroupDraft linkGroupDraft = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 4);
            callableStatement.setInt(3, 2);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            linkGroupDraft = (LinkGroupDraft)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            } else if (linkGroupDraft != null) {
                if (linkGroupDraft.getRecStatus() == 2) {
                    linkGroupDraft.setTypeWorkRequired(typeWorkRec);
                }
                linkGroupDraft.updateTypeRecData();
            } else {
                LogSystem.log(2, "No object found for indicator " + n);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        LogSystem.log(2, ">>> LinkGroupDraft.getDraft() completed");
        if (storedProcRec != null && storedProcRec.error && storedProcRec.sqlCode == 100) {
            throw new PendingDraftException();
        }
        return linkGroupDraft;
    }

    public void setComments(String string) {
        this.comments_ = string;
        this.updateRecStatus(1);
    }

    public String getComments() {
        return this.comments_;
    }

    public static void forceCloseDraft(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "forceCloseDraft", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("UPDATE oa.linkGroup SET openDraft='N' " + "WHERE linkGroupInd=" + n + " " + "AND (" + "SELECT linkGroupInd FROM oadraft.linkGroup " + "WHERE activeLinkGroupInd=" + n + " " + "AND stopDate IS NULL" + ") IS NULL");
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
    }

    public LinkGroupDraft(String string) {
        super(string);
        TypeList typeList = TypeList.getInstance();
        this.typeWork_ = (TypeWorkRec)typeList.objectFromInd(1, 14);
    }

    public LinkGroupDraft(int n) {
        super(n);
    }

    LinkGroupDraft(LinkGroup linkGroup) {
        super(linkGroup);
        this.activeLinkGroupInd_ = linkGroup.linkGroupInd_;
    }
}

