/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupReader;
import com.ibm.nzna.projects.common.quest.oa.LinkReader;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class LinkGroupDraftReader {
    public static boolean readFromDB(Connection connection, LinkGroupDraft linkGroupDraft, int n) throws SQLException {
        boolean bl;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "activeLinkGroupInd, " + "maintLock, startDate, stopDate, recycled, " + "archived, created, dbUser, changedTime, typeWorkInd, comments " + "FROM oadraft.linkGroup " + "WHERE linkGroupInd=" + linkGroupDraft.getInd() + " " + "FOR FETCH ONLY");
        if (!resultSet.next()) {
            bl = false;
            resultSet.close();
            statement.close();
        } else {
            bl = true;
            linkGroupDraft.setActiveLinkGroupInd(resultSet.getInt(1));
            linkGroupDraft.setMaintLock(DatabaseUtil.booleanFromDB(resultSet.getString(2)));
            linkGroupDraft.setStartDate(resultSet.getString(3));
            linkGroupDraft.setStopDate(resultSet.getString(4));
            linkGroupDraft.setRecycled(DatabaseUtil.booleanFromDB(resultSet.getString(5)));
            linkGroupDraft.setArchived(DatabaseUtil.booleanFromDB(resultSet.getString(6)));
            linkGroupDraft.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            linkGroupDraft.setDbUser(resultSet.getString(8).trim());
            linkGroupDraft.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            linkGroupDraft.setTypeWorkRequired(new TypeWorkRec(resultSet.getShort(10), ""));
            linkGroupDraft.setComments(resultSet.getString(11));
            if (resultSet.wasNull()) {
                linkGroupDraft.setComments("");
            }
            resultSet.close();
            statement.close();
            LinkGroupDraftReader.readLinkGroupLinks(connection, linkGroupDraft, n);
            if (n == 0) {
                LinkGroupDraftReader.readLinkGroupTitles(connection, linkGroupDraft);
            } else {
                LinkGroupDraftReader.readLinkGroupTitles(connection, linkGroupDraft, n);
            }
            linkGroupDraft.updateRecStatus(0);
        }
        return bl;
    }

    static void readLinkGroupTitles(Connection connection, LinkGroup linkGroup, int n) throws SQLException {
        String string;
        Statement statement = connection.createStatement();
        String string2 = string = "SELECT " + "languageInd, lastTranslated, title, " + "dbUser, changedTime " + "FROM oadraft.linkGroupTitle " + "WHERE linkGroupInd=" + linkGroup.getInd();
        ResultSet resultSet = statement.executeQuery(string2 = string2 + " AND languageInd=" + n + " FOR FETCH ONLY");
        if (!resultSet.next()) {
            string2 = string;
            string2 = string2 + " AND languageInd=1 FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            resultSet.next();
        }
        TypeLanguageRec typeLanguageRec = new TypeLanguageRec(resultSet.getShort(1), "");
        String string3 = resultSet.getString(3);
        LanguageText languageText = new LanguageText(string3, typeLanguageRec);
        languageText.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(2)));
        languageText.setDbUser(resultSet.getString(4));
        languageText.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
        languageText.updateRecStatus(0);
        Vector<LanguageText> vector = new Vector<LanguageText>(1);
        vector.addElement(languageText);
        resultSet.close();
        statement.close();
        linkGroup.setLinkGroupTitles(vector);
    }

    static void readLinkGroupTitles(Connection connection, LinkGroup linkGroup) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT " + "languageInd, lastTranslated, title, " + "dbUser, changedTime " + "FROM oadraft.linkGroupTitle " + "WHERE linkGroupInd=" + linkGroup.getInd() + " " + "ORDER BY languageInd " + "FOR FETCH ONLY";
        ResultSet resultSet = statement.executeQuery(string);
        Vector<LanguageText> vector = new Vector<LanguageText>();
        while (resultSet.next()) {
            TypeLanguageRec typeLanguageRec = new TypeLanguageRec(resultSet.getShort(1), "");
            String string2 = resultSet.getString(3);
            LanguageText languageText = new LanguageText(string2, typeLanguageRec);
            languageText.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(2)));
            languageText.setDbUser(resultSet.getString(4));
            languageText.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            languageText.updateRecStatus(0);
            vector.addElement(languageText);
        }
        resultSet.close();
        statement.close();
        linkGroup.setLinkGroupTitles(vector);
    }

    static void readLinkGroupLinks(Connection connection, LinkGroup linkGroup, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT linkInd " + "FROM oadraft.linkGroupLinks " + "WHERE linkGroupInd=" + linkGroup.getInd() + " " + "ORDER BY sortOrder " + "FOR FETCH ONLY");
        Vector<Link> vector = new Vector<Link>();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            Link link = LinkReader.readFromDB(connection, n2, n);
            vector.addElement(link);
        }
        resultSet.close();
        statement.close();
        linkGroup.setLinks(vector);
    }

    public static LinkGroupDraft getDraft(Connection connection, int n, int n2) throws SQLException, PendingDraftException {
        Statement statement = connection.createStatement();
        LinkGroupDraft linkGroupDraft = null;
        ResultSet resultSet = statement.executeQuery("SELECT linkGroupInd " + "FROM oadraft.linkGroup " + "WHERE stopDate IS NULL AND activeLinkGroupInd=" + n + " " + "FOR FETCH ONLY");
        if (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            resultSet.close();
            LinkGroupDraft linkGroupDraft2 = new LinkGroupDraft(n3);
            if (LinkGroupDraftReader.readFromDB(connection, linkGroupDraft2, n2)) {
                linkGroupDraft = linkGroupDraft2;
            }
        } else {
            resultSet.close();
            LinkGroup linkGroup = new LinkGroup(n);
            if (LinkGroupReader.readFromDB(connection, linkGroup, n2)) {
                LinkGroupDraft linkGroupDraft3;
                if (linkGroup.hasOpenDraft()) {
                    throw new PendingDraftException();
                }
                linkGroupDraft = linkGroupDraft3 = new LinkGroupDraft(linkGroup);
                statement.executeUpdate("UPDATE oa.linkGroup " + "SET openDraft='Y' " + "WHERE linkGroupInd=" + n);
            }
        }
        statement.close();
        return linkGroupDraft;
    }
}

