/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class LinkGroupDraftWriter {
    static String getSQL(LinkGroupDraft linkGroupDraft) {
        String string;
        switch (linkGroupDraft.getRecStatus()) {
            case 2: {
                string = LinkGroupDraftWriter.getInsertSQL(linkGroupDraft);
                break;
            }
            case 1: {
                string = LinkGroupDraftWriter.getUpdateSQL(linkGroupDraft);
                break;
            }
            case 3: {
                string = LinkGroupDraftWriter.getDeleteSQL(linkGroupDraft);
                break;
            }
            default: {
                string = "";
            }
        }
        if (linkGroupDraft.getRecStatus() != 3) {
            string = string + LinkGroupDraftWriter.getLinkGroupTitleSQL(linkGroupDraft);
        }
        if (!linkGroupDraft.modified() && string.length() > 0) {
            string = string + "UPDATE oadraft.linkGroup " + "SET changedTime=CURRENT TIMESTAMP " + "WHERE linkGroupInd=" + linkGroupDraft.getInd() + SqlRunner.END_DELIM;
        }
        return string;
    }

    static String getInsertSQL(LinkGroupDraft linkGroupDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.linkGroup (linkGroupInd, activeLinkGroupInd,  typeWorkInd, comments, maintLock, startDate, stopDate, recycled, archived, dbUser, created, changedTime) VALUES (");
        stringBuffer.append(linkGroupDraft.getInd()).append(',');
        if (linkGroupDraft.getActiveLinkGroupInd() == 0) {
            stringBuffer.append("NULL").append(',');
        } else {
            stringBuffer.append(linkGroupDraft.getActiveLinkGroupInd()).append(',');
        }
        stringBuffer.append(linkGroupDraft.getTypeWorkRequired().getInd()).append(',');
        String string = linkGroupDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL,");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string)).append(',');
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(linkGroupDraft.getMaintLock())).append(',');
        stringBuffer.append("CURRENT DATE").append(',');
        stringBuffer.append("NULL").append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(linkGroupDraft.isRecycled())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(linkGroupDraft.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(linkGroupDraft.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(LinkGroupDraftWriter.getLinkGroupLinksInsertSQL(linkGroupDraft));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(LinkGroupDraft linkGroupDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oadraft.linkGroup SET");
        stringBuffer.append(" typeWorkInd=").append(linkGroupDraft.getTypeWorkRequired().getInd());
        stringBuffer.append(",comments=");
        String string = linkGroupDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string));
        }
        stringBuffer.append(",maintLock=").append(DatabaseUtil.booleanToDB(linkGroupDraft.getMaintLock()));
        stringBuffer.append(",recycled=").append(DatabaseUtil.booleanToDB(linkGroupDraft.isRecycled()));
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(linkGroupDraft.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(linkGroupDraft.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP ");
        stringBuffer.append("WHERE linkGroupInd=").append(linkGroupDraft.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(LinkGroupDraftWriter.getLinkGroupLinksDeleteSQL(linkGroupDraft));
        stringBuffer.append(LinkGroupDraftWriter.getLinkGroupLinksInsertSQL(linkGroupDraft));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(LinkGroupDraft linkGroupDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(LinkGroupDraftWriter.getLinkGroupLinksDeleteSQL(linkGroupDraft));
        stringBuffer.append("DELETE FROM oadraft.linkGroupTitle WHERE linkGroupInd=").append(linkGroupDraft.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM oadraft.linkGroup WHERE linkgroupInd=").append(linkGroupDraft.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkGroupLinksInsertSQL(LinkGroupDraft linkGroupDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        Vector vector = linkGroupDraft.getLinks();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("INSERT INTO oadraft.linkGroupLinks (linkGroupInd, linkInd, sortOrder, dbUser, changedTime) VALUES (");
            Link link = (Link)vector.elementAt(n);
            stringBuffer.append(linkGroupDraft.getInd()).append(',');
            stringBuffer.append(link.getInd()).append(',');
            stringBuffer.append(n + 1).append(',');
            stringBuffer.append(DatabaseUtil.stringToDB(linkGroupDraft.getDbUser())).append(',');
            stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
            ++n;
        }
        return stringBuffer.toString();
    }

    static String getLinkGroupLinksDeleteSQL(LinkGroupDraft linkGroupDraft) {
        return "DELETE FROM oadraft.linkGroupLinks " + "WHERE linkgroupInd=" + linkGroupDraft.getInd() + SqlRunner.END_DELIM;
    }

    static String getLinkGroupTitleSQL(LinkGroupDraft linkGroupDraft) {
        String string = "";
        Vector vector = linkGroupDraft.getLinkGroupTitles();
        int n = 0;
        while (n < vector.size()) {
            LanguageText languageText = (LanguageText)vector.elementAt(n);
            switch (languageText.getRecStatus()) {
                case 2: {
                    string = string + LinkGroupDraftWriter.getLinkGroupTitleInsertSQL(linkGroupDraft, languageText);
                    break;
                }
                case 1: {
                    string = string + LinkGroupDraftWriter.getLinkGroupTitleUpdateSQL(linkGroupDraft, languageText);
                    break;
                }
                case 3: {
                    string = string + LinkGroupDraftWriter.getLinkGroupTitleDeleteSQL(linkGroupDraft, languageText);
                    break;
                }
            }
            ++n;
        }
        return string;
    }

    static String getLinkGroupTitleInsertSQL(LinkGroupDraft linkGroupDraft, LanguageText languageText) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.linkGroupTitle (linkgroupInd, languageInd, lastTranslated, title, dbUser, changedTime) VALUES(");
        stringBuffer.append(linkGroupDraft.getInd()).append(',');
        stringBuffer.append(languageText.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(languageText.getLastTranslationDate())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(languageText.getText())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(linkGroupDraft.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkGroupTitleUpdateSQL(LinkGroupDraft linkGroupDraft, LanguageText languageText) {
        return "UPDATE oadraft.linkGroupTitle SET" + " title=" + DatabaseUtil.stringToDB(languageText.getText()) + ",lastTranslated=" + DatabaseUtil.timestampToDB(languageText.getLastTranslationDate()) + ",dbUser=" + DatabaseUtil.timestampToDB(linkGroupDraft.getDbUser()) + ",changedTime=CURRENT TIMESTAMP " + "WHERE linkGroupInd=" + linkGroupDraft.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    static String getLinkGroupTitleDeleteSQL(LinkGroupDraft linkGroupDraft, LanguageText languageText) {
        return "DELETE FROM oadraft.linkGroupTitle " + "WHERE linkGroupInd=" + linkGroupDraft.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    LinkGroupDraftWriter() {
    }
}

