/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.sql.Connection;
import java.util.Vector;

public class LinkGroupWriter {
    static String getSQL(LinkGroup linkGroup) {
        String string;
        switch (linkGroup.getRecStatus()) {
            case 2: {
                string = LinkGroupWriter.getInsertSQL(linkGroup);
                break;
            }
            case 1: {
                string = LinkGroupWriter.getUpdateSQL(linkGroup);
                break;
            }
            case 3: {
                string = LinkGroupWriter.getDeleteSQL(linkGroup);
                break;
            }
            default: {
                string = "";
            }
        }
        if (linkGroup.getRecStatus() != 3) {
            string = string + LinkGroupWriter.getLinkGroupTitleSQL(linkGroup);
        }
        if (!linkGroup.modified() && string.length() > 0) {
            string = string + "UPDATE oa.linkGroup " + "SET changedTime=CURRENT TIMESTAMP " + "WHERE linkGroupInd=" + linkGroup.getInd() + SqlRunner.END_DELIM;
        }
        return string;
    }

    static String getInsertSQL(LinkGroup linkGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.linkGroup (linkGroupInd, archived, dbUser, created, changedTime, openDraft) VALUES (");
        stringBuffer.append(linkGroup.getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(linkGroup.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(linkGroup.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, CURRENT TIMESTAMP, 'N')").append(SqlRunner.END_DELIM);
        stringBuffer.append(LinkGroupWriter.getLinkGroupLinksInsertSQL(linkGroup));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(LinkGroup linkGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.linkGroup SET");
        stringBuffer.append(" archived=").append(DatabaseUtil.booleanToDB(linkGroup.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(linkGroup.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP ");
        stringBuffer.append("WHERE linkGroupInd=").append(linkGroup.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(LinkGroupWriter.getLinkGroupLinksDeleteSQL(linkGroup));
        stringBuffer.append(LinkGroupWriter.getLinkGroupLinksInsertSQL(linkGroup));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(LinkGroup linkGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(LinkGroupWriter.getLinkGroupLinksDeleteSQL(linkGroup));
        stringBuffer.append("DELETE FROM oa.linkGroupTitle WHERE linkGroupInd=").append(linkGroup.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM oa.linkGroup WHERE linkgroupInd=").append(linkGroup.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkGroupLinksInsertSQL(LinkGroup linkGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        Vector vector = linkGroup.getLinks();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("INSERT INTO oa.linkGroupLinks (linkGroupInd, linkInd, sortOrder, dbUser, changedTime) VALUES (");
            Link link = (Link)vector.elementAt(n);
            stringBuffer.append(linkGroup.getInd()).append(',');
            stringBuffer.append(link.getInd()).append(',');
            stringBuffer.append(n + 1).append(',');
            stringBuffer.append(DatabaseUtil.stringToDB(linkGroup.getDbUser())).append(',');
            stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
            ++n;
        }
        return stringBuffer.toString();
    }

    static String getLinkGroupLinksDeleteSQL(LinkGroup linkGroup) {
        return "DELETE FROM oa.linkGroupLinks " + "WHERE linkgroupInd=" + linkGroup.getInd() + SqlRunner.END_DELIM;
    }

    static String getLinkGroupTitleSQL(LinkGroup linkGroup) {
        String string = "";
        Vector vector = linkGroup.getLinkGroupTitles();
        int n = 0;
        while (n < vector.size()) {
            LanguageText languageText = (LanguageText)vector.elementAt(n);
            switch (languageText.getRecStatus()) {
                case 2: {
                    string = string + LinkGroupWriter.getLinkGroupTitleInsertSQL(linkGroup, languageText);
                    break;
                }
                case 1: {
                    string = string + LinkGroupWriter.getLinkGroupTitleUpdateSQL(linkGroup, languageText);
                    break;
                }
                case 3: {
                    string = string + LinkGroupWriter.getLinkGroupTitleDeleteSQL(linkGroup, languageText);
                    break;
                }
            }
            ++n;
        }
        return string;
    }

    static String getLinkGroupTitleInsertSQL(LinkGroup linkGroup, LanguageText languageText) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.linkGroupTitle (linkgroupInd, languageInd, lastTranslated, title, dbUser, changedTime) VALUES(");
        stringBuffer.append(linkGroup.getInd()).append(',');
        stringBuffer.append(languageText.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(languageText.getLastTranslationDate())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(languageText.getText())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(linkGroup.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkGroupTitleUpdateSQL(LinkGroup linkGroup, LanguageText languageText) {
        return "UPDATE oa.linkGroupTitle SET" + " title=" + DatabaseUtil.stringToDB(languageText.getText()) + ",lastTranslated=" + DatabaseUtil.timestampToDB(languageText.getLastTranslationDate()) + ",dbUser=" + DatabaseUtil.timestampToDB(linkGroup.getDbUser()) + ",changedTime=CURRENT TIMESTAMP " + "WHERE linkGroupInd=" + linkGroup.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    static String getLinkGroupTitleDeleteSQL(LinkGroup linkGroup, LanguageText languageText) {
        return "DELETE FROM oa.linkGroupTitle " + "WHERE linkGroupInd=" + linkGroup.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    public static String getPublishSQL(Connection connection, LinkGroupDraft linkGroupDraft) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(500);
        LinkGroup linkGroup = new LinkGroup(linkGroupDraft);
        linkGroup.assignDatabaseKeys(connection);
        if (linkGroup.getRecStatus() == 1) {
            stringBuffer.append("DELETE FROM oa.linkGroupTitle WHERE linkGroupInd=").append(linkGroup.getInd()).append(SqlRunner.END_DELIM);
        }
        stringBuffer.append(LinkGroupWriter.getSQL(linkGroup));
        stringBuffer.append("UPDATE oa.linkGroup SET openDraft='N' WHERE linkGroupInd=").append(linkGroup.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("UPDATE oadraft.linkGroup " + "SET stopDate=CURRENT DATE, " + "changedTime=CURRENT TIMESTAMP, " + "activeLinkGroupInd=" + linkGroup.getInd() + " " + "WHERE linkGroupInd=" + linkGroupDraft.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }
}

