/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.ExternalLink;
import com.ibm.nzna.projects.common.quest.oa.ExternalLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestLink;
import com.ibm.nzna.projects.common.quest.oa.QuestLinkDraft;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.sql.Connection;
import java.util.Vector;

public class LinkWriter {
    static String getSQL(Link link) {
        String string;
        switch (link.getRecStatus()) {
            case 2: {
                string = LinkWriter.getInsertSQL(link);
                break;
            }
            case 1: {
                string = LinkWriter.getUpdateSQL(link);
                break;
            }
            case 3: {
                string = LinkWriter.getDeleteSQL(link);
                break;
            }
            default: {
                string = "";
            }
        }
        if (link.getRecStatus() != 3) {
            string = string + LinkWriter.getLinkTitleSQL(link);
        }
        if (!link.modified() && string.length() > 0) {
            string = string + "UPDATE oa.link " + "SET changedTime=CURRENT TIMESTAMP " + "WHERE linkInd=" + link.getInd() + SqlRunner.END_DELIM;
        }
        return string;
    }

    static String getInsertSQL(Link link) {
        Link link2;
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.link (linkInd, linkType, docInd, url, urlValid, archived, dbUser, created, changedTime, openDraft) VALUES (");
        stringBuffer.append(link.getInd()).append(',');
        if (link instanceof ExternalLink) {
            link2 = (ExternalLink)link;
            stringBuffer.append(1).append(',');
            stringBuffer.append("NULL").append(',');
            stringBuffer.append(DatabaseUtil.stringToDB(((ExternalLink)link2).getUrl())).append(',');
            stringBuffer.append(DatabaseUtil.booleanToDB(((ExternalLink)link2).isUrlValid())).append(',');
        } else {
            link2 = (QuestLink)link;
            stringBuffer.append(0).append(',');
            stringBuffer.append(((QuestLink)link2).getDocInd()).append(',');
            stringBuffer.append("NULL,NULL,");
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(link.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(link.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, CURRENT TIMESTAMP, 'N')").append(SqlRunner.END_DELIM);
        if (link instanceof QuestLink) {
            link2 = (QuestLink)link;
            stringBuffer.append("UPDATE tigris.documents " + "SET knowledgebase='Y' " + "WHERE docInd=" + ((QuestLink)link2).getDocInd()).append(SqlRunner.END_DELIM);
            stringBuffer.append("UPDATE quest.documents " + "SET knowledgebase='Y' " + "WHERE existingDocInd=" + ((QuestLink)link2).getDocInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Link link) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.link SET");
        stringBuffer.append(" archived=").append(DatabaseUtil.booleanToDB(link.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(link.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        if (link instanceof ExternalLink) {
            ExternalLink externalLink = (ExternalLink)link;
            stringBuffer.append(",url=").append(DatabaseUtil.stringToDB(externalLink.getUrl()));
            stringBuffer.append(",urlValid=").append(DatabaseUtil.booleanToDB(externalLink.isUrlValid()));
        }
        stringBuffer.append(" WHERE linkInd=").append(link.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Link link) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM oa.linkTitle WHERE linkInd=").append(link.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM oa.link WHERE linkInd=").append(link.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkTitleSQL(Link link) {
        String string = "";
        Vector vector = link.getLinkTitles();
        int n = 0;
        while (n < vector.size()) {
            LanguageText languageText = (LanguageText)vector.elementAt(n);
            switch (languageText.getRecStatus()) {
                case 2: {
                    string = string + LinkWriter.getLinkTitleInsertSQL(link, languageText);
                    break;
                }
                case 1: {
                    string = string + LinkWriter.getLinkTitleUpdateSQL(link, languageText);
                    break;
                }
                case 3: {
                    string = string + LinkWriter.getLinkTitleDeleteSQL(link, languageText);
                    break;
                }
            }
            ++n;
        }
        return string;
    }

    static String getLinkTitleInsertSQL(Link link, LanguageText languageText) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.linkTitle (linkInd, languageInd, lastTranslated, title, dbUser, changedTime) VALUES(");
        stringBuffer.append(link.getInd()).append(',');
        stringBuffer.append(languageText.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(languageText.getLastTranslationDate())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(languageText.getText())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(link.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkTitleUpdateSQL(Link link, LanguageText languageText) {
        return "UPDATE oa.linkTitle SET" + " title=" + DatabaseUtil.stringToDB(languageText.getText()) + ",lastTranslated=" + DatabaseUtil.timestampToDB(languageText.getLastTranslationDate()) + ",dbUser=" + DatabaseUtil.timestampToDB(link.getDbUser()) + ",changedTime=CURRENT TIMESTAMP " + "WHERE linkInd=" + link.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    static String getLinkTitleDeleteSQL(Link link, LanguageText languageText) {
        return "DELETE FROM oa.linkTitle " + "WHERE linkInd=" + link.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    public static String getPublishSQL(Connection connection, LinkDraft linkDraft) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(500);
        Link link = linkDraft instanceof QuestLinkDraft ? new QuestLink((QuestLinkDraft)linkDraft) : new ExternalLink((ExternalLinkDraft)linkDraft);
        link.assignDatabaseKeys(connection);
        if (link.getRecStatus() == 1) {
            stringBuffer.append("DELETE FROM oa.linkTitle WHERE linkInd=").append(link.getInd()).append(SqlRunner.END_DELIM);
        }
        stringBuffer.append(LinkWriter.getSQL(link));
        stringBuffer.append("UPDATE oa.link SET openDraft='N' WHERE linkInd=").append(link.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("UPDATE oadraft.link " + "SET stopDate=CURRENT DATE, " + "changedTime=CURRENT TIMESTAMP, " + "activeLinkInd=" + link.getInd() + " " + "WHERE linkInd=" + linkDraft.asLink().getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }
}

