/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.AddtlInfoReader;
import com.ibm.nzna.projects.common.quest.oa.AnswerDraftReader;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLinkReader;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionReader;
import com.ibm.nzna.projects.common.quest.oa.TitleReader;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeQuestionRec;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class QuestionDraftReader {
    public static boolean readFromDB(Connection connection, QuestionDraft questionDraft, int n) throws SQLException {
        boolean bl;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "activeQuestionInd, questionTypeInd, hiddenFlag, autoFillFlag, " + "brandInd, typeWorkInd, docClassInd, " + "maintLock, startDate, stopDate, recycled, " + "archived, created, dbUser, changedTime, comments " + "FROM oadraft.question " + "WHERE questionInd=" + questionDraft.getInd() + " " + "FOR FETCH ONLY");
        if (!resultSet.next()) {
            bl = false;
            statement.close();
        } else {
            bl = true;
            questionDraft.setActiveQuestionInd(resultSet.getInt(1));
            questionDraft.setQuestionType(new TypeQuestionRec(resultSet.getShort(2), ""));
            questionDraft.setHiddenAnswers(DatabaseUtil.booleanFromDB(resultSet.getString(3)));
            questionDraft.setAutoFill(DatabaseUtil.booleanFromDB(resultSet.getString(4)));
            questionDraft.setBrand(new TypeBrandRec(resultSet.getInt(5), "", 0));
            questionDraft.setTypeWorkRequired(new TypeWorkRec(resultSet.getInt(6), ""));
            questionDraft.setDocClass(new TypeDocClassRec(resultSet.getShort(7), ""));
            questionDraft.setMaintLock(DatabaseUtil.booleanFromDB(resultSet.getString(8)));
            questionDraft.setStartDate(resultSet.getString(9));
            questionDraft.setStopDate(resultSet.getString(10));
            questionDraft.setRecycled(DatabaseUtil.booleanFromDB(resultSet.getString(11)));
            questionDraft.setArchived(DatabaseUtil.booleanFromDB(resultSet.getString(12)));
            questionDraft.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(13)));
            questionDraft.setDbUser(resultSet.getString(14).trim());
            questionDraft.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(15)));
            questionDraft.setComments(resultSet.getString(16));
            if (resultSet.wasNull()) {
                questionDraft.setComments("");
            }
            statement.close();
            questionDraft.setCountryList(CountryReader.readCountries(connection, "oadraft.questionCountry", "questionInd", questionDraft.getInd()));
            AnswerDraftReader.readAnswersForQuestion(connection, questionDraft, n);
            TitleReader.readQuestionDraftTitles(connection, questionDraft, n);
            AddtlInfoReader.readQuestionDraftAddtlInfo(connection, questionDraft, n, 0);
            DocLinkReader.readQuestionDraftDocLinks(connection, questionDraft);
            questionDraft.updateRecStatus(0);
            questionDraft.answersByInd_ = null;
        }
        return bl;
    }

    public static QuestionDraft getDraft(Connection connection, int n, int n2) throws SQLException, PendingDraftException {
        Statement statement = connection.createStatement();
        QuestionDraft questionDraft = null;
        ResultSet resultSet = statement.executeQuery("SELECT questionInd " + "FROM oadraft.question " + "WHERE stopDate IS NULL AND activeQuestionInd=" + n + " " + "FOR FETCH ONLY");
        if (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            resultSet.close();
            QuestionDraft questionDraft2 = new QuestionDraft(n3);
            if (QuestionDraftReader.readFromDB(connection, questionDraft2, n2)) {
                questionDraft = questionDraft2;
            }
        } else {
            resultSet.close();
            Question question = new Question(n);
            if (QuestionReader.readFromDB(connection, question, n2, 0)) {
                QuestionDraft questionDraft3;
                if (question.hasOpenDraft()) {
                    throw new PendingDraftException();
                }
                questionDraft = questionDraft3 = new QuestionDraft(question);
                statement.executeUpdate("UPDATE oa.question " + "SET openDraft='Y' " + "WHERE questionInd=" + n);
            }
        }
        statement.close();
        return questionDraft;
    }
}

