/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfoGraphic;
import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class QuestionInfoWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(AddtlInfo addtlInfo) {
        String string;
        switch (addtlInfo.getRecStatus()) {
            case 2: {
                string = QuestionInfoWriter.getInsertSQL(addtlInfo, SCHEMA);
                break;
            }
            case 1: {
                string = QuestionInfoWriter.getUpdateSQL(addtlInfo, SCHEMA);
                break;
            }
            case 3: {
                string = QuestionInfoWriter.getDeleteSQL(addtlInfo, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".questionAddInfo " + "(questionAddInfoInd, questionInd, sortOrder, addInfo, languageInd, " + "lastTranslated, titleInd, docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(addtlInfo.getInd()).append(',');
        stringBuffer.append(addtlInfo.getParentInd()).append(',');
        stringBuffer.append(addtlInfo.getSortOrder()).append(',');
        stringBuffer.append("'To be updated by PreparedStatement'").append(',');
        stringBuffer.append(addtlInfo.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(addtlInfo.getLastTranslationDate())).append(',');
        if (addtlInfo.getParentTitleInd() == 0) {
            stringBuffer.append("null").append(',');
        } else {
            stringBuffer.append(addtlInfo.getParentTitleInd()).append(',');
        }
        stringBuffer.append(addtlInfo.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(addtlInfo.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        if (addtlInfo.getLanguage().getInd() == 1) {
            stringBuffer.append(CountryWriter.getInsertSQL(string + ".questionInfoCntry", addtlInfo.getInd(), addtlInfo.getCountryList(), addtlInfo.getDbUser()));
            stringBuffer.append(ConditionWriter.getInsertSQL(string + ".questionInfoCond", addtlInfo.getInd(), addtlInfo.getConditions(), addtlInfo.getDbUser()));
        }
        stringBuffer.append(QuestionInfoWriter.getEmbeddedInsertSQL(addtlInfo, string));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".questionInfoCntry WHERE questionAddInfoInd = " + addtlInfo.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".questionInfoCond WHERE questionAddInfoInd = " + addtlInfo.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".questionAddInfo WHERE questionAddInfoInd = " + addtlInfo.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append(QuestionInfoWriter.getInsertSQL(addtlInfo, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".questionInfoCntry", "questionAddInfoInd", addtlInfo.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".questionInfoCond", "questionAddInfoInd", addtlInfo.getInd()));
        stringBuffer.append(QuestionInfoWriter.getEmbeddedDeleteSQL(addtlInfo, string));
        stringBuffer.append("DELETE FROM " + string + ".questionAddInfo " + "WHERE questionAddInfoInd=").append(addtlInfo.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getEmbeddedInsertSQL(AddtlInfo addtlInfo, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(250);
        Vector vector = addtlInfo.getEmbeddedDocInds();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                int n2 = (Integer)vector.elementAt(n);
                stringBuffer.append("INSERT INTO " + string + ".questionInfoLinks VALUES(");
                stringBuffer.append(addtlInfo.getInd()).append(',');
                stringBuffer.append(n2).append(',');
                stringBuffer.append(DatabaseUtil.stringToDB(addtlInfo.getDbUser())).append(',');
                stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
                ++n;
            }
        }
        if ((vector = addtlInfo.getEmbeddedGraphics()) != null) {
            n = 0;
            while (n < vector.size()) {
                AddtlInfoGraphic addtlInfoGraphic = (AddtlInfoGraphic)vector.elementAt(n);
                stringBuffer.append("INSERT INTO " + string + ".questionInfoGrphic VALUES(");
                stringBuffer.append(addtlInfo.getInd()).append(',');
                stringBuffer.append(addtlInfoGraphic.getGraphicInd()).append(',');
                stringBuffer.append(addtlInfoGraphic.getLanguage().getInd()).append(',');
                stringBuffer.append(DatabaseUtil.timestampToDB(addtlInfoGraphic.getLastTranslationDate())).append(',');
                stringBuffer.append(addtlInfoGraphic.getDocClass().getInd()).append(',');
                stringBuffer.append(DatabaseUtil.stringToDB(addtlInfo.getDbUser())).append(',');
                stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getEmbeddedUpdateSQL(AddtlInfo addtlInfo, String string) {
        return QuestionInfoWriter.getEmbeddedDeleteSQL(addtlInfo, string) + QuestionInfoWriter.getEmbeddedInsertSQL(addtlInfo, string);
    }

    static String getEmbeddedDeleteSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".questionInfoLinks " + "WHERE questionAddInfoInd=").append(addtlInfo.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".questionInfoGrphic " + "WHERE questionAddInfoInd=").append(addtlInfo.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForQuestionSQL(int n) {
        return QuestionInfoWriter.getDeleteAllForQuestionSQL(n, SCHEMA);
    }

    static String getDeleteAllForQuestionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".questioninfocond " + "where questionaddinfoind in " + "(select distinct questionaddinfoind " + "from " + string + ".questionaddinfo where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questioninfocntry " + "where questionaddinfoind in " + "(select distinct questionaddinfoind " + "from " + string + ".questionaddinfo where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questioninfolinks " + "where questionaddinfoind in " + "(select distinct questionaddinfoind " + "from " + string + ".questionaddinfo where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questioninfogrphic " + "where questionaddinfoind in " + "(select distinct questionaddinfoind " + "from " + string + ".questionaddinfo where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questionaddinfo where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    QuestionInfoWriter() {
    }
}

