/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;

class QuestionLinkWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(DocLink docLink) {
        String string;
        switch (docLink.getRecStatus()) {
            case 2: {
                string = QuestionLinkWriter.getInsertSQL(docLink, SCHEMA);
                break;
            }
            case 1: {
                string = QuestionLinkWriter.getUpdateSQL(docLink, SCHEMA);
                break;
            }
            case 3: {
                string = QuestionLinkWriter.getDeleteSQL(docLink, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(DocLink docLink, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".questionLink " + "(questionLinkInd, questionInd, sortOrder, linkInd, linkGroupInd, " + "docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(docLink.getInd()).append(',');
        stringBuffer.append(docLink.getParentInd()).append(',');
        stringBuffer.append(docLink.getSortOrder()).append(',');
        if (docLink.hasLinkGroup()) {
            stringBuffer.append("NULL,");
            stringBuffer.append(docLink.getLinkGroupInd()).append(',');
        } else {
            stringBuffer.append(docLink.getLinkInd()).append(',');
            stringBuffer.append("NULL,");
        }
        stringBuffer.append(docLink.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(docLink.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL(string + ".questionLinkCntry", docLink.getInd(), docLink.getCountryList(), docLink.getDbUser()));
        stringBuffer.append(ConditionWriter.getInsertSQL(string + ".questionLinkCond", docLink.getInd(), docLink.getConditions(), docLink.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(DocLink docLink, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE " + string + ".questionLink SET");
        stringBuffer.append(" sortOrder=").append(docLink.getSortOrder());
        stringBuffer.append(",docClassInd=").append(docLink.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(docLink.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE questionLinkInd=").append(docLink.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL(string + ".questionLinkCntry", "questionLinkInd", docLink.getInd(), docLink.getCountryList(), docLink.getOriginalCountryList(), docLink.getDbUser()));
        stringBuffer.append(ConditionWriter.getUpdateSQL(string + ".questionLinkCond", "questionLinkInd", docLink.getInd(), docLink.getConditions(), docLink.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(DocLink docLink, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".questionLinkCntry", "questionLinkInd", docLink.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".questionLinkCond", "questionLinkInd", docLink.getInd()));
        stringBuffer.append("DELETE FROM " + string + ".questionLink " + "WHERE questionLinkInd=").append(docLink.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForQuestionSQL(int n) {
        return QuestionLinkWriter.getDeleteAllForQuestionSQL(n, SCHEMA);
    }

    static String getDeleteAllForQuestionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".questionlinkcond where questionlinkind in " + "(select distinct questionlinkind " + "from " + string + ".questionlink where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questionlinkcntry where questionlinkind in " + "(select distinct questionlinkind " + "from " + string + ".questionlink where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questionlink where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    QuestionLinkWriter() {
    }
}

