/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;

class QuestionTitleWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(Title title) {
        String string;
        switch (title.getRecStatus()) {
            case 2: {
                string = QuestionTitleWriter.getInsertSQL(title, SCHEMA);
                break;
            }
            case 1: {
                string = QuestionTitleWriter.getUpdateSQL(title, SCHEMA);
                break;
            }
            case 3: {
                string = QuestionTitleWriter.getDeleteSQL(title, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".questionTitle " + "(questionTitleInd, questionInd, sortOrder, title, languageInd, " + "lastTranslated, docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(title.getInd()).append(',');
        stringBuffer.append(title.getParentInd()).append(',');
        stringBuffer.append(title.getSortOrder()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(title.getTitle())).append(',');
        stringBuffer.append(title.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(title.getLastTranslationDate())).append(',');
        stringBuffer.append(title.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(title.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        if (title.getLanguage().getInd() == 1) {
            stringBuffer.append(CountryWriter.getInsertSQL(string + ".questionTitleCntry", title.getInd(), title.getCountryList(), title.getDbUser()));
            stringBuffer.append(ConditionWriter.getInsertSQL(string + ".questionTitleCond", title.getInd(), title.getConditions(), title.getDbUser()));
        }
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".questionTitleCntry WHERE QUESTIONTITLEIND = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".questionTitleCond WHERE QUESTIONTITLEIND = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".questionTitle WHERE QUESTIONTITLEIND = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append(QuestionTitleWriter.getInsertSQL(title, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".questionTitleCntry", "questionTitleInd", title.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".questionTitleCond", "questionTitleInd", title.getInd()));
        stringBuffer.append("DELETE FROM " + string + ".questionTitle " + "WHERE questionTitleInd=").append(title.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForQuestionSQL(int n) {
        return QuestionTitleWriter.getDeleteAllForQuestionSQL(n, SCHEMA);
    }

    static String getDeleteAllForQuestionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".questiontitlecond " + "where questiontitleind in " + "(select distinct questiontitleind " + "from " + string + ".questiontitle where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questiontitlecntry " + "where questiontitleind in " + "(select distinct questiontitleind " + "from " + string + ".questiontitle where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".questiontitle where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    QuestionTitleWriter() {
    }
}

