/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerWriter;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionInfoWriter;
import com.ibm.nzna.projects.common.quest.oa.QuestionLinkWriter;
import com.ibm.nzna.projects.common.quest.oa.QuestionTitleWriter;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.pom.PersistentRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class QuestionWriter {
    static String getSQL(Question question) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(QuestionWriter.getQuestionSQL(question));
        if (question.valid()) {
            stringBuffer.append(QuestionWriter.getObjectSQL(question));
        }
        if (!question.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oa.question SET changedTime=CURRENT TIMESTAMP WHERE questionInd=").append(question.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(Question question) {
        ConditionalObject conditionalObject;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = question.getAnswers();
        if (vector != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (Answer)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((Answer)conditionalObject).setParentInd(question.getInd());
                    conditionalObject.setDbUser(question.getDbUser());
                }
                stringBuffer.append(AnswerWriter.getSQL((Answer)conditionalObject));
                ++n;
            }
        }
        if ((vector = question.getTitles()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (Title)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((Title)conditionalObject).setParentInd(question.getInd());
                    conditionalObject.setDbUser(question.getDbUser());
                }
                stringBuffer.append(QuestionTitleWriter.getSQL((Title)conditionalObject));
                ++n;
            }
        }
        if ((vector = question.getAdditionalInfo()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (AddtlInfo)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((AddtlInfo)conditionalObject).setParentInd(question.getInd());
                    conditionalObject.setDbUser(question.getDbUser());
                }
                stringBuffer.append(QuestionInfoWriter.getSQL((AddtlInfo)conditionalObject));
                ++n;
            }
        }
        if ((vector = question.getDocLinks()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (DocLink)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((DocLink)conditionalObject).setParentInd(question.getInd());
                    conditionalObject.setDbUser(question.getDbUser());
                }
                stringBuffer.append(QuestionLinkWriter.getSQL((DocLink)conditionalObject));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getQuestionSQL(Question question) {
        String string;
        switch (question.getRecStatus()) {
            case 2: {
                string = QuestionWriter.getInsertSQL(question);
                break;
            }
            case 1: {
                string = QuestionWriter.getUpdateSQL(question);
                break;
            }
            case 3: {
                string = QuestionWriter.getDeleteSQL(question);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Question question) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.question (questionInd, questionTypeInd, hiddenFlag, autoFillFlag, brandInd, docClassInd, archived, dbUser, changedTime, openDraft) VALUES (");
        stringBuffer.append(question.getInd()).append(',');
        stringBuffer.append(question.getQuestionType().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(question.getHiddenAnswers())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(question.getAutoFill())).append(',');
        stringBuffer.append(question.getBrand().getInd()).append(',');
        stringBuffer.append(question.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(question.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(question.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, 'N')").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oa.questionCountry", question.getInd(), question.getCountryList(), question.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Question question) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.question SET");
        stringBuffer.append(" questionTypeInd=").append(question.getQuestionType().getInd());
        stringBuffer.append(",hiddenFlag=").append(DatabaseUtil.booleanToDB(question.getHiddenAnswers()));
        stringBuffer.append(",autoFillFlag=").append(DatabaseUtil.booleanToDB(question.getAutoFill()));
        stringBuffer.append(",brandInd=").append(question.getBrand().getInd());
        stringBuffer.append(",docClassInd=").append(question.getDocClass().getInd());
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(question.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(question.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE questionInd=").append(question.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oa.questionCountry", "questionInd", question.getInd(), question.getCountryList(), question.getOriginalCountryList(), question.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Question question) {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = question.getInd();
        stringBuffer.append(AnswerWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(QuestionTitleWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(QuestionInfoWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(QuestionLinkWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append("DELETE from oa.questioncountry where questionind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.question where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    public static String getPublishSQL(Connection connection, QuestionDraft questionDraft) throws Exception {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(500);
        Question question = new Question(questionDraft);
        question.assignDatabaseKeys(connection);
        if (question.getRecStatus() == 1) {
            int n = question.getInd();
            stringBuffer.append(AnswerWriter.getDeleteAnswerDataForQuestionSQL(n));
            stringBuffer.append(QuestionTitleWriter.getDeleteAllForQuestionSQL(n));
            stringBuffer.append(QuestionInfoWriter.getDeleteAllForQuestionSQL(n));
            stringBuffer.append(QuestionLinkWriter.getDeleteAllForQuestionSQL(n));
            Statement statement = connection.createStatement();
            object = null;
            object = "SELECT answerind " + "FROM oa.answer " + "WHERE questionInd=" + question.getInd() + " " + "AND answerInd NOT IN (" + "SELECT activeAnswerInd " + "FROM oadraft.answer " + "WHERE questionInd=" + questionDraft.getInd() + " " + "AND activeAnswerInd IS NOT NULL" + ")";
            ResultSet resultSet = statement.executeQuery((String)object);
            stringBuffer.append("### " + (String)object + SqlRunner.END_DELIM);
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                stringBuffer.append("DELETE FROM oa.answer WHERE answerInd=").append(n2).append(SqlRunner.END_DELIM);
            }
            statement.close();
        }
        stringBuffer.append(QuestionWriter.getSQL(question));
        if (question.getRecStatus() == 2) {
            stringBuffer.append("UPDATE oadraft.node " + "SET activeQuestionInd=" + question.getInd() + " " + "WHERE draftQuestionInd=" + questionDraft.getInd()).append(SqlRunner.END_DELIM);
            stringBuffer.append("UPDATE oadraft.edgePreanswer " + "SET activeQuestionInd=" + question.getInd() + " " + "WHERE draftQuestionInd=" + questionDraft.getInd()).append(SqlRunner.END_DELIM);
        }
        Vector vector = question.getAnswers();
        int n = 0;
        while (n < vector.size()) {
            object = (Answer)vector.elementAt(n);
            if (((PersistentRec)object).getRecStatus() == 2) {
                stringBuffer.append("UPDATE oadraft.answer " + "SET activeAnswerInd=" + ((Answer)object).getInd() + " " + "WHERE answerInd=" + ((Answer)object).getDraftAnswerInd()).append(SqlRunner.END_DELIM);
                stringBuffer.append("UPDATE oadraft.edge " + "SET activeAnswerInd=" + ((Answer)object).getInd() + " " + "WHERE draftAnswerInd=" + ((Answer)object).getDraftAnswerInd()).append(SqlRunner.END_DELIM);
                stringBuffer.append("UPDATE oadraft.edgePreanswer " + "SET activeAnswerInd=" + ((Answer)object).getInd() + " " + "WHERE draftAnswerInd=" + ((Answer)object).getDraftAnswerInd()).append(SqlRunner.END_DELIM);
            }
            ++n;
        }
        stringBuffer.append("UPDATE oa.question SET openDraft='N' WHERE questionInd=").append(question.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("UPDATE oadraft.question " + "SET stopDate=CURRENT DATE, " + "changedTime=CURRENT TIMESTAMP, " + "activeQuestionInd=" + question.getInd() + " " + "WHERE questionInd=" + questionDraft.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }
}

