/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.OAMode;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.SymptomWriter;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeStatusRec;
import com.ibm.nzna.projects.common.quest.type.TypeSymptomRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class Symptom
extends OAObject {
    static final long serialVersionUID = 1000000L;
    public static final String OA_PREFIX = "S";
    protected int symptomInd_ = 0;
    protected Node rootNode_ = null;
    protected Vector titles_ = null;
    protected Vector nodes_ = null;
    protected Hashtable nodesByInd_ = null;
    protected Vector edgeGroups_ = null;
    protected TypeSymptomRec symptomType_ = null;
    protected TypeStatusRec symptomStatus_ = null;
    protected Hashtable edgesByInd_ = null;

    private void initSubObjects(Symptom symptom) {
        PersistentRec persistentRec;
        int n;
        this.rootNode_ = symptom.rootNode_;
        this.titles_ = symptom.titles_;
        this.nodes_ = symptom.nodes_;
        this.edgeGroups_ = symptom.edgeGroups_;
        this.symptomType_ = symptom.symptomType_;
        this.symptomStatus_ = symptom.symptomStatus_;
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                persistentRec = (SymptomTitle)this.titles_.elementAt(n);
                ((SymptomTitle)persistentRec).resetNew();
                ++n;
            }
        }
        if (this.nodes_ != null) {
            n = 0;
            while (n < this.nodes_.size()) {
                persistentRec = (Node)this.nodes_.elementAt(n);
                ((Node)persistentRec).resetNew();
                ++n;
            }
        }
        if (this.edgeGroups_ != null) {
            n = 0;
            while (n < this.edgeGroups_.size()) {
                persistentRec = (EdgeGroup)this.edgeGroups_.elementAt(n);
                ((EdgeGroup)persistentRec).resetNew();
                ++n;
            }
        }
    }

    public boolean assignDatabaseKeys() {
        PersistentRec persistentRec;
        int n;
        boolean bl = false;
        if (this instanceof SymptomDraft) {
            bl = true;
        }
        boolean bl2 = this.assignMyDatabaseKey();
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size() && bl2) {
                persistentRec = (SymptomTitle)this.titles_.elementAt(n);
                bl2 = ((SymptomTitle)persistentRec).assignDatabaseKey(bl);
                ++n;
            }
        }
        if (this.nodes_ != null) {
            n = 0;
            while (n < this.nodes_.size() && bl2) {
                persistentRec = (Node)this.nodes_.elementAt(n);
                bl2 = ((Node)persistentRec).assignDatabaseKey(bl);
                ++n;
            }
        }
        if (this.edgeGroups_ != null) {
            n = 0;
            while (n < this.edgeGroups_.size() && bl2) {
                persistentRec = (EdgeGroup)this.edgeGroups_.elementAt(n);
                bl2 = ((EdgeGroup)persistentRec).assignDatabaseKeys(bl);
                ++n;
            }
        }
        return bl2;
    }

    void assignDatabaseKeys(Connection connection) throws Exception {
        PersistentRec persistentRec;
        int n;
        boolean bl = false;
        if (this instanceof SymptomDraft) {
            bl = true;
        }
        this.assignMyDatabaseKey(connection);
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                persistentRec = (SymptomTitle)this.titles_.elementAt(n);
                ((SymptomTitle)persistentRec).assignDatabaseKey(connection, bl);
                ++n;
            }
        }
        if (this.nodes_ != null) {
            n = 0;
            while (n < this.nodes_.size()) {
                persistentRec = (Node)this.nodes_.elementAt(n);
                ((Node)persistentRec).assignDatabaseKey(connection, bl);
                ++n;
            }
        }
        if (this.edgeGroups_ != null) {
            n = 0;
            while (n < this.edgeGroups_.size()) {
                persistentRec = (EdgeGroup)this.edgeGroups_.elementAt(n);
                ((EdgeGroup)persistentRec).assignDatabaseKeys(connection, bl);
                ++n;
            }
        }
    }

    boolean assignMyDatabaseKey() {
        boolean bl = true;
        if (this.symptomInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for Symptom");
            this.symptomInd_ = Counter.getCounter(LogSystem.getInstance(), "SYMPTMIND");
            if (this.symptomInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Symptom");
                bl = false;
            }
        }
        return bl;
    }

    void assignMyDatabaseKey(Connection connection) throws Exception {
        if (this.symptomInd_ == 0) {
            this.symptomInd_ = Counter.getCounter(connection, "SYMPTMIND");
            if (this.symptomInd_ == 0) {
                throw new Exception("Failed to get database key for Symptom");
            }
        }
    }

    public int getInd() {
        return this.symptomInd_;
    }

    void setInd(int n) {
        this.symptomInd_ = n;
        this.setOAItemNum(this.symptomInd_);
    }

    void setOAItemNum(int n) {
        super.setOAItemNum(OA_PREFIX + n);
    }

    public Vector getSymptomTitles() {
        return this.titles_;
    }

    public void setSymptomTitles(Vector vector) {
        this.titles_ = vector;
        if (this.titles_ != null && this.titles_.size() > 0) {
            ((SymptomTitle)this.titles_.elementAt(this.titles_.size() - 1)).setCountryList(this.getCountryList());
            ((SymptomTitle)this.titles_.elementAt(this.titles_.size() - 1)).setDocClass(this.getDocClass());
        }
    }

    public int getRootNodeInd() {
        return this.rootNode_.getInd();
    }

    public Node getRootNode() {
        return this.rootNode_;
    }

    public void setRootNode(Node node) {
        this.rootNode_ = node;
    }

    public Vector getNodes() {
        return this.nodes_;
    }

    public void setNodes(Vector vector) {
        this.nodes_ = vector;
    }

    public Node getNodeByInd(int n) {
        if (this.nodesByInd_ == null) {
            this.buildNodeTable();
        }
        return (Node)this.nodesByInd_.get(new Integer(n));
    }

    private void buildNodeTable() {
        this.nodesByInd_ = new Hashtable();
        int n = 0;
        while (n < this.nodes_.size()) {
            Node node = (Node)this.nodes_.elementAt(n);
            this.nodesByInd_.put(new Integer(node.getInd()), node);
            ++n;
        }
    }

    public Hashtable getEdgesForNodeAndAnswer(int n, int n2) {
        return this.getEdgesForNodeAndAnswer(n, n2, false);
    }

    public Hashtable getEdgesForNodeAndAnswer(int n, int n2, boolean bl) {
        Hashtable<Edge, Node> hashtable = new Hashtable<Edge, Node>();
        int n3 = 0;
        while (n3 < this.edgeGroups_.size()) {
            EdgeGroup edgeGroup = (EdgeGroup)this.edgeGroups_.elementAt(n3);
            if (edgeGroup.getHeadNode().getInd() == n) {
                Vector vector = edgeGroup.getEdges();
                int n4 = 0;
                while (n4 < vector.size()) {
                    boolean bl2;
                    Edge edge = (Edge)vector.elementAt(n4);
                    if (bl) {
                        bl2 = edge.getDraftAnswerInd() == n2;
                    } else {
                        boolean bl3 = bl2 = edge.getActiveAnswerInd() == n2;
                    }
                    if (bl2) {
                        hashtable.put(edge, edgeGroup.getTailNode());
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return hashtable;
    }

    public Hashtable getTypeOtherEdgesForNode(int n) {
        Hashtable<Edge, Node> hashtable = new Hashtable<Edge, Node>();
        int n2 = 0;
        while (n2 < this.edgeGroups_.size()) {
            EdgeGroup edgeGroup = (EdgeGroup)this.edgeGroups_.elementAt(n2);
            if (edgeGroup.getHeadNode().getInd() == n) {
                Vector vector = edgeGroup.getEdges();
                int n3 = 0;
                while (n3 < vector.size()) {
                    Edge edge = (Edge)vector.elementAt(n3);
                    if (edge.getEdgeType() == 1) {
                        hashtable.put(edge, edgeGroup.getTailNode());
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return hashtable;
    }

    public Vector getEdgeGroups() {
        return this.edgeGroups_;
    }

    public void setEdgeGroups(Vector vector) {
        this.edgeGroups_ = vector;
    }

    public TypeSymptomRec getSymptomType() {
        return this.symptomType_;
    }

    public void setSymptomType(TypeSymptomRec typeSymptomRec) {
        this.symptomType_ = typeSymptomRec;
        this.updateRecStatus(1);
    }

    public TypeStatusRec getSymptomStatus() {
        return this.symptomStatus_;
    }

    public void setSymptomStatus(TypeStatusRec typeStatusRec) {
        this.symptomStatus_ = typeStatusRec;
        this.updateRecStatus(1);
    }

    public String toString() {
        return "Symptom " + this.getInd();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        int n;
        block11: {
            LogSystem.log(2, ">>> Starting Symptom.writeToDatabase()");
            if (!this.assignDatabaseKeys()) {
                return -1;
            }
            SQLMethod sQLMethod = new SQLMethod(1, "Symptom.writeToDatabase()", 10);
            n = 0;
            StoredProcRec storedProcRec = null;
            try {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ExtSqlRunner", 3);
                    String string = SymptomWriter.getSQL(this);
                    if (string.length() == 0) {
                        LogSystem.log(1, "No changes to be written");
                        int n2 = 0;
                        Object var5_8 = null;
                        sQLMethod.close();
                        return n2;
                    }
                    String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
                    LogSystem.log(1, "Starting to send statements to EXTSQLRUNNER");
                    LogSystem.log(1, string2);
                    callableStatement.registerOutParameter(3, -4);
                    callableStatement.setBytes(1, string.getBytes());
                    callableStatement.setInt(2, 0);
                    callableStatement.execute();
                    storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    if (storedProcRec == null) {
                        LogSystem.log(2, "StoredProcRec is null - error status unknown");
                    }
                    if (storedProcRec != null && storedProcRec.error) {
                        LogSystem.log(2, storedProcRec.errorStr);
                        n = storedProcRec.sqlCode;
                        if (n == 0) {
                            n = -1;
                        }
                    }
                    callableStatement.close();
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    n = -1;
                    Object var5_10 = null;
                    sQLMethod.close();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                sQLMethod.close();
                throw throwable;
            }
            Object var5_9 = null;
            sQLMethod.close();
        }
        if (n == 0) {
            this.setRecNoChange();
        }
        LogSystem.log(2, ">>> Symptom.writeToDatabase() complete");
        return n;
    }

    void setRecNoChange() {
        PersistentRec persistentRec;
        int n;
        this.updateRecStatus(0);
        super.setOriginalCountryListFromCurrent();
        if (this.nodes_ != null) {
            n = 0;
            while (n < this.nodes_.size()) {
                persistentRec = (Node)this.nodes_.elementAt(n);
                persistentRec.updateRecStatus(0);
                ++n;
            }
        }
        if (this.edgeGroups_ != null) {
            n = 0;
            while (n < this.edgeGroups_.size()) {
                persistentRec = (EdgeGroup)this.edgeGroups_.elementAt(n);
                ((EdgeGroup)persistentRec).setRecNoChange();
                ++n;
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                persistentRec = (SymptomTitle)this.titles_.elementAt(n);
                ((SymptomTitle)persistentRec).setRecNoChange();
                ++n;
            }
        }
    }

    public static Symptom readFromDatabase(int n, int n2) {
        LogSystem.log(2, ">>> Starting Symptom.readFromDatabase()");
        long l = System.currentTimeMillis();
        SQLMethod sQLMethod = new SQLMethod(1, "Symptom.readFromDatabase()", 5);
        StoredProcRec storedProcRec = null;
        Symptom symptom = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 2);
            callableStatement.setInt(3, 0);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            symptom = (Symptom)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        long l2 = System.currentTimeMillis();
        LogSystem.log(1, "Elapsed time: " + (l2 - l) + " msec");
        LogSystem.log(2, ">>> Symptom.readFromDatabase() completed");
        if (symptom != null) {
            if (OAMode.currentMode != 1) {
                symptom.updateTypeRecData();
                symptom.setRecNoChange();
            }
        } else {
            LogSystem.log(2, "No object found for indicator " + n);
        }
        return symptom;
    }

    void updateTypeRecData() {
        PersistentRec persistentRec;
        int n;
        TypeStatusRec typeStatusRec;
        super.updateTypeRecData();
        TypeList typeList = TypeList.getInstance();
        TypeSymptomRec typeSymptomRec = (TypeSymptomRec)typeList.objectFromInd(this.symptomType_.getInd(), 19);
        if (typeSymptomRec != null) {
            this.symptomType_ = typeSymptomRec;
        }
        if ((typeStatusRec = (TypeStatusRec)typeList.objectFromInd(this.symptomStatus_.getInd(), 15)) != null) {
            this.symptomStatus_ = typeStatusRec;
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                persistentRec = (SymptomTitle)this.titles_.elementAt(n);
                ((SymptomTitle)persistentRec).updateTypeRecData();
                ++n;
            }
        }
        if (this.edgeGroups_ != null) {
            n = 0;
            while (n < this.edgeGroups_.size()) {
                persistentRec = (EdgeGroup)this.edgeGroups_.elementAt(n);
                Vector vector = ((EdgeGroup)persistentRec).getEdges();
                if (vector != null) {
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        Edge edge = (Edge)vector.elementAt(n2);
                        edge.updateTypeRecData();
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public static int findOpenDraft(int n) {
        LogSystem.log(2, ">>> Starting Symptom.findOpenDraft()");
        SQLMethod sQLMethod = new SQLMethod(1, "Symptom.findOpenDraft()", 1);
        int n2 = 0;
        try {
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT symptomInd " + "FROM oadraft.symptom " + "WHERE activeSymptomInd=" + n + " " + "AND stopDate IS NULL " + "FOR FETCH ONLY");
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                } else {
                    LogSystem.log(1, "No open draft found for " + n);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LogSystem.log(3, exception);
                Object var4_7 = null;
                sQLMethod.close();
            }
            Object var4_6 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> Symptom.findOpenDraft() completed");
        return n2;
    }

    public Edge getEdgeByInd(int n) {
        if (this.edgesByInd_ == null) {
            this.buildEdgeTable();
        }
        return (Edge)this.edgesByInd_.get(new Integer(n));
    }

    private void buildEdgeTable() {
        this.edgesByInd_ = new Hashtable();
        int n = 0;
        while (n < this.edgeGroups_.size()) {
            EdgeGroup edgeGroup = (EdgeGroup)this.edgeGroups_.elementAt(n);
            Vector vector = edgeGroup.getEdges();
            int n2 = 0;
            while (n2 < vector.size()) {
                Edge edge = (Edge)vector.elementAt(n2);
                this.edgesByInd_.put(new Integer(edge.getInd()), edge);
                ++n2;
            }
            ++n;
        }
    }

    public void setCountryList(Vector vector) {
        super.setCountryList(vector);
        if (this.titles_ != null && this.titles_.size() > 0) {
            ((SymptomTitle)this.titles_.elementAt(this.titles_.size() - 1)).setCountryList(vector);
        }
    }

    public void setDocClass(TypeDocClassRec typeDocClassRec) {
        super.setDocClass(typeDocClassRec);
        if (this.titles_ != null && this.titles_.size() > 0) {
            ((SymptomTitle)this.titles_.elementAt(this.titles_.size() - 1)).setDocClass(typeDocClassRec);
        }
    }

    public Symptom() {
        this(0);
    }

    public Symptom(int n) {
        this.setInd(n);
        if (this.symptomInd_ == 0) {
            this.updateRecStatus(2);
        }
    }

    Symptom(Symptom symptom) {
        super(symptom);
        this.setInd(0);
        this.initSubObjects(symptom);
        this.updateRecStatus(2);
    }

    Symptom(SymptomDraft symptomDraft) {
        super(symptomDraft);
        this.setInd(symptomDraft.getActiveSymptomInd());
        this.initSubObjects(symptomDraft);
        if (this.symptomInd_ == 0) {
            this.updateRecStatus(2);
        } else {
            this.updateRecStatus(1);
        }
    }
}

