/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;

class SymptomTitleWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(SymptomTitle symptomTitle) {
        String string;
        switch (symptomTitle.getRecStatus()) {
            case 2: {
                string = SymptomTitleWriter.getInsertSQL(symptomTitle, SCHEMA);
                break;
            }
            case 1: {
                string = SymptomTitleWriter.getUpdateSQL(symptomTitle, SCHEMA);
                break;
            }
            case 3: {
                string = SymptomTitleWriter.getDeleteSQL(symptomTitle, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(SymptomTitle symptomTitle, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".symptomTitle " + "(symptomTitleInd, symptomInd, sortOrder, title, keywords, " + "languageInd, lastTranslated, docClassInd, indexable, " + "dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(symptomTitle.getInd()).append(',');
        stringBuffer.append(symptomTitle.getSymptomInd()).append(',');
        stringBuffer.append(symptomTitle.getSortOrder()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(symptomTitle.getTitle())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(symptomTitle.getKeywords())).append(',');
        stringBuffer.append(symptomTitle.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(symptomTitle.getLastTranslationDate())).append(',');
        stringBuffer.append(symptomTitle.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(symptomTitle.isIndexable())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(symptomTitle.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        if (symptomTitle.getLanguage().getInd() == 1) {
            stringBuffer.append(CountryWriter.getInsertSQL(string + ".symptomTitleCntry", symptomTitle.getInd(), symptomTitle.getCountryList(), symptomTitle.getDbUser()));
        }
        return stringBuffer.toString();
    }

    static String getUpdateSQL(SymptomTitle symptomTitle, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".symptomTitleCntry WHERE SYMPTOMTITLEIND = " + symptomTitle.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".symptomTitle WHERE SYMPTOMTITLEIND = " + symptomTitle.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append(SymptomTitleWriter.getInsertSQL(symptomTitle, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(SymptomTitle symptomTitle, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".symptomTitleCntry", "symptomTitleInd", symptomTitle.getInd()));
        stringBuffer.append("DELETE FROM " + string + ".symptomTitle WHERE symptomTitleInd=").append(symptomTitle.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForSymptomSQL(int n) {
        return SymptomTitleWriter.getDeleteAllForSymptomSQL(n, SCHEMA);
    }

    static String getDeleteAllForSymptomSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".symptomtitlecntry where symptomtitleind in " + "(select distinct symptomtitleind from " + string + ".symptomtitle " + "where symptomind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".symptomtitle where symptomind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    SymptomTitleWriter() {
    }
}

