/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroupWriter;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.NodeWriter;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitleWriter;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.sql.Connection;
import java.util.Vector;

public class SymptomWriter {
    static String getSQL(Symptom symptom) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SymptomWriter.getSymptomSQL(symptom));
        if (symptom.valid()) {
            stringBuffer.append(SymptomWriter.getObjectSQL(symptom));
        }
        if (symptom.getRecStatus() == 2) {
            stringBuffer.append(SymptomWriter.getUpdateRootNodeSQL(symptom));
        }
        if (!symptom.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oa.symptom SET changedTime=CURRENT TIMESTAMP WHERE symptomInd=").append(symptom.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(Symptom symptom) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = symptom.getSymptomTitles();
        if (vector != null) {
            n = 1;
            int n2 = 0;
            while (n2 < vector.size()) {
                SymptomTitle symptomTitle = (SymptomTitle)vector.elementAt(n2);
                if (symptomTitle.valid()) {
                    symptomTitle.setSortOrder(n++);
                    symptomTitle.setSymptomInd(symptom.getInd());
                    symptomTitle.setDbUser(symptom.getDbUser());
                }
                stringBuffer.append(SymptomTitleWriter.getSQL(symptomTitle));
                ++n2;
            }
        }
        if ((vector = symptom.getNodes()) != null) {
            n = 0;
            while (n < vector.size()) {
                Node node = (Node)vector.elementAt(n);
                if (node.valid()) {
                    node.setSymptomInd(symptom.getInd());
                    node.setDbUser(symptom.getDbUser());
                    stringBuffer.append(NodeWriter.getSQL(node));
                }
                ++n;
            }
        }
        if ((vector = symptom.getEdgeGroups()) != null) {
            n = 0;
            while (n < vector.size()) {
                EdgeGroup edgeGroup = (EdgeGroup)vector.elementAt(n);
                if (edgeGroup.valid()) {
                    edgeGroup.setSymptomInd(symptom.getInd());
                    edgeGroup.setDbUser(symptom.getDbUser());
                }
                stringBuffer.append(EdgeGroupWriter.getSQL(edgeGroup));
                ++n;
            }
        }
        if ((vector = symptom.getNodes()) != null) {
            n = 0;
            while (n < vector.size()) {
                Node node = (Node)vector.elementAt(n);
                if (!node.valid()) {
                    stringBuffer.append(NodeWriter.getSQL(node));
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getSymptomSQL(Symptom symptom) {
        String string;
        switch (symptom.getRecStatus()) {
            case 2: {
                string = SymptomWriter.getInsertSQL(symptom);
                break;
            }
            case 1: {
                string = SymptomWriter.getUpdateSQL(symptom);
                break;
            }
            case 3: {
                string = SymptomWriter.getDeleteSQL(symptom);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Symptom symptom) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.symptom (symptomInd, symptomTypeInd, rootNodeInd, brandInd, docClassInd, statusInd, archived, dbUser, changedTime, openDraft) VALUES (");
        stringBuffer.append(symptom.getInd()).append(',');
        stringBuffer.append(symptom.getSymptomType().getInd()).append(',');
        stringBuffer.append("NULL,");
        stringBuffer.append(symptom.getBrand().getInd()).append(',');
        stringBuffer.append(symptom.getDocClass().getInd()).append(',');
        stringBuffer.append(symptom.getSymptomStatus().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(symptom.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(symptom.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, 'N')").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oa.symptomCountry", symptom.getInd(), symptom.getCountryList(), symptom.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateRootNodeSQL(Symptom symptom) {
        if (symptom.getRootNode() == null) {
            throw new IllegalStateException("Root Node has not been set");
        }
        if (symptom.getRootNodeInd() == 0) {
            throw new IllegalStateException("Root Node indicator is 0 -- the Node was probably not put in the Symptom's Vector of Nodes");
        }
        return "UPDATE oa.symptom set rootNodeInd=" + symptom.getRootNodeInd() + " WHERE symptomInd=" + symptom.getInd() + SqlRunner.END_DELIM;
    }

    static String getUpdateSQL(Symptom symptom) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.symptom SET");
        stringBuffer.append(" symptomTypeInd=").append(symptom.getSymptomType().getInd());
        stringBuffer.append(",brandInd=").append(symptom.getBrand().getInd());
        stringBuffer.append(",docClassInd=").append(symptom.getDocClass().getInd());
        stringBuffer.append(",statusInd=").append(symptom.getSymptomStatus().getInd());
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(symptom.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(symptom.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE symptomInd=").append(symptom.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oa.symptomCountry", "symptomInd", symptom.getInd(), symptom.getCountryList(), symptom.getOriginalCountryList(), symptom.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Symptom symptom) {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = symptom.getInd();
        stringBuffer.append("UPDATE oa.symptom SET rootNodeInd=NULL WHERE symptomInd=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append(EdgeGroupWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append(NodeWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append(SymptomTitleWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append("DELETE from oa.symptomcountry where symptomind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.symptom where symptomind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    public static String getPublishSQL(Connection connection, SymptomDraft symptomDraft) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(500);
        Symptom symptom = new Symptom(symptomDraft);
        symptom.assignDatabaseKeys(connection);
        if (symptom.getRecStatus() == 1) {
            int n = symptom.getInd();
            stringBuffer.append(SymptomTitleWriter.getDeleteAllForSymptomSQL(n));
            stringBuffer.append(EdgeGroupWriter.getDeleteAllForSymptomSQL(n));
            stringBuffer.append("UPDATE oa.symptom SET rootNodeInd=NULL WHERE symptomInd=").append(n).append(SqlRunner.END_DELIM);
            stringBuffer.append(NodeWriter.getDeleteAllForSymptomSQL(n));
        }
        stringBuffer.append(SymptomWriter.getSQL(symptom));
        if (symptom.getRecStatus() == 1) {
            stringBuffer.append(SymptomWriter.getUpdateRootNodeSQL(symptom));
        }
        stringBuffer.append("DELETE FROM oa.symptomResponse WHERE symptomInd=").append(symptom.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("INSERT INTO oa.symptomResponse " + "SELECT DISTINCT " + "s.symptomInd, sc.countryInd, 'N', s.dbUser, s.changedTime " + "FROM oa.symptom s, oa.symptomCountry sc " + "WHERE s.symptomInd=" + symptom.getInd() + "  AND sc.symptomInd=s.symptomInd").append(SqlRunner.END_DELIM);
        if (symptom.getRecStatus() == 2) {
            stringBuffer.append("UPDATE oadraft.node " + "SET activeSymptomInd=" + symptom.getInd() + " " + "WHERE draftSymptomInd=" + symptomDraft.getInd()).append(SqlRunner.END_DELIM);
        }
        stringBuffer.append("UPDATE oa.symptom SET openDraft='N' WHERE symptomInd=").append(symptom.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("UPDATE oadraft.symptom " + "SET stopDate=CURRENT DATE, " + "changedTime=CURRENT TIMESTAMP, " + "activeSymptomInd=" + symptom.getInd() + " " + "WHERE symptomInd=" + symptomDraft.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }
}

