/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;

public class Title
extends ConditionalObject {
    static final long serialVersionUID = 1000000L;
    private int titleInd_ = 0;
    private int parentInd_ = 0;
    private String title_ = null;
    private TypeLanguageRec language_ = null;
    private String lastTranslated_ = null;
    private boolean textUpdated_ = false;

    private boolean assignDatabaseKey(String string) {
        boolean bl = true;
        if (this.titleInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for Title: " + string);
            this.titleInd_ = Counter.getCounter(LogSystem.getInstance(), string);
            if (this.titleInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Title");
                bl = false;
            }
        }
        return bl;
    }

    private void assignDatabaseKey(Connection connection, String string) throws Exception {
        if (this.titleInd_ == 0) {
            this.titleInd_ = Counter.getCounter(connection, string);
            if (this.titleInd_ == 0) {
                throw new Exception("Failed to get database key for Title");
            }
        }
    }

    boolean assignDatabaseKeyForAction() {
        return this.assignDatabaseKey("ACTIONTITL");
    }

    void assignDatabaseKeyForAction(Connection connection) throws Exception {
        this.assignDatabaseKey(connection, "ACTIONTITL");
    }

    boolean assignDatabaseKeyForQuestion() {
        return this.assignDatabaseKey("QSTNTITLE");
    }

    void assignDatabaseKeyForQuestion(Connection connection) throws Exception {
        this.assignDatabaseKey(connection, "QSTNTITLE");
    }

    boolean assignDatabaseKeyForAnswer() {
        return this.assignDatabaseKey("ANSWERTITL");
    }

    void assignDatabaseKeyForAnswer(Connection connection) throws Exception {
        this.assignDatabaseKey(connection, "ANSWERTITL");
    }

    boolean assignDatabaseKeyForActionDraft() {
        return this.assignDatabaseKey("DACTNTITL");
    }

    void assignDatabaseKeyForActionDraft(Connection connection) throws Exception {
        this.assignDatabaseKey(connection, "DACTNTITL");
    }

    boolean assignDatabaseKeyForQuestionDraft() {
        return this.assignDatabaseKey("DQSTNTITLE");
    }

    void assignDatabaseKeyForQuestionDraft(Connection connection) throws Exception {
        this.assignDatabaseKey(connection, "DQSTNTITLE");
    }

    boolean assignDatabaseKeyForAnswerDraft() {
        return this.assignDatabaseKey("DANSRTITL");
    }

    void assignDatabaseKeyForAnswerDraft(Connection connection) throws Exception {
        this.assignDatabaseKey(connection, "DANSRTITL");
    }

    public int getInd() {
        return this.titleInd_;
    }

    void setInd(int n) {
        this.titleInd_ = n;
    }

    int getParentInd() {
        return this.parentInd_;
    }

    void setParentInd(int n) {
        this.parentInd_ = n;
    }

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String string) {
        this.title_ = string;
        this.textUpdated_ = true;
        this.updateRecStatus(1);
    }

    void setTextUpdated(boolean bl) {
        this.textUpdated_ = bl;
    }

    boolean wasTextUpdated() {
        return this.textUpdated_;
    }

    public TypeLanguageRec getLanguage() {
        return this.language_;
    }

    public void setLanguage(TypeLanguageRec typeLanguageRec) {
        this.language_ = typeLanguageRec;
        this.updateRecStatus(1);
    }

    public String getLastTranslationDate() {
        return this.lastTranslated_;
    }

    public void setLastTranslationDate(String string) {
        this.lastTranslated_ = string;
    }

    public Object clone() {
        return super.clone();
    }

    public String toString() {
        return this.title_;
    }

    public String debugString() {
        return "Title " + this.titleInd_ + ": \"" + this.title_ + "\" (lang=" + this.language_.getInd() + ")";
    }

    void resetNew() {
        this.setInd(0);
        this.setParentInd(0);
        this.updateRecStatus(0);
        this.updateRecStatus(2);
    }

    void updateTypeRecData() {
        super.updateTypeRecData();
        TypeList typeList = TypeList.getInstance();
        TypeLanguageRec typeLanguageRec = (TypeLanguageRec)typeList.objectFromInd(this.language_.getInd(), 8);
        if (typeLanguageRec != null) {
            this.language_ = typeLanguageRec;
        }
    }

    public Title() {
        this("");
    }

    public Title(String string) {
        this.title_ = string;
        this.updateRecStatus(2);
    }

    Title(int n) {
        this.titleInd_ = n;
        this.updateRecStatus(0);
    }
}

