/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;

public class OPICMMapper {
    private Hashtable seriesHash = new Hashtable();
    private Hashtable countryHash = new Hashtable();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeCategoryRec getQuestFamilyFromOPICM(String string, String string2, String string3) {
        TypeCategoryRec typeCategoryRec = null;
        try {
            TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategoryFromDescription(string, "opicmbrand");
            TypeCategoryRec typeCategoryRec3 = TypeCategory.getCategoryFromDescription(string2, "opicmfamily", typeCategoryRec2.getInd());
            TypeCategoryRec typeCategoryRec4 = TypeCategory.getCategoryFromDescription(string3, "opicmseries", typeCategoryRec3.getInd());
            return (TypeCategoryRec)this.seriesHash.get(typeCategoryRec4);
        }
        catch (NullPointerException nullPointerException) {
        }
        return typeCategoryRec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeCountryCodeRec getQuestCountryFromOPICM(String string, String string2) {
        TypeCountryCodeRec typeCountryCodeRec = null;
        try {
            TypeCategoryRec typeCategoryRec = TypeCategory.getCategoryFromDescription(string, "opicmgeo");
            TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategoryFromDescription(string2, "opicmcountry", typeCategoryRec.getInd());
            return (TypeCountryCodeRec)this.countryHash.get(typeCategoryRec2);
        }
        catch (NullPointerException nullPointerException) {
        }
        return typeCountryCodeRec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readBrandFamilyMap() {
        SQLMethod sQLMethod = new SQLMethod(1, "readBrandFamilyMap", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT OPICMTYPECATIND, QUESTTYPECATIND " + "FROM OPICM.BRANDFAMILYMAP FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(resultSet.getInt(1));
                TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategory(resultSet.getInt(2));
                if (typeCategoryRec == null || this.seriesHash.get(typeCategoryRec) != null) continue;
                this.seriesHash.put(typeCategoryRec, typeCategoryRec2);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readGeoCountryMap() {
        SQLMethod sQLMethod = new SQLMethod(1, "readGeoCountryMap", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT TYPECATIND, COUNTRYCODEIND " + "FROM OPICM.GEOCOUNTRYMAP FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(resultSet.getInt(1));
                TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)TypeList.getInstance().objectFromInd(resultSet.getInt(2), 3);
                if (this.countryHash.get(typeCategoryRec) != null) continue;
                this.countryHash.put(typeCategoryRec, typeCountryCodeRec);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            new DatabaseSystem(false, null, false);
            if (!DatabaseSystem.createConnection(1, "quest", "defiant", "5703", "dlentz", "m0seley")) return;
            TypeList typeList = new TypeList();
            typeList.initialize(false);
            new TypeCategory();
            OPICMMapper oPICMMapper = new OPICMMapper();
            System.out.println("Quest Family for OPICM Family 1:");
            System.out.println(oPICMMapper.getQuestFamilyFromOPICM("OPICMBrand1", "OPICMFamily1", "OPICMSeries1") + "\n\n");
            System.out.println("Quest Family for OPICM Family 2:");
            System.out.println(oPICMMapper.getQuestFamilyFromOPICM("OPICMBrand2", "OPICMFamily2", "OPICMSeries2") + "\n\n");
            System.out.println("Country for OPICMCountry:");
            System.out.println(oPICMMapper.getQuestCountryFromOPICM("OPICMGeography", "OPICMCountry"));
            return;
        }
        catch (Exception exception) {
        }
    }

    public OPICMMapper() {
        TypeCategory.getCategories("opicmbrand");
        TypeCategory.getCategories("opicmfamily");
        TypeCategory.getCategories("opicmseries");
        TypeCategory.getCategories("opicmgeo");
        TypeCategory.getCategories("opicmcountry");
        this.readBrandFamilyMap();
        this.readGeoCountryMap();
    }
}

