/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.type.TypeDateRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.util.CDate;
import java.awt.Color;
import java.awt.Graphics;

public class ProductDateRow
implements ExtendedMultiListRow,
MultiListRow,
MultiListSort {
    private String dateType = null;
    private int dateTypeInd = 0;
    private String date = null;
    private ProductDate productDate = null;
    private boolean target = false;

    public void setProductDate(ProductDate productDate) {
        if (productDate.getActualDate() == null || productDate.getActualDate().length() == 0) {
            this.target = true;
            this.date = productDate.getTargetDate();
        } else {
            this.target = false;
            this.date = productDate.getActualDate();
        }
        this.date = CDate.createDate(CDate.parse(this.date, 7, 2), CDate.parse(this.date, 8, 2), CDate.parse(this.date, 9, 2), 0, 0, 0, 13);
        this.dateTypeInd = productDate.getDateType();
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        if (multiListSort instanceof ProductDateRow && this.date != null) {
            ProductDateRow productDateRow = (ProductDateRow)multiListSort;
            switch (n) {
                case 0: {
                    return this.dateType.compareTo(productDateRow.dateType);
                }
                case 1: {
                    if (this.date.length() > 0) {
                        return CDate.compareDate(this.date, productDateRow.date, 13);
                    }
                    return 0;
                }
            }
        }
        return 0;
    }

    public Object getColumnData(int n) {
        switch (n) {
            case 0: {
                if (this.dateType != null) {
                    return this.dateType;
                }
            }
            case 1: {
                if (this.date == null) break;
                return this.date;
            }
        }
        return "";
    }

    public ProductDate getProductDate() {
        return this.productDate;
    }

    public int getDateType() {
        return this.dateTypeInd;
    }

    public void adjustColumnGraphics(int n, Graphics graphics) {
        if (n == 1) {
            if (this.target) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.black);
            }
        }
    }

    public void columnSized(int n, int n2) {
    }

    public ProductDateRow(ProductDate productDate) {
        if (productDate != null) {
            this.setProductDate(productDate);
            this.dateType = TypeList.getInstance().objectFromInd(productDate.getDateType(), 27).toString();
        }
    }

    public ProductDateRow(TypeDateRec typeDateRec) {
        this.productDate = null;
        this.dateType = typeDateRec.toString();
        this.dateTypeInd = typeDateRec.getInd();
        this.date = "";
    }
}

