/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.CreateProductDraft;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductComment;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.product.ProductSQL;
import com.ibm.nzna.projects.common.quest.product.XRef;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.POMUtil;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ProductDraft
extends Product {
    static final long serialVersionUID = 1000000L;
    private ProductComment comment = null;
    private String originalComments = null;
    private int existingProductInd = 0;
    private String startDate = new CDate(1).today();
    private String stopDate = null;
    private boolean misfit = false;
    private boolean recycled = false;
    private int typeCancelInd = 0;
    private int originalProductInd = 0;
    private String opicmKey = null;
    protected boolean opicmKeyUpdated = false;
    private String draftCreatedBy = null;
    private String draftCreatedOn = null;
    private int workRequired = 1;
    private boolean template = false;
    private String opicmDescript = null;
    private TypeCategoryRec opicmBrand = null;
    private TypeCategoryRec opicmFamily = null;
    private TypeCategoryRec opicmSeries = null;
    private Vector opicmCountries = null;
    private Vector opicmGeographies = null;

    public ProductComment getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = new ProductComment(this.getProductInd(), string, new CDate(1).today(), this.getLastTouchedBy());
        this.updateRecStatus(1);
    }

    public void setComment(ProductComment productComment) {
        this.comment = productComment;
        this.updateRecStatus(1);
    }

    public int getExistingProductInd() {
        return this.existingProductInd;
    }

    protected void setExistingProductInd(int n) {
        this.existingProductInd = n;
        if (n == 0) {
            this.workRequired = 1;
        }
        this.updateRecStatus(1);
    }

    public String getStartDate() {
        return this.startDate;
    }

    protected void setStartDate(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Start Date cannot be NULL");
        }
        this.startDate = string;
        this.updateRecStatus(1);
    }

    public String getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(String string) {
        this.stopDate = string;
        this.updateRecStatus(1);
    }

    public boolean getMisfit() {
        return this.misfit;
    }

    public void setMisfit(boolean bl) {
        this.misfit = bl;
        this.updateRecStatus(1);
    }

    public boolean getRecycled() {
        return this.recycled;
    }

    public void setRecycled(boolean bl) {
        this.recycled = bl;
        this.updateRecStatus(1);
    }

    public int getTypeCancelInd() {
        return this.typeCancelInd;
    }

    public void setTypeCancelInd(int n) {
        this.typeCancelInd = n;
        this.updateRecStatus(1);
    }

    public int writeToDatabase() {
        String string = this.toSQL();
        int n = 0;
        if (string != null && string.length() > 0 && (n = SqlRunner.sqlRunnerCode(1, string)) == 0) {
            this.setLastTouchedOn(ProductSQL.getDBTimestampFromDatabase());
            this.updateRecStatus(0);
            super.resetUpdateVariables();
        }
        return n;
    }

    public int publish() {
        int n = 0;
        this.setStopDate(new CDate(1).today());
        n = this.writeToDatabase();
        if (n == 0) {
            Product product = null;
            if (this.workRequired == 1) {
                product = new Product();
            } else {
                product = new Product(this.existingProductInd);
                n = product.readFromDatabase();
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 100: {
                        LogSystem.log(1, "While publishing a ProductDraft with work required for EDIT, could not find existing product. Creating new product with existing Indicator of " + this.existingProductInd);
                        product = null;
                        break;
                    }
                    default: {
                        LogSystem.log(1, "While publishing a ProductDraft with work required for EDIT, could not read Existing Product " + this.existingProductInd);
                        LogSystem.log(1, "Product.readFromDatabase returned a code of " + n);
                        product = null;
                        break;
                    }
                }
            }
            if (product != null) {
                product.initializeProperties(this);
                product.createCategoryFromDraft(this);
                if (this.getWorkRequired() == 3) {
                    product.updateRecStatus(0);
                    product.updateRecStatus(3);
                }
                n = product.writeToDatabase();
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFromDatabase() {
        int n;
        SQLMethod sQLMethod;
        block6: {
            String string = "ProductDraft.readFromDatabase";
            sQLMethod = new SQLMethod(1, string, 5);
            n = 0;
            if (sQLMethod != null) {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ProDraftReader", 3);
                    callableStatement.setInt(1, this.getProductInd());
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.registerOutParameter(3, -4);
                    LogSystem.log(1, "Reading Product Draft:" + this.getProductInd());
                    callableStatement.execute();
                    StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    if (storedProcRec != null && storedProcRec.error) {
                        LogSystem.beginLogSection("ProductDraftReader Returned Error");
                        LogSystem.log(1, "sqlCode:   " + storedProcRec.sqlCode);
                        LogSystem.log(1, "userError: " + storedProcRec.userError);
                        LogSystem.log(1, "errorStr:  " + storedProcRec.errorStr);
                        LogSystem.log(1, "error:     " + storedProcRec.error);
                        try {
                            n = new Integer(storedProcRec.sqlCode);
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, "Could not translate retRec.sqlCode to integer");
                            n = -1;
                        }
                        LogSystem.endLogSection();
                        break block6;
                    }
                    this.initializeProperties((Product)StoredProcUtil.getObjectFromStatement(callableStatement, 2));
                    this.forceRecStatus(0);
                    n = 0;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception, false);
                    n = -1;
                }
            }
        }
        sQLMethod.close();
        return n;
    }

    public static CreateProductDraft createProductDraft(Product product) {
        CreateProductDraft createProductDraft = null;
        ProductDraft productDraft = null;
        int n = ProductDraft.draftExists(product.getProductInd());
        block0 : switch (n) {
            case 0: {
                productDraft = new ProductDraft();
                productDraft.setWorkRequired(2);
                productDraft.initializeProperties(product);
                productDraft.createCategoryFromExisting();
                createProductDraft = new CreateProductDraft(4, 0, productDraft);
                break;
            }
            case -1: {
                LogSystem.log(1, "ProductDraft.createDraft ( " + product.getProductInd() + " ): Could not find Existing Product.");
                createProductDraft = new CreateProductDraft(0, 0, null);
                productDraft = null;
                break;
            }
            default: {
                int n2 = 0;
                productDraft = new ProductDraft(n);
                n2 = productDraft.readFromDatabase();
                switch (n2) {
                    case 0: {
                        productDraft.forceRecStatus(0);
                        if (productDraft.getRecycled()) {
                            createProductDraft = new CreateProductDraft(2, 0, productDraft);
                            break block0;
                        }
                        createProductDraft = new CreateProductDraft(1, 0, productDraft);
                        break block0;
                    }
                    case 100: {
                        LogSystem.log(1, "ProductDraft.createDraft ( " + product.getProductInd() + " ): Wierd, found draft " + n + " for existing product, but can't read it! rc 100");
                        productDraft = null;
                        createProductDraft = new CreateProductDraft(0, 0, null);
                        break block0;
                    }
                }
                LogSystem.log(1, "ProductDraft.createDraft ( " + product.getProductInd() + " ): Read Draft Product " + n + ". rc:" + n2);
                createProductDraft = new CreateProductDraft(5, n2, null);
                productDraft = null;
                break;
            }
        }
        if (createProductDraft == null) {
            LogSystem.log(1, "ProductDraft.createDraft ( " + product.getProductInd() + " ) could not figure out what to do");
            createProductDraft = new CreateProductDraft(0, 0, null);
        }
        return createProductDraft;
    }

    public static CreateProductDraft createProductDraft(int n) {
        CreateProductDraft createProductDraft = null;
        Product product = new Product(n);
        int n2 = product.readFromDatabase();
        switch (n2) {
            case 0: {
                createProductDraft = ProductDraft.createProductDraft(product);
                break;
            }
            case 100: {
                createProductDraft = new CreateProductDraft(6, 100, null);
                break;
            }
            default: {
                createProductDraft = new CreateProductDraft(5, n2, null);
                break;
            }
        }
        return createProductDraft;
    }

    public static CreateProductDraft createProductDraft(TypeCategoryRec typeCategoryRec, String string, String string2) throws Exception {
        TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategoryFromDescriptionUnderParent(string, "machine", typeCategoryRec.getInd());
        if (typeCategoryRec2 == null) {
            typeCategoryRec2 = TypeCategory.getDraftCategoryFromDescriptionUnderParent(string, "machine", typeCategoryRec.getInd());
        }
        if (typeCategoryRec2 != null) {
            TypeCategoryRec typeCategoryRec3;
            TypeCategoryRec typeCategoryRec4 = typeCategoryRec3 = typeCategoryRec2.getIsDraft() ? TypeCategory.getDraftCategoryFromDescription(string2, typeCategoryRec2.getInd()) : TypeCategory.getCategoryFromDescription(string2, typeCategoryRec2.getInd());
            if (typeCategoryRec3 != null) {
                int n;
                int n2 = n = typeCategoryRec3.getIsDraft() ? ProductSQL.getDraftProductIndFromModel(typeCategoryRec3) : ProductSQL.getProductIndFromModel(typeCategoryRec3);
                if (n != 0) {
                    return ProductDraft.createProductDraft(n);
                }
                throw new Exception("Cannot create product draft because model doesn't exist in PRODUCT.CATEGORY.\nModel:" + string2 + "\nMachine:" + string + "\nFamily:" + typeCategoryRec.toString());
            }
            throw new Exception("Cannot create product draft for model that does not exist.\nModel:" + string2 + "\nMachine:" + string + "\nFamily:" + typeCategoryRec.toString());
        }
        throw new Exception("Cannot create product draft for machine that does not exist.\nModel:" + string2 + "\nMachine:" + string + "\nFamily:" + typeCategoryRec.toString());
    }

    public static CreateProductDraft createProductDraft(String string) throws Exception {
        TypeCategoryRec typeCategoryRec = TypeCategory.getCategoryFromDescription(string, "partnum");
        if (typeCategoryRec != null) {
            int n = ProductSQL.getProductIndFromModel(typeCategoryRec);
            if (n != 0) {
                return ProductDraft.createProductDraft(n);
            }
            throw new Exception("Cannot create product draft because part number doesn't exist in PRODUCT.CATEGORY.\nPart Number:" + string);
        }
        throw new Exception("Cannot create draft from part number because part number doesn't exist.\nPart Number:" + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkOut(String string) throws Exception {
        if (this.getProductInd() != 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "checkOut ( " + string + " )", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                this.setCheckedOutBy(string);
                if (string != null) {
                    statement.executeUpdate("UPDATE PRODRAFT.PRODUCT SET CHECKEDOUTBY = '" + string + "' where productInd = " + this.getProductInd());
                } else {
                    statement.executeUpdate("UPDATE PRODRAFT.PRODUCT SET CHECKEDOUTBY = NULL where productInd = " + this.getProductInd());
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                throw exception;
            }
            sQLMethod.close();
        }
    }

    public int getWorkRequired() {
        return this.workRequired;
    }

    public void setWorkRequired(int n) {
        this.workRequired = n;
        this.updateRecStatus(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int draftExists(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "draftExists (" + n + ")", 5);
        int n2 = -1;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND " + "FROM PRODRAFT.PRODUCT " + "WHERE STOPDATE IS NULL AND " + "      EXISTINGPRODUCTIND = " + n + " " + "FOR FETCH ONLY");
            n2 = resultSet.next() ? resultSet.getInt(1) : 0;
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return n2;
    }

    public void initializeProperties(Product product) {
        super.initializeProperties(product);
        if (product instanceof ProductDraft) {
            ProductDraft productDraft = (ProductDraft)product;
            super.setProductInd(productDraft.getProductInd());
            this.existingProductInd = productDraft.existingProductInd;
            this.comment = productDraft.comment;
            this.startDate = productDraft.startDate;
            this.stopDate = productDraft.stopDate;
            this.misfit = productDraft.misfit;
            this.recycled = productDraft.recycled;
            this.typeCancelInd = productDraft.typeCancelInd;
            this.workRequired = productDraft.workRequired;
            this.originalComments = productDraft.originalComments;
            this.originalProductInd = productDraft.originalProductInd;
            this.opicmDescript = productDraft.opicmDescript;
            this.opicmBrand = productDraft.opicmBrand;
            this.opicmFamily = productDraft.opicmFamily;
            this.opicmSeries = productDraft.opicmSeries;
            this.opicmKey = productDraft.opicmKey;
            this.opicmKeyUpdated = productDraft.opicmKeyUpdated;
            this.draftCreatedOn = productDraft.draftCreatedOn;
            this.draftCreatedBy = productDraft.draftCreatedBy;
            if (productDraft.opicmCountries != null) {
                this.opicmCountries = (Vector)productDraft.opicmCountries.clone();
            }
            if (productDraft.opicmGeographies != null) {
                this.opicmGeographies = (Vector)productDraft.opicmGeographies.clone();
            }
        } else {
            TypeCategoryRec typeCategoryRec;
            TypeCategoryRec typeCategoryRec2 = product.getProject();
            this.existingProductInd = product.getProductInd();
            if (product.getProject() != null && !product.getProject().getIsDraft()) {
                this.setProject(TypeCategory.getDraftCategoryFromCategory(product.getProject()));
            }
            if (product.getMachine() != null && !product.getMachine().getIsDraft()) {
                typeCategoryRec = TypeCategory.getDraftCategoryFromCategory(product.getMachine());
                typeCategoryRec.setParentCatInd(product.getProject().getInd());
                this.setMachine(typeCategoryRec);
            }
            if (product.getSubCategory() != null && !product.getSubCategory().getIsDraft()) {
                typeCategoryRec = TypeCategory.getDraftCategoryFromCategory(product.getSubCategory());
                typeCategoryRec.setParentCatInd(product.getProject().getInd());
                this.setSubCategory(typeCategoryRec);
            }
            if (product.getModel() != null && !product.getModel().getIsDraft()) {
                typeCategoryRec = TypeCategory.getDraftCategoryFromCategory(product.getModel());
                TypeCategoryRec typeCategoryRec3 = this.getProductType() == 2 ? product.getSubCategory() : product.getMachine();
                typeCategoryRec.setParentCatInd(typeCategoryRec3.getInd());
                this.setModel(typeCategoryRec);
            }
        }
    }

    public String toSQL() {
        String string = "";
        if (this.generateKeys()) {
            String string2 = this.originalComments;
            if (string2 == null) {
                string2 = "";
            }
            string2 = this.comment != null ? string2 + "\n" + this.comment.toString() : string2 + "\nN/A";
            string2 = Text.cleanDBString(string2);
            switch (this.getRecStatus()) {
                case 3: {
                    string = "UPDATE PRODRAFT.PRODUCT " + "SET RECYCLED = 'Y'," + "    LASTCHANGEDBY = '" + this.getLastTouchedBy() + "', " + "    LASTCHANGEDON = CURRENT TIMESTAMP " + "WHERE PRODUCTIND = " + this.getProductInd();
                    break;
                }
                case 2: {
                    string = "INSERT INTO PRODRAFT.PRODUCT " + "( PRODUCTIND,     PRODNUM,         DESCRIPTION,        BASEMODEL, TYPECUSTOMERIND, " + "  TYPEPRODUCTIND, TYPEOFFERINGIND, TYPEWARRANTYIND,    INPUT,     SOURCE, " + "  PUBLISH,        CHECKEDOUTBY,    CREATEDON,          CREATEDBY, " + "  LASTTOUCHEDON,  LASTTOUCHEDBY,   EXISTINGPRODUCTIND, COMMENTS,  MISFIT, " + "  TYPECANCELIND,  STARTDATE,       STOPDATE,           RECYCLED,  WORKIND, TEMPLATE, IMPORTOPICM ) values ( " + " " + this.getProductInd() + ", " + " '" + Text.cleanDBString(this.getProdNum()) + "', " + " '" + Text.cleanDBString(this.getDescription()) + "', " + " " + Text.cleanNullableDBString(this.getBaseModel()) + ", " + " " + this.getCustomer() + ", " + " " + this.getProductType() + ", " + " " + this.getOffering() + ", " + " " + this.getWarranty() + ", " + " '" + Text.cleanDBString(this.getInput()) + "', " + " '" + Text.cleanDBString(this.getSource()) + "', " + " 'Y', " + " NULL, " + " CURRENT TIMESTAMP, " + " '" + this.getLastTouchedBy() + "', " + " CURRENT TIMESTAMP, " + " '" + this.getLastTouchedBy() + "', " + " " + this.getExistingProductInd() + ", " + " '" + string2 + "', " + " '" + Text.getYN(this.misfit) + "', " + "  " + this.getTypeCancelInd() + ", " + "  " + Text.cleanNullableDBString(this.getStartDate()) + ", " + "  " + Text.cleanNullableDBString(this.getStopDate()) + ", " + "  'N', " + "  " + this.workRequired + ", " + "  '" + Text.getYN(this.template) + "', " + "  '" + (this.getOPICMImport() ? "Y" : "N") + "')";
                    break;
                }
                case 1: {
                    string = "UPDATE PRODRAFT.PRODUCT " + "SET PRODNUM            = '" + Text.cleanDBString(this.getProdNum()) + "', " + "    DESCRIPTION        = '" + Text.cleanDBString(this.getDescription()) + "', " + "    BASEMODEL          = '" + Text.cleanDBString(this.getBaseModel()) + "', " + "    TYPECUSTOMERIND    = " + this.getCustomer() + ", " + "    TYPEPRODUCTIND     = " + this.getProductType() + ", " + "    TYPEOFFERINGIND    = " + this.getOffering() + ", " + "    TYPEWARRANTYIND    = " + this.getWarranty() + ", " + "    INPUT              = '" + Text.cleanDBString(this.getInput()) + "', " + "    SOURCE             = '" + Text.cleanDBString(this.getSource()) + "', " + "    PUBLISH            = '" + (this.getPublish().equals("Y") ? "Y" : "N") + "', " + "    CHECKEDOUTBY       = '" + Text.cleanDBString(this.getCheckedOutBy()) + "', " + "    LASTTOUCHEDON      = CURRENT TIMESTAMP, " + "    LASTTOUCHEDBY      = '" + Text.cleanDBString(this.getLastTouchedBy()) + "', " + "    EXISTINGPRODUCTIND = " + this.existingProductInd + ", " + "    COMMENTS           = '" + string2 + "', " + "    MISFIT             = '" + Text.getYN(this.misfit) + "', " + "    TYPECANCELIND      = " + this.getTypeCancelInd() + ", " + "    STARTDATE          = " + Text.cleanNullableDBString(this.startDate) + ", " + "    STOPDATE           = " + Text.cleanNullableDBString(this.stopDate) + ", " + "    WORKIND            = " + this.workRequired + ", " + "    TEMPLATE           = '" + Text.getYN(this.template) + "', " + "    IMPORTOPICM        = '" + (this.getOPICMImport() ? "Y" : "N") + "' " + "WHERE PRODUCTIND = " + this.getProductInd();
                    break;
                }
            }
            if (string.length() > 0) {
                string = string + SqlRunner.END_DELIM;
            }
            string = this.opicmKeyUpdated ? string + this.opicmKeyToSQL() : string + this.opicmDescriptToSQL();
            string = string + this.datesToSQL();
            string = string + this.xRefToSQL();
            string = string + this.localeToSQL();
            string = string + this.categoryToSQL();
        } else {
            String string3 = "Could not generate a Product Indicator. No INSERT can occur. Please check logs for more info";
            LogSystem.log(1, string3);
        }
        return string;
    }

    protected boolean generateKeys() {
        if (this.getProductIndNow() == 0) {
            this.setProductInd(Counter.getCounter(LogSystem.getInstance(), "PRODRAFT"));
        }
        if (this.existingProductInd == 0) {
            this.existingProductInd = Counter.getCounter(LogSystem.getInstance(), "PRODUCT");
        }
        return this.getProductIndNow() != 0;
    }

    protected String datesToSQL() {
        String string = "";
        Vector vector = this.getDates();
        int n = 0;
        int n2 = vector.size();
        ProductDate productDate = null;
        string = "DELETE FROM PRODRAFT.DATES WHERE PRODUCTIND = " + this.getProductInd() + SqlRunner.END_DELIM;
        while (n < n2) {
            productDate = (ProductDate)vector.elementAt(n);
            productDate.setProductInd(this.getProductInd());
            string = string + productDate.toDraftSQL();
            ++n;
        }
        return string;
    }

    protected String xRefToSQL() {
        String string = "";
        Vector vector = this.getXRef();
        if (POMUtil.vectorContainsChanges(vector)) {
            int n = 0;
            int n2 = vector.size();
            XRef xRef = null;
            while (n < n2) {
                xRef = (XRef)vector.elementAt(n);
                if (xRef.modified()) {
                    string = string + xRef.toDraftSQL();
                }
                ++n;
            }
        }
        return string;
    }

    protected String localeToSQL() {
        String string = "";
        LocaleRec localeRec = this.getLocale();
        if (localeRec != null && localeRec.modified()) {
            Vector vector = localeRec.getCountryList();
            Vector vector2 = localeRec.getGeoListContainingAll();
            string = "DELETE FROM PRODRAFT.GEO WHERE PRODUCTIND = " + this.getProductInd() + SqlRunner.END_DELIM;
            string = string + "DELETE FROM PRODRAFT.COUNTRY WHERE PRODUCTIND = " + this.getProductInd() + SqlRunner.END_DELIM;
            if (localeRec.isWorldWide()) {
                string = string + "INSERT INTO PRODRAFT.GEO ( PRODUCTIND, GEOIND ) " + "values ( " + this.getProductInd() + ", " + 6 + " )" + SqlRunner.END_DELIM;
            } else {
                TypeRec typeRec;
                int n;
                int n2;
                if (vector != null && vector.size() > 0) {
                    n2 = 0;
                    n = vector.size();
                    typeRec = null;
                    while (n2 < n) {
                        typeRec = (TypeCountryCodeRec)vector.elementAt(n2);
                        string = string + "INSERT INTO PRODRAFT.COUNTRY ( PRODUCTIND, COUNTRYCODEIND ) " + "values ( " + this.getProductInd() + ", " + typeRec.getInd() + " )" + SqlRunner.END_DELIM;
                        ++n2;
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n2 = 0;
                    n = vector2.size();
                    typeRec = null;
                    while (n2 < n) {
                        typeRec = (TypeGeoRec)vector2.elementAt(n2);
                        string = string + "INSERT INTO PRODRAFT.GEO ( PRODUCTIND, GEOIND ) " + "values ( " + this.getProductInd() + ", " + typeRec.getInd() + " )" + SqlRunner.END_DELIM;
                        ++n2;
                    }
                }
            }
        }
        return string;
    }

    protected String categoryToSQL() {
        int n;
        TypeCategoryRec typeCategoryRec;
        String string = "";
        if (this.brandUpdated) {
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODRAFT.CATEGORY " + "WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from product.category a, " + "                         product.typecategory b " + "                    where a.productInd      = " + this.getProductInd() + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = 'brand')" + SqlRunner.END_DELIM;
            }
            string = string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getBrand().getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.familyUpdated) {
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODRAFT.CATEGORY " + "WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from product.category a, " + "                         product.typecategory b " + "                    where a.productInd      = " + this.getProductInd() + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = 'family')" + SqlRunner.END_DELIM;
            }
            string = string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getFamily().getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.projectUpdated && (typeCategoryRec = this.getProject()) != null) {
            string = string + typeCategoryRec.toDraftSQL();
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODRAFT.CATEGORY " + "WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from prodraft.category a, " + "                         prodraft.typecategory b " + "                    where A.productInd      = " + this.getProductInd() + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = '" + "project" + "')" + SqlRunner.END_DELIM;
            }
            string = string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + typeCategoryRec.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.machineUpdated) {
            boolean bl = this.getProductType() == 2;
            string = bl ? string + this.getSubCategory().toDraftSQL() : string + this.getMachine().toDraftSQL();
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODRAFT.CATEGORY " + "WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from prodraft.category a, " + "                         prodraft.typecategory b " + "                    where a.productInd      = " + this.getProductInd() + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel IN ('" + "machine" + "', '" + "subcategory" + "'))" + SqlRunner.END_DELIM;
            }
            string = bl ? string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getSubCategory().getInd() + " )" + SqlRunner.END_DELIM : string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getMachine().getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.partNumUpdated) {
            if (this.getPartNumber() != null) {
                string = string + this.getPartNumber().toDraftSQL();
                if (this.getRecStatus() == 2) {
                    string = string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getPartNumber().getInd() + " )" + SqlRunner.END_DELIM;
                }
            } else {
                string = string + "DELETE FROM PRODRAFT.CATEGORY WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "TYPECATIND IN (SELECT TYPECATIND FROM PRODRAFT.TYPECATEGORY WHERE CATEGORYLEVEL = '" + "partnum" + "')" + SqlRunner.END_DELIM;
            }
        }
        if (this.modelUpdated) {
            if (this.getModel() != null) {
                string = string + this.getModel().toDraftSQL();
                if (this.getRecStatus() == 2) {
                    string = string + "INSERT INTO PRODRAFT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getModel().getInd() + " )" + SqlRunner.END_DELIM;
                }
            } else {
                string = string + "DELETE FROM PRODRAFT.CATEGORY WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "TYPECATIND IN (SELECT TYPECATIND FROM PRODRAFT.TYPECATEGORY WHERE CATEGORYLEVEL = '" + "model" + "')" + SqlRunner.END_DELIM;
            }
        }
        string = string + "DELETE FROM PRODRAFT.CATEGORY " + "WHERE TYPECATIND IN (SELECT TYPECATIND FROM PRODRAFT.TYPECATEGORY WHERE CATEGORYLEVEL IN ( " + "'" + "opicmbrand" + "', " + "'" + "opicmseries" + "', " + "'" + "opicmfamily" + "', " + "'" + "opicmgeo" + "', " + "'" + "opicmcountry" + "' ) ) AND " + "PRODUCTIND = " + this.getProductInd() + SqlRunner.END_DELIM;
        if (this.opicmBrand != null) {
            string = string + "INSERT INTO PRODRAFT.CATEGORY VALUES ( " + this.getProductInd() + ", " + this.opicmBrand.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.opicmFamily != null) {
            string = string + "INSERT INTO PRODRAFT.CATEGORY VALUES ( " + this.getProductInd() + ", " + this.opicmFamily.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.opicmSeries != null) {
            string = string + "INSERT INTO PRODRAFT.CATEGORY VALUES ( " + this.getProductInd() + ", " + this.opicmSeries.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.opicmGeographies != null && this.opicmGeographies.size() > 0) {
            int n2 = 0;
            n = this.opicmGeographies.size();
            while (n2 < n) {
                string = string + "INSERT INTO PRODRAFT.CATEGORY " + "VALUES ( " + this.getProductInd() + ", " + "" + ((TypeCategoryRec)this.opicmGeographies.elementAt(n2)).getInd() + " )" + SqlRunner.END_DELIM;
                ++n2;
            }
        }
        if (this.opicmCountries != null && this.opicmCountries.size() > 0) {
            int n3 = 0;
            n = this.opicmCountries.size();
            while (n3 < n) {
                string = string + "INSERT INTO PRODRAFT.CATEGORY " + "VALUES ( " + this.getProductInd() + ", " + "" + ((TypeCategoryRec)this.opicmCountries.elementAt(n3)).getInd() + " )" + SqlRunner.END_DELIM;
                ++n3;
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toOut() {
        block8: {
            block7: {
                var1_1 = this.getLocale();
                var2_2 = this.getXRef();
                var3_3 = "";
                var4_4 = this.getCommentHistory();
                var3_3 = var3_3 + "Product Ind:            " + this.getProductIndNow() + "\n";
                var3_3 = var3_3 + "Existing Product Ind:   " + this.existingProductInd + "\n";
                var3_3 = var3_3 + "Description:            " + this.getDescription() + "\n";
                var3_3 = this.getBrand() != null ? var3_3 + "Brand:                  " + this.getBrand().toString() + "\n" : var3_3 + "Brand:                  NONE\n";
                var3_3 = this.getFamily() != null ? var3_3 + "Family:                 " + this.getFamily().toString() + "\n" : var3_3 + "Family:                  NONE\n";
                var3_3 = this.getProject() != null ? (this.getProject().toString().equals("") ? var3_3 + "Project:                BLANK PROJECT\n" : var3_3 + "Project:                " + this.getProject().toString() + "\n") : var3_3 + "Project:                NULL!\n";
                try {
                    var3_3 = var3_3 + "Machine:                " + this.getMachine().toString() + "\n";
                    var3_3 = var3_3 + "Model:                  " + this.getModel().toString() + "\n";
                }
                catch (Exception var5_5) {
                    var3_3 = var3_3 + "Machine:                NONE\n";
                    var3_3 = var3_3 + "Model:                  NONE\n";
                }
                try {
                    var3_3 = var3_3 + "Part Number:            " + this.getPartNumber().toString() + "\n";
                }
                catch (Exception var5_6) {
                    var3_3 = var3_3 + "Part Number:            NONE\n";
                }
                var3_3 = var3_3 + "publish:                " + this.getPublish() + "\n";
                var3_3 = var3_3 + "Checked Out By:         " + this.getCheckedOutBy() + "\n";
                var3_3 = var3_3 + "Source:                 " + this.getSource() + "\n";
                var3_3 = var3_3 + "Offering:               " + this.getOffering() + "\n";
                var3_3 = var3_3 + "Customer:               " + this.getCustomer() + "\n";
                var3_3 = var3_3 + "Warranty:               " + this.getWarranty() + "\n";
                var3_3 = this.comment != null ? var3_3 + "Comments:\n   " + this.comment.toString() + "\n\n" : var3_3 + "Comments:\n   NONE\n";
                var3_3 = var3_3 + "Start Date:             " + this.startDate + "\n";
                var3_3 = var3_3 + "Stop Date:              " + this.stopDate + "\n";
                var3_3 = var3_3 + "Recycled:               " + this.recycled + "\n";
                var3_3 = var3_3 + "Cancel Ind:             " + this.typeCancelInd + "\n";
                var3_3 = var3_3 + "Work Ind:               " + this.workRequired + "\n";
                if (var2_2 == null || var2_2.size() <= 0) break block7;
                var5_8 = 0;
                var6_10 = var2_2.size();
                if (true) ** GOTO lbl47
            }
            var3_3 = var3_3 + "\nNo XRef Objects\n";
            break block8;
            do {
                var3_3 = var3_3 + ((XRef)var2_2.elementAt(var5_8)).toOut() + "\n\n";
                ++var5_8;
lbl47:
                // 2 sources

            } while (var5_8 < var6_10);
        }
        var3_3 = var1_1 != null ? var3_3 + var1_1.toOut() + "\n\n" : var3_3 + "No locale information\n\n";
        if (var4_4 != null && var4_4.size() > 0) {
            var5_9 = 0;
            var6_10 = var4_4.size();
            while (var5_9 < var6_10) {
                var3_3 = var3_3 + "   " + ((ProductComment)var4_4.elementAt(var5_9)).toString() + "\n-----------------------------------------\n";
                ++var5_9;
            }
        }
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Product find(int n) {
        ProductDraft productDraft = null;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductDraft.find ( " + n + " )", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND FROM PRODRAFT.PRODUCT WHERE PRODUCTIND = " + n + " FOR FETCH ONLY");
            if (resultSet.next()) {
                productDraft = new ProductDraft(n);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return productDraft;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Product findFromCategory(int n, int n2, int n3, int n4) {
        ProductDraft productDraft = null;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductDraft.find ( " + n2 + ", " + n3 + ", " + n4 + " )", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND " + "FROM   PRODRAFT.PRODUCT " + "WHERE " + "STOPDATE IS NULL AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODRAFT.CATEGORY " + "    WHERE  TYPECATIND = " + n2 + ") AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODRAFT.CATEGORY " + "    WHERE  TYPECATIND = " + n + ") AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODRAFT.CATEGORY " + "    WHERE  TYPECATIND = " + n3 + ") AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODRAFT.CATEGORY " + "    WHERE  TYPECATIND = " + n4 + ") FOR FETCH ONLY ");
            if (resultSet.next()) {
                productDraft = new ProductDraft(resultSet.getInt(1));
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return productDraft;
    }

    public static Product findFromCategory(String string, String string2, String string3, String string4) {
        TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(string, "brand");
        TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategory(string2, "family");
        TypeCategoryRec typeCategoryRec3 = TypeCategory.getDraftCategory(string3, "machine");
        TypeCategoryRec typeCategoryRec4 = TypeCategory.getDraftCategory(string4, "model");
        if (typeCategoryRec2 != null && typeCategoryRec3 != null && typeCategoryRec4 != null) {
            return ProductDraft.findFromCategory(typeCategoryRec.getInd(), typeCategoryRec2.getInd(), typeCategoryRec3.getInd(), typeCategoryRec4.getInd());
        }
        return null;
    }

    public void createCategoryFromExisting() {
        TypeCategoryRec typeCategoryRec = this.getProject();
        TypeCategoryRec typeCategoryRec2 = this.getMachine();
        TypeCategoryRec typeCategoryRec3 = this.getModel();
        TypeCategoryRec typeCategoryRec4 = this.getSubCategory();
        TypeCategoryRec typeCategoryRec5 = this.getPartNumber();
        TypeCategoryRec typeCategoryRec6 = null;
        TypeCategoryRec typeCategoryRec7 = null;
        TypeCategoryRec typeCategoryRec8 = null;
        TypeCategoryRec typeCategoryRec9 = null;
        TypeCategoryRec typeCategoryRec10 = null;
        if (typeCategoryRec != null && (typeCategoryRec6 = TypeCategory.getDraftCategoryFromDescription(typeCategoryRec.toString(), "project", this.getFamily().getInd())) == null) {
            typeCategoryRec6 = TypeCategory.createDraftTypeCategory(this.getFamily().getInd(), typeCategoryRec.toString(), "project", typeCategoryRec.getOrderNum(), typeCategoryRec.getChildSort(), typeCategoryRec.getOwner());
        }
        if (typeCategoryRec6 != null) {
            if (typeCategoryRec2 != null && (typeCategoryRec7 = TypeCategory.getDraftCategoryFromDescription(typeCategoryRec2.toString(), "machine", typeCategoryRec6.getInd())) == null) {
                typeCategoryRec7 = TypeCategory.createDraftTypeCategory(typeCategoryRec6.getInd(), typeCategoryRec2.toString(), "machine", typeCategoryRec2.getOrderNum(), typeCategoryRec2.getChildSort(), typeCategoryRec2.getOwner());
            }
            if (typeCategoryRec7 != null && typeCategoryRec3 != null && (typeCategoryRec8 = TypeCategory.getDraftCategoryFromDescription(typeCategoryRec3.toString(), "model", typeCategoryRec7.getInd())) == null) {
                typeCategoryRec8 = TypeCategory.createDraftTypeCategory(typeCategoryRec7.getInd(), typeCategoryRec3.toString(), "model", typeCategoryRec3.getOrderNum(), typeCategoryRec3.getChildSort(), typeCategoryRec3.getOwner());
            }
            if (typeCategoryRec4 != null && (typeCategoryRec9 = TypeCategory.getDraftCategoryFromDescription(typeCategoryRec4.toString(), "subcategory", typeCategoryRec6.getInd())) == null) {
                typeCategoryRec9 = TypeCategory.createDraftTypeCategory(typeCategoryRec6.getInd(), typeCategoryRec4.toString(), "subcategory", typeCategoryRec4.getOrderNum(), typeCategoryRec4.getChildSort(), typeCategoryRec4.getOwner());
            }
            if (typeCategoryRec9 != null && typeCategoryRec5 != null && (typeCategoryRec10 = TypeCategory.getDraftCategoryFromDescription(typeCategoryRec5.toString(), "partnum", typeCategoryRec9.getInd())) == null) {
                typeCategoryRec10 = TypeCategory.createDraftTypeCategory(typeCategoryRec9.getInd(), typeCategoryRec5.toString(), "subcategory", typeCategoryRec5.getOrderNum(), typeCategoryRec5.getChildSort(), typeCategoryRec5.getOwner());
            }
            if (typeCategoryRec7 != null) {
                this.setMachine(typeCategoryRec7);
            }
            if (typeCategoryRec8 != null) {
                this.hardSetModel(typeCategoryRec8);
            }
            if (typeCategoryRec9 != null) {
                this.setSubCategory(typeCategoryRec9);
            }
            if (typeCategoryRec10 != null) {
                this.setPartNumber(typeCategoryRec10);
            }
        }
    }

    public TypeCategoryRec getProject() {
        if (this.project == null && this.getFamily() != null) {
            boolean bl = false;
            TypeCategoryRec typeCategoryRec = TypeCategory.getCategoryFromDescription("Default", "project", this.getFamily().getInd());
            TypeCategoryRec typeCategoryRec2 = TypeCategory.getDraftCategoryFromDescription("Default", "project", this.getFamily().getInd());
            if (typeCategoryRec == null) {
                typeCategoryRec = TypeCategory.createTypeCategory(this.getFamily().getInd(), "Default", "project", 0, "N", "QUEST");
                bl = true;
            }
            if (typeCategoryRec2 == null) {
                typeCategoryRec2 = TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), this.getFamily().getInd(), "Default", "project", 0, "N", "QUEST");
                bl = true;
            }
            if (bl) {
                TypeCategory.writeToDatabase();
            }
            this.projectUpdated = true;
            this.project = typeCategoryRec;
        }
        return this.project;
    }

    public void setOPICMBrand(TypeCategoryRec typeCategoryRec) {
        this.opicmBrand = typeCategoryRec;
        this.updateRecStatus(1);
    }

    public void setOPICMFamily(TypeCategoryRec typeCategoryRec) {
        this.opicmFamily = typeCategoryRec;
        this.updateRecStatus(1);
    }

    public void setOPICMSeries(TypeCategoryRec typeCategoryRec) {
        this.opicmSeries = typeCategoryRec;
        this.updateRecStatus(1);
    }

    public TypeCategoryRec getOPICMBrand() {
        return this.opicmBrand;
    }

    public TypeCategoryRec getOPICMFamily() {
        return this.opicmFamily;
    }

    public TypeCategoryRec getOPICMSeries() {
        return this.opicmSeries;
    }

    public Vector getOPICMCountries() {
        return this.opicmCountries;
    }

    public Vector getOPICMGeographies() {
        return this.opicmGeographies;
    }

    public void setOPICMCountries(Vector vector) {
        this.opicmCountries = vector;
        this.updateRecStatus(1);
    }

    public void setOPICMGeographies(Vector vector) {
        this.opicmGeographies = vector;
        this.updateRecStatus(1);
    }

    public String getOPICMDescript() {
        return this.opicmDescript;
    }

    public void setOPICMDescript(String string) {
        this.opicmDescript = string.trim();
    }

    public int getOriginalProductInd() {
        return this.originalProductInd;
    }

    public void setOriginalProductInd(int n) {
        this.originalProductInd = n;
    }

    public String getOPICMKey() {
        return this.opicmKey;
    }

    public void setOPICMKey(String string) {
        if (this.opicmKey == null) {
            this.opicmKeyUpdated = true;
            this.opicmKey = string;
        }
    }

    public boolean getTemplate() {
        return this.template;
    }

    public void setTemplate(boolean bl) {
        this.template = bl;
        this.hardSetModel(null);
        this.hardSetPartNumber(null);
    }

    public void setBrand(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null && !typeCategoryRec.getIsDraft()) {
            typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
            typeCategoryRec.setIsDraft(true);
        }
        super.setBrand(typeCategoryRec);
    }

    public void setFamily(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null && !typeCategoryRec.getIsDraft()) {
            typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
            typeCategoryRec.setIsDraft(true);
        }
        super.setFamily(typeCategoryRec);
    }

    public void setModel(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null) {
            if (!typeCategoryRec.getIsDraft()) {
                if (TypeCategory.getDraftCategory(typeCategoryRec.getInd()) != null) {
                    typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
                } else {
                    typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
                    typeCategoryRec.updateRecStatus(0);
                    typeCategoryRec.updateRecStatus(2);
                }
                typeCategoryRec.setIsDraft(true);
            }
            super.setModel(typeCategoryRec);
        } else {
            super.hardSetModel(null);
        }
    }

    public void setProject(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null && !typeCategoryRec.getIsDraft()) {
            if (TypeCategory.getDraftCategory(typeCategoryRec.getInd()) != null) {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
            } else {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
                typeCategoryRec.updateRecStatus(0);
                typeCategoryRec.updateRecStatus(2);
            }
            typeCategoryRec.setIsDraft(true);
        }
        super.setProject(typeCategoryRec);
    }

    public void setMachine(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null && !typeCategoryRec.getIsDraft()) {
            if (TypeCategory.getDraftCategory(typeCategoryRec.getInd()) != null) {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
            } else {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
                typeCategoryRec.updateRecStatus(0);
                typeCategoryRec.updateRecStatus(2);
            }
            typeCategoryRec.setIsDraft(true);
        }
        super.setMachine(typeCategoryRec);
    }

    public void setSubCategory(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null && !typeCategoryRec.getIsDraft()) {
            if (TypeCategory.getDraftCategory(typeCategoryRec.getInd()) != null) {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
            } else {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
                typeCategoryRec.updateRecStatus(0);
                typeCategoryRec.updateRecStatus(2);
            }
            typeCategoryRec.setIsDraft(true);
        }
        super.setSubCategory(typeCategoryRec);
    }

    public void setPartNumber(TypeCategoryRec typeCategoryRec) {
        if (typeCategoryRec != null && !typeCategoryRec.getIsDraft()) {
            if (TypeCategory.getDraftCategory(typeCategoryRec.getInd()) != null) {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
            } else {
                typeCategoryRec = (TypeCategoryRec)typeCategoryRec.clone();
                typeCategoryRec.updateRecStatus(0);
                typeCategoryRec.updateRecStatus(2);
            }
            typeCategoryRec.setIsDraft(true);
        }
        super.setPartNumber(typeCategoryRec);
    }

    public ProductDraft createNew(TypeCategoryRec typeCategoryRec) {
        ProductDraft productDraft = new ProductDraft();
        productDraft.setWorkRequired(1);
        productDraft.setDescription(this.getDescription());
        productDraft.setBrand(this.getBrand());
        productDraft.setFamily(this.getFamily());
        productDraft.setProject(this.getProject());
        productDraft.setMachine(this.getMachine());
        productDraft.setSubCategory(this.getSubCategory());
        productDraft.setDates(this.getDates());
        productDraft.setCustomer(this.getCustomer());
        productDraft.setBaseModel(this.getBaseModel());
        productDraft.setLocale(this.getLocale());
        productDraft.setInput(this.getInput());
        productDraft.setComment(this.getComment());
        productDraft.setOffering(this.getOffering());
        productDraft.setWarranty(this.getWarranty());
        productDraft.setProductType(this.getProductType());
        productDraft.setPublish(this.getPublish());
        productDraft.setRecycled(this.getRecycled());
        productDraft.setOriginalComments(this.getOriginalComments());
        productDraft.setStartDate(new CDate(1).today());
        productDraft.setXRef(this.getXRef());
        productDraft.setSource(this.getSource());
        if (this.getProductType() == 2) {
            productDraft.setPartNumber(typeCategoryRec);
        } else {
            productDraft.setModel(typeCategoryRec);
        }
        return productDraft;
    }

    public boolean isOPICM() {
        if (this.getInput() != null) {
            return this.getInput().equals("OPIC/M");
        }
        return false;
    }

    public String getOriginalComments() {
        return this.originalComments;
    }

    protected void setOriginalComments(String string) {
        this.originalComments = string;
    }

    private final String opicmKeyToSQL() {
        String string = "";
        if (this.opicmKeyUpdated) {
            string = "INSERT INTO OPICM.PRIMARYLINK ( KEY, PRODUCTIND, DESCRIPT ) " + "VALUES ( " + " '" + this.opicmKey + "', " + "  " + this.getProductInd() + ", " + " '" + Text.cleanDBString(this.opicmDescript) + "')" + SqlRunner.END_DELIM;
        }
        return string;
    }

    private final String opicmDescriptToSQL() {
        String string = "";
        if (this.opicmKey != null && this.opicmKey.length() > 0) {
            string = "UPDATE OPICM.PRIMARYLINK " + "SET DESCRIPT = '" + Text.cleanDBString(this.opicmDescript) + "', " + "    KEY      = '" + this.opicmKey + "' " + "WHERE PRODUCTIND = " + this.getProductInd() + SqlRunner.END_DELIM;
        }
        return string;
    }

    public void setDraftCreatedBy(String string) {
        this.draftCreatedBy = string;
    }

    public String getDraftCreatedBy() {
        return this.draftCreatedBy;
    }

    public void setDraftCreatedOn(String string) {
        this.draftCreatedOn = string;
    }

    public String getDraftCreatedOn() {
        return this.draftCreatedOn;
    }

    public ProductDraft() {
        this.workRequired = 1;
    }

    public ProductDraft(int n) {
        super(n);
    }

    public ProductDraft(ProductDraft productDraft) {
        this.initializeProperties(productDraft);
        this.existingProductInd = 0;
        this.template = false;
        this.setProductInd(0);
        this.updateRecStatus(0);
        this.updateRecStatus(2);
        this.setCreatedOn(new CDate(2).today());
    }
}

