/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.XRef;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.util.CDate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ProductDraftReader
extends StoredProc {
    private StoredProcRec returnRec = new StoredProcRec();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readProduct(int n, Blob blob, Blob blob2) throws Exception {
        Connection connection = this.getConnection();
        try {
            ProductDraft productDraft = new ProductDraft(n);
            int n2 = 0;
            n2 = ProductDraftReader.readFromDatabase(connection, productDraft);
            blob = Lob.newBlob();
            StoredProcUtil.setObjectInBlob(blob, productDraft);
            this.set(2, blob);
            this.returnRec.sqlCode = n2;
            this.returnRec.errorStr = "ProductDraftReader Returned rc:" + n2;
            this.returnRec.error = n2 != 0;
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
        }
        connection.commit();
        connection.close();
        blob2 = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob2, this.returnRec);
        this.set(3, blob2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int readFromDatabase(Connection connection, ProductDraft productDraft) throws Exception {
        int n = 0;
        try {
            n = ProductDraftReader.readBaseInfo(connection, productDraft);
            if (n != 0) return n;
            if (!ProductDraftReader.readDates(connection, productDraft)) {
                return -2;
            }
            if (!ProductDraftReader.readCrossProduct(connection, productDraft)) {
                return -3;
            }
            if (!ProductDraftReader.readLocale(connection, productDraft)) {
                return -5;
            }
            if (!ProductDraftReader.readOriginalProductInd(connection, productDraft)) {
                return -7;
            }
            if (!ProductDraftReader.readOPICMInfo(connection, productDraft)) {
                return -6;
            }
            if (!ProductDraftReader.readCategories(connection, productDraft)) return -4;
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static int readBaseInfo(Connection connection, ProductDraft productDraft) throws Exception {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT DESCRIPTION,        BASEMODEL,       TYPECUSTOMERIND, " + "       TYPEPRODUCTIND,     TYPEOFFERINGIND, TYPEWARRANTYIND, INPUT, " + "       SOURCE,             PUBLISH,         CHECKEDOUTBY,    CREATEDON, " + "       CREATEDBY,          LASTTOUCHEDON,   LASTTOUCHEDBY,   COMMENTS, " + "       STARTDATE,          STOPDATE,        WORKIND,         TYPECANCELIND,  " + "       EXISTINGPRODUCTIND, IMPORTOPICM " + "FROM PRODRAFT.PRODUCT " + "WHERE PRODUCTIND = " + productDraft.getProductInd() + " FOR FETCH ONLY");
        if (resultSet.next()) {
            productDraft.setDescription(resultSet.getString(1).trim());
            productDraft.setBaseModel(resultSet.getString(2));
            productDraft.setCustomer(resultSet.getInt(3));
            productDraft.setProductType(resultSet.getInt(4));
            productDraft.setOffering(resultSet.getInt(5));
            productDraft.setWarranty(resultSet.getInt(6));
            productDraft.setInput(resultSet.getString(7).trim());
            productDraft.setSource(resultSet.getString(8).trim());
            productDraft.setPublish(resultSet.getString(9));
            productDraft.setCheckedOutBy(resultSet.getString(10));
            productDraft.setDraftCreatedOn(resultSet.getString(11).trim());
            productDraft.setDraftCreatedBy(resultSet.getString(12).trim());
            productDraft.setLastTouchedOn(resultSet.getString(13).trim());
            productDraft.setLastTouchedBy(resultSet.getString(14).trim());
            productDraft.setOriginalComments(resultSet.getString(15));
            productDraft.setStartDate(resultSet.getString(16).trim());
            productDraft.setStopDate(resultSet.getString(17));
            productDraft.setWorkRequired(resultSet.getInt(18));
            productDraft.setTypeCancelInd(resultSet.getInt(19));
            productDraft.setExistingProductInd(resultSet.getInt(20));
            if (resultSet.getString(21) != null) {
                productDraft.setOPICMImport(resultSet.getString(21).equals("Y"));
            }
        } else {
            n = 100;
        }
        resultSet.close();
        statement.close();
        if (productDraft.getExistingProductInd() != 0) {
            ProductDraftReader.readActiveCreation(connection, productDraft);
        }
        if (productDraft.getCreatedBy() == null) {
            productDraft.setCreatedBy(productDraft.getDraftCreatedBy());
        }
        if (productDraft.getCreatedOn() == null) {
            productDraft.setCreatedOn(productDraft.getDraftCreatedOn());
        }
        return n;
    }

    public static boolean readDates(Connection connection, ProductDraft productDraft) throws Exception {
        Statement statement = connection.createStatement();
        Vector<ProductDate> vector = new Vector<ProductDate>(1);
        ResultSet resultSet = statement.executeQuery("SELECT TYPEDATEIND, COUNTRYCODEIND, ACTUAL, TARGET " + "FROM   PRODRAFT.DATES " + "WHERE PRODUCTIND = " + productDraft.getProductInd() + " FOR FETCH ONLY");
        while (resultSet.next()) {
            String string = resultSet.getString(3);
            String string2 = resultSet.getString(4);
            if (string != null) {
                string = CDate.createDate(CDate.parse(string, 7, 10), CDate.parse(string, 8, 10), CDate.parse(string, 9, 10), 0, 0, 0, 2);
            }
            if (string2 != null) {
                string2 = CDate.createDate(CDate.parse(string2, 7, 10), CDate.parse(string2, 8, 10), CDate.parse(string2, 9, 10), 0, 0, 0, 2);
            }
            vector.addElement(new ProductDate(productDraft.getProductInd(), string, string2, resultSet.getInt(1), resultSet.getInt(2)));
        }
        productDraft.setDates(vector);
        resultSet.close();
        statement.close();
        return true;
    }

    public static boolean readCrossProduct(Connection connection, ProductDraft productDraft) throws Exception {
        Statement statement = connection.createStatement();
        Vector<XRef> vector = new Vector<XRef>(1);
        ResultSet resultSet = statement.executeQuery("SELECT TYPEXREFIND, NUMBER " + "FROM   PRODRAFT.XREF " + "WHERE PRODUCTIND = " + productDraft.getProductInd() + " FOR FETCH ONLY");
        while (resultSet.next()) {
            vector.addElement(new XRef(productDraft.getProductInd(), resultSet.getInt(1), resultSet.getString(2).trim()));
        }
        productDraft.setXRef(vector);
        resultSet.close();
        statement.close();
        return true;
    }

    public static boolean readLocale(Connection connection, ProductDraft productDraft) throws Exception {
        LocaleRec localeRec = new LocaleRec(connection);
        Statement statement = connection.createStatement();
        boolean bl = false;
        ResultSet resultSet = null;
        boolean bl2 = true;
        resultSet = statement.executeQuery("SELECT A.GEOIND, B.DESCRIPT " + "FROM PRODRAFT.GEO A, " + "     TIGRIS.TYPEGEOGRAPHY B " + "WHERE PRODUCTIND = " + productDraft.getProductInd() + " AND " + "      A.GEOIND = B.GEOIND " + "FOR FETCH ONLY");
        while (bl2 && resultSet.next()) {
            if (resultSet.getInt(1) == 6) {
                localeRec.setWorldWide(true);
                bl2 = false;
                continue;
            }
            localeRec.addGeography(new TypeGeoRec(resultSet.getInt(1), resultSet.getString(2).trim()));
        }
        resultSet.close();
        if (bl2) {
            resultSet = statement.executeQuery("SELECT A.COUNTRYCODEIND, B.PHONECOUNTRYCODE, B.DESCRIPT,     B.ZIPMASK,   " + "       B.PHONEMASK,      B.ZIPDIGITS,        B.TIMEDIFF,     B.MULTIZONE, " + "       B.USESDST,        B.CURRENCY,         B.CURRENCYMASK, B.LANG01,    " + "       B.LANG02,         B.LANG03,           C.GEOIND,       B.ISOCODE    " + "FROM PRODRAFT.COUNTRY  A,                                                 " + "     TIGRIS.TYPECOUNTRYCODE B,                                            " + "     TIGRIS.GEOCOUNTRY C                                                  " + "WHERE PRODUCTIND = " + productDraft.getProductInd() + "  AND                       " + "      A.COUNTRYCODEIND = B.COUNTRYCODEIND AND                             " + "      A.COUNTRYCODEIND = C.COUNTRYCODEIND                                 " + "FOR FETCH ONLY");
        }
        while (bl2 && resultSet.next()) {
            localeRec.addCountry(new TypeCountryCodeRec(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3).trim(), resultSet.getString(4), resultSet.getString(5), (short)resultSet.getInt(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), (short)resultSet.getInt(12), (short)resultSet.getInt(13), (short)resultSet.getInt(14), (short)resultSet.getInt(15), resultSet.getString(16)));
        }
        resultSet.close();
        statement.close();
        bl = true;
        productDraft.setLocale(localeRec);
        return bl;
    }

    public static boolean readCategories(Connection connection, ProductDraft productDraft) throws Exception {
        Statement statement = connection.createStatement();
        TypeCategoryRec typeCategoryRec = null;
        ResultSet resultSet = statement.executeQuery("SELECT TYPECATEGORY.TYPECATIND, TYPECATEGORY.DESCRIPTION, " + "       TYPECATEGORY.PARENTCATIND, TYPECATEGORY.CATEGORYLEVEL, " + "       TYPECATEGORY.ORDERNUM,     TYPECATEGORY.CHILDSORT, " + "       TYPECATEGORY.OWNER " + "FROM PRODRAFT.TYPECATEGORY TYPECATEGORY, " + "     PRODRAFT.CATEGORY     CATEGORY " + "WHERE CATEGORY.PRODUCTIND = " + productDraft.getProductInd() + " AND " + "      TYPECATEGORY.TYPECATIND = CATEGORY.TYPECATIND " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            Vector vector;
            typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
            typeCategoryRec.setOrderNum(resultSet.getInt(5));
            typeCategoryRec.setChildSort(resultSet.getString(6).trim());
            typeCategoryRec.setOwner(resultSet.getString(7));
            typeCategoryRec.setIsDraft(true);
            typeCategoryRec.updateRecStatus(0);
            if (typeCategoryRec.getCategoryLevel().equals("brand")) {
                productDraft.setBrand(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("family")) {
                productDraft.setFamily(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("machine")) {
                productDraft.setMachine(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("model")) {
                productDraft.setModel(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("project")) {
                productDraft.setProject(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("subcategory")) {
                productDraft.setSubCategory(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("partnum")) {
                productDraft.setPartNumber(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("opicmgeo")) {
                vector = productDraft.getOPICMGeographies();
                if (vector == null) {
                    vector = new Vector(1);
                }
                if (!vector.contains(typeCategoryRec)) {
                    vector.addElement(typeCategoryRec);
                }
                productDraft.setOPICMGeographies(vector);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("opicmcountry")) {
                vector = productDraft.getOPICMCountries();
                if (vector == null) {
                    vector = new Vector(1);
                }
                if (!vector.contains(typeCategoryRec)) {
                    vector.addElement(typeCategoryRec);
                }
                productDraft.setOPICMCountries(vector);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("opicmbrand")) {
                productDraft.setOPICMBrand(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("opicmfamily")) {
                productDraft.setOPICMFamily(typeCategoryRec);
                continue;
            }
            if (!typeCategoryRec.getCategoryLevel().equals("opicmseries")) continue;
            productDraft.setOPICMSeries(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        return true;
    }

    public static boolean readOPICMInfo(Connection connection, ProductDraft productDraft) throws Exception {
        if (productDraft.getOriginalProductInd() != 0) {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DESCRIPT, KEY " + "FROM OPICM.PRIMARYLINK " + "WHERE PRODUCTIND = " + productDraft.getOriginalProductInd() + " FOR FETCH ONLY");
            if (resultSet.next()) {
                productDraft.setOPICMDescript(resultSet.getString(1).trim());
                productDraft.setOPICMKey(resultSet.getString(2).trim());
                productDraft.opicmKeyUpdated = false;
            }
            resultSet.close();
            statement.close();
        }
        return true;
    }

    public static boolean readOriginalProductInd(Connection connection, ProductDraft productDraft) throws Exception {
        if (productDraft.getExistingProductInd() != 0) {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND FROM " + "PRODRAFT.PRODUCT " + "WHERE EXISTINGPRODUCTIND = " + productDraft.getExistingProductInd() + " " + "ORDER BY LASTTOUCHEDBY FOR FETCH ONLY");
            if (resultSet.next()) {
                productDraft.setOriginalProductInd(resultSet.getInt(1));
            }
            resultSet.close();
            statement.close();
        } else {
            productDraft.setOriginalProductInd(productDraft.getProductInd());
        }
        return true;
    }

    public static boolean readActiveCreation(Connection connection, ProductDraft productDraft) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CREATEDON, CREATEDBY FROM " + "PRODUCT.PRODUCT " + "WHERE PRODUCTIND = " + productDraft.getExistingProductInd() + " " + "FOR FETCH ONLY");
        if (resultSet.next()) {
            productDraft.setCreatedOn(resultSet.getString(1));
            productDraft.setCreatedBy(resultSet.getString(2));
        }
        resultSet.close();
        statement.close();
        return true;
    }
}

