/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductComment;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.product.XRef;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.util.CDate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ProductReader
extends StoredProc {
    private StoredProcRec returnRec = new StoredProcRec();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readProduct(int n, Blob blob, Blob blob2) throws Exception {
        Connection connection = this.getConnection();
        try {
            Product product = new Product(n);
            int n2 = 0;
            n2 = ProductReader.readFromDatabase(connection, product);
            blob = Lob.newBlob();
            StoredProcUtil.setObjectInBlob(blob, product);
            this.set(2, blob);
            this.returnRec.sqlCode = n2;
            this.returnRec.errorStr = "ProductReader Returned rc:" + n2;
            this.returnRec.error = n2 != 0;
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
        }
        connection.commit();
        connection.close();
        blob2 = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob2, this.returnRec);
        this.set(3, blob2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int readFromDatabase(Connection connection, Product product) throws Exception {
        int n = 0;
        try {
            n = ProductReader.readBaseInfo(connection, product);
            if (n != 0) return n;
            if (!ProductReader.readDates(connection, product)) {
                return -2;
            }
            if (!ProductReader.readCrossProduct(connection, product)) {
                return -3;
            }
            if (!ProductReader.readLocale(connection, product)) {
                return -5;
            }
            if (!ProductReader.readCategories(connection, product)) {
                return -4;
            }
            if (ProductReader.readCommentHistory(connection, product) != 0) return -6;
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static int readBaseInfo(Connection connection, Product product) throws Exception {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT DESCRIPTION,    BASEMODEL,       TYPECUSTOMERIND, " + "       TYPEPRODUCTIND, TYPEOFFERINGIND, TYPEWARRANTYIND, INPUT, " + "       SOURCE,         PUBLISH,         CHECKEDOUTBY,    CREATEDON, " + "       CREATEDBY,      LASTTOUCHEDON,   LASTTOUCHEDBY,   IMPORTOPICM " + "FROM PRODUCT.PRODUCT " + "WHERE PRODUCTIND = " + product.getProductInd() + " FOR FETCH ONLY");
        if (resultSet.next()) {
            product.setDescription(resultSet.getString(1).trim());
            product.setBaseModel(resultSet.getString(2));
            product.setCustomer(resultSet.getInt(3));
            product.setProductType(resultSet.getInt(4));
            product.setOffering(resultSet.getInt(5));
            product.setWarranty(resultSet.getInt(6));
            product.setInput(resultSet.getString(7).trim());
            product.setSource(resultSet.getString(8).trim());
            product.setPublish(resultSet.getString(9));
            product.setCheckedOutBy(resultSet.getString(10));
            product.setCreatedOn(resultSet.getString(11).trim());
            product.setCreatedBy(resultSet.getString(12).trim());
            product.setLastTouchedOn(resultSet.getString(13).trim());
            product.setLastTouchedBy(resultSet.getString(14).trim());
            if (resultSet.getString(15) != null) {
                product.setOPICMImport(resultSet.getString(15).equals("Y"));
            }
        } else {
            n = 100;
        }
        resultSet.close();
        statement.close();
        return n;
    }

    public static boolean readDates(Connection connection, Product product) throws Exception {
        Statement statement = connection.createStatement();
        Vector<ProductDate> vector = new Vector<ProductDate>(1);
        ResultSet resultSet = statement.executeQuery("SELECT TYPEDATEIND, COUNTRYCODEIND, ACTUAL, TARGET " + "FROM   PRODUCT.DATES " + "WHERE PRODUCTIND = " + product.getProductInd() + " FOR FETCH ONLY");
        while (resultSet.next()) {
            String string = resultSet.getString(3);
            String string2 = resultSet.getString(4);
            if (string != null) {
                string = CDate.createDate(CDate.parse(string, 7, 10), CDate.parse(string, 8, 10), CDate.parse(string, 9, 10), 0, 0, 0, 2);
            }
            if (string2 != null) {
                string2 = CDate.createDate(CDate.parse(string2, 7, 10), CDate.parse(string2, 8, 10), CDate.parse(string2, 9, 10), 0, 0, 0, 2);
            }
            vector.addElement(new ProductDate(product.getProductInd(), string, string2, resultSet.getInt(1), resultSet.getInt(2)));
        }
        product.setDates(vector);
        resultSet.close();
        statement.close();
        return true;
    }

    public static boolean readCrossProduct(Connection connection, Product product) throws Exception {
        Statement statement = connection.createStatement();
        Vector<XRef> vector = new Vector<XRef>(1);
        ResultSet resultSet = statement.executeQuery("SELECT TYPEXREFIND, NUMBER " + "FROM   PRODUCT.XREF " + "WHERE PRODUCTIND = " + product.getProductInd() + " FOR FETCH ONLY");
        while (resultSet.next()) {
            vector.addElement(new XRef(product.getProductInd(), resultSet.getInt(1), resultSet.getString(2).trim()));
        }
        product.setXRef(vector);
        resultSet.close();
        statement.close();
        return true;
    }

    public static boolean readLocale(Connection connection, Product product) throws Exception {
        LocaleRec localeRec = new LocaleRec(connection);
        Statement statement = connection.createStatement();
        boolean bl = false;
        ResultSet resultSet = null;
        boolean bl2 = true;
        resultSet = statement.executeQuery("SELECT A.GEOIND, B.DESCRIPT " + "FROM PRODUCT.GEO A, " + "     TIGRIS.TYPEGEOGRAPHY B " + "WHERE PRODUCTIND = " + product.getProductInd() + " AND " + "      A.GEOIND = B.GEOIND " + "FOR FETCH ONLY");
        while (bl2 && resultSet.next()) {
            if (resultSet.getInt(1) == 6) {
                bl2 = false;
                localeRec.setWorldWide(true);
                continue;
            }
            localeRec.addGeography(new TypeGeoRec(resultSet.getInt(1), resultSet.getString(2).trim()));
        }
        resultSet.close();
        if (bl2) {
            resultSet = statement.executeQuery("SELECT A.COUNTRYCODEIND, B.PHONECOUNTRYCODE, B.DESCRIPT,     B.ZIPMASK,   " + "       B.PHONEMASK,      B.ZIPDIGITS,        B.TIMEDIFF,     B.MULTIZONE, " + "       B.USESDST,        B.CURRENCY,         B.CURRENCYMASK, B.LANG01,    " + "       B.LANG02,         B.LANG03,           C.GEOIND                     " + "FROM PRODUCT.COUNTRY A,                                                   " + "     TIGRIS.TYPECOUNTRYCODE B,                                            " + "     TIGRIS.GEOCOUNTRY C                                                  " + "WHERE PRODUCTIND = " + product.getProductInd() + "  AND                       " + "      A.COUNTRYCODEIND = B.COUNTRYCODEIND AND                             " + "      A.COUNTRYCODEIND = C.COUNTRYCODEIND                                 " + "FOR FETCH ONLY");
        }
        while (bl2 && resultSet.next()) {
            localeRec.addCountry(new TypeCountryCodeRec(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3).trim(), resultSet.getString(4), resultSet.getString(5), (short)resultSet.getInt(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), (short)resultSet.getInt(12), (short)resultSet.getInt(13), (short)resultSet.getInt(14), (short)resultSet.getInt(15), ""));
        }
        resultSet.close();
        statement.close();
        bl = true;
        product.setLocale(localeRec);
        return bl;
    }

    public static boolean readCategories(Connection connection, Product product) throws Exception {
        Statement statement = connection.createStatement();
        TypeCategoryRec typeCategoryRec = null;
        ResultSet resultSet = statement.executeQuery("SELECT TYPECATEGORY.TYPECATIND, TYPECATEGORY.DESCRIPTION, " + "       TYPECATEGORY.PARENTCATIND, TYPECATEGORY.CATEGORYLEVEL, " + "       TYPECATEGORY.ORDERNUM,     TYPECATEGORY.CHILDSORT, " + "       TYPECATEGORY.OWNER " + "FROM PRODUCT.TYPECATEGORY TYPECATEGORY, " + "     PRODUCT.CATEGORY     CATEGORY " + "WHERE CATEGORY.PRODUCTIND = " + product.getProductInd() + " AND " + "      TYPECATEGORY.TYPECATIND = CATEGORY.TYPECATIND " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
            typeCategoryRec.setOrderNum(resultSet.getInt(5));
            typeCategoryRec.setChildSort(resultSet.getString(6).trim());
            typeCategoryRec.setOwner(resultSet.getString(7));
            typeCategoryRec.updateRecStatus(0);
            if (typeCategoryRec.getCategoryLevel().equals("brand")) {
                product.setBrand(typeCategoryRec);
            } else if (typeCategoryRec.getCategoryLevel().equals("family")) {
                product.setFamily(typeCategoryRec);
            } else if (typeCategoryRec.getCategoryLevel().equals("machine")) {
                product.setMachine(typeCategoryRec);
            } else if (typeCategoryRec.getCategoryLevel().equals("model")) {
                product.setModel(typeCategoryRec);
            }
            if (typeCategoryRec.getCategoryLevel().equals("project")) {
                product.setProject(typeCategoryRec);
            }
            if (typeCategoryRec.getCategoryLevel().equals("subcategory")) {
                product.setSubCategory(typeCategoryRec);
            }
            if (!typeCategoryRec.getCategoryLevel().equals("partnum")) continue;
            product.setPartNumber(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        return true;
    }

    public static int readCommentHistory(Connection connection, Product product) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        string = "SELECT PRODUCTIND, COMMENTS, LASTTOUCHEDON, LASTTOUCHEDBY " + "FROM PRODRAFT.PRODUCT " + "WHERE  EXISTINGPRODUCTIND = " + product.getProductInd() + " AND " + "       STOPDATE IS NOT NULL AND " + "       RECYCLED = 'N' AND " + "       TEMPLATE = 'N' " + "ORDER BY STOPDATE DESC FETCH FIRST 5 ROWS ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            if (resultSet.getString(2) != null) {
                product.addCommentToHistory(new ProductComment(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim()));
                continue;
            }
            product.addCommentToHistory(new ProductComment(resultSet.getInt(1), "N/A", resultSet.getString(3).trim(), resultSet.getString(4).trim()));
        }
        resultSet.close();
        statement.close();
        return 0;
    }
}

