/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.Text;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

public class ProductRow
implements Serializable,
ExtendedMultiListRow,
MultiListRow,
MultiListSort {
    static final long serialVersionUID = 1000000L;
    public static final int COL_LOCKED = 1;
    public static final int COL_PRODNUM = 2;
    public static final int COL_DESCRIPTION = 3;
    public static final int COL_ANNOUNCEDATE = 4;
    public static final int COL_CREATEDATE = 5;
    public static final int COL_LASTTOUCHEDBY = 6;
    public static final int COL_LASTTOUCHEDON = 7;
    public static final int COL_WORKREQUIRED = 8;
    public static final int COL_PROJECT = 9;
    public static final int MAX_COLUMNS = 10;
    private String description = null;
    private String[] descriptionArray = null;
    private String[] projectArray = null;
    private String[] lastTouchedOnArray = null;
    private String[] createdOnArray = null;
    private String[] lastTouchedByArray = null;
    private String[] workRequiredArray = null;
    private String[] announceDateArray = null;
    private int existingProductInd = 0;
    private int productInd = 0;
    private String prodNum = null;
    private Image image = null;
    private String originalLastTouchedBy = null;
    private String lastTouchedOn = null;
    private String createdOn = null;
    private String createdBy = null;
    private String actualDate = null;
    private String targetDate = null;
    private String lastTouchedBy = null;
    private String workRequired = null;
    private TypeCategoryRec model = null;
    private int[] columnOrder = null;
    private boolean draft = false;
    private String project = null;
    private Product product = null;

    public Object getColumnData(int n) {
        return this.getData(n, this.columnOrder[n]);
    }

    private final Object getData(int n, int n2) {
        switch (n2) {
            case 1: {
                return this.image;
            }
            case 9: {
                if (this.projectArray == null) {
                    this.columnSized(n, 500);
                }
                return this.projectArray;
            }
            case 2: {
                return this.prodNum;
            }
            case 3: {
                if (this.descriptionArray == null) {
                    this.columnSized(n, 500);
                }
                return this.descriptionArray;
            }
            case 8: {
                if (this.workRequiredArray == null) {
                    this.columnSized(n, 500);
                }
                return this.workRequiredArray;
            }
            case 4: {
                if (this.announceDateArray == null) {
                    this.columnSized(n, 500);
                }
                return this.announceDateArray;
            }
            case 5: {
                if (this.createdOnArray == null) {
                    this.columnSized(n, 500);
                }
                return this.createdOnArray;
            }
            case 6: {
                if (this.lastTouchedByArray == null) {
                    this.columnSized(n, 500);
                }
                return this.lastTouchedByArray;
            }
            case 7: {
                if (this.lastTouchedOnArray == null) {
                    this.columnSized(n, 500);
                }
                return this.lastTouchedOnArray;
            }
        }
        return "";
    }

    public String getLastTouchedBy() {
        return this.lastTouchedBy;
    }

    public void setLastTouchedBy(String string) {
        if (this.originalLastTouchedBy == null) {
            this.originalLastTouchedBy = this.lastTouchedBy;
        }
        this.lastTouchedBy = string;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void adjustColumnGraphics(int n, Graphics graphics) {
        if (this.columnOrder[n] == 4) {
            boolean bl = false;
            if (this.actualDate == null || this.actualDate.length() == 0) {
                bl = true;
            }
            if (bl && this.targetDate != null) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.black);
            }
        } else {
            graphics.setColor(Color.black);
        }
    }

    public int getExistingProductInd() {
        return new Integer(this.existingProductInd);
    }

    public int getProductInd() {
        return new Integer(this.productInd);
    }

    public String getDescription() {
        return this.description;
    }

    public int readProduct(boolean bl) {
        int n = 0;
        if (bl) {
            this.product = null;
        }
        if (this.product == null) {
            this.product = this.isDraft() ? new ProductDraft(this.productInd) : new Product(this.productInd);
            n = this.product.readFromDatabase();
        }
        return n;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProdNum(String string) {
        this.prodNum = string;
        if (this.prodNum != null) {
            this.prodNum = this.prodNum.trim();
        }
    }

    public String toString() {
        return "(" + this.prodNum + ") " + this.description;
    }

    public void columnSized(int n, int n2) {
        if (this.columnOrder[n] == 3) {
            this.descriptionArray = Text.formatStringLines(this.description, n2 / 6);
        } else if (this.columnOrder[n] == 9) {
            this.projectArray = Text.formatStringLines(this.project, n2 / 6);
        } else if (this.columnOrder[n] == 8) {
            this.workRequiredArray = Text.formatStringLines(this.workRequired, n2 / 6);
        } else if (this.columnOrder[n] == 7) {
            this.lastTouchedOnArray = Text.formatStringLines(this.lastTouchedOn, n2 / 6);
        } else if (this.columnOrder[n] == 6) {
            this.lastTouchedByArray = Text.formatStringLines(this.lastTouchedBy, n2 / 6);
        } else if (this.columnOrder[n] == 5) {
            this.createdOnArray = Text.formatStringLines(this.createdOn, n2 / 6);
        } else if (this.columnOrder[n] == 4) {
            String string = this.actualDate != null && this.actualDate.length() > 0 ? this.actualDate : this.targetDate;
            this.announceDateArray = Text.formatStringLines(string, n2 / 6);
        }
    }

    public TypeCategoryRec getModel() {
        return this.model;
    }

    public void setModel(TypeCategoryRec typeCategoryRec) {
        this.model = typeCategoryRec;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        if (multiListSort instanceof ProductRow) {
            ProductRow productRow = (ProductRow)multiListSort;
            switch (this.columnOrder[n]) {
                case 1: {
                    if (this.image != null && productRow.image == null) {
                        return 1;
                    }
                    if (this.image == null && productRow.image != null) {
                        return -1;
                    }
                    return 0;
                }
                case 2: {
                    if (this.prodNum == null || this.prodNum.length() == 0) {
                        return -1;
                    }
                    if (productRow.prodNum == null || productRow.prodNum.length() == 0) {
                        return 1;
                    }
                    return this.prodNum.compareTo(productRow.prodNum);
                }
                case 3: {
                    if (this.description == null || this.description.length() == 0) {
                        return -1;
                    }
                    if (productRow.description == null || productRow.description.length() == 0) {
                        return 1;
                    }
                    return this.description.compareTo(productRow.description);
                }
                case 4: {
                    if (this.actualDate == null || this.actualDate.length() == 0) {
                        return -1;
                    }
                    if (productRow.actualDate == null || productRow.actualDate.length() == 0) {
                        return 1;
                    }
                    return CDate.compareDate(this.actualDate, productRow.actualDate, 13);
                }
                case 5: {
                    if (this.createdOn == null || this.createdOn.length() == 0) {
                        return -1;
                    }
                    if (productRow.createdOn == null || productRow.createdOn.length() == 0) {
                        return 1;
                    }
                    return CDate.compareDate(this.createdOn, productRow.createdOn, 13);
                }
                case 6: {
                    if (this.lastTouchedBy == null || this.lastTouchedBy.length() == 0) {
                        return -1;
                    }
                    if (productRow.lastTouchedBy == null || productRow.lastTouchedBy.length() == 0) {
                        return 1;
                    }
                    return this.lastTouchedBy.compareTo(productRow.lastTouchedBy);
                }
                case 9: {
                    if (this.project == null || this.project.length() == 0) {
                        return -1;
                    }
                    if (productRow.project == null || productRow.project.length() == 0) {
                        return 1;
                    }
                    return this.project.compareTo(productRow.project);
                }
                case 8: {
                    if (this.workRequired == null || this.workRequired.length() == 0) {
                        return -1;
                    }
                    if (productRow.workRequired == null || productRow.workRequired.length() == 0) {
                        return 1;
                    }
                    return this.workRequired.compareTo(productRow.workRequired);
                }
                case 7: {
                    if (this.lastTouchedOn == null || this.lastTouchedOn.length() == 0) {
                        return -1;
                    }
                    if (productRow.lastTouchedOn == null || productRow.lastTouchedOn.length() == 0) {
                        return 1;
                    }
                    return CDate.compareDate(this.lastTouchedOn, productRow.lastTouchedOn, 14);
                }
            }
        }
        return 0;
    }

    public void setActualDate(String string) {
        this.actualDate = string;
    }

    public String getActualDate() {
        return this.actualDate;
    }

    public void setTargetDate(String string) {
        this.targetDate = string;
    }

    public String getTargetDate() {
        return this.targetDate;
    }

    public void setWorkRequired(String string) {
        this.workRequired = string;
    }

    public String getWorkRequired() {
        return this.workRequired;
    }

    public void setProject(String string) {
        this.project = string;
    }

    public String getProject() {
        return this.project;
    }

    public void setColumnOrderData(int n, int n2) {
        this.columnOrder[n] = n2;
    }

    public String getProductNumber() {
        return this.prodNum;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ProductRow(ProductDraft productDraft) {
        this(productDraft.getProductInd(), productDraft.getExistingProductInd(), productDraft.getProdNum() != null ? productDraft.getProdNum() : productDraft.getPartNumber().toString(), productDraft.getDescription(), productDraft.getCreatedOn(), productDraft.getCreatedBy(), "", "", productDraft.getLastTouchedBy(), productDraft.getLastTouchedOn(), true);
        this.product = productDraft;
    }

    public ProductRow(int n) {
        this.productInd = n;
        this.existingProductInd = n;
    }

    public ProductRow(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this.productInd = n;
        this.existingProductInd = n2;
        this.description = string2;
        this.createdOn = string3;
        this.createdBy = string4;
        this.actualDate = string5;
        this.targetDate = string6;
        this.lastTouchedBy = string7;
        this.lastTouchedOn = string8;
        this.draft = bl;
        this.prodNum = string;
        if (string != null) {
            string = string.trim();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        this.columnOrder = new int[10];
        this.setColumnOrderData(0, 1);
        this.setColumnOrderData(1, 2);
        this.setColumnOrderData(2, 3);
        this.setColumnOrderData(3, 4);
        this.setColumnOrderData(4, 5);
        this.setColumnOrderData(5, 6);
        this.setColumnOrderData(6, 7);
        this.setColumnOrderData(7, 8);
        this.setColumnOrderData(8, 9);
        this.columnSized(1, 500);
    }
}

