/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.type;

import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.Text;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class TypeGeoRec
extends TypeRec {
    private Vector countryVec = null;
    private boolean enhanceOutput = false;

    public Vector getCountryVec() {
        if (this.countryVec == null) {
            Vector vector = TypeList.getInstance().getTypeList(3);
            int n = 0;
            int n2 = 0;
            this.countryVec = new Vector(10);
            if (vector != null) {
                n2 = vector.size();
                while (n < n2) {
                    if (((TypeCountryCodeRec)vector.elementAt(n)).getGeoInd() == this.getInd()) {
                        this.countryVec.addElement(vector.elementAt(n));
                    }
                    ++n;
                }
            }
        }
        return this.countryVec;
    }

    public Vector getCountryVec(Connection connection) throws SQLException {
        if (this.countryVec == null) {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.COUNTRYCODEIND, A.DESCRIPT " + "FROM TIGRIS.TYPECOUNTRYCODE A, " + "     TIGRIS.GEOCOUNTRY B " + "WHERE B.GEOIND = " + this.getInd() + " AND " + "      A.COUNTRYCODEIND = B.COUNTRYCODEIND");
            this.countryVec = new Vector(10);
            while (resultSet.next()) {
                this.countryVec.addElement(new TypeCountryCodeRec(resultSet.getInt(1), resultSet.getString(2).trim()));
            }
            resultSet.close();
            statement.close();
        }
        return this.countryVec;
    }

    public void setEnhanceOutput(boolean bl) {
        this.enhanceOutput = bl;
    }

    public String toString() {
        if (this.enhanceOutput) {
            return super.toString() + " (All Countries)";
        }
        return super.toString();
    }

    public int writeToDatabase() {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "TypeGeoRec.writeToDatabase", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            switch (this.getRecStatus()) {
                case 1: {
                    statement.executeUpdate("UPDATE TIGRIS.TYPEGEOGRAPHY SET CHANGEDTIME = CURRENT TIMESTAMP, DESCRIPT = '" + Text.cleanDBString(this.toString()) + "' " + "WHERE GEOIND = " + this.getInd());
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return n;
    }

    public Object clone() {
        TypeGeoRec typeGeoRec = new TypeGeoRec(this.getInd(), this.getDescript());
        if (this.countryVec != null) {
            typeGeoRec.countryVec = (Vector)this.countryVec.clone();
        }
        typeGeoRec.enhanceOutput = this.enhanceOutput;
        return typeGeoRec;
    }

    public TypeGeoRec(int n, String string) {
        super(n, string);
    }
}

