/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.storedProc;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Clob;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StoredProcUtil {
    public static void setObjectInBlob(Blob blob, Object object) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(blob.getOutputStream());
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public static byte[] getObjectBytes(Object object) throws Exception {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            byte[] byArray2 = null;
            objectOutputStream.writeObject(object);
            byArray2 = byteArrayOutputStream.toByteArray();
            byArray = new byte[byArray2.length + 10];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray.length - 1] = 0;
            int n = 0;
            System.out.println("Returing:\n");
            while (n < byArray.length) {
                System.out.print(byArray[n]);
                ++n;
            }
            System.out.println(":end");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public static Object getObjectFromStatement(CallableStatement callableStatement, int n) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(callableStatement.getBytes(n));
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = null;
        object = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return object;
    }

    public static Object getObjectFromBlob(Blob blob) throws Exception {
        Object object = null;
        if (blob != null && blob.getInputStream() != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            InputStream inputStream = blob.getInputStream();
            ObjectInputStream objectInputStream = null;
            byte[] byArray = new byte[(int)blob.size()];
            boolean bl = false;
            inputStream.read(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
            throw new Exception("Read in " + byArray.length + " bytes. First two:" + byArray[0] + " " + byArray[1]);
        }
        return object;
    }

    public static void writeException(Throwable throwable, StoredProcRec storedProcRec) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Object var4_4 = null;
        String string = "";
        throwable.printStackTrace(printWriter);
        string = stringWriter.toString();
        if (string == null) {
            string = "No Stack Available";
        }
        storedProcRec.errorStr = string;
        storedProcRec.error = true;
        if (throwable instanceof SQLException) {
            storedProcRec.sqlCode = ((SQLException)throwable).getErrorCode();
        }
    }

    public static Object getObjectFromResultSet(ResultSet resultSet, int n) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(resultSet.getBytes(n));
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = null;
        object = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return object;
    }

    public static String getStringFromClob(Clob clob) throws Exception {
        Reader reader = clob.getReader();
        int n = 256;
        char[] cArray = new char[n];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1 && reader != null) {
            n2 = reader.read(cArray);
            if (n2 <= -1) continue;
            stringBuffer.append(new String(cArray).substring(0, n2));
        }
        return stringBuffer.toString();
    }
}

