/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.storedProc.extSqlRunner;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Clob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.BufferedReader;
import java.io.StreamTokenizer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class ExtSqlRunner
extends StoredProc {
    public static final String END_DELIM = new Character('\u0003').toString();
    private int sqlCode = 0;
    private Connection con = null;
    private String strClob = null;
    private String errorStr = null;
    private StoredProcRec returnRec = new StoredProcRec();
    private String lastSQL = "";
    private int statementsRun = 0;
    private int commitInterval = 0;

    public void runSQL(Clob clob, int n, Blob blob) throws Exception {
        Object var4_4 = null;
        this.con = this.getConnection();
        this.con.setAutoCommit(false);
        this.commitInterval = n;
        try {
            this.parseAndRunSQL(clob);
        }
        catch (SQLException sQLException) {
            StoredProcUtil.writeException(sQLException, this.returnRec);
            this.returnRec.errorStr = this.returnRec.errorStr + "\nLast SQL Run:" + this.lastSQL;
            this.returnRec.sqlCode = sQLException.getErrorCode();
            this.con.rollback();
        }
        catch (Throwable throwable) {
            StoredProcUtil.writeException(throwable, this.returnRec);
            this.returnRec.errorStr = this.returnRec.errorStr + "\nLast SQL Run:" + this.lastSQL;
            this.returnRec.sqlCode = this.sqlCode;
            this.con.rollback();
        }
        this.con.commit();
        this.con.close();
        blob = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob, this.returnRec);
        this.set(3, blob);
    }

    private void parseAndRunSQL(Clob clob) throws Exception {
        int n;
        boolean bl = false;
        int n2 = 255;
        char c = END_DELIM.charAt(0);
        BufferedReader bufferedReader = new BufferedReader(clob.getReader());
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        Statement statement = this.con.createStatement();
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(c, c);
        streamTokenizer.wordChars(0, c - '\u0001');
        streamTokenizer.wordChars(c + '\u0001', 255);
        int n3 = 0;
        while ((n = streamTokenizer.nextToken()) != -1) {
            ++n3;
            this.runSQL(streamTokenizer.sval, statement);
        }
        this.returnRec.userError = "ExtSqlRunner: processed " + n3 + " statements";
        bufferedReader.close();
        statement.close();
        this.con.commit();
    }

    private void runSQL(String string, Statement statement) throws Exception {
        this.lastSQL = string;
        statement.executeUpdate(string);
        ++this.statementsRun;
        if (this.statementsRun > this.commitInterval && this.commitInterval > 0) {
            this.con.commit();
            this.statementsRun = 0;
        }
    }

    public static int sqlRunnerCode(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(n, "sqlRunner", 5);
        int n2 = 0;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ExtSqlRunner", 3);
            String string2 = Text.replaceAllStrInStr(string, END_DELIM, "\n");
            LogSystem.log(1, "Starting to send statements to EXT SQLRUNNER");
            LogSystem.log(1, string2);
            callableStatement.registerOutParameter(1, -4);
            callableStatement.registerOutParameter(2, -4);
            callableStatement.registerOutParameter(3, -4);
            callableStatement.setBytes(1, string.getBytes());
            LogSystem.log(2, "Running SQLRunner:");
            LogSystem.log(2, Text.replaceAllStrInStr(string, END_DELIM, "\n    "));
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
                n2 = storedProcRec.sqlCode;
            }
            callableStatement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n2 = -1;
        }
        sQLMethod.close();
        return n2;
    }
}

