/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.storedProc.oaPublish;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ActionDraftReader;
import com.ibm.nzna.projects.common.quest.oa.ActionWriter;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.DraftObject;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkDraftReader;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraftReader;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupWriter;
import com.ibm.nzna.projects.common.quest.oa.LinkWriter;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraftReader;
import com.ibm.nzna.projects.common.quest.oa.QuestionWriter;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraftReader;
import com.ibm.nzna.projects.common.quest.oa.SymptomWriter;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.oaPublish.PublishException;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.util.Text;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class OAPublish
extends StoredProc {
    private static final boolean DEBUG = true;
    public static final int ACTION = 0;
    public static final int QUESTION = 1;
    public static final int SYMPTOM = 2;
    public static final int LINK = 3;
    public static final int LINKGROUP = 4;
    StoredProcRec returnRec = new StoredProcRec();

    public void publishOAObject(int n, int n2, Blob blob) throws Exception {
        Connection connection = null;
        boolean bl = false;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            switch (n2) {
                case 0: {
                    ActionDraft actionDraft = new ActionDraft(n);
                    if (!ActionDraftReader.readFromDB(connection, actionDraft, 0)) {
                        this.returnRec.error = true;
                        this.returnRec.errorStr = "Failed to read draft Action " + n + " from the database";
                        break;
                    }
                    this.checkPublishable(actionDraft);
                    String string = ActionWriter.getPublishSQL(connection, actionDraft);
                    this.runSQL(connection, string);
                    this.updateActionAddtlInfo(connection, actionDraft.getAdditionalInfo());
                    break;
                }
                case 1: {
                    QuestionDraft questionDraft = new QuestionDraft(n);
                    if (!QuestionDraftReader.readFromDB(connection, questionDraft, 0)) {
                        this.returnRec.error = true;
                        this.returnRec.errorStr = "Failed to read draft Question " + n + " from the database";
                        break;
                    }
                    this.checkPublishable(questionDraft);
                    String string = QuestionWriter.getPublishSQL(connection, questionDraft);
                    this.runSQL(connection, string);
                    this.updateQuestionAddtlInfo(connection, questionDraft.getAdditionalInfo());
                    break;
                }
                case 2: {
                    SymptomDraft symptomDraft = new SymptomDraft(n);
                    if (!SymptomDraftReader.readFromDB(connection, symptomDraft, 0)) {
                        this.returnRec.error = true;
                        this.returnRec.errorStr = "Failed to read draft Symptom " + n + " from the database";
                        break;
                    }
                    this.checkPublishable(symptomDraft);
                    String string = SymptomWriter.getPublishSQL(connection, symptomDraft);
                    this.runSQL(connection, string);
                    break;
                }
                case 3: {
                    LinkDraft linkDraft = LinkDraftReader.readFromDB(connection, n, 0);
                    if (linkDraft == null) {
                        this.returnRec.error = true;
                        this.returnRec.errorStr = "Failed to read draft Link " + n + " from the database";
                        break;
                    }
                    this.checkPublishable(linkDraft);
                    String string = LinkWriter.getPublishSQL(connection, linkDraft);
                    this.runSQL(connection, string);
                    break;
                }
                case 4: {
                    LinkGroupDraft linkGroupDraft = new LinkGroupDraft(n);
                    if (!LinkGroupDraftReader.readFromDB(connection, linkGroupDraft, 0)) {
                        this.returnRec.error = true;
                        this.returnRec.errorStr = "Failed to read draft LinkGroup " + n + " from the database";
                        break;
                    }
                    this.checkPublishable(linkGroupDraft);
                    String string = LinkGroupWriter.getPublishSQL(connection, linkGroupDraft);
                    this.runSQL(connection, string);
                    break;
                }
                default: {
                    this.returnRec.error = true;
                    this.returnRec.errorStr = "Invalid objectType " + n2;
                    break;
                }
            }
        }
        catch (PublishException publishException) {
        }
        catch (SQLException sQLException) {
            StoredProcUtil.writeException(sQLException, this.returnRec);
            this.returnRec.sqlCode = sQLException.getErrorCode();
            this.returnRec.error = true;
            connection.rollback();
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
            this.returnRec.error = true;
            connection.rollback();
        }
        catch (Error error) {
            StoredProcUtil.writeException(error, this.returnRec);
            this.returnRec.error = true;
            connection.rollback();
        }
        connection.commit();
        connection.close();
        blob = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob, this.returnRec);
        this.set(3, blob);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runSQL(Connection connection, String string) throws SQLException, PublishException {
        Object object = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
        this.returnRec.userError = ((String)object).length() > 65534 ? ((String)object).substring(1, 65534) : object;
        object = new StringTokenizer(string, SqlRunner.END_DELIM);
        Statement statement = null;
        String string2 = "";
        try {
            try {
                statement = connection.createStatement();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    statement.executeUpdate(string2);
                }
            }
            catch (SQLException sQLException) {
                StoredProcUtil.writeException(sQLException, this.returnRec);
                this.returnRec.errorStr = this.returnRec.errorStr + "===> Current SQL Statement: " + string2;
                this.returnRec.sqlCode = sQLException.getErrorCode();
                this.returnRec.error = true;
                connection.rollback();
                throw new PublishException();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (statement == null) return;
        statement.close();
        return;
    }

    private void updateActionAddtlInfo(Connection connection, Vector vector) throws SQLException, PublishException {
        this.updateAddtlInfo(connection, vector, "oa.actionAddInfo", "actionAddInfoInd");
    }

    private void updateQuestionAddtlInfo(Connection connection, Vector vector) throws SQLException, PublishException {
        this.updateAddtlInfo(connection, vector, "oa.questionAddInfo", "questionAddInfoInd");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateAddtlInfo(Connection connection, Vector vector, String string, String string2) throws SQLException, PublishException {
        boolean bl = true;
        Statement statement = null;
        try {
            try {
                if (vector != null && vector.size() > 0) {
                    statement = connection.prepareStatement("UPDATE " + string + " SET addInfo=?" + " WHERE " + string2 + "=?" + " AND languageInd=?");
                    int n = 0;
                    while (n < vector.size()) {
                        AddtlInfo addtlInfo = (AddtlInfo)vector.elementAt(n);
                        statement.setString(1, addtlInfo.getAddtlInfo());
                        statement.setInt(2, addtlInfo.getInd());
                        statement.setInt(3, addtlInfo.getLanguage().getInd());
                        statement.executeUpdate();
                        ++n;
                    }
                }
            }
            catch (SQLException sQLException) {
                bl = false;
                StoredProcUtil.writeException(sQLException, this.returnRec);
                this.returnRec.errorStr = this.returnRec.errorStr + "Failure while updating AddtlInfo objects";
                this.returnRec.sqlCode = sQLException.getErrorCode();
                this.returnRec.error = true;
                connection.rollback();
                throw new PublishException();
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            try {
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (statement == null) return;
        statement.close();
        return;
    }

    private void checkPublishable(DraftObject draftObject) throws PublishException {
        if (draftObject.getStopDate() != null) {
            this.returnRec.errorStr = "Draft was closed on " + draftObject.getStopDate();
            this.returnRec.error = true;
        } else if (draftObject.getMaintLock()) {
            this.returnRec.errorStr = "Maint lock is set";
            this.returnRec.error = true;
        } else if (draftObject.isRecycled()) {
            this.returnRec.errorStr = "Draft is recycled";
            this.returnRec.error = true;
        }
        if (this.returnRec.error) {
            throw new PublishException();
        }
    }
}

