/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.storedProc.sqlRunner;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Clob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class SqlRunner
extends StoredProc {
    public static final String END_DELIM = new Character('\u0003').toString();
    private int sqlCode = 0;
    private Connection con = null;
    private String strClob = null;
    private String errorStr = null;
    private StoredProcRec returnRec = new StoredProcRec();

    public void runSQL(Clob clob, Blob blob) throws Exception {
        String[] stringArray = null;
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        String string = "";
        try {
            if (this.getStringFromClob(clob)) {
                stringArray = this.parseSql();
                if (stringArray != null && stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        string = stringArray[n];
                        statement.executeUpdate(stringArray[n]);
                        ++n;
                    }
                }
            } else {
                this.sqlCode = -1;
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            StoredProcUtil.writeException(sQLException, this.returnRec);
            this.returnRec.errorStr = this.returnRec.errorStr + "\nLast SQL Run:" + string;
            this.returnRec.sqlCode = sQLException.getErrorCode();
            connection.rollback();
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
            this.returnRec.errorStr = this.returnRec.errorStr + "\nLast SQL Run:" + string;
            this.returnRec.sqlCode = this.sqlCode;
            connection.rollback();
        }
        connection.commit();
        connection.close();
        blob = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob, this.returnRec);
        this.set(2, blob);
    }

    private boolean getStringFromClob(Clob clob) throws Exception {
        Reader reader = clob.getReader();
        int n = 256;
        char[] cArray = new char[n];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1 && reader != null) {
            n2 = reader.read(cArray);
            if (n2 <= -1) continue;
            stringBuffer.append(new String(cArray).substring(0, n2));
        }
        if (stringBuffer.length() > 0) {
            this.strClob = stringBuffer.toString();
            return true;
        }
        return false;
    }

    private String[] parseSql() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.strClob, END_DELIM);
        String[] stringArray = null;
        int n = 0;
        if (stringTokenizer.countTokens() > 0) {
            stringArray = new String[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                stringArray[n] = SqlRunner.replaceInStr(stringArray[n], END_DELIM, "");
                ++n;
            }
        }
        return stringArray;
    }

    private static String replaceInStr(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n > -1) {
            return string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static int sqlRunnerCode(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(n, "sqlRunner", 5);
        int n2 = 0;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.sqlRunner", 2);
            String string2 = Text.replaceAllStrInStr(string, END_DELIM, "\n");
            LogSystem.log(1, "Starting to send statements to EXT SQLRUNNER");
            LogSystem.log(1, string2);
            callableStatement.registerOutParameter(1, -4);
            callableStatement.registerOutParameter(2, -4);
            callableStatement.setBytes(1, string.getBytes());
            LogSystem.log(2, "Running SQLRunner:");
            LogSystem.log(2, Text.replaceAllStrInStr(string, END_DELIM, "\n    "));
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
                n2 = storedProcRec.sqlCode;
            }
            callableStatement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n2 = -1;
        }
        sQLMethod.close();
        return n2;
    }

    public static int runSingleSQL(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(n, "runSingleSQL", 5);
        int n2 = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            LogSystem.log(2, "Running Single SQL:");
            LogSystem.log(2, string);
            statement.executeUpdate(string);
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException, false);
            n2 = sQLException.getErrorCode();
        }
        sQLMethod.close();
        return n2;
    }
}

