/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.htmlProductImport;

import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.htmlProductImport.HTMLParse;
import com.ibm.nzna.projects.qit.app.LocaleRec;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.batch.Batch;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.db.DatabaseDlg;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.Text;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class HTMLProductImport
extends Batch
implements ProductConstants {
    private static final int UPDATEONLY = 0;
    private static final int INSERTONLY = 1;
    private static final int INSERTUPDATE = 2;
    private static final int INDEX_BRAND = 0;
    private static final int INDEX_FAMILY = 1;
    private static final int INDEX_PRODUCTNUM = 2;
    private static final int INDEX_MACHINE = 3;
    private static final int INDEX_MODEL = 4;
    private static final int INDEX_DESCRIPT = 5;
    private static final int INDEX_ANNOUNCEDATE = 6;
    private static final int INDEX_COUNTRY = 7;
    private String databaseName = null;
    private String portNum = "5703";
    private String serverName = null;
    private String userId = null;
    private String password = null;
    private String importFilename = null;
    private BatchLogSystem logSystem = new BatchLogSystem("HTMLProductImport", this);
    private boolean insertUpdate = false;
    private DatabaseSystem dbSys = null;
    private int step = 0;
    private boolean continueImport = true;
    private int updateType = 1;
    private Vector rowVec = null;
    private int rowCount = 0;
    private boolean showDatabaseWin = false;
    private int MAX_NUMBER_OF_STEPS = 12;

    public static void main(String[] stringArray) {
        HTMLProductImport hTMLProductImport = new HTMLProductImport(stringArray);
        if (hTMLProductImport.getContinue()) {
            hTMLProductImport.startBatch();
        }
        System.exit(hTMLProductImport.getContinue() ? 1 : 0);
    }

    public HTMLProductImport(String[] stringArray) {
        this.continueImport = this.readParams(stringArray);
        if (this.continueImport) {
            this.continueImport = this.validateParams();
        }
    }

    public boolean getContinue() {
        return this.continueImport;
    }

    public void startBatch() {
        if (this.continueImport) {
            this.logProgress("Creating DatabaseSystem", this.MAX_NUMBER_OF_STEPS, this.step++);
            try {
                this.dbSys = new DatabaseSystem(true, this.logSystem, false);
                if (DatabaseSystem.createConnection(1, this.databaseName, this.serverName, this.portNum, this.userId, this.password)) {
                    this.logProgress("Connected.", this.MAX_NUMBER_OF_STEPS, this.step++);
                } else {
                    this.continueImport = false;
                }
            }
            catch (Exception exception) {
                this.logSevereError(exception);
                this.logProgress("Cannot connect", this.MAX_NUMBER_OF_STEPS, this.MAX_NUMBER_OF_STEPS);
            }
        }
        if (this.continueImport && this.showDatabaseWin) {
            new DatabaseDlg();
        }
        new TypeList();
        if (this.continueImport) {
            this.continueImport = this.parseHTMLFile();
        }
        if (this.continueImport) {
            this.commitImport();
        }
        this.logProgress("Shutting Down", this.MAX_NUMBER_OF_STEPS, this.step++);
        this.logProgress("Batch Completed", this.MAX_NUMBER_OF_STEPS, this.step++);
        System.out.println("Steps:" + this.step);
    }

    public boolean readParams(String[] stringArray) {
        boolean bl = false;
        try {
            if (stringArray != null && stringArray.length > 0) {
                int n = stringArray.length;
                int n2 = 0;
                BatchLogSystem.beginLogSection("Reading Command Line Parameters. Number of params passed:" + stringArray.length);
                while (n2 < n) {
                    this.processParam(stringArray[n2].toUpperCase(), stringArray[n2]);
                    ++n2;
                }
                BatchLogSystem.endLogSection();
                bl = true;
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
        }
        return bl;
    }

    public void processParam(String string, String string2) throws Exception {
        if (!string.startsWith("/PASSWORD:")) {
            this.logProgress("Parameter:" + string2, this.MAX_NUMBER_OF_STEPS, this.step++);
        }
        if (string.startsWith("/D:")) {
            this.databaseName = string2.substring(3, string.length());
        } else if (string.startsWith("/S:")) {
            this.serverName = string2.substring(3, string.length());
        } else if (string.startsWith("/DATABASEWIN")) {
            this.showDatabaseWin = true;
        } else if (string.startsWith("/USER:")) {
            this.userId = string2.substring(6, string.length());
        } else if (string.startsWith("/PASSWORD:")) {
            this.password = string2.substring(10, string.length());
        } else if (string.startsWith("/P:")) {
            this.portNum = string.substring(3, string.length());
        } else if (string.startsWith("/FILE:")) {
            this.importFilename = string2.substring(6, string.length());
        } else if (string.startsWith("/INSERT_UPDATE")) {
            this.updateType = 2;
        } else if (string.startsWith("/INSERT")) {
            this.updateType = 1;
        } else if (string.startsWith("/UPDATE")) {
            this.updateType = 0;
        } else if (string.startsWith("/?")) {
            HTMLProductImport.printParams();
            System.exit(0);
        } else if (string.startsWith("?")) {
            HTMLProductImport.printParams();
            System.exit(0);
        } else {
            System.out.println("Unknown parameter:" + string);
        }
    }

    private static void printParams() {
        System.out.println("");
        System.out.println("Usage: java com.ibm.nzna.projects.htmlProductImport.HTMLProductImport <params>");
        System.out.println("Parameter         Description                           Example");
        System.out.println("----------------- ------------------------------------- --------");
        System.out.println("/D:               This is which database to import into /D:QUEST");
        System.out.println("/S:               This is which server the db is on     /S:CHAOS");
        System.out.println("/P:               This is the port number of JDBC       /P:5703");
        System.out.println("/INSERT           *Only tries to insert each product    /INSERT");
        System.out.println("/INSERT           Only tries to update each product     /UPDATE");
        System.out.println("/INSERT_UPDATE    Tried to update, then insert          /INSERT_UPDATE");
        System.out.println("/USER:            The User Id to log into the db with   /USER:DLENTZ");
        System.out.println("/PASSWORD:        The password to log into the db with  /PASSWORD:MYPASS");
        System.out.println("/FILE:            The HTML file to load and process     /FILE:MYHTML.HTML");
        System.out.println("/?                Get this help                         /? ");
        System.out.println("\n* = Default\n");
    }

    private boolean validateParams() {
        boolean bl = false;
        if (this.databaseName == null) {
            this.logSevereError("No database specified from command line parameter /D:");
        } else if (this.serverName == null) {
            this.logSevereError("No server specified from command line parameter /S:");
        } else if (this.userId == null) {
            this.logSevereError("No User Id specified from command line parameter /USER:");
        } else if (this.password == null) {
            this.logSevereError("No password specified from command line parameter /PASSWORD:");
        } else if (this.importFilename == null) {
            this.logSevereError("No import filename specified from command line parameter /FILE:");
        } else {
            bl = true;
        }
        return bl;
    }

    public void commitImport() {
        if (this.rowVec != null && this.rowVec.size() > 0) {
            int n = 0;
            int n2 = this.rowVec.size();
            ProductRec productRec = null;
            while (n < n2 && this.continueImport) {
                productRec = (ProductRec)this.rowVec.elementAt(n);
                this.importProductRec(productRec);
                ++n;
                this.logProgress("Committed Product:" + productRec.getFieldData(4), this.MAX_NUMBER_OF_STEPS, this.step++);
            }
        }
    }

    private boolean parseHTMLFile() {
        boolean bl = false;
        this.logProgress("Parsing HTML Table", this.MAX_NUMBER_OF_STEPS, this.step++);
        try {
            String string = FileUtil.readFile(this.importFilename);
            boolean bl2 = true;
            String string2 = null;
            boolean bl3 = false;
            int n = 1;
            if (string != null && string.length() > 0) {
                string = this.cleanHTMLString(string);
                this.MAX_NUMBER_OF_STEPS += this.rowCount;
                if (this.rowCount > 0) {
                    if (string.indexOf("<table") == -1 && string.indexOf("<TABLE") == -1 && string.indexOf("</table") == -1 && string.indexOf("</TABLE") == -1) {
                        this.logError("HTML File contains no table");
                    } else {
                        string = Text.replaceAllStrInStr(string, "<tr", "<TR");
                        string = Text.replaceAllStrInStr(string, "<td", "<TD");
                        string = Text.replaceAllStrInStr(string, "</tr", "</TR");
                        if ((string = Text.replaceAllStrInStr(string, "</td", "</TD")).indexOf("<TR") == -1) {
                            this.logError("The HTML Table contains no rows");
                        } else if (string.indexOf("<TD") == -1) {
                            this.logError("The HTML Table contains no columns");
                        } else {
                            int n2 = 0;
                            int n3 = 0;
                            string = string.substring(string.indexOf("<TR"), string.length());
                            if (this.rowVec != null) {
                                this.rowVec.removeAllElements();
                            } else {
                                this.rowVec = new Vector(10, 10);
                            }
                            while (bl2 && !bl3 && this.continueImport) {
                                if ((n2 = string.indexOf("<TR", n2)) == -1) {
                                    bl2 = false;
                                }
                                if (bl2 && (n2 = string.indexOf(">", n2) + 1) == -1) {
                                    bl3 = true;
                                }
                                if (!bl3 && bl2 && (n3 = string.indexOf("</TR", n2)) == -1) {
                                    bl3 = true;
                                }
                                if (bl2 && !bl3) {
                                    ProductRec productRec = null;
                                    string2 = string.substring(n2, n3);
                                    if (string2.indexOf("<TD>") >= 0 && string2.indexOf("</TD>") >= 0) {
                                        productRec = this.createProdRecFromColumns(string2, n);
                                    } else {
                                        this.logError("There are no table cells in row " + n);
                                    }
                                    if (productRec != null) {
                                        this.rowVec.addElement(productRec);
                                        this.logProgress("Parsed Product Number: " + productRec.getFieldData(4), this.MAX_NUMBER_OF_STEPS, this.step++);
                                        this.logProgress("       Description:    " + productRec.getFieldData(5), this.MAX_NUMBER_OF_STEPS, this.step++);
                                    }
                                }
                                ++n;
                            }
                            if (!bl3) {
                                this.rowVec.trimToSize();
                                if (this.rowVec.size() == 0) {
                                    this.logError("There was no data in the table");
                                } else {
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
        }
        return bl;
    }

    private ProductRec createProdRecFromColumns(String string, int n) {
        ProductRec productRec = null;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        boolean bl = true;
        boolean bl2 = false;
        int n4 = 0;
        try {
            productRec = new ProductRec();
            while (bl && !bl2 && this.continueImport) {
                if ((n2 = string.indexOf("<TD", n2)) == -1) {
                    bl = false;
                } else if ((n2 = string.indexOf(">", n2) + 1) == -1) {
                    bl2 = true;
                }
                if (bl2 || !bl) continue;
                n3 = string.indexOf("</TD>", n2);
                if (n3 == -1) {
                    bl2 = true;
                    continue;
                }
                string2 = string.substring(n2, n3).trim();
                bl2 = !this.processColumnString(productRec, string2, string, n4, n);
                ++n4;
            }
            if (bl2) {
                productRec = null;
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            productRec = null;
        }
        return productRec;
    }

    private boolean processColumnString(ProductRec productRec, String string, String string2, int n, int n2) {
        boolean bl = false;
        productRec.autoSetProductNumber(false);
        switch (n) {
            case 0: {
                productRec.setFieldData(0, TypeList.getInstance().objectFromString(string, 2));
                if (productRec.getFieldData(0) == null) {
                    this.logError("The Brand was not found. Brand:" + string + ". This was in row " + n2);
                    break;
                }
                bl = true;
                break;
            }
            case 1: {
                productRec.setFieldData(1, TypeList.getInstance().objectFromString(string, 7));
                if (productRec.getFieldData(1) == null) {
                    this.logError("The Family was not found. Family:" + string + ". This was in row " + n2);
                    break;
                }
                bl = true;
                break;
            }
            case 2: {
                if (string != null) {
                    if (string.length() > 8) {
                        productRec.setFieldData(4, string.substring(0, 8));
                    } else if (string.length() != 0) {
                        productRec.setFieldData(4, string);
                    }
                    bl = true;
                    break;
                }
                this.logError("The was no Product Number found This was in row " + n2);
                break;
            }
            case 3: {
                if (string != null) {
                    if (productRec.getFieldData(4) == null || ((String)productRec.getFieldData(4)).length() < 8) {
                        productRec.autoSetProductNumber(true);
                    }
                    if (string.length() > 4) {
                        productRec.setFieldData(2, string.substring(0, 4));
                    } else {
                        productRec.setFieldData(2, string);
                    }
                    bl = true;
                    break;
                }
                this.logError("The was no Machine Type found This was in row " + n2);
                break;
            }
            case 4: {
                if (string != null) {
                    if (productRec.getFieldData(4) == null || ((String)productRec.getFieldData(4)).length() < 8) {
                        productRec.autoSetProductNumber(true);
                    }
                    if (string.length() > 3) {
                        productRec.setFieldData(3, string.substring(0, 3));
                    } else {
                        productRec.setFieldData(3, string);
                    }
                    bl = true;
                    break;
                }
                this.logError("The was no Model found This was in row " + n2);
                break;
            }
            case 5: {
                if (string != null) {
                    if (string.length() > 254) {
                        productRec.setFieldData(5, string.substring(0, 254));
                    } else {
                        productRec.setFieldData(5, string);
                    }
                    bl = true;
                    break;
                }
                this.logError("The was no Description found This was in row " + n2);
                break;
            }
            case 7: {
                bl = this.processGeoString(productRec, string, string2, n2);
                break;
            }
            case 6: {
                bl = this.processDateString(productRec, string, string2, n2);
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean processGeoString(ProductRec productRec, String string, String string2, int n) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        TypeGeoRec typeGeoRec = null;
        String string3 = null;
        LocaleRec localeRec = (LocaleRec)productRec.getFieldData(7);
        if (localeRec == null) {
            localeRec = new LocaleRec();
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            typeGeoRec = (TypeGeoRec)TypeList.getInstance().objectFromString(string3, 6);
            if (typeGeoRec != null) {
                localeRec.addGeography(typeGeoRec);
                continue;
            }
            this.logError("Cannot import product. The country was unknown. The Country ways: " + string3 + " Current Row:" + n);
        }
        productRec.setFieldData(7, localeRec);
        bl = true;
        return bl;
    }

    private boolean processDateString(ProductRec productRec, String string, String string2, int n) {
        boolean bl = false;
        int n2 = 0;
        n2 = CDate.checkDate(string = CDate.format4DigitYear(string, 2), 2);
        if (n2 != 0) {
            this.logError("The date was wrong. The date that was specified is:" + string + ".  Current row: " + n);
        } else {
            productRec.setFieldData(6, new StatusRec(0, string));
            bl = true;
        }
        return bl;
    }

    private String cleanHTMLString(String string) {
        HTMLParse hTMLParse = null;
        Object var3_3 = null;
        String string2 = null;
        int n = 0;
        hTMLParse = new HTMLParse(string);
        this.rowCount = 0;
        while (n < hTMLParse.tagCount() && this.continueImport) {
            string2 = hTMLParse.getTag(n);
            if (string2 != null) {
                if ((string2 = string2.toUpperCase()).indexOf("</TR") >= 0) {
                    hTMLParse.replaceTag(n, "</TR>");
                } else if (string2.indexOf("</TD") >= 0) {
                    hTMLParse.replaceTag(n, "</TD>");
                } else if (string2.indexOf("<TR") >= 0) {
                    hTMLParse.replaceTag(n, "<TR>");
                    ++this.rowCount;
                } else if (string2.indexOf("<TD") >= 0) {
                    hTMLParse.replaceTag(n, "<TD>");
                } else if (string2.indexOf("STYLE") >= 0 || string2.indexOf("FONT") >= 0 || string2.indexOf("APPLET") >= 0 || string2.indexOf("PARAM") >= 0 || string2.indexOf("HREF") >= 0 || string2.indexOf("FRAME") >= 0 || string2.indexOf("H1") >= 0 || string2.indexOf("H2") >= 0 || string2.indexOf("H3") >= 0 || string2.indexOf("H4") >= 0 || string2.indexOf("H5") >= 0 || string2.indexOf("H6") >= 0 || string2.indexOf("IMG") >= 0 || string2.indexOf("MAILTO") >= 0 || string2.indexOf("!") >= 0 || string2.indexOf("META") >= 0 || string2.indexOf("FORM") >= 0 || string2.indexOf("BGCOLOR") >= 0 || string2.indexOf("COLOR") >= 0 || string2.indexOf("SCRIPT") >= 0 || string2.indexOf("COMMENT") >= 0 || string2.indexOf("HTML") >= 0 || string2.indexOf("HEAD") >= 0 || string2.indexOf("P") >= 0 || string2.equals("<B>") || string2.equals("</B>") || string2.equals("<I>") || string2.equals("</I>") || string2.equals("<U>") || string2.equals("</U>") || string2.equals("<S>") || string2.equals("</S>")) {
                    hTMLParse.removeTag(n);
                }
            }
            ++n;
        }
        string = hTMLParse.getHTMLString();
        return string;
    }

    private boolean importProductRec(ProductRec productRec) {
        boolean bl = false;
        productRec.setFieldData(16, new Integer(this.checkProdExist(productRec)));
        if (this.updateType == 1) {
            if (productRec.getProdInt() != -1) {
                this.logError("Cannot insert Product Number: " + productRec.getFieldData(4) + " because it is already in the database");
            } else {
                productRec.updateRecStatus(0);
                productRec.updateRecStatus(2);
                productRec.setFieldData(16, new Integer(0));
                bl = productRec.saveToDatabase(true);
                if (bl) {
                    this.logProgress("Inserted Product Number:" + productRec.getFieldData(4), this.MAX_NUMBER_OF_STEPS, this.step++);
                }
            }
        } else if (this.updateType == 0) {
            if (productRec.getProdInt() != -1) {
                if (!productRec.checkProductLock()) {
                    productRec.updateRecStatus(0);
                    productRec.updateRecStatus(1);
                    bl = productRec.saveToDatabase(true);
                    if (bl) {
                        this.logProgress("Updated Product Number:" + productRec.getFieldData(4), this.MAX_NUMBER_OF_STEPS, this.step++);
                    }
                } else {
                    this.logError("Cannot update Product because it is locked. Product Number:" + productRec.getFieldData(4));
                }
            } else {
                this.logError("Cannot update Product because it does not exist. Product Number:" + productRec.getFieldData(4));
            }
        } else if (this.updateType == 2) {
            if (productRec.getProdInt() != -1) {
                if (!productRec.checkProductLock()) {
                    productRec.updateRecStatus(0);
                    productRec.updateRecStatus(1);
                    bl = productRec.saveToDatabase(true);
                    if (bl) {
                        this.logProgress("Updated Product Number: " + productRec.getFieldData(4), this.MAX_NUMBER_OF_STEPS, this.step++);
                    }
                } else {
                    this.logError("Cannot update product because it is locked. Product Number:" + productRec.getFieldData(4));
                }
            } else {
                productRec.updateRecStatus(0);
                productRec.updateRecStatus(2);
                productRec.setFieldData(16, new Integer(0));
                bl = productRec.saveToDatabase(true);
                if (bl) {
                    this.logProgress("Updated Product Number: " + productRec.getFieldData(4), this.MAX_NUMBER_OF_STEPS, this.step++);
                }
            }
        }
        return bl;
    }

    private int checkProdExist(ProductRec productRec) {
        String string = "checkProdExist";
        SQLMethod sQLMethod = new SQLMethod(1, string, 5);
        String string2 = "SELECT PRODINT FROM TIGRIS.PRODUCTS WHERE PRODNUM = '";
        int n = -1;
        try {
            String string3;
            if (productRec != null && (string3 = (String)productRec.getFieldData(4)) != null && string3.length() != 0 && sQLMethod != null) {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = null;
                resultSet = statement.executeQuery(string2 = string2 + string3 + "' FOR FETCH ONLY");
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return n;
    }
}

