/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.oa.engine;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.Conditions;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.ProductConcl;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.oa.engine.OAMemoryInterface;
import com.ibm.nzna.projects.oa.engine.OASessionState;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class DBAPI
implements Serializable {
    private static String database = "";
    private static String servName = "";
    private static String port = "";
    private static String userId = "";
    private static String passwd = "";
    private static String logpath = "";
    private static String logname = "oadbconnection.log";
    private static boolean useAppDrv = false;
    String DraftAction = "DA";
    String ActiveAction = "AA";
    String ActiveQuestion = "AQ";
    String DraftQuestion = "DQ";
    String DraftSymptom = "DS";
    String ActiveSymptom = "AS";
    private OAMemoryInterface qitMem = null;
    private boolean Debug = false;

    public Symptom getSymptomObject(int n, OASessionState oASessionState) throws Exception {
        Symptom symptom = null;
        int n2 = oASessionState.getCurrentSymptom();
        int n3 = oASessionState.getLanguage();
        if (oASessionState.getSourceFlag()) {
            symptom = this.qitMem.getDraftSymptomFromMemory(n2, n3);
            if (symptom == null) {
                symptom = this.getDraftSymptomFromDataBase(n2, n, oASessionState);
            }
            oASessionState.setNodeFlag(this.DraftSymptom);
        }
        if (symptom == null) {
            symptom = this.getSymptomFromDataBase(n2, n3);
            oASessionState.setNodeFlag(this.ActiveSymptom);
        }
        if (this.Debug) {
            LogSystem.log(1, "DBAPI: Symptom Ind =" + n2 + " (current, " + oASessionState.getNodeFlag() + ") " + symptom);
        }
        return symptom;
    }

    public Symptom getDraftSymptomObject(OASessionState oASessionState) throws Exception {
        int n = oASessionState.getCurrentSymptom();
        Symptom symptom = this.getDraftSymptomFromDataBaseOnly(n, oASessionState);
        if (symptom != null) {
            oASessionState.setNodeFlag(this.DraftSymptom);
        }
        if (this.Debug) {
            LogSystem.log(1, "DBAPI: Draft Symptom Ind =" + n + " (current, " + oASessionState.getNodeFlag() + ") " + symptom);
        }
        return symptom;
    }

    public Node getNodeByInd(int n, Symptom symptom) throws Exception {
        Node node = null;
        if (n != 0) {
            node = symptom.getNodeByInd(n);
        } else if (this.Debug) {
            LogSystem.log(1, "DBAPI/getNodeByInd: ERROR: node indicator is " + n);
        }
        return node;
    }

    public Node getRootNode(Symptom symptom, OASessionState oASessionState) throws Exception {
        Node node = symptom.getRootNode();
        return node;
    }

    public int getOAObjectIndForNode(Node node, OASessionState oASessionState) throws Exception {
        int n = 0;
        if (oASessionState.getSourceFlag() && (n = this.qitMem.getMemoryObjectInd(node)) == 0) {
            n = node.getDraftObjectInd();
        }
        if (n == 0) {
            n = node.getActiveObjectInd();
        }
        return n;
    }

    public int getRootNodeInd(Symptom symptom, OASessionState oASessionState) throws Exception {
        int n = symptom.getRootNodeInd();
        return n;
    }

    public Question getQuestionByInd(int n, int n2, OASessionState oASessionState) throws Exception {
        Question question = null;
        int n3 = oASessionState.getLanguage();
        if (oASessionState.getSourceFlag()) {
            question = this.qitMem.getDraftQuestionFromMemory(n, n3);
            if (question == null) {
                question = this.getDraftQuestionFromDataBase(n, n2, oASessionState);
            }
            oASessionState.setNodeFlag(this.DraftQuestion);
        }
        if (question == null) {
            question = this.getQuestionFromDataBase(n, n3);
            oASessionState.setNodeFlag(this.ActiveQuestion);
        }
        if (this.Debug && question == null) {
            LogSystem.log(1, "DBAPI/getQuestionByInd: Warning: returning null for qInd = " + n + " and node " + n2 + " within " + oASessionState.getCurrentSymptom() + " (Language " + n3 + ", flag " + oASessionState.getNodeFlag() + ")");
        }
        return question;
    }

    public Action getActionByInd(int n, int n2, OASessionState oASessionState) throws Exception {
        Action action = null;
        int n3 = oASessionState.getLanguage();
        if (oASessionState.getSourceFlag()) {
            action = this.qitMem.getDraftActionFromMemory(n, n3);
            if (action == null) {
                action = this.getDraftActionFromDataBase(n, n2, oASessionState);
            }
            oASessionState.setNodeFlag(this.DraftAction);
        }
        if (action == null) {
            action = this.getActionFromDataBase(n, n3);
            oASessionState.setNodeFlag(this.ActiveAction);
        }
        if (this.Debug && action == null) {
            LogSystem.log(1, "DBAPI/getQuestionByInd: Warning: returning null for aInd = " + n + " and node " + n2 + " within " + oASessionState.getCurrentSymptom());
        }
        return action;
    }

    public int getActionInd(Action action, OASessionState oASessionState) throws Exception {
        int n = 0;
        n = action.getInd();
        return n;
    }

    public int getQuestionInd(Question question, OASessionState oASessionState) throws Exception {
        int n = 0;
        n = question.getInd();
        return n;
    }

    public Vector getAnswersForQuestion(int n, int n2, OASessionState oASessionState) throws Exception {
        Question question = this.getQuestionByInd(n, n2, oASessionState);
        Vector vector = question.getAnswers();
        return vector;
    }

    public Answer getAnswerByInd(int n, int n2, int n3, OASessionState oASessionState) throws Exception {
        Question question = this.getQuestionByInd(n, n2, oASessionState);
        if (question == null) {
            return null;
        }
        Answer answer = question.getAnswerByInd(n3);
        return answer;
    }

    public int getAnswerForConclusion(AnswerConcl answerConcl) throws Exception {
        int n = answerConcl.getToAnswerInd();
        return n;
    }

    public int getQuestionForConclusion(AnswerConcl answerConcl) throws Exception {
        int n = answerConcl.getToQuestionInd();
        return n;
    }

    public Vector getPreanswers(Edge edge) throws Exception {
        Vector vector = edge.getPreanswers();
        return vector;
    }

    public Vector getUnanswers(Edge edge) throws Exception {
        Vector vector = edge.getUnanswers();
        return vector;
    }

    public Vector getActionListsForEdge(Edge edge) throws Exception {
        Vector vector = edge.getActionList();
        return vector;
    }

    public int getActionForEdgeAlist(EdgeAlist edgeAlist, OASessionState oASessionState) throws Exception {
        int n = 0;
        if (oASessionState.getSourceFlag() && (n = this.qitMem.getMemoryActionInd(edgeAlist)) == 0) {
            n = edgeAlist.getDraftActionInd();
        }
        if (n == 0) {
            n = edgeAlist.getActiveActionInd();
        }
        return n;
    }

    public int getQuestionForEdgeUnanswer(EdgeUnanswer edgeUnanswer, OASessionState oASessionState) throws Exception {
        int n = 0;
        if (oASessionState.getSourceFlag() && (n = this.qitMem.getMemoryUnQuestionInd(edgeUnanswer)) == 0) {
            n = edgeUnanswer.getDraftQuestionInd();
        }
        if (n == 0) {
            n = edgeUnanswer.getActiveQuestionInd();
        }
        return n;
    }

    public int getQuestionForEdgePreanswer(EdgePreanswer edgePreanswer, OASessionState oASessionState) throws Exception {
        int n = 0;
        if (oASessionState.getSourceFlag() && (n = this.qitMem.getMemoryPreQuestionInd(edgePreanswer)) == 0) {
            n = edgePreanswer.getDraftQuestionInd();
        }
        if (n == 0) {
            n = edgePreanswer.getActiveQuestionInd();
        }
        return n;
    }

    public int getAnswerForEdgePreanswer(EdgePreanswer edgePreanswer, OASessionState oASessionState) throws Exception {
        int n = 0;
        if (oASessionState.getSourceFlag() && (n = this.qitMem.getMemoryAnswerInd(edgePreanswer)) == 0) {
            n = edgePreanswer.getDraftAnswerInd();
        }
        if (n == 0) {
            n = edgePreanswer.getActiveQuestionInd();
        }
        return n;
    }

    public Hashtable getEdgesForNodeAndAnswer(OASessionState oASessionState) throws Exception {
        int n = oASessionState.getCurrentResponse();
        int n2 = oASessionState.getCurrentNode();
        Symptom symptom = this.getSymptomObject(n2, oASessionState);
        Hashtable hashtable = new Hashtable();
        if (oASessionState.getSourceFlag() && (hashtable = this.qitMem.getEdgesForMemoryNodeAndAnswer(symptom, n2, n)).isEmpty()) {
            hashtable = symptom.getEdgesForNodeAndAnswer(n2, n, true);
        }
        if (hashtable.isEmpty()) {
            hashtable = symptom.getEdgesForNodeAndAnswer(n2, n, false);
        }
        return hashtable;
    }

    public Hashtable getOtherEdgesForNode(OASessionState oASessionState) throws Exception {
        int n = oASessionState.getCurrentNode();
        Symptom symptom = this.getSymptomObject(n, oASessionState);
        Hashtable hashtable = symptom.getTypeOtherEdgesForNode(n);
        return hashtable;
    }

    public int getEdgeDocClassInd(Edge edge) throws Exception {
        int n = edge.getDocClass().ind;
        return n;
    }

    public int getAnswerConclDocClassInd(AnswerConcl answerConcl) throws Exception {
        int n = answerConcl.getDocClass().ind;
        return n;
    }

    public Vector getEdgeCountryList(Edge edge) throws Exception {
        Vector vector = edge.getCountryList();
        return vector;
    }

    public Vector getAnswerConclCountryList(AnswerConcl answerConcl) throws Exception {
        Vector vector = answerConcl.getCountryList();
        return vector;
    }

    public int getAnswerDocClassInd(Answer answer) throws Exception {
        int n = answer.getDocClass().ind;
        return n;
    }

    public Vector getAnswerCountryList(Answer answer) throws Exception {
        Vector vector = answer.getCountryList();
        return vector;
    }

    public boolean areConditionsValid(Conditions conditions, OASessionState oASessionState) throws Exception {
        boolean bl = false;
        Vector vector = conditions.getConditionTerms();
        if (!vector.isEmpty()) {
            if (conditions.size() > 0) {
                if (oASessionState.testCondition(vector)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (this.Debug) {
            if (!bl) {
                LogSystem.log(1, "DBAPI: Conditions valid: " + bl);
            } else {
                System.out.print(".");
            }
        }
        return bl;
    }

    public Vector getValidAnswersForQuestion(int n, int n2, OASessionState oASessionState) throws Exception {
        Vector<Answer> vector = new Vector<Answer>();
        Vector vector2 = this.getAnswersForQuestion(n, n2, oASessionState);
        int n3 = 0;
        while (n3 < vector2.size()) {
            Conditions conditions;
            int n4;
            Answer answer = (Answer)vector2.elementAt(n3);
            Vector vector3 = this.getAnswerCountryList(answer);
            if (this.isCountryMatch(vector3, oASessionState) && this.isDocClassIndMatch(n4 = this.getAnswerDocClassInd(answer), oASessionState) && this.areConditionsValid(conditions = answer.getConditions(), oASessionState)) {
                vector.addElement(answer);
            }
            ++n3;
        }
        return vector;
    }

    public Hashtable getTitlesForValidAnswers(int n, int n2, OASessionState oASessionState) throws Exception {
        Vector vector = this.getValidAnswersForQuestion(n, n2, oASessionState);
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n3 = 0;
        while (n3 < vector.size()) {
            Answer answer = (Answer)vector.elementAt(n3);
            int n4 = answer.getInd();
            String string = this.getTitleStringForAnswer(answer, oASessionState);
            hashtable.put(new Integer(n4), string);
            ++n3;
        }
        return hashtable;
    }

    public Title getActionTitle(Action action, OASessionState oASessionState) throws Exception {
        Title title = null;
        boolean bl = false;
        Vector vector = action.getTitles();
        int n = 0;
        while (n < vector.size() && !bl) {
            Conditions conditions;
            Vector vector2;
            title = (Title)vector.elementAt(n);
            int n2 = title.getDocClass().ind;
            if (this.isDocClassIndMatch(n2, oASessionState) && !bl && this.isCountryMatch(vector2 = title.getCountryList(), oASessionState) && this.areConditionsValid(conditions = title.getConditions(), oASessionState)) {
                bl = true;
            }
            ++n;
        }
        return title;
    }

    public Title getAnswerTitle(Answer answer, OASessionState oASessionState) throws Exception {
        Title title = null;
        boolean bl = false;
        int n = 0;
        if (answer == null) {
            return null;
        }
        Vector vector = answer.getTitles();
        int n2 = 0;
        while (n2 < vector.size() && !bl) {
            title = (Title)vector.elementAt(n2);
            n = title.getDocClass().ind;
            if (this.isDocClassIndMatch(n, oASessionState) && !bl && this.isCountryMatch(title.getCountryList(), oASessionState)) {
                bl = this.areConditionsValid(title.getConditions(), oASessionState);
            }
            ++n2;
        }
        return title;
    }

    public Title getQuestionTitle(Question question, OASessionState oASessionState) throws Exception {
        Title title = null;
        boolean bl = false;
        Vector vector = question.getTitles();
        int n = 0;
        while (n < vector.size() && !bl) {
            Conditions conditions;
            Vector vector2;
            title = (Title)vector.elementAt(n);
            int n2 = title.getDocClass().ind;
            if (this.isDocClassIndMatch(n2, oASessionState) && this.isCountryMatch(vector2 = title.getCountryList(), oASessionState) && this.areConditionsValid(conditions = title.getConditions(), oASessionState)) {
                bl = true;
            }
            ++n;
        }
        return title;
    }

    public AddtlInfo getAddtlInfoForAction(Action action, OASessionState oASessionState) throws Exception {
        AddtlInfo addtlInfo = null;
        boolean bl = false;
        Vector vector = action.getAdditionalInfo();
        int n = 0;
        while (n < vector.size() && !bl) {
            Conditions conditions;
            Vector vector2;
            addtlInfo = (AddtlInfo)vector.elementAt(n);
            int n2 = addtlInfo.getDocClass().ind;
            if (this.isDocClassIndMatch(n2, oASessionState) && !bl && this.isCountryMatch(vector2 = addtlInfo.getCountryList(), oASessionState) && !bl && this.areConditionsValid(conditions = addtlInfo.getConditions(), oASessionState) && !bl) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return addtlInfo;
        }
        return null;
    }

    public AddtlInfo getAddtlInfoForQuestion(Question question, OASessionState oASessionState) throws Exception {
        AddtlInfo addtlInfo = null;
        boolean bl = false;
        Vector vector = question.getAdditionalInfo();
        int n = 0;
        while (n < vector.size() && !bl) {
            Conditions conditions;
            Vector vector2;
            addtlInfo = (AddtlInfo)vector.elementAt(n);
            int n2 = addtlInfo.getDocClass().ind;
            if (this.isDocClassIndMatch(n2, oASessionState) && !bl && this.isCountryMatch(vector2 = addtlInfo.getCountryList(), oASessionState) && !bl && this.areConditionsValid(conditions = addtlInfo.getConditions(), oASessionState) && !bl) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return addtlInfo;
        }
        return null;
    }

    public Vector getDocLinksForAction(Action action, OASessionState oASessionState) throws Exception {
        Vector<DocLink> vector = new Vector<DocLink>();
        DocLink docLink = null;
        Vector vector2 = action.getDocLinks();
        int n = 0;
        while (n < vector2.size()) {
            Conditions conditions;
            Vector vector3;
            docLink = (DocLink)vector2.elementAt(n);
            int n2 = docLink.getDocClass().ind;
            if (this.isDocClassIndMatch(n2, oASessionState) && this.isCountryMatch(vector3 = docLink.getCountryList(), oASessionState) && this.areConditionsValid(conditions = docLink.getConditions(), oASessionState)) {
                vector.addElement(docLink);
            }
            ++n;
        }
        return vector;
    }

    public Vector getDocLinksForQuestion(Question question, OASessionState oASessionState) throws Exception {
        Vector<DocLink> vector = new Vector<DocLink>();
        DocLink docLink = null;
        Vector vector2 = question.getDocLinks();
        int n = 0;
        while (n < vector2.size()) {
            Conditions conditions;
            Vector vector3;
            docLink = (DocLink)vector2.elementAt(n);
            int n2 = docLink.getDocClass().ind;
            if (this.isDocClassIndMatch(n2, oASessionState) && this.isCountryMatch(vector3 = docLink.getCountryList(), oASessionState) && this.areConditionsValid(conditions = docLink.getConditions(), oASessionState)) {
                vector.addElement(docLink);
            }
            ++n;
        }
        return vector;
    }

    public Vector getLinksFromDocLinks(Vector vector, OASessionState oASessionState) throws Exception {
        Vector<Link> vector2 = new Vector<Link>();
        int n = 0;
        while (n < vector.size()) {
            DocLink docLink = (DocLink)vector.elementAt(n);
            Vector vector3 = new Vector();
            if (docLink.hasLinkGroup()) {
                int n2 = docLink.getLinkGroupInd();
                LinkGroup linkGroup = this.getLinkGroupFromDataBase(n2, oASessionState.getLanguage());
                vector3 = linkGroup.getLinks();
                int n3 = 0;
                while (n3 < vector3.size()) {
                    Link link = this.getLinkFromDataBase(((Link)vector3.elementAt(n3)).getInd(), oASessionState.getLanguage());
                    vector2.addElement(link);
                    ++n3;
                }
            } else {
                Link link = this.getLinkFromDataBase(docLink.getLinkInd(), oASessionState.getLanguage());
                vector2.addElement(link);
            }
            ++n;
        }
        return vector2;
    }

    public boolean checkCountryForEdge(Edge edge, OASessionState oASessionState) throws Exception {
        Vector vector = this.getEdgeCountryList(edge);
        boolean bl = this.isCountryMatch(vector, oASessionState);
        return bl;
    }

    public boolean checkCountryForAnswerConcl(AnswerConcl answerConcl, OASessionState oASessionState) throws Exception {
        Vector vector = this.getAnswerConclCountryList(answerConcl);
        boolean bl = this.isCountryMatch(vector, oASessionState);
        return bl;
    }

    public boolean isDocClassIndMatch(int n, OASessionState oASessionState) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (oASessionState.getDocClassInd() == 1) {
            bl2 = true;
        }
        if (oASessionState.getDocClassInd() == 2 && n == 2 | n == 3) {
            bl2 = true;
        }
        if (oASessionState.getDocClassInd() == 3 && n == 3) {
            bl2 = true;
        }
        if (this.Debug) {
            if (bl2) {
                System.out.print(",");
            } else {
                System.out.print("-");
            }
        }
        return bl2;
    }

    public boolean isCountryMatch(Vector vector, OASessionState oASessionState) throws Exception {
        if (vector == null || vector.isEmpty()) {
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            int n2 = ((TypeCountryCodeRec)vector.elementAt(n)).getInd();
            if (n2 == oASessionState.getCountry()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getTitleStringForAction(Action action, OASessionState oASessionState) throws Exception {
        if (action == null) {
            return "";
        }
        Title title = this.getActionTitle(action, oASessionState);
        if (title == null) {
            return "";
        }
        return title.getTitle();
    }

    public String getTitleStringForQuestion(Question question, OASessionState oASessionState) throws Exception {
        if (question == null) {
            return "";
        }
        Title title = this.getQuestionTitle(question, oASessionState);
        if (title == null) {
            return "";
        }
        return title.getTitle();
    }

    public String getTitleStringForAnswer(Answer answer, OASessionState oASessionState) throws Exception {
        if (answer == null) {
            return "";
        }
        Title title = this.getAnswerTitle(answer, oASessionState);
        if (title == null) {
            return "";
        }
        return title.getTitle();
    }

    public String getTitleForCurrentSymptom(int n, OASessionState oASessionState) throws Exception {
        Symptom symptom = this.getSymptomObject(n, oASessionState);
        if (symptom == null) {
            return "";
        }
        Vector vector = symptom.getSymptomTitles();
        SymptomTitle symptomTitle = null;
        String string = "";
        int n2 = 0;
        while (n2 < vector.size()) {
            symptomTitle = (SymptomTitle)vector.elementAt(n2);
            if (this.isDocClassIndMatch(symptomTitle.getDocClass().ind, oASessionState) && this.isCountryMatch(symptomTitle.getCountryList(), oASessionState) && symptomTitle.getLanguage() != null && symptomTitle.getLanguage().getInd() == oASessionState.getLanguage()) {
                string = symptomTitle.getTitle();
                break;
            }
            ++n2;
        }
        if (string.equals("") && !vector.isEmpty() && vector.elementAt(0) != null) {
            symptomTitle = (SymptomTitle)vector.elementAt(0);
            string = symptomTitle.getTitle();
        }
        return string;
    }

    public String getAddInfoStringForAction(Action action, OASessionState oASessionState) throws Exception {
        String string = "";
        AddtlInfo addtlInfo = this.getAddtlInfoForAction(action, oASessionState);
        if (addtlInfo != null) {
            string = string + addtlInfo.getAddtlInfo();
        }
        return string;
    }

    public String getAddInfoStringForQuestion(Question question, OASessionState oASessionState) throws Exception {
        String string = "";
        AddtlInfo addtlInfo = this.getAddtlInfoForQuestion(question, oASessionState);
        if (addtlInfo != null) {
            string = string + addtlInfo.getAddtlInfo();
        }
        return string;
    }

    public Vector getLinkTitlesForQuestion(Question question, OASessionState oASessionState) throws Exception {
        String string = "";
        Vector vector = this.getDocLinksForQuestion(question, oASessionState);
        Vector vector2 = this.getLinksFromDocLinks(vector, oASessionState);
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector2.size()) {
            Link link = (Link)vector2.elementAt(n);
            this.concatenateTwoVectors(vector3, link.getLinkTitles());
            ++n;
        }
        if (this.Debug) {
            LogSystem.log(1, "DBAPI: Links are done.");
        }
        return vector3;
    }

    public Vector getLinkTitlesForAction(Action action, OASessionState oASessionState) throws Exception {
        Vector vector = this.getDocLinksForAction(action, oASessionState);
        Vector vector2 = this.getLinksFromDocLinks(vector, oASessionState);
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector2.size()) {
            Link link = (Link)vector2.elementAt(n);
            this.concatenateTwoVectors(vector3, link.getLinkTitles());
            ++n;
        }
        return vector3;
    }

    public Vector getLinkURLsForAction(Action action, OASessionState oASessionState) throws Exception {
        Vector vector = this.getDocLinksForAction(action, oASessionState);
        Vector vector2 = this.getLinksFromDocLinks(vector, oASessionState);
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < vector2.size()) {
            Link link = (Link)vector2.elementAt(n);
            vector3.addElement(link.getUrlString());
            ++n;
        }
        return vector3;
    }

    public Vector getLinkURLsForQuestion(Question question, OASessionState oASessionState) throws Exception {
        Vector vector = this.getDocLinksForQuestion(question, oASessionState);
        Vector vector2 = this.getLinksFromDocLinks(vector, oASessionState);
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < vector2.size()) {
            Link link = (Link)vector2.elementAt(n);
            vector3.addElement(link.getUrlString());
            ++n;
        }
        return vector3;
    }

    public void concatenateTwoVectors(Vector vector, Vector vector2) throws Exception {
        if (vector2 == null) {
            return;
        }
        int n = 0;
        while (n < vector2.size()) {
            vector.addElement(vector2.elementAt(n));
            ++n;
        }
    }

    public Question getQuestionFromDataBase(int n, int n2) throws Exception {
        Question question = Question.readFromDatabase(n, n2);
        return question;
    }

    public Question getDraftQuestionFromDataBase(int n, int n2, OASessionState oASessionState) throws Exception {
        Symptom symptom = this.getSymptomObject(n2, oASessionState);
        Node node = this.getNodeByInd(n2, symptom);
        Question question = null;
        if (node.getDraftObjectInd() != 0) {
            question = QuestionDraft.readFromDatabase(n, oASessionState.getLanguage());
            if (this.Debug && question == null) {
                LogSystem.log(1, "DBAPI/getDraftQ: Warning: returning null for draft ques = " + n + " and node " + n2 + " within " + symptom.toString());
            }
        }
        return question;
    }

    public Action getActionFromDataBase(int n, int n2) throws Exception {
        new Action();
        Action action = Action.readFromDatabase(n, n2);
        return action;
    }

    public Action getDraftActionFromDataBase(int n, int n2, OASessionState oASessionState) throws Exception {
        Symptom symptom = this.getSymptomObject(n2, oASessionState);
        Node node = this.getNodeByInd(n2, symptom);
        Action action = null;
        if (node.getDraftObjectInd() != 0) {
            action = ActionDraft.readFromDatabase(n, oASessionState.getLanguage());
            if (this.Debug && action == null) {
                LogSystem.log(1, "DBAPI/getDraftAct: Warning: returning null for draft act = " + n + " and node " + n2 + " within " + symptom.toString());
            }
        }
        return action;
    }

    public Symptom getSymptomFromDataBase(int n, int n2) throws Exception {
        Symptom symptom = Symptom.readFromDatabase(n, n2);
        if (this.Debug && symptom == null) {
            LogSystem.log(1, "DBAPI/getSym: Warning: Symptom.readFromDataBase returned " + "null for " + n + " (lang: " + n2 + ")");
        }
        return symptom;
    }

    public Symptom getDraftSymptomFromDataBase(int n, int n2, OASessionState oASessionState) throws Exception {
        Symptom symptom = this.getDraftSymptomObject(oASessionState);
        if (symptom == null) {
            return null;
        }
        Node node = this.getNodeByInd(n2, symptom);
        Symptom symptom2 = null;
        if (node.getDraftObjectInd() != 0) {
            symptom2 = SymptomDraft.readFromDatabase(n, oASessionState.getLanguage());
            if (this.Debug && symptom2 == null) {
                LogSystem.log(1, "DBAPI/getDraftSym: Warning: returning null for draft sym = " + n + " and node " + n2 + " within " + symptom.toString());
            }
        }
        return symptom2;
    }

    public Symptom getDraftSymptomFromDataBaseOnly(int n, OASessionState oASessionState) throws Exception {
        Symptom symptom = SymptomDraft.readFromDatabase(n, oASessionState.getLanguage());
        if (this.Debug && symptom == null) {
            LogSystem.log(1, "DBAPI/getDraftSymOnly: Warning: returning null for draft sym = " + n);
        }
        return symptom;
    }

    public Link getLinkFromDataBase(int n, int n2) throws Exception {
        Link link = Link.readFromDatabase(n, n2);
        return link;
    }

    public LinkGroup getLinkGroupFromDataBase(int n, int n2) throws Exception {
        new LinkGroup(n);
        LinkGroup linkGroup = LinkGroup.readFromDatabase(n, n2);
        return linkGroup;
    }

    private static void init() throws Exception {
        Class.forName("COM.ibm.db2.jdbc.net.DB2Driver");
        DatabaseSystem databaseSystem = new DatabaseSystem(true, LogSystem.getInstance(), useAppDrv);
        DatabaseSystem.createConnection(1, database, servName, port, userId, passwd);
        LogSystem.log(1, "");
        LogSystem.log(1, "---------------------------------------------");
        LogSystem.log(1, "===> Using database " + database);
        LogSystem.log(1, "---------------------------------------------");
        LogSystem.log(1, "");
    }

    public Hashtable getProductConclusionsForNewSym(OASessionState oASessionState) throws Exception {
        Hashtable hashtable = new Hashtable();
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "DBAPI.getProductionConclusionsForNewSym()", 1);
        Statement statement = sQLMethod.createStatement();
        ResultSet resultSet = statement.executeQuery("select c.prodint from tigris.typebrand" + " a,tigris.brands b,tigris.products c where  a.brandind= " + " b.brandind  and a.descript='" + oASessionState.getBrand() + "' and b.brandgroupind=" + "c.brandgroupind and c.prodnum='" + oASessionState.getModel() + "'");
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        if (this.Debug) {
            LogSystem.log(1, "DBAPI: Brand " + oASessionState.getBrand() + " / Model " + oASessionState.getModel() + " / ProductInd " + n);
        }
        ProductConcl productConcl = new ProductConcl(n);
        hashtable = ProductConcl.getProductConclusions(n);
        resultSet.close();
        sQLMethod.close();
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCLIOCountryCodeForCustNum(int n, String string, String string2, String string3, String string4, String string5) throws Exception {
        Class.forName("COM.ibm.db2.jdbc.net.DB2Driver");
        DatabaseSystem databaseSystem = new DatabaseSystem(true, LogSystem.getInstance(), useAppDrv);
        DatabaseSystem.createConnection(2, string, string2, string3, userId, passwd);
        String string6 = null;
        SQLMethod sQLMethod = new SQLMethod(2, "getCLIOCountryCodeForCustNum()", 1);
        ResultSet resultSet = null;
        try {
            block5: {
                try {
                    Statement statement = sQLMethod.createStatement();
                    resultSet = statement.executeQuery("SELECT countryCode " + "FROM clio.custaddress " + "WHERE custNum=" + n + " " + "FOR READ ONLY");
                    if (!resultSet.next()) break block5;
                    string6 = resultSet.getString(1);
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception);
                    return string6;
                }
            }
            Object var12_13 = null;
            resultSet.close();
            sQLMethod.close();
            return string6;
        }
        finally {
            Object var12_14 = null;
            resultSet.close();
            sQLMethod.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLangIndFromDatabase(String string) throws Exception {
        int n;
        block6: {
            SQLMethod sQLMethod = new SQLMethod(1, "DBAPI.getLangIndFromDatabase()", 1);
            n = 0;
            ResultSet resultSet = null;
            try {
                try {
                    Statement statement = sQLMethod.createStatement();
                    resultSet = statement.executeQuery("SELECT languageInd " + "FROM tigris.typelanguage " + "WHERE descript='" + string + "' " + "FOR READ ONLY");
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception);
                    Object var6_8 = null;
                    resultSet.close();
                    sQLMethod.close();
                    break block6;
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                resultSet.close();
                sQLMethod.close();
                throw throwable;
            }
            resultSet.close();
            sQLMethod.close();
        }
        if (this.Debug) {
            LogSystem.log(1, "DBAPI: Language Ind =" + n);
        }
        return n;
    }

    public DBAPI(String string, String string2, String string3, String string4, String string5, OAMemoryInterface oAMemoryInterface, String string6, boolean bl) throws Exception {
        database = string;
        servName = string2;
        port = string3;
        userId = string4;
        passwd = string5;
        this.qitMem = oAMemoryInterface;
        logpath = string6;
        useAppDrv = bl;
        DBAPI.init();
    }
}

