/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.oa.engine;

import com.ibm.nzna.projects.common.quest.oa.ConditionTerm;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class OASessionState
implements Serializable,
Cloneable {
    private int currentSymptom = 0;
    private Stack symptomStack = null;
    private int currentNode = 0;
    private int currentResponse = 0;
    private int previousNode = 0;
    private int previousResponse = 0;
    private int custNum = 0;
    private String brand = "";
    private String model = "";
    private String geo = "";
    private int country = 110;
    private int language = 1;
    private int docClassInd = 3;
    private Vector historyOrder = new Vector();
    private Vector questionHistory = new Vector();
    private Vector answerHistory = new Vector();
    private Vector nodeHistory = new Vector();
    private Vector symptomHistory = new Vector();
    private Vector sequenceHistory = new Vector();
    private Hashtable preanswers = new Hashtable();
    private Vector actionList = new Vector();
    private String sessionTime = "";
    private boolean qit_flag = false;
    private int sessionId = 0;
    private String node_flag = "";
    private int currentSeqNo = 0;
    private boolean Debug = false;

    public boolean isAnswered(int n) throws Exception {
        Integer n2 = new Integer(n);
        return this.questionHistory.contains(n2) || this.preanswers.containsKey(n2);
    }

    public boolean isPreanswered(int n) throws Exception {
        Integer n2 = new Integer(n);
        return this.preanswers.containsKey(n2);
    }

    public boolean isAnswerTrue(int n, int n2) throws Exception {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        int n5 = 0;
        if (this.questionHistory.contains(n3)) {
            if (this.answerHistory.contains(n4)) {
                n5 = (Integer)this.answerHistory.elementAt(this.questionHistory.indexOf(n3));
            }
        } else if (this.preanswers.containsKey(n3)) {
            n5 = (Integer)this.preanswers.get(n3);
        }
        return n5 == n2;
    }

    public int getAnswer(int n) throws Exception {
        Integer n2 = new Integer(n);
        if (this.questionHistory.contains(n2)) {
            return (Integer)this.answerHistory.elementAt(this.questionHistory.indexOf(n2));
        }
        if (this.preanswers.containsKey(n2)) {
            return (Integer)this.preanswers.get(n2);
        }
        return 0;
    }

    public void setCurrentSymptom(int n) throws Exception {
        this.currentSymptom = n;
    }

    public int getCurrentSymptom() throws Exception {
        return this.currentSymptom;
    }

    public void pushSymptom(int n) throws Exception {
        Integer n2 = new Integer(n);
        if (this.symptomStack == null) {
            this.symptomStack = new Stack();
        }
        this.symptomStack.push(n2);
    }

    public int popSymptom() throws Exception {
        return (Integer)this.symptomStack.pop();
    }

    public String getSymptomStackString() throws Exception {
        return this.symptomStack.toString();
    }

    public void setCurrentNode(int n) throws Exception {
        this.currentNode = n;
    }

    public int getCurrentNode() throws Exception {
        return this.currentNode;
    }

    public void setCurrentResponse(int n) throws Exception {
        this.currentResponse = n;
    }

    public int getCurrentResponse() throws Exception {
        return this.currentResponse;
    }

    public void setPreviousNode(int n) throws Exception {
        this.previousNode = n;
    }

    public int getPreviousNode() throws Exception {
        return this.previousNode;
    }

    public void setPreviousResponse(int n) throws Exception {
        this.previousResponse = n;
    }

    public int getPreviousResponse() throws Exception {
        return this.previousResponse;
    }

    public void setBrand(String string) throws Exception {
        this.brand = string;
    }

    public String getBrand() throws Exception {
        return this.brand;
    }

    public void setGeo(String string) throws Exception {
        this.geo = string;
    }

    public String getGeo() throws Exception {
        return this.geo;
    }

    public void setCountry(int n) throws Exception {
        this.country = n;
    }

    public int getCountry() throws Exception {
        return this.country;
    }

    public void setLanguage(int n) throws Exception {
        this.language = n;
    }

    public int getLanguage() throws Exception {
        return this.language;
    }

    public void setDocClassInd(int n) throws Exception {
        this.docClassInd = n;
    }

    public int getDocClassInd() throws Exception {
        return this.docClassInd;
    }

    public void setModel(String string) throws Exception {
        this.model = string;
    }

    public String getModel() throws Exception {
        return this.model;
    }

    public int getCustNum() throws Exception {
        return this.custNum;
    }

    public void setCustNum(int n) throws Exception {
        this.custNum = n;
    }

    public void addHistoryItem(int n, int n2, int n3) throws Exception {
        Integer n4 = new Integer(n);
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n3);
        Integer n7 = new Integer(this.getCurrentSymptom());
        Integer n8 = new Integer(this.getCurrentSeqNo());
        this.historyOrder.addElement(n5);
        this.nodeHistory.addElement(n4);
        this.questionHistory.addElement(n5);
        this.answerHistory.addElement(n6);
        this.symptomHistory.addElement(n7);
        this.sequenceHistory.addElement(n8);
        if (this.Debug) {
            LogSystem.log(1, "SessionState/addHistory: node " + n + ", question " + n2 + ", answer " + n3 + ", symptom " + n7.toString() + ", sequence# " + n8.toString());
        }
    }

    public Enumeration getHistoryOrder() throws Exception {
        return this.historyOrder.elements();
    }

    public int getHistoryItem(String string) throws Exception {
        Integer n = new Integer(string);
        return (Integer)this.answerHistory.elementAt(this.questionHistory.indexOf(n));
    }

    public Vector getQuestionHistory() throws Exception {
        return this.questionHistory;
    }

    public Vector getAnswerHistory() throws Exception {
        return this.answerHistory;
    }

    public Vector getNodeHistory() throws Exception {
        return this.nodeHistory;
    }

    public Vector getSymptomHistory() throws Exception {
        return this.symptomHistory;
    }

    public Vector getSequenceHistory() throws Exception {
        return this.sequenceHistory;
    }

    public void addPreanswerItem(int n, int n2) throws Exception {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        this.preanswers.put(n3, n4);
        if (this.questionHistory.contains(n3)) {
            this.addHistoryItem(0, n, n2);
        }
    }

    public int getPreanswerItem(int n) throws Exception {
        Integer n2 = new Integer(n);
        if (this.preanswers.get(n2) != null) {
            return (Integer)this.preanswers.get(n2);
        }
        return 0;
    }

    public String getPreanswerString() throws Exception {
        return this.preanswers.toString();
    }

    public void removePreanswerItem(int n) throws Exception {
        Integer n2 = new Integer(n);
        this.preanswers.remove(n2);
    }

    public void addActionListItem(int n) throws Exception {
        Integer n2 = new Integer(n);
        this.actionList.addElement(n2);
    }

    public int getActionListItem(int n) throws Exception {
        Integer n2 = new Integer(n);
        int n3 = (Integer)this.actionList.elementAt(this.actionList.indexOf(n2));
        return n3;
    }

    public Enumeration getActionList() throws Exception {
        return this.actionList.elements();
    }

    public String getActionListString() throws Exception {
        return this.actionList.toString();
    }

    public void removeActionListItem(int n) throws Exception {
        Integer n2 = new Integer(n);
        boolean bl = this.actionList.removeElement(n2);
    }

    public void clear() throws Exception {
        this.currentSymptom = 0;
        if (this.symptomStack != null) {
            this.symptomStack.removeAllElements();
        }
        this.currentNode = 0;
        this.currentResponse = 0;
        this.previousNode = 0;
        this.previousResponse = 0;
        this.brand = "";
        this.geo = "";
        this.country = 0;
        this.language = 0;
        this.docClassInd = 0;
        this.historyOrder.removeAllElements();
        this.questionHistory.removeAllElements();
        this.answerHistory.removeAllElements();
        this.preanswers.clear();
        this.actionList.removeAllElements();
        this.sessionTime = "";
    }

    public Object clone() {
        try {
            OASessionState oASessionState = (OASessionState)super.clone();
            oASessionState.symptomStack = this.symptomStack != null ? (Stack)this.symptomStack.clone() : null;
            oASessionState.historyOrder = (Vector)this.historyOrder.clone();
            oASessionState.questionHistory = (Vector)this.questionHistory.clone();
            oASessionState.answerHistory = (Vector)this.answerHistory.clone();
            oASessionState.preanswers = (Hashtable)this.preanswers.clone();
            oASessionState.actionList = (Vector)this.actionList.clone();
            return oASessionState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean testCondition(Vector vector) throws Exception {
        boolean bl = this.booleanEvaluate(vector);
        return bl;
    }

    public boolean checkQAPair(int n, int n2) throws Exception {
        boolean bl = false;
        bl = n2 == 0 ? this.isAnswered(n) : this.isAnswerTrue(n, n2);
        return bl;
    }

    private boolean booleanEvaluate(Vector vector) throws Exception {
        Stack<Boolean> stack = new Stack<Boolean>();
        boolean bl = false;
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        ConditionTerm conditionTerm = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            conditionTerm = (ConditionTerm)vector.elementAt(n3);
            n = conditionTerm.getQuestionInd();
            n2 = conditionTerm.getAnswerInd();
            string = conditionTerm.getOperators();
            if (string.equals("") | string.equals(" ") | string.equals("  ")) {
                stack.push(new Boolean(this.checkQAPair(n, n2)));
            } else {
                bl4 = false;
                if (stack.empty()) {
                    bl5 = false;
                    bl4 = true;
                    bl3 = true;
                } else {
                    bl5 = (Boolean)stack.pop();
                }
                bl6 = this.checkQAPair(n, n2);
                int n4 = 0;
                while (n4 < string.length()) {
                    if (String.valueOf(string.charAt(n4)).equals("&")) {
                        bl2 = bl4 ? bl6 : bl5 && bl6;
                    } else if (String.valueOf(string.charAt(n4)).equals("|")) {
                        bl2 = bl5 || bl6;
                    } else if (String.valueOf(string.charAt(n4)).equals("!")) {
                        bl2 = !bl5;
                    }
                    stack.push(new Boolean(bl2));
                    ++n4;
                }
            }
            ++n3;
        }
        if (stack.empty()) {
            bl3 = true;
        }
        if (bl3) {
            LogSystem.log(1, "OASessionState/boolEval: Warning bad data format - " + vector.toString());
        }
        return (Boolean)stack.pop();
    }

    public boolean getSourceFlag() throws Exception {
        return this.qit_flag;
    }

    public void setSourceFlag(boolean bl) throws Exception {
        this.qit_flag = bl;
    }

    public int getSessionId() throws Exception {
        return this.sessionId;
    }

    public void setSessionId(int n) throws Exception {
        this.sessionId = n;
    }

    public int getCurrentSeqNo() throws Exception {
        return this.currentSeqNo;
    }

    public void setCurrentSeqNo(int n) throws Exception {
        this.currentSeqNo = n;
    }

    public void setNodeFlag(String string) throws Exception {
        this.node_flag = string;
    }

    public String getNodeFlag() throws Exception {
        return this.node_flag;
    }

    public String toString() {
        String string = "<p><p><b>Session State</b><br>\n";
        string = string + "Curent Symptom: " + String.valueOf(this.currentSymptom) + "<br>\n";
        string = string + "Symptom Stack: " + this.symptomStack + "<br>\n";
        string = string + "Current Node:" + String.valueOf(this.currentNode) + "<br>\n";
        string = string + "Current Response:" + String.valueOf(this.currentResponse) + "<br>\n";
        string = string + "Previous Node: " + String.valueOf(this.previousNode) + "<br>\n";
        string = string + "Previous Response:" + String.valueOf(this.previousResponse) + "<br>\n";
        string = string + "Brand:" + this.brand + "<br>\n";
        string = string + "Geography:" + this.geo + "<br>\n";
        string = string + "Country:" + String.valueOf(this.country) + "<br>\n";
        string = string + "Language: " + String.valueOf(this.language) + "<br>\n";
        string = string + "Type/Model:" + this.model + "<br>\n";
        string = string + "Session Time:" + this.sessionTime + "<br>\n";
        string = string + "QuestionHistory: " + this.questionHistory.toString() + "<br>\n";
        string = string + "AnswerHistory: " + this.answerHistory.toString() + "<br>\n";
        string = string + "HistoryOrder: " + this.historyOrder.toString() + "<br>\n";
        string = string + "Preanswers: " + this.preanswers.toString() + "<br>\n";
        string = string + "Action List: " + this.actionList.toString() + "<br>\n";
        string = string + "Node_Flag:" + this.node_flag + "<br>\n";
        string = string + "Node_Flag:" + this.node_flag + "<br>\n";
        string = string + "Qit_Flag:" + String.valueOf(this.qit_flag) + "<br>\n";
        string = string + "DocClassInd:" + String.valueOf(this.docClassInd) + "<br>\n";
        string = string + "SessionId:" + String.valueOf(this.sessionId) + "<br>\n";
        string = string + "CurrentSeqNo:" + String.valueOf(this.currentSeqNo) + "<br>\n";
        return string;
    }

    public OASessionState(int n) throws Exception {
        this.sessionId = n;
    }
}

