/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.oa.export;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.shared.batch.Batch;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.util.CDate;
import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class Export
extends Batch
implements Runnable {
    private static int LANG = 0;
    private static int QUEST = 1;
    private static int CDATETYPE = 1;
    private BatchLogSystem batchLog = null;
    private String dbName = null;
    private String serverName = null;
    private String portNumber = null;
    private boolean appDriverFlag = false;
    private String outputDir = null;
    private Vector ftpSite = new Vector();
    private String userId = null;
    private String password = null;
    private boolean fullExportFlag = false;
    private String timeDelta = null;
    private String outputType = null;
    private String brand = null;
    private String classification = null;
    private String geography = null;
    private Vector fileNames = new Vector();
    private int symptomCounter = 0;
    private Vector symptoms = new Vector();
    private Vector nodes = new Vector();
    private Vector actions = new Vector();
    private Vector questions = new Vector();
    private Vector edges = new Vector();
    private Vector expLinks = new Vector();
    private Thread exportThread = null;
    private boolean processFlag = false;
    private CDate todayDate = new CDate(CDATETYPE);

    public void readParameters(String[] stringArray) {
        System.out.println("Reading Command Line Parameters. # of params read : " + stringArray.length);
        this.logProgress("Reading command line parameters.  # of parameters read: " + stringArray.length, 13, 1);
        String string = null;
        String string2 = null;
        if (stringArray.length == 0) {
            Export.exportHelp();
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            string2 = string.toUpperCase();
            if (string2.startsWith("/D:")) {
                this.dbName = string.substring(3);
            } else if (string2.startsWith("/S:")) {
                this.serverName = string.substring(3);
            } else if (string2.startsWith("/P:")) {
                this.portNumber = string.substring(3);
            } else if (string2.equals("/APPDRIVER")) {
                this.appDriverFlag = true;
            } else if (string2.startsWith("/OUT:")) {
                this.outputDir = string.substring(5);
            } else if (string2.startsWith("/FTP:")) {
                this.ftpSite.addElement(string.substring(5));
            } else if (string2.startsWith("/USER:")) {
                this.userId = string.substring(6);
            } else if (string2.startsWith("/PASSWORD:")) {
                this.password = string.substring(10);
            } else if (string2.equals("/FULLEXPORT")) {
                this.fullExportFlag = true;
            } else if (string2.startsWith("/BRAND:")) {
                this.brand = string.substring(7);
                this.fullExportFlag = false;
            } else if (string2.startsWith("/CLASS:")) {
                this.classification = string.substring(7);
                this.fullExportFlag = false;
            } else if (string2.startsWith("/GEO:")) {
                this.geography = string.substring(5);
                this.fullExportFlag = false;
            } else if (string2.startsWith("/CHANGEDTIME:")) {
                this.timeDelta = string.substring(13);
            } else if (string2.startsWith("/EXPORT:")) {
                this.outputType = string.substring(8);
            } else if (string.startsWith("/?") || string.startsWith("?")) {
                Export.exportHelp();
                System.exit(1);
            } else {
                System.out.println("Unknown Parameter:  " + string);
            }
            ++n;
        }
        if (this.timeDelta == null) {
            this.timeDelta = CDate.subtractDaysFromDate(this.todayDate.today(), 1, this.todayDate.dateType);
        }
        if (this.dbName == null || !this.appDriverFlag && (this.serverName == null || this.portNumber == null) || this.userId == null || this.password == null || this.outputDir == null) {
            Export.exportHelp();
            System.exit(1);
        }
        if (this.brand == null && this.classification == null && this.geography == null) {
            this.fullExportFlag = true;
        }
        if (this.outputType == null) {
            this.outputType = "XML";
        }
        System.out.println("Exiting readParameters");
    }

    public static void exportHelp() {
        System.out.println("\nUsage:  java Export {/D:database-name /S:server_name \n/P:port-number /OUT:output-directory /FTP:ftp-site \n/USER:user-id /PASSWORD:password /EXPORT:export-type} \n\n");
        System.out.println("\n Parameter      Description");
        System.out.println(" --------------- --------------------------------------");
        System.out.println(" /D:          The database name to export.                ");
        System.out.println("              Example:  /D:QUEST");
        System.out.println(" /S:          The server name that the database resides.");
        System.out.println("              Example:    /S:CHAOS");
        System.out.println(" /P:          The port number of JDBC.");
        System.out.println("              Example:    /P:5703");
        System.out.println(" /APPDRIVER   If this parameter is passed, the batch ");
        System.out.println("              shall use the App Driver instead of the ");
        System.out.println("              default Net Driver.");
        System.out.println("              Example:    /APPDRIVER");
        System.out.println(" /OUT:        The output directory to place the exported ");
        System.out.println("              files.");
        System.out.println("              Example:    /OUT:/quest/oa/ ");
        System.out.println(" /FTP:        The FTP site to place the files.  This ");
        System.out.println("              parameter will be sectioned by semicolons.");
        System.out.println("              Example:");
        System.out.println("              /FTP:testsvr1.raleigh.ibm.com;/home/testid/oaexport;testid;testpw ");
        System.out.println("              /FTP:servername;directory;user;password");
        System.out.println(" /USER:       The user id to connect to the database    ");
        System.out.println("              with. ");
        System.out.println("              Example:    /USER:DBTESTID");
        System.out.println(" /PASSWORD:   The password for the user id.   ");
        System.out.println("              Example:    /PASSWORD:DBTESTPW");
        System.out.println(" /FULLEXPORT  If this parameter is passed, the batch shall  ");
        System.out.println("              produce a full export. All brands, classifications ");
        System.out.println("              and geographies passed will be ignored. ");
        System.out.println("              Example:    /FULLEXPORT");
        System.out.println(" /BRAND       If this parameter is passed, the batch shall  ");
        System.out.println("              produce an export for the specified Brand. ");
        System.out.println("              Example:    /BRAND:290");
        System.out.println(" /CLASS       If this parameter is passed, the batch shall  ");
        System.out.println("              produce an export for the specified Classification. ");
        System.out.println("              Example:    /CLASS:Unclassified");
        System.out.println(" /GEO         If this parameter is passed, the batch shall  ");
        System.out.println("              produce an export for the specified Geography. ");
        System.out.println("              Example:    /GEO:WorldWide");
        System.out.println(" /CHANGEDTIME:If this parameter is passed, the batch ");
        System.out.println("              shall do a delta export using this time as");
        System.out.println("              the delta. ");
        System.out.println("              Example:    /CHANGEDTIME:2000-01-07.00.00.000000");
        System.out.println(" /EXPORT:     This parameter defines whay type of output");
        System.out.println("              is needed.  The default type is XML. ");
        System.out.println("              Example:    /EXPORT:XML");
        System.out.println(" /?           This parameter displays this help message. \n");
    }

    public void startBatch() {
        this.processFlag = true;
        this.exportThread.start();
    }

    public void stopBatch() {
        this.processFlag = false;
        this.exportThread.stop();
    }

    public void run() {
        boolean bl = false;
        try {
            int n;
            if (!this.processFlag) {
                return;
            }
            if (this.appDriverFlag) {
                System.out.println("if(appDriverFlag)");
                Class.forName("COM.ibm.db2.jdbc.app.DB2Driver");
                System.out.println("Driver ok");
                new DatabaseSystem(true, this.batchLog, true);
                System.out.println("DB System object created");
                this.portNumber = "0";
                this.serverName = "";
            } else {
                new DatabaseSystem(true, this.batchLog, false);
            }
            DatabaseSystem.createConnection(1, this.dbName, this.serverName, this.portNumber, this.userId, this.password);
            System.out.println("Database connection successful.");
            this.logProgress("Database connection successful.", 13, 2);
            SQLMethod sQLMethod = new SQLMethod(1, "Export", 30);
            System.out.println("Db connection id = " + sQLMethod.getDatabaseId());
            this.logProgress("Db connection id = " + sQLMethod.getDatabaseId(), 13, 2);
            Statement statement = sQLMethod.createStatement();
            System.out.println("Statement creation successful.");
            this.logProgress("Statement creation successful.", 13, 2);
            String string = "select distinct a.symptomind from oa.symptom a, oa.symptomcountry b ";
            string = string + " where a.changedtime >= '" + this.timeDelta + "' ";
            if (!this.fullExportFlag) {
                if (this.brand != null && !this.fullExportFlag) {
                    string = string + " and a.brandind = " + this.brand;
                } else if (this.classification != null && !this.fullExportFlag) {
                    string = string + " and a.docclassind = " + this.classification;
                } else if (this.geography != null && !this.fullExportFlag) {
                    string = string + " and b.countryind = " + this.geography;
                }
            }
            System.out.println("The query qry:  " + string);
            this.logProgress("Query executed:", 13, 2);
            ResultSet resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                bl = false;
                statement.close();
            } else {
                bl = true;
                System.out.println("Getting next result.");
                this.logProgress("Getting next result.", 13, 3);
                this.symptoms.addElement(new Symptom(resultSet.getInt(1)));
                while (resultSet.next()) {
                    System.out.println("Getting next result.");
                    this.logProgress("Getting next result.", 13, 3);
                    this.symptoms.addElement(new Symptom(resultSet.getInt(1)));
                }
                this.symptomCounter = this.symptoms.size();
                n = 0;
                while (n < this.symptomCounter) {
                    System.out.println("Num of symptoms:  " + this.symptoms.size());
                    this.logProgress("Number of changed symptoms:" + this.symptoms.size(), 13, 3);
                    this.symptoms.setElementAt(this.processSymptom((Symptom)this.symptoms.elementAt(n)), n);
                    this.logProgress("Symtom " + (Symptom)this.symptoms.elementAt(n) + " processed.", 13, 6);
                    ++n;
                }
                statement.close();
            }
            DatabaseSystem.shutdown();
            System.out.println("DatabaseSystem shutdown successful.");
            this.logProgress("DatabaseSystem shutdown successful.", 13, 7);
            System.out.println("SymptomCounter:  " + this.symptomCounter);
            n = 0;
            while (n < this.symptoms.size()) {
                this.toXML((Symptom)this.symptoms.elementAt(n));
                this.logProgress("Output generated for symptom: " + this.symptoms.elementAt(n), 13, 5);
                ++n;
            }
            System.out.println("Current List of Files:  ");
            this.logProgress("Curent list of files:", 13, 6);
            n = 0;
            while (n < this.fileNames.size()) {
                if (this.fileNames.elementAt(n) != null) {
                    System.out.println(this.fileNames.elementAt(n) + "\n");
                    this.logProgress((String)this.fileNames.elementAt(n), 13, 6);
                }
                ++n;
            }
            if (!this.fileNames.isEmpty()) {
                this.ftpFiles();
                this.logProgress("Files have been ftped.", 13, 12);
            }
            BatchLogSystem.endLogSection();
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            this.processFlag = false;
        }
        this.logProgress("Batch stopped.", 13, 13);
        System.exit(0);
    }

    public Symptom processSymptom(Symptom symptom) {
        System.out.println("Reading current symptom from db.");
        this.logProgress("Reading current symptom from db.", 13, 4);
        try {
            if (symptom != null) {
                symptom = Symptom.readFromDatabase(symptom.getInd(), LANG);
                System.out.println(symptom.toString() + " was read.");
                System.out.println("Getting all associated nodes...");
                this.nodes = symptom.getNodes();
                int n = 0;
                while (n < this.nodes.size()) {
                    System.out.println("Node : " + n + " is " + this.nodes.elementAt(n));
                    Node node = (Node)this.nodes.elementAt(n);
                    node = symptom.getNodeByInd(node.getInd());
                    System.out.println("n is " + node);
                    short s = node.getNodeType();
                    if (node.isOAObjectNode()) {
                        switch (s) {
                            case 0: {
                                System.out.println("This node is an Action.");
                                this.processAction(node);
                                break;
                            }
                            case 1: {
                                System.out.println("This node is a Question.");
                                this.processQuestion(node);
                                break;
                            }
                            case 2: {
                                System.out.println("This node is a child Symptom.");
                                this.processChildSymptom(node);
                                break;
                            }
                        }
                    }
                    ++n;
                }
                Vector vector = new Vector();
                vector = symptom.getEdgeGroups();
                System.out.println("edgeGroup size " + vector.size());
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (vector.elementAt(n2) != null) {
                        System.out.println("edgeGroup " + n2 + " was not null.");
                        EdgeGroup edgeGroup = (EdgeGroup)vector.elementAt(n2);
                        System.out.println(edgeGroup);
                        Vector vector2 = new Vector();
                        vector2 = edgeGroup.getEdges();
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            if (vector2.elementAt(n3) != null) {
                                Edge edge = (Edge)vector2.elementAt(n3);
                                System.out.println("edge: " + edge);
                                this.processEdge(edge);
                            }
                            ++n3;
                        }
                    } else {
                        System.out.println("edgeGroup: " + vector.elementAt(n2) + " was null.");
                    }
                    ++n2;
                }
            } else {
                System.out.println("Symptom " + symptom.getInd() + "was null");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:  " + exception);
            this.logSevereError(exception);
            System.out.println("Problem reading and processing all of symptom " + symptom.getInd() + " from the database.");
        }
        return symptom;
    }

    public void processChildSymptom(Node node) {
        System.out.println("In method processChildSymptom.");
        Symptom symptom = new Symptom(node.getOAObjectInd());
        Symptom symptom2 = new Symptom();
        System.out.println("Current symptoms.size: " + this.symptoms.size());
        int n = 0;
        while (n < this.symptoms.size()) {
            symptom2 = (Symptom)this.symptoms.elementAt(n);
            if (symptom.getInd() == symptom2.getInd()) {
                System.out.println("Symptom: " + symptom.getInd() + " is already in the symptoms Vector.");
                return;
            }
            ++n;
        }
        System.out.println("New childSympNode created: " + symptom.getInd());
        this.symptoms.addElement(symptom);
        symptom = this.processSymptom(symptom);
        this.symptoms.setElementAt(symptom, this.symptoms.size() - 1);
    }

    public void processAction(Node node) {
        System.out.println("In method processAction.");
        this.logProgress("Reading current action from database.", 13, 4);
        Action action = new Action(node.getOAObjectInd());
        Action action2 = new Action();
        System.out.println("Current actions.size: " + this.actions.size());
        int n = 0;
        while (n < this.actions.size()) {
            action2 = (Action)this.actions.elementAt(n);
            if (action.getInd() == action2.getInd()) {
                System.out.println("Action: " + action.getInd() + " is already in the actions Vector.");
                return;
            }
            ++n;
        }
        System.out.println("New actNode created: " + action.getInd());
        this.actions.addElement(action);
        Vector vector = new Vector();
        action = Action.readFromDatabase(action.getInd(), LANG);
        if (action == null) {
            boolean bl = false;
            bl = this.actions.removeElement(action);
            return;
        }
        System.out.println("Action: " + action);
        this.actions.setElementAt(action, this.actions.size() - 1);
        vector = action.getDocLinks();
        this.processDocLinks(vector);
        this.toXML(action);
    }

    public void processDocLinks(Vector vector) {
        System.out.println("In method processDocLinks.");
        this.logProgress("Reading current docLink from database.", 13, 4);
        Vector vector2 = new Vector();
        System.out.println("docLinks size " + vector.size());
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null) {
                System.out.println("docLink " + n + " was not null.");
                DocLink docLink = (DocLink)vector.elementAt(n);
                System.out.println(docLink);
                if (docLink.hasLinkGroup()) {
                    LinkGroup linkGroup = new LinkGroup(docLink.getLinkGroupInd());
                    linkGroup = LinkGroup.readFromDatabase(linkGroup.getInd(), LANG);
                    vector2 = linkGroup.getLinks();
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        if (vector2.elementAt(n2) != null) {
                            Link link = (Link)vector2.elementAt(n2);
                            System.out.println("link: " + link);
                            Vector vector3 = link.getLinkTitles();
                            System.out.println("lTitles.size() in DocLinks: " + vector3.size());
                            this.processLink(link);
                        }
                        ++n2;
                    }
                } else {
                    this.processLink(docLink.getLinkInd());
                }
            } else {
                System.out.println("docLinks: " + vector.elementAt(n) + " was null.");
            }
            ++n;
        }
    }

    public void processLink(Link link) {
        System.out.println("In method processLinks(link).");
        this.logProgress("Reading current link from database.", 13, 4);
        if (link == null) {
            return;
        }
        System.out.println("Link: " + link);
        System.out.println("Link Ind: " + link.getInd());
        link = Link.readFromDatabase(link.getInd(), LANG);
        if (link == null) {
            System.out.println("Link was null.");
            return;
        }
        Vector vector = link.getLinkTitles();
        System.out.println("# Titles: " + vector.size());
        this.toXML(link);
    }

    public void processLink(int n) {
        System.out.println("In method processLinks(int).");
        Link link = Link.readFromDatabase(n, LANG);
        if (link == null) {
            return;
        }
        System.out.println("Link: " + link);
        this.processLink(link);
    }

    public void processQuestion(Node node) {
        System.out.println("In method processQuestion.");
        this.logProgress("Reading current quesiton from database.", 13, 4);
        Question question = new Question(node.getOAObjectInd());
        Question question2 = new Question();
        System.out.println("Current questions.size: " + this.questions.size());
        int n = 0;
        while (n < this.questions.size()) {
            question2 = (Question)this.questions.elementAt(n);
            if (question.getInd() == question2.getInd()) {
                System.out.println("Question: " + question.getInd() + " is already in the questions Vector.");
                return;
            }
            ++n;
        }
        System.out.println("New quesNode created: " + question.getInd());
        this.questions.addElement(question);
        question = Question.readFromDatabase(question.getInd(), LANG);
        if (question == null) {
            n = 0;
            n = this.questions.removeElement(question) ? 1 : 0;
            return;
        }
        System.out.println("Question: " + question);
        this.questions.setElementAt(question, this.questions.size() - 1);
        Vector vector = new Vector();
        vector = question.getDocLinks();
        this.processDocLinks(vector);
        this.toXML(question);
    }

    public void processEdge(Edge edge) {
        System.out.println("In method processEdge.");
        this.logProgress("Reading current edge from database.", 13, 4);
        System.out.println("Current edges.size: " + this.edges.size());
        int n = 0;
        while (n < this.edges.size()) {
            Edge edge2 = (Edge)this.edges.elementAt(n);
            if (edge.getInd() == edge2.getInd()) {
                System.out.println("edge: " + edge.getInd() + " is already in the edges Vector.");
                return;
            }
            ++n;
        }
        System.out.println("New edge created: " + edge.getInd());
        this.edges.addElement(edge);
        if (edge == null) {
            n = 0;
            n = this.edges.removeElement(edge) ? 1 : 0;
            return;
        }
        System.out.println("Edge: " + edge);
        this.edges.setElementAt(edge, this.edges.size() - 1);
        this.toXML(edge);
    }

    public void displayParameters() {
        if (this.dbName != null) {
            System.out.println("/D: " + this.dbName);
        }
        if (this.serverName != null) {
            System.out.println("/S: " + this.serverName);
        }
        if (this.portNumber != null) {
            System.out.println("/P: " + this.portNumber);
        }
        System.out.println("/APPDRIVER " + this.appDriverFlag);
        if (this.outputDir != null) {
            System.out.println("/OUT: " + this.outputDir);
        }
        int n = 0;
        while (n < this.ftpSite.size()) {
            if (this.ftpSite.elementAt(n) != null) {
                System.out.println("/FTP: " + this.ftpSite.elementAt(n));
            }
            ++n;
        }
        if (this.userId != null) {
            System.out.println("/USER: " + this.userId);
        }
        if (this.password != null) {
            System.out.println("/PASSWORD: " + this.password);
        }
        System.out.println("/FULLEXPORT: " + this.fullExportFlag);
        if (this.timeDelta != null) {
            System.out.println("/CHANGEDTIME: " + this.timeDelta);
        }
        if (this.outputType != null) {
            System.out.println("/EXPORT: " + this.outputType);
        }
        if (this.brand != null) {
            System.out.println("/BRAND: " + this.brand);
        }
        if (this.classification != null) {
            System.out.println("/CLASS: " + this.classification);
        }
        if (this.geography != null) {
            System.out.println("/GEO: " + this.geography);
        }
    }

    public void ftpFiles() {
        System.out.println("Entering method ftpFiles()");
        this.logProgress("Ftping files...", 13, 8);
        Ftp ftp = new Ftp();
        boolean bl = false;
        String string = null;
        System.out.println("Which sep? " + this.outputDir);
        System.out.println("Index of " + this.outputDir.indexOf("/"));
        try {
            int n = 0;
            while (n < this.ftpSite.size()) {
                if (this.ftpSite.elementAt(n) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)this.ftpSite.elementAt(n), ";");
                    System.out.println("ftpSite: " + n + " " + this.ftpSite.elementAt(n));
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    System.out.println("Which sep? " + this.outputDir);
                    System.out.println("Index of " + this.outputDir.indexOf("/"));
                    if (!this.outputDir.endsWith("/") && !this.outputDir.endsWith("\\")) {
                        string = this.outputDir.indexOf("/") >= 0 ? "/" : "\\";
                    }
                    System.out.println("outputDir:  " + this.outputDir + "\n Sep: " + string);
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    System.out.println("ftpServer: " + string2);
                    System.out.println("ftpDir: " + string3);
                    System.out.println("ftpUser: " + string4);
                    System.out.println("ftpPW: " + string5);
                    ftp.connect(string2);
                    System.out.println("Connected to : " + string2);
                    System.out.println(ftp.getReply());
                    ftp.login(string4, string5);
                    System.out.println("     as user: " + string4);
                    System.out.println(ftp.getReply());
                    this.logProgress("Connected/logged into ftp site: " + string2, 13, 9);
                    ftp.cd(string3);
                    System.out.println("     cd to dir: " + string3);
                    System.out.println(ftp.getReply());
                    this.logProgress("Changed to directory: " + string3, 13, 10);
                    int n2 = 0;
                    while (n2 < this.fileNames.size()) {
                        if (this.fileNames.elementAt(n2) != null) {
                            System.out.println("Directory: " + this.outputDir);
                            System.out.println("File: " + this.fileNames.elementAt(n2));
                            ftp.put(this.outputDir + string + (String)this.fileNames.elementAt(n2), bl);
                            System.out.println(ftp.getReply());
                            System.out.println("FTPed file " + this.fileNames.elementAt(n2) + " to server " + string2);
                            this.logProgress("File: " + this.fileNames.elementAt(n2) + " has been ftped.", 13, 11);
                        }
                        ++n2;
                    }
                    ftp.logout();
                    ftp.disconnect();
                    this.logProgress("Disconnected from ftp site.", 13, 12);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while Ftping files:  " + exception);
        }
    }

    public void toXML(Symptom symptom) {
        SymptomTitle symptomTitle = new SymptomTitle();
        Vector vector = symptom.getSymptomTitles();
        String string = "<!-- Online Assistant Symptom --> \n";
        string = string + "<SYMPTOM> \n";
        string = string + "    <IND>" + symptom.getInd() + "</IND> \n";
        string = string + "    <OABRAND>" + symptom.getBrand() + "</OABRAND> \n";
        Vector vector2 = symptom.getCountryList();
        string = string + "    <COUNTRIES>";
        if (!vector2.isEmpty() && vector2.firstElement() != null) {
            string = string + vector2.firstElement();
        }
        int n = 1;
        while (n < vector2.size()) {
            if (vector2.elementAt(n) != null) {
                string = string + ", " + vector2.elementAt(n);
            }
            ++n;
        }
        string = string + "</COUNTRIES>\n";
        string = string + "    <DOCCLASS>" + symptom.getDocClass() + "</DOCCLASS> \n";
        n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null) {
                symptomTitle = (SymptomTitle)vector.elementAt(n);
                string = string + "    <TITLE> \n";
                string = string + "        <IND>" + symptomTitle.getInd() + "</IND> \n";
                string = string + "        <TEXT>" + symptomTitle.getTitle() + "</TEXT> \n";
                vector2 = symptomTitle.getCountryList();
                string = string + "        <COUNTRIES>";
                if (!vector2.isEmpty() && vector2.firstElement() != null) {
                    string = string + vector2.firstElement();
                }
                int n2 = 1;
                while (n2 < vector2.size()) {
                    if (vector2.elementAt(n2) != null) {
                        string = string + ", " + vector2.elementAt(n2);
                    }
                    ++n2;
                }
                string = string + "</COUNTRIES>\n";
                string = string + "        <DOCCLASS>" + symptomTitle.getDocClass() + "</DOCCLASS> \n";
                string = string + "        <KEYWORDS>" + symptomTitle.getKeywords() + "</KEYWORDS> \n";
                string = string + "        <LANGUAGES>" + symptomTitle.getLanguage() + "</LANGUAGES> \n";
                string = string + "    </TITLE> \n";
            }
            ++n;
        }
        string = string + "</SYMPTOM> \n";
        try {
            System.out.println(symptom.toString());
            File file = new File(this.outputDir, "SYMPTOM_" + symptom.getInd() + ".XML");
            FileWriter fileWriter = new FileWriter(file);
            System.out.println("outFile: " + file.toString());
            this.fileNames.addElement(file.getName());
            this.logProgress("File name: " + file.toString() + " has been added to vector.", 13, 6);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            this.logProgress("File name: " + file.toString() + " has been created.", 13, 5);
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            System.out.println("Exception: " + exception);
        }
    }

    public void toXML(Edge edge) {
        Action action = new Action();
        Vector vector = edge.getActionList();
        String string = "<!-- Online Assistant Edge --> \n";
        string = string + "<EDGE> \n";
        string = string + "    <IND>" + edge.getInd() + "</IND> \n";
        Vector vector2 = edge.getCountryList();
        string = string + "    <COUNTRIES>";
        if (!vector2.isEmpty() && vector2.firstElement() != null) {
            string = string + vector2.firstElement();
        }
        int n = 1;
        while (n < vector2.size()) {
            if (vector2.elementAt(n) != null) {
                string = string + ", " + vector2.elementAt(n);
            }
            ++n;
        }
        string = string + "</COUNTRIES>\n";
        string = string + "    <DOCCLASS>" + edge.getDocClass() + "</DOCCLASS> \n";
        if (edge.isAnswerEdge()) {
            string = string + "    <ANSWER> \n";
            string = string + "        <IND>" + edge.getAnswerInd() + "</IND> \n";
            string = string + "        <QUESTION> \n";
            string = string + "            <IND>" + edge.getQuestionInd() + "</IND> \n";
            string = string + "        </QUESTION> \n";
            string = string + "    </ANSWER> \n";
        }
        n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null) {
                action = (Action)vector.elementAt(n);
                string = string + "    <ACTION> \n";
                string = string + "        <IND>" + action.getInd() + "</IND> \n";
                string = string + "    </ACTION> \n";
            }
            ++n;
        }
        string = string + "</EDGE> \n";
        try {
            System.out.println(edge.toString());
            File file = new File(this.outputDir, "EDGE_" + edge.getInd() + ".XML");
            FileWriter fileWriter = new FileWriter(file);
            System.out.println("outFile: " + file.toString());
            this.fileNames.addElement(file.getName());
            this.logProgress("File name: " + file.toString() + " has been added to vector.", 13, 6);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            this.logProgress("File name: " + file.toString() + " has been created.", 13, 5);
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            System.out.println("Exception: " + exception);
        }
    }

    public void toXML(Link link) {
        System.out.println("In method toXML(Link)");
        LanguageText languageText = new LanguageText();
        Vector vector = link.getLinkTitles();
        System.out.println("LinkTitle size= " + vector.size());
        String string = "<!-- Online Assistant Document Link --> \n";
        string = string + "<LINK> \n";
        string = string + "    <IND>" + link.getInd() + "</IND> \n";
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null) {
                languageText = (LanguageText)vector.elementAt(n);
                string = string + "    <TITLE> \n";
                string = string + "        <TEXT>" + languageText.getText() + "</TEXT> \n";
                string = string + "        <LANGUAGE>" + languageText.getLanguage() + "</LANGUAGE> \n";
                string = string + "    </TITLE> \n";
            }
            ++n;
        }
        string = string + "</LINK> \n";
        try {
            System.out.println(link.toString());
            File file = new File(this.outputDir, "LINK_" + link.getInd() + ".XML");
            FileWriter fileWriter = new FileWriter(file);
            System.out.println("outFile: " + file.toString());
            this.fileNames.addElement(file.getName());
            this.logProgress("File name: " + file.toString() + " has been added to vector.", 13, 6);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            this.logProgress("File name: " + file.toString() + " has been created.", 13, 5);
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            System.out.println("Exception: " + exception);
        }
    }

    public void toXML(Action action) {
        int n;
        Title title = new Title();
        Vector vector = action.getTitles();
        AddtlInfo addtlInfo = new AddtlInfo();
        Vector vector2 = action.getAdditionalInfo();
        String string = "<!-- Online Assistant Action --> \n";
        string = string + "<ACTION> \n";
        string = string + "    <IND>" + action.getInd() + "</IND> \n";
        string = string + "    <OABRAND>" + action.getBrand() + "</OABRAND> \n";
        Vector vector3 = action.getCountryList();
        string = string + "    <COUNTRIES>";
        if (!vector3.isEmpty() && vector3.firstElement() != null) {
            string = string + vector3.firstElement();
        }
        int n2 = 1;
        while (n2 < vector3.size()) {
            if (vector3.elementAt(n2) != null) {
                string = string + ", " + vector3.elementAt(n2);
            }
            ++n2;
        }
        string = string + "</COUNTRIES>\n";
        string = string + "    <DOCCLASS>" + action.getDocClass() + "</DOCCLASS> \n";
        n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) != null) {
                title = (Title)vector.elementAt(n2);
                string = string + "    <TITLE> \n";
                string = string + "        <IND>" + title.getInd() + "</IND> \n";
                string = string + "        <TEXT>" + title.getTitle() + "</TEXT> \n";
                vector3 = title.getCountryList();
                string = string + "        <COUNTRIES>";
                if (!vector3.isEmpty() && vector3.firstElement() != null) {
                    string = string + vector3.firstElement();
                }
                n = 1;
                while (n < vector3.size()) {
                    if (vector3.elementAt(n) != null) {
                        string = string + ", " + vector3.elementAt(n);
                    }
                    ++n;
                }
                string = string + "</COUNTRIES>\n";
                string = string + "        <DOCCLASS>" + title.getDocClass() + "</DOCCLASS> \n";
                string = string + "        <LANGUAGE>" + title.getLanguage() + "</LANGUAGE> \n";
                string = string + "    </TITLE> \n";
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            if (vector2.elementAt(n2) != null) {
                addtlInfo = (AddtlInfo)vector2.elementAt(n2);
                string = string + "    <ADDTLINFO> \n";
                string = string + "        <IND>" + addtlInfo.getInd() + "</IND> \n";
                string = string + "        <TEXT>" + addtlInfo.getAddtlInfo() + "</TEXT> \n";
                vector3 = addtlInfo.getCountryList();
                string = string + "        <COUNTRIES>";
                if (!vector3.isEmpty() && vector3.firstElement() != null) {
                    string = string + vector3.firstElement();
                }
                n = 1;
                while (n < vector3.size()) {
                    if (vector3.elementAt(n) != null) {
                        string = string + ", " + vector3.elementAt(n);
                    }
                    ++n;
                }
                string = string + "</COUNTRIES>\n";
                string = string + "        <DOCCLASS>" + addtlInfo.getDocClass() + "</DOCCLASS> \n";
                string = string + "        <LANGUAGE>" + addtlInfo.getLanguage() + "</LANGUAGE> \n";
                string = string + "    </ADDTLINFO> \n";
            }
            ++n2;
        }
        string = string + "</ACTION> \n";
        try {
            System.out.println("Action: " + action.toString());
            File file = new File(this.outputDir, "ACTION_" + action.getInd() + ".XML");
            FileWriter fileWriter = new FileWriter(file);
            System.out.println("outFile: " + file.toString());
            this.fileNames.addElement(file.getName());
            this.logProgress("File name: " + file.toString() + " has been added to vector.", 13, 6);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            this.logProgress("File name: " + file.toString() + " has been created.", 13, 5);
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            System.out.println("Exception: " + exception);
        }
    }

    public void toXML(Question question) {
        int n;
        Title title = new Title();
        Vector vector = question.getTitles();
        AddtlInfo addtlInfo = new AddtlInfo();
        Vector vector2 = question.getAdditionalInfo();
        Answer answer = new Answer();
        Vector vector3 = question.getAnswers();
        Title title2 = new Title();
        Vector vector4 = new Vector();
        String string = "<!-- Online Assistant Question --> \n";
        string = string + "<QUESTION> \n";
        string = string + "    <IND>" + question.getInd() + "</IND> \n";
        string = string + "    <OABRAND>" + question.getBrand() + "</OABRAND> \n";
        Vector vector5 = question.getCountryList();
        string = string + "    <COUNTRIES>";
        if (!vector5.isEmpty() && vector5.firstElement() != null) {
            string = string + vector5.firstElement();
        }
        int n2 = 1;
        while (n2 < vector5.size()) {
            if (vector5.elementAt(n2) != null) {
                string = string + ", " + vector5.elementAt(n2);
            }
            ++n2;
        }
        string = string + "</COUNTRIES>\n";
        string = string + "    <DOCCLASS>" + question.getDocClass() + "</DOCCLASS> \n";
        n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) != null) {
                title = (Title)vector.elementAt(n2);
                string = string + "    <TITLE> \n";
                string = string + "        <IND>" + title.getInd() + "</IND> \n";
                string = string + "        <TEXT>" + title.getTitle() + "</TEXT> \n";
                vector5 = title.getCountryList();
                string = string + "        <COUNTRIES>";
                if (!vector5.isEmpty() && vector5.firstElement() != null) {
                    string = string + vector5.firstElement();
                }
                n = 1;
                while (n < vector5.size()) {
                    if (vector5.elementAt(n) != null) {
                        string = string + ", " + vector5.elementAt(n);
                    }
                    ++n;
                }
                string = string + "</COUNTRIES>\n";
                string = string + "        <DOCCLASS>" + title.getDocClass() + "</DOCCLASS> \n";
                string = string + "        <LANGUAGE>" + title.getLanguage() + "</LANGUAGE> \n";
                string = string + "    </TITLE> \n";
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            if (vector2.elementAt(n2) != null) {
                addtlInfo = (AddtlInfo)vector2.elementAt(n2);
                string = string + "    <ADDTLINFO> \n";
                string = string + "        <IND>" + addtlInfo.getInd() + "</IND> \n";
                string = string + "        <TEXT>" + addtlInfo.getAddtlInfo() + "</TEXT> \n";
                vector5 = addtlInfo.getCountryList();
                string = string + "            <COUNTRIES>";
                if (!vector5.isEmpty() && vector5.firstElement() != null) {
                    string = string + vector5.firstElement();
                }
                n = 1;
                while (n < vector5.size()) {
                    if (vector5.elementAt(n) != null) {
                        string = string + ", " + vector5.elementAt(n);
                    }
                    ++n;
                }
                string = string + "</COUNTRIES>\n";
                string = string + "        <DOCCLASS>" + addtlInfo.getDocClass() + "</DOCCLASS> \n";
                string = string + "        <LANGUAGE>" + addtlInfo.getLanguage() + "</LANGUAGE> \n";
                string = string + "    </ADDTLINFO> \n";
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector3.size()) {
            if (vector3.elementAt(n2) != null) {
                answer = (Answer)vector3.elementAt(n2);
                answer = question.getAnswerByInd(answer.getInd());
                vector4 = answer.getTitles();
                string = string + "    <ANSWER> \n";
                string = string + "        <IND>" + answer.getInd() + "</IND> \n";
                vector5 = answer.getCountryList();
                string = string + "        <COUNTRIES>";
                if (!vector5.isEmpty() && vector5.firstElement() != null) {
                    string = string + vector5.firstElement();
                }
                n = 1;
                while (n < vector5.size()) {
                    if (vector5.elementAt(n) != null) {
                        string = string + ", " + vector5.elementAt(n);
                    }
                    ++n;
                }
                string = string + "</COUNTRIES>\n";
                string = string + "        <DOCCLASS>" + answer.getDocClass() + "</DOCCLASS> \n";
                n = 0;
                while (n < vector4.size()) {
                    if (vector4.elementAt(n) != null) {
                        title2 = (Title)vector4.elementAt(n);
                        string = string + "        <TITLE> \n";
                        string = string + "            <IND>" + title2.getInd() + "</IND> \n";
                        string = string + "            <TEXT>" + title2.getTitle() + "</TEXT> \n";
                        vector5 = title2.getCountryList();
                        string = string + "            <COUNTRIES>";
                        if (!vector5.isEmpty() && vector5.firstElement() != null) {
                            string = string + vector5.firstElement();
                        }
                        int n3 = 1;
                        while (n3 < vector5.size()) {
                            if (vector5.elementAt(n3) != null) {
                                string = string + ", " + vector5.elementAt(n3);
                            }
                            ++n3;
                        }
                        string = string + "</COUNTRIES>\n";
                        string = string + "            <DOCCLASS>" + title2.getDocClass() + "</DOCCLASS> \n";
                        string = string + "            <LANGUAGE>" + title2.getLanguage() + "</LANGUAGE> \n";
                        string = string + "        </TITLE> \n";
                    }
                    ++n;
                }
                string = string + "    </ANSWER> \n";
            }
            ++n2;
        }
        string = string + "</QUESTION> \n";
        try {
            System.out.println("Question: " + question.toString());
            File file = new File(this.outputDir, "QUESTION_" + question.getInd() + ".XML");
            FileWriter fileWriter = new FileWriter(file);
            System.out.println("outFile: " + file.toString());
            this.fileNames.addElement(file.getName());
            this.logProgress("File name: " + file.toString() + " has been added to vector.", 13, 6);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
            this.logProgress("File name: " + file.toString() + " has been created.", 13, 5);
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            System.out.println("Exception: " + exception);
        }
    }

    public static void main(String[] stringArray) {
        Export export = new Export(stringArray);
        export.startBatch();
    }

    public Export(String[] stringArray) {
        this.batchLog = new BatchLogSystem("Export", this);
        this.batchLog.batchStart();
        BatchLogSystem.beginLogSection("Online Assistant Export Batch: ");
        this.logProgress("Initialization of batch & Reading of parameters.", 13, 1);
        this.readParameters(stringArray);
        this.displayParameters();
        this.exportThread = new Thread(this);
        this.batchLog.batchStop();
    }
}

