/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.oa.imports;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.oa.imports.ImportUtil;
import com.ibm.nzna.projects.oa.imports.IndicatorDescriptionMapping;
import com.ibm.nzna.projects.oa.imports.KBIO;
import com.ibm.nzna.projects.oa.imports.OAImport;
import com.ibm.nzna.projects.oa.imports.RFileFilter;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.PersistentRec;
import java.io.File;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RFilesImporter {
    public static Hashtable questDocLinksTable = new Hashtable();
    public static Hashtable externDocLinksTable = new Hashtable();
    final String BASEDIR = OAImport.properties.getProperty("mainpath");
    final File EXTERNALDIR = new File(this.BASEDIR + "/production/");
    final File INTERNALDIR = new File(this.BASEDIR + "/production.internal/");
    final File DEALERDIR = new File(this.BASEDIR + "/production.dealer/");
    private KBIO kbio = new KBIO();
    String geo = null;
    String brand = null;
    String docClass = null;
    String[] fileList = null;
    File rFileDir = null;
    Vector mainDir = new Vector(1);
    Vector descriptV = new Vector(3);
    Hashtable actionTable = new Hashtable();
    Hashtable questionTable = new Hashtable();
    Hashtable symptomTable = new Hashtable();
    Hashtable nodeTable = new Hashtable();
    Hashtable transTable = new Hashtable();

    public void startImports() {
        String string = "a";
        String string2 = "q";
        String string3 = "s";
        String string4 = "t";
        boolean bl = false;
        System.out.println("\n=== Reading Actions ===");
        BatchLogSystem.log("\n=== Reading Actions ===");
        this.actionTable = this.readFiles(string, this.actionTable, false);
        if (!this.actionTable.isEmpty()) {
            this.importToDatabase(this.actionTable, string.toUpperCase(), false);
        }
        System.out.println("\n=== Reading Questions ===");
        BatchLogSystem.log("\n=== Reading Questions ===");
        this.questionTable = this.readFiles(string2, this.questionTable, false);
        if (!this.questionTable.isEmpty()) {
            this.importToDatabase(this.questionTable, string2.toUpperCase(), false);
        }
        System.out.println("\n=== Reading Translation Files ===");
        BatchLogSystem.log("\n=== Reading Translation Files ===");
        this.transTable = this.readFiles(string4, this.transTable, false);
        if (!this.transTable.isEmpty()) {
            this.importToDatabase(this.transTable, string4.toUpperCase(), false);
        }
        System.out.println("\n=== Reading Questions - 2nd pass ===");
        BatchLogSystem.log("\n=== Reading Questions - 2nd pass ===");
        this.questionTable = this.readFiles(string2, this.questionTable, true);
        if (!this.questionTable.isEmpty()) {
            this.importToDatabase(this.questionTable, string2.toUpperCase(), true);
        }
        System.out.println("\n=== Reading Symptoms ===");
        BatchLogSystem.log("\n=== Reading Symptoms ===");
        this.symptomTable = this.readFiles(string3, this.symptomTable, false);
        if (!this.symptomTable.isEmpty()) {
            this.importToDatabase(this.symptomTable, string3.toUpperCase(), false);
        }
        System.out.println("\n=== Reading Symptoms - 2nd pass ===");
        BatchLogSystem.log("\n=== Reading Symptoms - 2nd pass ===");
        this.symptomTable = this.readFiles(string3, this.symptomTable, true);
        if (!this.symptomTable.isEmpty()) {
            this.importToDatabase(this.symptomTable, string3.toUpperCase(), true);
        }
    }

    public Hashtable readFiles(String string, Hashtable hashtable, boolean bl) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        Hashtable hashtable2 = new Hashtable();
        Vector<String> vector = new Vector<String>();
        Object var8_8 = null;
        int n = 0;
        while (n < this.mainDir.size()) {
            BatchLogSystem.log("\n*------------------------------");
            BatchLogSystem.log("*------- Main directory -------\n" + this.mainDir.elementAt(n) + "\n");
            System.out.print("Reading " + this.mainDir.elementAt(n) + "    \r");
            stringArray2 = ((File)this.mainDir.elementAt(n)).list();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].startsWith("us")) {
                    vector.insertElementAt(stringArray2[n2], 0);
                    BatchLogSystem.log("Repositioning the US directory: " + stringArray2[n2]);
                } else {
                    vector.addElement(stringArray2[n2]);
                }
                ++n2;
            }
            if (stringArray2.length > 0) {
                n2 = 0;
                while (n2 < vector.size()) {
                    BatchLogSystem.log("This is the current directory: " + (String)vector.elementAt(n2));
                    this.rFileDir = new File(((File)this.mainDir.elementAt(n)).getPath() + (String)vector.elementAt(n2));
                    this.setDBDescriptions(this.rFileDir.getName(), this.rFileDir.getParent());
                    stringArray = this.rFileDir.list(new RFileFilter(string));
                    hashtable2 = this.processRFiles(stringArray, hashtable, bl);
                    ++n2;
                }
            }
            vector.removeAllElements();
            ++n;
        }
        return hashtable2;
    }

    public Hashtable processRFiles(String[] stringArray, Hashtable hashtable, boolean bl) {
        Object var4_4 = null;
        String string = null;
        Object var6_6 = null;
        String string2 = null;
        Object var8_8 = null;
        Hashtable hashtable2 = hashtable;
        Action action = new Action();
        Question question = new Question();
        Symptom symptom = new Symptom();
        int n = 0;
        System.out.println("SubDirectory ==> " + this.rFileDir.getAbsolutePath() + "\n");
        if (!bl) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    System.out.print("Reading (" + ++n + ") " + string + "   \r");
                    string = stringArray[n2];
                    if (string.endsWith(".r")) {
                        if ((string = string.substring(0, string.length() - 2)).toLowerCase().startsWith("a")) {
                            action = this.kbio.readAction(this.rFileDir.getPath() + "/", string, this.getDBDescriptions());
                            string2 = string.toLowerCase() + "." + (String)this.getDBDescriptions().elementAt(1);
                            if (hashtable2.isEmpty()) {
                                hashtable2.put(string2, action);
                            } else {
                                hashtable2 = this.compareActions(action, string2, hashtable2);
                            }
                        }
                        if (string.toLowerCase().startsWith("q")) {
                            question = this.kbio.readQuestion(this.rFileDir.getPath() + "/", string, this.getDBDescriptions());
                            string2 = string.toLowerCase() + "." + (String)this.getDBDescriptions().elementAt(1);
                            BatchLogSystem.log("KEY: " + string2);
                            if (hashtable2.isEmpty()) {
                                hashtable2.put(string2, question);
                            } else {
                                hashtable2 = this.compareQuestions(question, string2, hashtable2);
                            }
                        }
                        if (string.toLowerCase().startsWith("t")) {
                            hashtable2 = this.kbio.processTranslationFile(this.rFileDir.getPath() + "/", string, this.questionTable, this.transTable, this.getDBDescriptions());
                        }
                        if (string.toLowerCase().startsWith("s")) {
                            Vector vector = new Vector();
                            SymptomTitle symptomTitle = new SymptomTitle();
                            symptom = this.kbio.readSymptom(this.rFileDir.getPath() + "/", string, this.getDBDescriptions());
                            vector = symptom.getSymptomTitles();
                            symptomTitle = (SymptomTitle)vector.elementAt(0);
                            string2 = string.toLowerCase() + "." + (String)this.getDBDescriptions().elementAt(1);
                            if (hashtable2.isEmpty()) {
                                hashtable2.put(string2, symptom);
                            } else {
                                hashtable2 = this.compareSymptoms(symptom, string2, hashtable2);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BatchLogSystem.log("ProcessRFiles Exception 1st pass:  " + exception);
                }
                ++n2;
            }
        } else {
            BatchLogSystem.log("=== SECONDPASS === ");
            int n3 = 0;
            while (n3 < stringArray.length) {
                try {
                    string = stringArray[n3];
                    System.out.print("Reading (" + ++n + ") " + string + "   \r");
                    if (string.endsWith(".r")) {
                        if ((string = string.substring(0, string.length() - 2)).toLowerCase().startsWith("q")) {
                            string2 = string.toLowerCase() + "." + (String)this.getDBDescriptions().elementAt(1);
                            hashtable2 = this.kbio.readQuestion(this.rFileDir.getPath() + "/", string, this.getDBDescriptions(), hashtable, string2);
                        }
                        if (string.toLowerCase().startsWith("s")) {
                            string2 = string.toLowerCase() + "." + (String)this.getDBDescriptions().elementAt(1);
                            hashtable2 = this.kbio.readSymptom(this.rFileDir.getPath() + "/", string, this.getDBDescriptions(), this.symptomTable, this.questionTable, this.actionTable, this.nodeTable);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BatchLogSystem.log("ProcessRFiles Exception 2nd pass:  " + exception);
                }
                ++n3;
            }
        }
        this.descriptV.removeAllElements();
        return hashtable2;
    }

    public void setDBDescriptions(String string, String string2) {
        String string3 = string;
        Vector<String> vector = new Vector<String>(3);
        IndicatorDescriptionMapping indicatorDescriptionMapping = new IndicatorDescriptionMapping();
        this.geo = string3.substring(0, string3.indexOf("."));
        string3 = string3.substring(this.geo.length() + 1, string3.length());
        this.brand = string3.substring(0, string3.indexOf("."));
        string3 = string3.substring(this.brand.length() + 1, string3.length());
        this.docClass = string2.endsWith("production.dealer") ? "dealer" : string3;
        vector.addElement(this.geo);
        vector.addElement(this.brand);
        vector.addElement(this.docClass);
        this.descriptV.addElement(indicatorDescriptionMapping.mapGeoCountry((String)vector.elementAt(0)));
        this.descriptV.addElement(indicatorDescriptionMapping.mapBrand((String)vector.elementAt(1)));
        this.descriptV.addElement(indicatorDescriptionMapping.mapDocClass((String)vector.elementAt(2)));
    }

    public Vector getDBDescriptions() {
        return this.descriptV;
    }

    public Hashtable compareActions(Action action, String string, Hashtable hashtable) {
        String string2 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string3 = null;
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Hashtable hashtable2 = hashtable;
        AddtlInfo addtlInfo = new AddtlInfo();
        AddtlInfo addtlInfo2 = new AddtlInfo();
        Action action2 = new Action();
        Title title = new Title();
        BatchLogSystem.log("Comparing Actions");
        if (hashtable2.containsKey(string)) {
            action2 = (Action)hashtable2.get(string);
            vector2 = action2.getTitles();
            vector = action.getTitles();
            boolean bl = false;
            int n = 0;
            while (n < vector2.size()) {
                title = (Title)vector2.elementAt(n);
                string2 = title.getTitle();
                if (string2.equals(vector.elementAt(0).toString())) {
                    title.setDocClass(this.getDocClassForConditionalObject((Title)vector2.elementAt(n), (Title)vector.elementAt(0)));
                    Title title2 = (Title)vector.elementAt(0);
                    ImportUtil.mergeCountries((ConditionalObject)title2, (ConditionalObject)title);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector2.addElement((Title)action.getTitles().elementAt(0));
            }
            vector2 = ImportUtil.orderByGeo((Vector)vector2);
            action2.setTitles(vector2);
            ImportUtil.mergeCountries((OAObject)action, (OAObject)action2);
            n = 0;
            vector3 = action.getAdditionalInfo();
            if (action.getAdditionalInfo() != null && !vector3.isEmpty()) {
                vector4 = action2.getAdditionalInfo();
                if (vector4 == null) {
                    vector4 = new Vector();
                }
                BatchLogSystem.log("hAddInfoV.size: " + vector4.size());
                if (vector4.size() > 0) {
                    int n2 = 0;
                    while (n2 < vector4.size()) {
                        addtlInfo = (AddtlInfo)vector4.elementAt(n2);
                        string3 = addtlInfo.getAddtlInfo();
                        addtlInfo2 = (AddtlInfo)vector3.elementAt(0);
                        BatchLogSystem.log("Hashed addInfo string: " + string3);
                        BatchLogSystem.log("Incoming addInfo string: " + ((AddtlInfo)vector3.elementAt(0)).getAddtlInfo());
                        if (string3.equals(((AddtlInfo)vector3.elementAt(0)).getAddtlInfo())) {
                            TypeDocClassRec typeDocClassRec = this.getDocClassForConditionalObject(addtlInfo, addtlInfo2);
                            BatchLogSystem.log("AddInfo Question DocClass hash, incoming, result: " + addtlInfo.getDocClass().getInd() + "," + addtlInfo2.getDocClass().getInd() + "," + typeDocClassRec.getInd());
                            addtlInfo.setDocClass(this.getDocClassForConditionalObject((AddtlInfo)vector4.elementAt(n2), (AddtlInfo)vector3.elementAt(0)));
                            ImportUtil.mergeCountries((ConditionalObject)addtlInfo2, (ConditionalObject)addtlInfo);
                            n = 1;
                            break;
                        }
                        ++n2;
                    }
                }
                if (n == 0) {
                    vector4.addElement((AddtlInfo)action.getAdditionalInfo().elementAt(0));
                }
                vector4 = ImportUtil.orderByGeo(vector4);
                action2.setAdditionalInfo(vector4);
            }
        } else {
            hashtable2.put(string, action);
        }
        return hashtable2;
    }

    public Hashtable compareQuestions(Question question, String string, Hashtable hashtable) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        Hashtable hashtable2 = hashtable;
        AddtlInfo addtlInfo = new AddtlInfo();
        AddtlInfo addtlInfo2 = new AddtlInfo();
        Question question2 = new Question();
        Title title = new Title();
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        BatchLogSystem.log("Comparing questions");
        if (hashtable2.containsKey(string)) {
            PersistentRec persistentRec;
            question2 = (Question)hashtable2.get(string);
            vector2 = question2.getTitles();
            vector = question.getTitles();
            int n = 0;
            while (n < vector2.size()) {
                title = (Title)vector2.elementAt(n);
                string2 = title.getTitle();
                if (string2.equals(vector.elementAt(0).toString())) {
                    title.setDocClass(this.getDocClassForConditionalObject((Title)vector2.elementAt(n), (Title)vector.elementAt(0)));
                    Title title2 = (Title)vector.elementAt(0);
                    ImportUtil.mergeCountries((ConditionalObject)title2, (ConditionalObject)title);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector2.addElement((Title)question.getTitles().elementAt(0));
            }
            vector2 = ImportUtil.orderByGeo((Vector)vector2);
            question2.setTitles(vector2);
            ImportUtil.mergeCountries((OAObject)question, (OAObject)question2);
            n = 0;
            vector3 = question.getAdditionalInfo();
            if (question.getAdditionalInfo() != null && !vector3.isEmpty()) {
                vector4 = question2.getAdditionalInfo();
                if (vector4 == null) {
                    vector4 = new Vector();
                }
                BatchLogSystem.log("hAddInfoV.size: " + vector4.size());
                if (vector4.size() > 0) {
                    BatchLogSystem.log("inside if statement, before for loop");
                    int n2 = 0;
                    while (n2 < vector4.size()) {
                        addtlInfo = (AddtlInfo)vector4.elementAt(n2);
                        string3 = addtlInfo.getAddtlInfo();
                        addtlInfo2 = (AddtlInfo)vector3.elementAt(0);
                        BatchLogSystem.log("Hashed addInfo string: " + string3);
                        BatchLogSystem.log("Incoming addInfo string: " + ((AddtlInfo)vector3.elementAt(0)).getAddtlInfo());
                        if (string3.equals(((AddtlInfo)vector3.elementAt(0)).getAddtlInfo())) {
                            persistentRec = this.getDocClassForConditionalObject(addtlInfo, addtlInfo2);
                            BatchLogSystem.log("AddInfo Question DocClass hash, incoming, result: " + addtlInfo.getDocClass().getInd() + "," + addtlInfo2.getDocClass().getInd() + "," + ((TypeRec)persistentRec).getInd());
                            addtlInfo.setDocClass(this.getDocClassForConditionalObject((AddtlInfo)vector4.elementAt(n2), (AddtlInfo)vector3.elementAt(0)));
                            ImportUtil.mergeCountries((ConditionalObject)addtlInfo2, (ConditionalObject)addtlInfo);
                            n = 1;
                            break;
                        }
                        ++n2;
                    }
                }
                if (n == 0) {
                    vector4.addElement((AddtlInfo)question.getAdditionalInfo().elementAt(0));
                }
                vector4 = ImportUtil.orderByGeo(vector4);
                question2.setAdditionalInfo(vector4);
            }
            vector5 = question.getAnswers();
            vector6 = question2.getAnswers();
            int n3 = 0;
            while (n3 < vector6.size() && n3 < vector5.size()) {
                if (vector6.elementAt(n3) == null && vector5.elementAt(n3) != null) {
                    vector6.removeElementAt(n3);
                    vector6.insertElementAt((Answer)vector5.elementAt(n3), n3);
                    BatchLogSystem.log("Inserted new answer at position: " + n3);
                    BatchLogSystem.log("Key : " + string);
                }
                if (vector6.elementAt(n3) != null && vector5.elementAt(n3) != null) {
                    persistentRec = (Answer)vector6.elementAt(n3);
                    Answer answer = (Answer)vector5.elementAt(n3);
                    Title title3 = (Title)((Answer)persistentRec).getTitles().elementAt(0);
                    Title title4 = (Title)answer.getTitles().elementAt(0);
                    TypeDocClassRec typeDocClassRec = this.getDocClassForConditionalObject(title3, title4);
                    title3.setDocClass(typeDocClassRec);
                    ((ConditionalObject)persistentRec).setDocClass(typeDocClassRec);
                    BatchLogSystem.log("Answer DocClass hash, incoming, result: " + ((ConditionalObject)vector6.elementAt(n3)).getDocClass().getInd() + "," + ((ConditionalObject)vector5.elementAt(n3)).getDocClass().getInd() + "," + typeDocClassRec.getInd());
                    ((ConditionalObject)persistentRec).setDocClass(typeDocClassRec);
                }
                ++n3;
            }
            if (vector5.size() > vector6.size()) {
                n3 = vector6.size();
                while (n3 < vector5.size()) {
                    vector6.addElement(vector5.elementAt(n3));
                    ++n3;
                }
            }
        } else {
            hashtable2.put(string, question);
        }
        return hashtable2;
    }

    public TypeDocClassRec getDocClassForConditionalObject(ConditionalObject conditionalObject, ConditionalObject conditionalObject2) {
        TypeDocClassRec typeDocClassRec = conditionalObject2.getDocClass();
        TypeDocClassRec typeDocClassRec2 = conditionalObject.getDocClass();
        TypeDocClassRec typeDocClassRec3 = null;
        BatchLogSystem.log("Hash object docclass: " + typeDocClassRec2.getInd());
        BatchLogSystem.log("Incoming object docclass: " + typeDocClassRec.getInd());
        switch (typeDocClassRec2.getInd()) {
            case 1: {
                BatchLogSystem.log("case 1");
                if (typeDocClassRec.getInd() == 2 || typeDocClassRec.getInd() == 3) {
                    typeDocClassRec3 = typeDocClassRec;
                    break;
                }
                typeDocClassRec3 = typeDocClassRec2;
                break;
            }
            case 2: {
                BatchLogSystem.log("case 2");
                if (typeDocClassRec.getInd() == 3) {
                    typeDocClassRec3 = typeDocClassRec;
                    break;
                }
                if (typeDocClassRec.getInd() != 1 && typeDocClassRec.getInd() != 2) break;
                typeDocClassRec3 = typeDocClassRec2;
                break;
            }
            case 3: {
                BatchLogSystem.log("case 3");
                typeDocClassRec3 = typeDocClassRec2;
                break;
            }
        }
        BatchLogSystem.log("Docclass set to: " + typeDocClassRec3.getInd());
        return typeDocClassRec3;
    }

    public Hashtable compareSymptoms(Symptom symptom, String string, Hashtable hashtable) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        SymptomTitle symptomTitle = null;
        SymptomTitle symptomTitle2 = null;
        Hashtable hashtable2 = hashtable;
        Symptom symptom2 = new Symptom();
        boolean bl = false;
        BatchLogSystem.log("Comparing Symptoms");
        if (hashtable2.containsKey(string)) {
            symptom2 = (Symptom)hashtable2.get(string);
            vector2 = symptom2.getSymptomTitles();
            vector = symptom.getSymptomTitles();
            symptomTitle2 = (SymptomTitle)vector.elementAt(0);
            int n = 0;
            while (n < vector2.size()) {
                String string2;
                symptomTitle = (SymptomTitle)vector2.elementAt(n);
                String string3 = symptomTitle.getTitle();
                if (string3.equals(string2 = symptomTitle2.getTitle())) {
                    symptomTitle.setDocClass(this.getSymptomTitleDocClass(symptomTitle, symptomTitle2));
                    bl = true;
                    ImportUtil.mergeCountries((SymptomTitle)symptomTitle2, (SymptomTitle)symptomTitle);
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector2.addElement(symptomTitle2);
                BatchLogSystem.log("added symptom title: " + symptomTitle2);
            }
            vector2 = ImportUtil.orderSymptomTitlesByGeo((Vector)vector2);
            symptom2.setSymptomTitles(vector2);
        } else {
            hashtable2.put(string, symptom);
            BatchLogSystem.log("symptom is new");
        }
        return hashtable2;
    }

    public TypeDocClassRec getSymptomTitleDocClass(SymptomTitle symptomTitle, SymptomTitle symptomTitle2) {
        TypeDocClassRec typeDocClassRec = symptomTitle2.getDocClass();
        TypeDocClassRec typeDocClassRec2 = symptomTitle.getDocClass();
        TypeDocClassRec typeDocClassRec3 = null;
        switch (typeDocClassRec2.getInd()) {
            case 1: {
                if (typeDocClassRec.getInd() == 2 || typeDocClassRec.getInd() == 3) {
                    typeDocClassRec3 = typeDocClassRec;
                    break;
                }
                typeDocClassRec3 = typeDocClassRec2;
                break;
            }
            case 2: {
                if (typeDocClassRec.getInd() == 3) {
                    typeDocClassRec3 = typeDocClassRec;
                    break;
                }
                if (typeDocClassRec.getInd() != 1 && typeDocClassRec.getInd() != 2) break;
                typeDocClassRec3 = typeDocClassRec2;
                break;
            }
            case 3: {
                typeDocClassRec3 = typeDocClassRec2;
                break;
            }
        }
        return typeDocClassRec3;
    }

    public void importToDatabase(Hashtable hashtable, String string, boolean bl) {
        Enumeration enumeration = hashtable.elements();
        Enumeration enumeration2 = hashtable.keys();
        System.out.println("\nImporting objects to database");
        BatchLogSystem.log("Importing objects to database");
        int n = 0;
        switch (string.charAt(0)) {
            case 'A': {
                Action action = new Action();
                Title title = new Title();
                String string2 = null;
                System.out.println("\nTotal Actions: " + hashtable.size());
                while (enumeration2.hasMoreElements()) {
                    try {
                        BatchLogSystem.log("\nKEY: " + enumeration2.nextElement());
                        action = (Action)enumeration.nextElement();
                        Vector vector = action.getTitles();
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            title = (Title)vector.elementAt(n2);
                            string2 = title.getTitle();
                            ++n2;
                        }
                        System.out.print("Writing Action " + ++n + "   \r");
                        action.writeToDatabase();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case 'Q': {
                String string3 = null;
                Question question = new Question();
                Vector vector = new Vector();
                System.out.println("\nTotal Questions: " + hashtable.size());
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    try {
                        BatchLogSystem.log("\nKEY: " + string3);
                        question = (Question)enumeration.nextElement();
                        vector = question.getDocLinks();
                        if (bl) {
                            question.updateRecStatus(1);
                        }
                        Vector vector2 = question.getAnswers();
                        Vector vector3 = new Vector();
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            if (vector2.elementAt(n3) != null) {
                                vector3.addElement(vector2.elementAt(n3));
                            }
                            ++n3;
                        }
                        question.setAnswers(vector3);
                        System.out.print("Writing Question " + ++n + "   \r");
                        question.writeToDatabase();
                        question.setAnswers(vector2);
                    }
                    catch (Exception exception) {
                        BatchLogSystem.log("\nKEY: " + string3 + "\n" + exception);
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case 'S': {
                Symptom symptom = new Symptom();
                System.out.println("\nTotal Symptoms: " + hashtable.size());
                while (enumeration2.hasMoreElements()) {
                    try {
                        BatchLogSystem.log("\nKEY: " + enumeration2.nextElement());
                        symptom = (Symptom)enumeration.nextElement();
                        if (bl) {
                            symptom.updateRecStatus(1);
                        }
                        System.out.print("Writing Symptom " + ++n + "    \r");
                        symptom.writeToDatabase();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case 'T': {
                SQLMethod sQLMethod = null;
                Statement statement = null;
                Integer n4 = null;
                Integer n5 = null;
                Integer n6 = null;
                Vector vector = new Vector();
                Vector vector4 = new Vector();
                int n7 = 0;
                n = 0;
                sQLMethod = new SQLMethod(1, "RFilesImporter.importToDatabase()", 5);
                statement = sQLMethod.createStatement();
                BatchLogSystem.log("*** UPDATING OA.PRODUCTCONCL Table");
                if (!hashtable.isEmpty()) {
                    while (enumeration2.hasMoreElements()) {
                        BatchLogSystem.log("KEY: " + enumeration2.nextElement());
                        vector = (Vector)enumeration.nextElement();
                        BatchLogSystem.log("indicatorlist.size " + vector.size());
                        n4 = (Integer)vector.elementAt(0);
                        vector4 = (Vector)vector.elementAt(1);
                        n5 = (Integer)vector.elementAt(2);
                        try {
                            int n8 = 0;
                            while (n8 < vector4.size()) {
                                n6 = (Integer)vector4.elementAt(n8);
                                BatchLogSystem.log("prodint and answerind " + n4 + " " + n6);
                                n7 = statement.executeUpdate("insert into oa.productconcl( productind, answerind, brandind,dbuser,changedtime) values (" + n4 + ", " + n6 + ", " + n5 + ", '', CURRENT TIMESTAMP )");
                                ++n8;
                            }
                            ++n;
                        }
                        catch (SQLException sQLException) {
                            BatchLogSystem.log("SQLException: " + sQLException);
                            sQLException.printStackTrace();
                        }
                        catch (Exception exception) {
                            BatchLogSystem.log("Table size: " + hashtable.size());
                            exception.printStackTrace();
                        }
                    }
                    BatchLogSystem.log("Number of written product conclusions: " + n);
                }
                sQLMethod.close();
                BatchLogSystem.log("Finished processing Translation files\n");
                break;
            }
        }
    }

    public void logTables() {
        Serializable serializable;
        String string = null;
        Enumeration enumeration = this.actionTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            serializable = (Action)this.actionTable.get(string);
            BatchLogSystem.log("Action: " + string + " --> " + ((Action)serializable).getInd());
        }
        enumeration = this.questionTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            serializable = (Question)this.questionTable.get(string);
            BatchLogSystem.log("Question: " + string + " --> " + ((Question)serializable).getInd());
        }
        enumeration = this.symptomTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            serializable = (Symptom)this.symptomTable.get(string);
            BatchLogSystem.log("Symptom: " + string + " --> " + ((Symptom)serializable).getInd());
        }
        enumeration = this.nodeTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            serializable = (Node)this.nodeTable.get(string);
            BatchLogSystem.log("Node: " + string + " --> " + ((Node)serializable).getInd());
        }
        enumeration = this.transTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            serializable = (Vector)this.transTable.get(string);
            BatchLogSystem.log("Model: " + string + " --> " + serializable);
        }
    }

    public RFilesImporter() {
        this.mainDir.addElement(this.INTERNALDIR);
        this.mainDir.addElement(this.EXTERNALDIR);
        this.mainDir.addElement(this.DEALERDIR);
        this.startImports();
        BatchLogSystem.log("IMPORTS DONE");
        BatchLogSystem.log("Writing rFile -> Indicator logs");
        this.logTables();
    }
}

