/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.doc;

import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.admin.doc.ReadDocsCSV;
import com.ibm.nzna.projects.qit.admin.doc.ReadDocsSingleLine;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.QuestProcess;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DocPublishCheck
extends JPanel
implements QuestProcess,
Runnable,
ActionListener,
AppConst,
QuestPanel {
    private JLabel st_FILENAME = null;
    private JTextField ef_FILENAME = null;
    private DButton pb_BROWSE = null;
    private JLabel st_FILE_TYPE = null;
    private JRadioButton rb_SINGLE_LINE = null;
    private JRadioButton rb_CSV = null;
    private DButton pb_START = null;
    private JScrollPane outputScroll = null;
    private JTextArea output = null;
    private JLabel st_OUTPUT = null;
    private JLabel st_WEB_SITE = null;
    private JComboBox cb_WEB_SITE = null;
    private ActionButton pb_CLOSE = null;
    private boolean processing = false;
    private String outputString = "";
    private boolean continueProcessing = true;
    private int docClassInd = 0;

    public boolean initialize() {
        ButtonGroup buttonGroup = new ButtonGroup();
        Vector<String> vector = new Vector<String>(3);
        vector.addElement(Str.getStr(117));
        vector.addElement(Str.getStr(119));
        vector.addElement(Str.getStr(118));
        new QuickSort(vector);
        this.st_FILENAME = new JLabel(Str.getStr(1626));
        this.ef_FILENAME = new JTextField("");
        this.pb_BROWSE = new DButton(Str.getStr(393));
        this.st_FILE_TYPE = new JLabel(Str.getStr(1629));
        this.rb_SINGLE_LINE = new JRadioButton(Str.getStr(1627));
        this.rb_CSV = new JRadioButton(Str.getStr(1628));
        this.pb_START = new DButton(Str.getStr(1263));
        this.output = new JTextArea();
        this.outputScroll = new JScrollPane(this.output);
        this.st_OUTPUT = new JLabel(Str.getStr(1291));
        this.st_WEB_SITE = new JLabel(Str.getStr(1207));
        this.cb_WEB_SITE = new JComboBox(vector);
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(28));
        this.rb_SINGLE_LINE.setOpaque(false);
        this.rb_CSV.setOpaque(false);
        this.st_FILENAME.setOpaque(false);
        this.st_FILE_TYPE.setOpaque(false);
        this.setBackground(Color.white);
        this.output.setFont(this.pb_CLOSE.getFont());
        this.output.setEditable(false);
        buttonGroup.add(this.rb_SINGLE_LINE);
        buttonGroup.add(this.rb_CSV);
        this.pb_BROWSE.addActionListener(this);
        this.pb_START.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_FILENAME);
        this.add(this.ef_FILENAME);
        this.add(this.pb_BROWSE);
        this.add(this.st_FILE_TYPE);
        this.add(this.rb_SINGLE_LINE);
        this.add(this.rb_CSV);
        this.add(this.st_WEB_SITE);
        this.add(this.cb_WEB_SITE);
        this.add(this.pb_START);
        this.add(this.st_OUTPUT);
        this.add(this.outputScroll);
        this.output.setText("Staring");
        return true;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        this.st_FILENAME.setBounds(n, n2, 250, n3);
        this.ef_FILENAME.setBounds(n, n2 += n3, 250, n3);
        this.pb_BROWSE.setBounds(n, n2 += n3, 85, n3);
        this.st_FILE_TYPE.setBounds(n, n2 += n3 * 2, 250, n3);
        this.rb_SINGLE_LINE.setBounds(n, n2 += n3, dimension.width, n3);
        this.rb_CSV.setBounds(n, n2 += n3, dimension.width, n3);
        this.st_WEB_SITE.setBounds(n, n2 += n3 * 2, 250, n3);
        this.cb_WEB_SITE.setBounds(n + 250, n2, 250, n3);
        this.pb_START.setBounds(dimension.width / 2 - 40, n2 += n3 * 2, 80, n3 + 2);
        this.st_OUTPUT.setBounds(n, n2 += n3 * 2, dimension.width - n * 2, n3);
        this.outputScroll.setBounds(n, n2 += n3, dimension.width - n * 2, dimension.height - n2 - 5);
    }

    public boolean bookmark() {
        return false;
    }

    public void refresh() {
    }

    public void panelDeselected() {
    }

    public void panelSelected() {
    }

    public boolean pasteText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean copyText() {
        return false;
    }

    public boolean shutdown() {
        return !this.processing;
    }

    public boolean stop() {
        return !this.processing;
    }

    public JComponent getJComponent() {
        return this;
    }

    public void start() {
        GUISystem.getParentDefWin(this).addActionComponent(this, this.pb_CLOSE);
    }

    public NavPanel getDefaultNavPanel() {
        return null;
    }

    public String getName() {
        return Str.getStr(1630);
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 121);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_BROWSE) {
            File[] fileArray = GUISystem.getFileOpen(GUISystem.getParentDefWin(this), Str.getStr(1626), "", true);
            if (fileArray != null && fileArray.length > 0) {
                this.ef_FILENAME.setText(fileArray[0].getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.pb_START) {
            new Thread(this).start();
        } else if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, null);
        }
    }

    public void run() {
        String string = this.ef_FILENAME.getText();
        boolean bl = false;
        Vector vector = null;
        this.output.setText("");
        this.outputString = "";
        this.continueProcessing = true;
        this.processing = true;
        if (FileUtil.exists(string)) {
            if (this.rb_SINGLE_LINE.isSelected() || this.rb_CSV.isSelected()) {
                ProcessManagerSystem.addProcess(this);
                if (this.cb_WEB_SITE.getSelectedItem().equals(Str.getStr(117))) {
                    this.docClassInd = 3;
                }
                try {
                    String string2 = FileUtil.readFile(string);
                    this.addOutput("Processing Document File:" + string);
                    if (this.rb_SINGLE_LINE.isSelected()) {
                        vector = ReadDocsSingleLine.read(string2, this.output);
                    } else if (this.rb_CSV.isSelected()) {
                        vector = ReadDocsCSV.read(string2, this.output);
                    }
                    if (vector != null && vector.size() > 0) {
                        SQLMethod sQLMethod = new SQLMethod(1, "DocPublishCheck", 5);
                        try {
                            Statement statement = sQLMethod.createStatement();
                            int n = 0;
                            int n2 = vector.size();
                            AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
                            this.addOutput("\n\nFinished Reading File\n-----------------------------------------");
                            this.addOutput("Total Possible Document Lookups: " + n2 + "\n\nLooking up documents");
                            appDefaultWin.setStatus(14);
                            appDefaultWin.setValueMax(n2);
                            while (n < n2 && this.continueProcessing) {
                                this.documentIsWebable((String)vector.elementAt(n), statement);
                                appDefaultWin.setValue(++n);
                            }
                            appDefaultWin.setStatus(null);
                            appDefaultWin.setValue(0);
                            if (this.continueProcessing) {
                                GUISystem.printBox(7, 375);
                            }
                        }
                        catch (Exception exception) {
                            sQLMethod.rollBack();
                            LogSystem.log(1, exception, false);
                            bl = false;
                            this.addOutput("Processing stopped due to exception");
                            GUISystem.printBox(7, 202);
                        }
                        sQLMethod.close();
                    } else {
                        this.addOutput("No Possible Document Lookups found in file");
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception, false);
                    bl = false;
                    this.addOutput("Processing stopped due to exception");
                    GUISystem.printBox(7, 202);
                }
                ProcessManagerSystem.removeProcess(this);
                this.addOutput(bl ? "Process Complete" : "Process Complete with Errors");
            } else {
                GUISystem.printBox(7, 1632);
            }
        } else {
            GUISystem.printBox(7, 1631);
        }
        this.processing = false;
    }

    public String getProcessName() {
        return "DOC_PUB_THREAD_CHECK";
    }

    public void stopProcess() {
        this.continueProcessing = false;
    }

    public void addOutput(String string) {
        this.outputString = this.outputString + string + "\n";
        this.output.setText(this.outputString);
    }

    private void documentIsWebable(String string, Statement statement) throws Exception {
        ResultSet resultSet = statement.executeQuery("SELECT WEBABLE, PUBLISH, DBUSER, CHANGEDTIME, DOCCLASSIND FROM TIGRIS.DOCUMENTS " + "WHERE LNDOCID = '" + string + "' FOR FETCH ONLY");
        if (resultSet.next()) {
            String string2 = resultSet.getString(1).trim();
            String string3 = resultSet.getString(2).trim();
            String string4 = UserSystem.getNameFromUserId(resultSet.getString(3).trim());
            String string5 = DateSystem.prettyDateFromStamp(resultSet.getString(4).trim());
            int n = resultSet.getInt(5);
            if (string3.equals("N")) {
                this.addOutput("Document: " + string + " was deleted by " + string4 + " on " + string5);
            } else if (string2.equals("N")) {
                this.addOutput("Document: " + string + " is not Webable");
            } else if (n < this.docClassInd) {
                this.addOutput("Document: " + string + " will not appear on the web site " + this.cb_WEB_SITE.getSelectedItem() + " because it's classification is '" + TypeList.getInstance().objectFromInd(n, 5) + "'");
            }
        } else {
            this.addOutput("Cannot find document:" + string);
        }
        resultSet.close();
    }
}

