/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.keyword;

import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.qit.admin.AdminConst;
import com.ibm.nzna.projects.qit.admin.keyword.KeywordList;
import com.ibm.nzna.projects.qit.admin.keyword.KeywordNavPanel;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.print.Preview;
import com.ibm.nzna.projects.qit.print.PreviewPanel;
import com.ibm.nzna.projects.qit.print.Print;
import com.ibm.nzna.projects.qit.print.PrintPanel;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KeywordPanel
extends JPanel
implements PrintPanel,
PreviewPanel,
AdminConst,
AppConst,
QuestPanel,
ActionListener {
    private static final String[] listTitle = new String[]{"", "", "", "", ""};
    private KeywordNavPanel defaultNavPanel = null;
    private ActionButton pb_EXPORT = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_EDIT = null;
    private ActionButton pb_NEW = null;
    private ActionButton pb_DELETE = null;
    private JTitle st_TITLE = null;
    private MultiList cnr_DATA = null;
    private KeywordList currentKeywordList = null;

    public boolean initialize() {
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_EDIT = new ActionButton(Str.getStr(50), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(50));
        this.pb_NEW = new ActionButton(Str.getStr(171), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(171));
        this.pb_DELETE = new ActionButton(Str.getStr(172), ImageSystem.getImageIcon((Object)this, 58), Str.getStr(172));
        this.pb_EXPORT = new ActionButton(Str.getStr(1193), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(1193));
        this.st_TITLE = new JTitle("");
        this.cnr_DATA = new MultiList(GUISystem.getFontUtil());
        this.defaultNavPanel = new KeywordNavPanel(this);
        this.cnr_DATA.setColumnHeadings(listTitle);
        this.cnr_DATA.setColumnWidth(0, 250);
        this.pb_EXPORT.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_NEW.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.pb_DELETE.addActionListener(this);
        this.cnr_DATA.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.st_TITLE, "North");
        this.add((Component)this.cnr_DATA, "Center");
        return true;
    }

    public void start() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        appDefaultWin.addActionComponent(this, this.pb_CLOSE);
        appDefaultWin.addActionComponent(this, this.pb_NEW);
        appDefaultWin.addActionComponent(this, this.pb_EDIT);
        appDefaultWin.addActionComponent(this, this.pb_DELETE);
        appDefaultWin.addActionComponent(this, this.pb_EXPORT);
    }

    public void refresh() {
        if (this.currentKeywordList != null) {
            Vector vector = this.currentKeywordList.getKeywords();
            new QuickSort(vector);
            this.cnr_DATA.setData(vector);
        }
    }

    public boolean copyText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public String getName() {
        return Str.getStr(15028);
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 114);
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public NavPanel getDefaultNavPanel() {
        return this.defaultNavPanel;
    }

    public boolean stop() {
        this.removeAll();
        return true;
    }

    public boolean shutdown() {
        return true;
    }

    public JComponent getJComponent() {
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, null);
        } else if (actionEvent.getSource() == this.pb_EDIT || actionEvent.getSource() == this.cnr_DATA) {
            Object object;
            if (this.currentKeywordList != null && this.currentKeywordList.edit(object = this.cnr_DATA.getSelectedItem())) {
                this.refresh();
                this.cnr_DATA.setSelectedItem(object, true);
            }
        } else if (actionEvent.getSource() == this.pb_DELETE) {
            TypeRec typeRec = (TypeRec)this.cnr_DATA.getSelectedItem();
            if (typeRec != null) {
                if (this.currentKeywordList != null && this.currentKeywordList.delete(this.cnr_DATA.getSelectedItem())) {
                    this.refresh();
                }
            } else {
                GUISystem.printBox(7, 358);
            }
        } else if (actionEvent.getSource() == this.pb_NEW) {
            if (this.currentKeywordList != null) {
                Object object = this.currentKeywordList.add();
                this.refresh();
                this.cnr_DATA.setSelectedItem(object, true);
            }
        } else if (actionEvent.getSource() == this.pb_EXPORT && this.currentKeywordList != null) {
            this.export();
        }
    }

    protected void setKeywordList(KeywordList keywordList) {
        this.currentKeywordList = keywordList;
        this.st_TITLE.setText(this.currentKeywordList.getName());
        this.cnr_DATA.removeAll();
        this.cnr_DATA.setColumnHeadings(this.currentKeywordList.getTitles());
        if (keywordList.toString().equals(Str.getStr(15037))) {
            this.cnr_DATA.setColumnWidth(0, 40);
            this.cnr_DATA.setColumnWidth(1, 100);
            this.cnr_DATA.setColumnWidth(2, 450);
        } else {
            this.cnr_DATA.setColumnWidth(0, 250);
        }
        this.refresh();
    }

    public boolean bookmark() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void export() {
        File[] fileArray = GUISystem.getFileOpen(GUISystem.getParentDefWin(this), Str.getStr(1193), PropertySystem.getString(30), false);
        if (fileArray == null) return;
        if (fileArray.length <= 0) return;
        try {
            this.cnr_DATA.exportToFile(fileArray[0].toString());
            GUISystem.printBox(7, 375);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox(6, 202);
        }
    }

    public Object getPrintObject() {
        return new Print(this.cnr_DATA, GUISystem.getParentDefWin(this), Str.getStr(353));
    }

    public Object getPreviewObject() {
        return new Preview(this.cnr_DATA, GUISystem.getParentDefWin(this), Str.getStr(353));
    }
}

