/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.keyword;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeGroupRec;
import com.ibm.nzna.projects.qit.admin.keyword.FamilyBrandStep;
import com.ibm.nzna.projects.qit.admin.keyword.FamilyNameStep;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.wizard.InfoStep;
import com.ibm.nzna.shared.gui.wizard.Wizard;
import com.ibm.nzna.shared.gui.wizard.WizardEvent;
import com.ibm.nzna.shared.gui.wizard.WizardListener;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JDialog;

public class NewFamilyWizard
extends JDialog
implements WizardListener,
AppConst {
    private Wizard wizardPanel = null;
    private WizardStep[] steps = null;

    private void createWizardSteps() {
        this.steps = new WizardStep[3];
        this.steps[0] = new InfoStep(Str.getStr(1329));
        this.steps[1] = new FamilyNameStep(this);
        this.steps[2] = new FamilyBrandStep(this);
    }

    public void cancelPerformed(WizardEvent wizardEvent) {
        this.dispose();
    }

    public void finishPerformed(WizardEvent wizardEvent) {
        String string = ((FamilyNameStep)this.steps[1]).getName();
        TypeBrandRec typeBrandRec = ((FamilyBrandStep)this.steps[2]).getBrand();
        if (string == null || string.length() == 0 || typeBrandRec == null) {
            GUISystem.printBox(7, 1330);
        } else {
            this.saveFamily(string, typeBrandRec);
            this.dispose();
        }
    }

    public void nextPerformed(WizardEvent wizardEvent) {
        int n = this.indexFromStep(wizardEvent.getWizardStep());
        this.wizardPanel.setCurrentStep(this.steps[++n]);
        this.adjustButtons();
    }

    public void backPerformed(WizardEvent wizardEvent) {
        this.adjustButtons();
    }

    private void adjustButtons() {
        WizardStep wizardStep = this.wizardPanel.getCurrentStep();
        if (wizardStep == this.steps[0]) {
            this.wizardPanel.showButtons(true, false, true, false);
        } else if (wizardStep == this.steps[this.steps.length - 1]) {
            this.wizardPanel.showButtons(false, true, false, true);
        } else {
            this.wizardPanel.showButtons(true, true, true, false);
        }
    }

    private int indexFromStep(WizardStep wizardStep) {
        int n = 0;
        int n2 = 0;
        while (n == 0 && n2 < this.steps.length) {
            if (this.steps[n2] == wizardStep) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public void processNext() {
        this.wizardPanel.processNext();
    }

    public void saveFamily(String string, TypeBrandRec typeBrandRec) {
        if (DatabaseSystem.createConnection(2, Constants.getStrConst("IT_CLIODBNAME"), Constants.getStrConst("IT_CLIOSERVER"), Constants.getStrConst("IT_CLIOPORTNUM"), "esupport", "ESUPP0RT")) {
            int n = this.getCLIOBrandInd(typeBrandRec.toString());
            try {
                SQLMethod sQLMethod = new SQLMethod(1, "saveFamily", 5);
                SQLMethod sQLMethod2 = new SQLMethod(2, "saveFamily(CLIO)", 5);
                try {
                    Statement statement = sQLMethod.createStatement();
                    Statement statement2 = sQLMethod2.createStatement();
                    int n2 = Counter.getCounter(LogSystem.getInstance(), "GROUPIND");
                    int n3 = Counter.getCounter(LogSystem.getInstance(), "BGIND");
                    TypeGroupRec typeGroupRec = new TypeGroupRec(n2, string, n3, typeBrandRec.getInd());
                    if (n > 0) {
                        statement.executeUpdate("INSERT INTO TIGRIS.TYPEGROUP " + "( GROUPIND, LANGUAGEIND, DESCRIPT, OWNER, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + n2 + ", " + "  1, " + "  '" + string + "', " + "  '" + UserSystem.getUserId() + "', " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP)");
                        statement2.executeUpdate("INSERT INTO CLIO.TYPEGROUP " + "( GROUPID, DESCRIPT, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + n2 + ", " + "  '" + string + "', " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP)");
                        statement.executeUpdate("INSERT INTO TIGRIS.BRANDS " + "(BRANDGROUPIND, BRANDIND, GROUPIND, TEMPLATEIND, DBUSER, CHANGEDTIME) " + "VALUES " + "( " + n3 + ", " + "  " + typeBrandRec.getInd() + ", " + "  " + n2 + ", " + "  0, " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP)");
                        statement2.executeUpdate("INSERT INTO CLIO.BRANDS " + "(BRANDIND, BRANDID, GROUPID, DBUSER, CHANGEDTIME) " + "VALUES " + "( " + n3 + ", " + "  " + n + ", " + "  " + n2 + ", " + " '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP)");
                    } else {
                        GUISystem.printBox(7, 1331);
                    }
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    sQLMethod2.rollBack();
                    LogSystem.log(1, exception, false);
                    GUISystem.printBox(7, 202);
                }
                sQLMethod.close();
                sQLMethod2.close();
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
            }
        } else {
            GUISystem.printBox(7, 1294);
        }
    }

    private int getCLIOBrandInd(String string) {
        SQLMethod sQLMethod = new SQLMethod(2, "getCLIOBrandInd", 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT BRANDID FROM CLIO.TYPEBRAND WHERE DESCRIPT = '" + string + "'");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return n;
    }

    public NewFamilyWizard(AppDefaultWin appDefaultWin) {
        super(appDefaultWin, Str.getStr(1326), true);
        try {
            this.wizardPanel = new Wizard(ImageSystem.getImageIcon((Object)this, 185));
            this.wizardPanel.addWizardListener(this);
        }
        catch (Exception exception) {
            this.wizardPanel = new Wizard();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.wizardPanel, "Center");
        this.createWizardSteps();
        this.wizardPanel.setCurrentStep(this.steps[0]);
        ((Component)this).setSize(495, 375);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }
}

