/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.property;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.ConstantsRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.NavPanelWrapper;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.print.Preview;
import com.ibm.nzna.projects.qit.print.PreviewPanel;
import com.ibm.nzna.projects.qit.print.Print;
import com.ibm.nzna.projects.qit.print.PrintPanel;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertyPanel
extends JPanel
implements PrintPanel,
PreviewPanel,
ActionListener,
ListSelectionListener,
AppConst,
QuestPanel {
    private static String[] propertyTitles = new String[]{Str.getStr(1320), Str.getStr(1321), Str.getStr(1322), Str.getStr(52)};
    private MultiList propertyList = null;
    private JTitle st_PROPERTY = null;
    private JLabel stt_PROPERTY = null;
    private JLabel st_PROPERTY_NAME = null;
    private JLabel st_INT_VALUE = null;
    private JTextField ef_INT_VALUE = null;
    private JLabel st_STRING_VALUE = null;
    private JTextField ef_STRING_VALUE = null;
    private JLabel st_APPLICATION = null;
    private JTextField ef_APPLICATION = null;
    private JScrollPane scr_DESCRIPTION = null;
    private JTextArea mle_DESCRIPTION = null;
    private NavPanelWrapper navPanel = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_NEW = null;
    private DButton pb_SAVE = null;
    private ConstantsRec constantRec = null;

    public boolean initialize() {
        this.propertyList = new MultiList(GUISystem.getFontUtil());
        this.mle_DESCRIPTION = new JTextArea();
        this.scr_DESCRIPTION = new JScrollPane(this.mle_DESCRIPTION);
        this.navPanel = new NavPanelWrapper(Str.getStr(100), this.scr_DESCRIPTION);
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(28));
        this.pb_NEW = new ActionButton(Str.getStr(171), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(171));
        this.st_PROPERTY = new JTitle(Str.getStr(51));
        this.stt_PROPERTY = new JLabel(Str.getStr(1320));
        this.st_PROPERTY_NAME = new JLabel("");
        this.st_INT_VALUE = new JLabel(Str.getStr(1321));
        this.st_STRING_VALUE = new JLabel(Str.getStr(1322));
        this.ef_INT_VALUE = new JTextField(new MaskDocument(3, 5), "", 0);
        this.ef_STRING_VALUE = new JTextField(new MaskDocument(0, 50), "", 0);
        this.st_APPLICATION = new JLabel(Str.getStr(52));
        this.ef_APPLICATION = new JTextField(new MaskDocument(0, 50), "", 0);
        this.pb_SAVE = new DButton(Str.getStr(515));
        this.propertyList.setBorder(null);
        this.propertyList.setColumnHeadings(propertyTitles);
        this.propertyList.setColumnWidth(0, 200);
        this.propertyList.setColumnWidth(1, 75);
        this.propertyList.setColumnWidth(2, 250);
        this.propertyList.setColumnWidth(3, 250);
        this.mle_DESCRIPTION.setFont(FontSystem.defaultFont);
        this.mle_DESCRIPTION.setWrapStyleWord(true);
        this.mle_DESCRIPTION.setLineWrap(true);
        this.st_PROPERTY_NAME.setForeground(Color.blue);
        this.propertyList.addListSelectionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_SAVE.addActionListener(this);
        this.ef_INT_VALUE.addActionListener(this);
        this.ef_STRING_VALUE.addActionListener(this);
        this.ef_APPLICATION.addActionListener(this);
        this.pb_NEW.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_PROPERTY);
        this.add(this.propertyList);
        this.add(this.stt_PROPERTY);
        this.add(this.st_PROPERTY_NAME);
        this.add(this.st_INT_VALUE);
        this.add(this.ef_INT_VALUE);
        this.add(this.st_STRING_VALUE);
        this.add(this.ef_STRING_VALUE);
        this.add(this.st_APPLICATION);
        this.add(this.ef_APPLICATION);
        this.add(this.pb_SAVE);
        return true;
    }

    public void doLayout() {
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        Dimension dimension = this.getSize();
        super.doLayout();
        this.st_PROPERTY.setBounds(n, n2, dimension.width - n * 2, n3 * 2);
        this.propertyList.setBounds(n, n2 += n3 * 2, dimension.width - n * 2, dimension.height - n3 * 12);
        n2 = dimension.height - n3 * 9;
        this.stt_PROPERTY.setBounds(n, n2, 200, n3);
        this.st_PROPERTY_NAME.setBounds(n + 200, n2, 200, n3);
        this.st_INT_VALUE.setBounds(n, n2 += n3, 200, n3);
        this.ef_INT_VALUE.setBounds(n + 200, n2, 200, n3);
        this.st_STRING_VALUE.setBounds(n, n2 += n3 + 2, 200, n3);
        this.ef_STRING_VALUE.setBounds(n + 200, n2, 200, n3);
        this.st_APPLICATION.setBounds(n, n2 += n3 + 2, 200, n3);
        this.ef_APPLICATION.setBounds(n + 200, n2, 200, n3);
        this.pb_SAVE.setBounds(n, n2 += n3 + 5, 100, 25);
    }

    public void start() {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        appDefaultWin.addActionComponent(this, this.pb_CLOSE);
        appDefaultWin.addActionComponent(this, this.pb_NEW);
        this.refresh();
    }

    public JComponent getJComponent() {
        return this;
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    public boolean copyText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public boolean stop() {
        return true;
    }

    public boolean shutdown() {
        return true;
    }

    public boolean bookmark() {
        return false;
    }

    public String getName() {
        return Str.getStr(51);
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 183);
    }

    public void refresh() {
        Constants constants = new Constants();
        Vector vector = null;
        GUISystem.getParentDefWin(this).setStatus(Str.getStr(14));
        Constants.refreshConstants(LogSystem.getInstance());
        vector = constants.getConstantVector();
        this.propertyList.removeAll();
        this.propertyList.add(vector);
        GUISystem.getParentDefWin(this).setStatus(null);
    }

    private final String getDescription(String string) {
        if (string.equals("IT_FILEURL")) {
            return "This value is prepended to file names that are attached" + "to documents to form a complete URL. For example, if the " + "filename is '/pub/pccbbs/mobiles/mytext.txt' then when the " + "file is attached, the location of the file will be " + "IT_FILEURL/pub/pccbbs/mobiles/mytext.txt";
        }
        if (string.equals("IT_PRODFTP")) {
            return "This is the production FTP site to place file attachments " + "that have been published with the Quest Input Tool. This should " + "contain only the host name or I/P Address of the FTP server";
        }
        if (string.equals("IT_IMAGELOCTEMP")) {
            return "This is the location on the TEMPORARY FTP server that draft documents " + "store their Images. The images will only reside in that directory " + "for as long as the document draft is alive.";
        }
        if (string.equals("IT_IMAGEHOST")) {
            return "This is the location of the production machine to FTP published " + "graphics in a document to. For example, if a document has 2 graphics and " + "the user publishes the document, those 2 graphics are FTPed to this " + "host. This should be the host name or I/P Address of the FTP site";
        }
        if (string.equals("IT_FILEHOSTTEMP")) {
            return "This is the host name of the FTP server to store files for " + "document drafts. If the user creates a new draft with a file attachment " + "and then saves the draft, this FTP site is used to put the file attachments";
        }
        if (string.equals("IT_FILELOC")) {
            return "This is the location on the FTP Server to store files that have been " + "published. If a document has 2 file attachments and the user publishses" + "that document, the file attachments are placed in this location, on the IT_PRODFTP server";
        }
        if (string.equals("IT_IMAGELOC")) {
            return "This is the location to put published images on the IT_IMAGEHOST FTP server. " + "If a document has 3 graphics with it and the user publishes the document, all " + "graphics are put in this directory";
        }
        if (string.equals("IT_IMAGEHOSTTEMP")) {
            return "This is the FTP site that image files are placed " + "temporarily until a document draft is published. For " + "example, if a document draft has 3 images then when " + "the user saves it, the images are put on this FTP site. " + "This value should be either a host name or preferable an I/P Address";
        }
        if (string.equals("IT_FILEHOST")) {
            return "This is the host name for the FTP site that stores the production " + "file attachments. For example if a document draft has 3 file attachments " + "and the user publishes the document, all file attachments are placed " + "on this FTP site. This should either be the host name or preferably the I/P Address";
        }
        if (string.equals("IT_FILELOCTEMP")) {
            return "This is the location on the IT_FILEHOSTTEMP server to " + "place temporary files for document drafts. For example, " + "if a document draft has 3 file attachments and the user " + "saves it, the file attachments are placed in this directory";
        }
        if (string.equals("IT_VER")) {
            return "DANGER DANGER DANGER DANGER DANGER DANGER. This property " + "tells the Quest Input tool what version it should be at. If this " + "number is different then what is running on the clients, then the " + "quest input tool will auto-update itself";
        }
        if (string.equals("IT_OA_FTP_IMG_DRFT")) {
            return "This is the FTP site for images to be placed while an Avalon " + "object is in draft mode. For example, if an Action has 3 graphics and " + "the user saves it, the graphics will be placed on this FTP server. " + "This should be either the host name or I/P Address";
        }
        if (string.equals("IT_OA_FTP_IMG_LOC_DRFT")) {
            return "This is the the location on the IT_OA_FTP_IMG_DRFT " + "server that temporary graphics are placed while a draft " + "object in Avalon is alive. For example, if an Action has 3 graphics and " + "the user saves it, the graphics will be placed on this FTP server. ";
        }
        if (string.equals("IT_OA_FTP_IMG_LOC_PUB")) {
            return "This is the location on the IT_OA_FTP_IMG_PUB " + "server that graphics are published to. For example, " + "if an Action has 3 graphics and the user publishes it, " + "the graphics are put in this directory on the FTP server";
        }
        if (string.equals("IT_OA_FTP_IMG_PUB")) {
            return "This is the host name of the FTP site where published " + "graphics are stored. For example, if the user has an Action Draft " + "and that Action has 3 graphics and they publish the Action, the " + "graphics are placed on this FTP site. This should be either the " + "host name or I/P Address of the FTP site";
        }
        if (string.equals("IT_HELP_URL")) {
            return "This is the base URL of all Help files. For example, if the " + "help files are placed on the root of bigdawg, then this url would be " + "http://bigdawg.raleigh.ibm.com";
        }
        if (string.equals("IT_CLIOSERVER")) {
            return "This is the server that is housing the CLIO database. This should " + "be the full host name or I/P Address";
        }
        if (string.equals("IT_DEBUG_EMAIL")) {
            return "This is the eMail Address that the Quest Client will eMail if the " + "user chooses to send the QUEST.DEBUG file";
        }
        if (string.equals("IT_DEBUG_SMTP")) {
            return "This is the host name or IP Address of the SMTP server that " + "the Quest client uses to send a Quest.Debug file";
        }
        if (string.equals("IT_CLIOPORTNUM")) {
            return "This is the port number that db2jstrt is listening on the " + "IT_CLIOSERVER server for the CLIO database";
        }
        if (string.equals("IT_CLIODBNAME")) {
            return "This is the name of the database on the IT_CLIOSERVER " + "that Quest will attempt to connect to";
        }
        return "No Description yet";
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.constantRec = (ConstantsRec)this.propertyList.getSelectedItem();
        this.mle_DESCRIPTION.setText(this.getDescription(this.constantRec.getConstant()));
        this.ef_INT_VALUE.setText("" + this.constantRec.getIntValue());
        this.ef_STRING_VALUE.setText("" + this.constantRec.getStringValue());
        this.ef_APPLICATION.setText("" + this.constantRec.getApplication());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, null);
        } else if (actionEvent.getSource() == this.pb_SAVE || actionEvent.getSource() == this.ef_APPLICATION) {
            this.save();
        } else if (actionEvent.getSource() == this.pb_NEW) {
            this.newConstant();
        } else if (actionEvent.getSource() == this.ef_INT_VALUE) {
            this.ef_STRING_VALUE.requestFocus();
        } else if (actionEvent.getSource() == this.ef_STRING_VALUE) {
            this.ef_APPLICATION.requestFocus();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void save() {
        SQLMethod sQLMethod = new SQLMethod(1, "PropertyPanel.save", 5);
        this.constantRec.setIntValue(new Integer(this.ef_INT_VALUE.getText()));
        this.constantRec.setStringValue(this.ef_STRING_VALUE.getText());
        this.constantRec.setApplication(this.ef_APPLICATION.getText());
        try {
            Statement statement = sQLMethod.createStatement();
            if (statement != null) {
                statement.executeUpdate("UPDATE TIGRIS.CONSTANTS " + "SET INTCONST    = " + this.constantRec.getIntValue() + ", " + "    STRCONST    = '" + this.constantRec.getStringValue() + "', " + "    APPLICATION = '" + this.constantRec.getApplication() + "' " + "WHERE CONSTANT = '" + this.constantRec.getConstant() + "'");
            }
            GUISystem.printBox(7, 1323);
            this.propertyList.repaint();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(6, 202);
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void newConstant() {
        String string = new SingleEntryDlg((Frame)GUISystem.getParentDefWin(this), "New Constant", "Please enter the name of the new constant", "", "").getResult();
        if (string != null && string.length() > 0) {
            SQLMethod sQLMethod = new SQLMethod(1, "newConstant", 5);
            try {
                Statement statement = sQLMethod.createStatement();
                statement.executeUpdate("INSERT INTO TIGRIS.CONSTANTS VALUES ( '" + string + "', 0, ' ', ' ', user, current timestamp)");
                this.constantRec = new ConstantsRec(string, 0, " ", " ");
                this.propertyList.add(this.constantRec);
                this.propertyList.setSelectedItem(this.constantRec, true);
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 202);
            }
            sQLMethod.close();
        }
    }

    public Object getPrintObject() {
        return new Print(this.propertyList, GUISystem.getParentDefWin(this), Str.getStr(353));
    }

    public Object getPreviewObject() {
        return new Preview(this.propertyList, GUISystem.getParentDefWin(this), Str.getStr(353));
    }
}

