/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.stats;

import com.ibm.nzna.projects.common.quest.type.TypeDocCatRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.admin.stats.StatDocRec;
import com.ibm.nzna.projects.qit.admin.stats.StatProductRec;
import com.ibm.nzna.projects.qit.admin.stats.StatsPanel;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class StatsExport
implements AppConst {
    public static final int OUTPUT_HTML = 1;
    public static final int OUTPUT_COMMA = 2;
    private Vector documents = new Vector(1000, 1);
    private String dbUser = null;
    private Vector headers = null;
    private int rowsExported = 0;
    private boolean oddLine = false;
    private FileOutputStream outputStream = null;
    private String toDate = null;
    private String date = null;
    private String filename = null;
    private int outputType = 2;
    private AppDefaultWin defaultWin = null;
    private StatsPanel statsPanel = null;

    public void setDBUser(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.dbUser = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int exportChangedBodyDocuments() {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "StatsExport.exportChangedBodyDocuments", 100);
        long l = System.currentTimeMillis();
        this.defaultWin.setStatus("Reading Initial Document List ...", false);
        try {
            int n2 = 0;
            int n3 = 0;
            StatDocRec statDocRec = null;
            int n4 = -1;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.DOCIND,         STARTDATE,  STOPDATE,       LNDOCID,     " + "         EXISTINGDOCIND, TITLE,      A.OWNER,        REQUESTOR,   " + "         METRICIND,      DOCTYPEIND, WORKIND,        DOCCLASSIND, " + "       A.CHANGEDTIME,    A.DBUSER,   FAQ,            FLASHDATE, " + "         EMAILABLE,      STATUSIND,  D.DESCRIPTION,  D.CATEGORYLEVEL  " + "FROM QUEST.DOCUMENTS A, " + "     QUEST.DOCSTATUS B, " + "     QUEST.CATEGORY  C, " + "     PRODUCT.TYPECATEGORY D " + "WHERE TEMPLATE = 'N' AND " + "      A.DOCIND = B.DOCIND AND " + "      B.RECNUM = 2 AND " + "      A.CHANGEDTIME > '" + this.date + "' AND " + "      A.CHANGEDTIME < '" + this.toDate + "' AND " + "      COMMENT LIKE '%BODY HAS BEEN CHANGED%' AND " + "      A.DOCIND = C.DOCIND AND " + "      C.TYPECATIND = D.TYPECATIND " + (this.dbUser != null ? "AND A.DBUSER = '" + this.dbUser + "' " : "") + "ORDER BY STARTDATE, A.DOCIND");
            this.createDocumentHeaders();
            this.beginOutFile("Changed Documents");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    this.rowsExported = n2;
                    this.endOutFile();
                    break;
                }
                if (resultSet.getInt(1) != n4) {
                    if (statDocRec != null) {
                        System.out.println("Writing Document " + statDocRec.existingDocInd);
                        this.exportDocument(statDocRec);
                    }
                    statDocRec = null;
                    n4 = resultSet.getInt(1);
                }
                if (statDocRec == null) {
                    statDocRec = new StatDocRec(resultSet.getInt(1), resultSet.getString(2).trim());
                    statDocRec.stopDate = resultSet.getString(3);
                    statDocRec.notesId = resultSet.getString(4);
                    statDocRec.existingDocInd = resultSet.getInt(5);
                    statDocRec.title = resultSet.getString(6).trim();
                    statDocRec.owner = resultSet.getString(7).trim();
                    statDocRec.requestor = resultSet.getString(8).trim();
                    statDocRec.metricInd = resultSet.getInt(9);
                    statDocRec.docTypeInd = resultSet.getInt(10);
                    statDocRec.workInd = resultSet.getInt(11);
                    statDocRec.docClassInd = resultSet.getInt(12);
                    statDocRec.changedTime = DateSystem.prettyDateFromStamp(resultSet.getString(13));
                    statDocRec.dbUser = resultSet.getString(14).trim();
                    statDocRec.faq = resultSet.getString(15).trim();
                    statDocRec.hotNewsDate = resultSet.getString(16);
                    statDocRec.eMailable = resultSet.getString(17);
                    ++n2;
                    ++n;
                    if (++n3 > 20) {
                        this.defaultWin.setStatus("Exporting Documents. Currently exported " + n2 + " documents", false);
                        n3 = 0;
                    }
                }
                if (resultSet.getString(20).trim().equals("brand")) {
                    statDocRec.brands = statDocRec.brands + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("family")) {
                    statDocRec.family = statDocRec.family + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("subcategory")) {
                    statDocRec.machines = statDocRec.machines + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("machine")) {
                    statDocRec.machines = statDocRec.machines + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("model")) {
                    statDocRec.models = statDocRec.models + resultSet.getString(19).trim() + "; ";
                    continue;
                }
                if (!resultSet.getString(20).trim().equals("partnum")) continue;
                statDocRec.models = statDocRec.models + resultSet.getString(19).trim() + "; ";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            exception.printStackTrace();
            GUISystem.printBox(7, 202);
        }
        this.defaultWin.setStatus(null);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int exportAllDocuments() {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "StatsExport.exportAllDocuments", 100);
        long l = System.currentTimeMillis();
        this.defaultWin.setStatus("Reading Initial Document List ...", false);
        try {
            this.createDocumentHeaders();
            this.beginOutFile("All Documents");
            int n2 = 0;
            int n3 = 0;
            StatDocRec statDocRec = null;
            int n4 = -1;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.DOCIND,         STARTDATE,  STOPDATE,       LNDOCID,     " + "         EXISTINGDOCIND, TITLE,      A.OWNER,        REQUESTOR,   " + "         METRICIND,      DOCTYPEIND, WORKIND,        DOCCLASSIND, " + "       A.CHANGEDTIME,    A.DBUSER,   FAQ,            FLASHDATE, " + "         EMAILABLE,      STATUSIND,  D.DESCRIPTION,  D.CATEGORYLEVEL  " + "FROM QUEST.DOCUMENTS A, " + "     QUEST.DOCSTATUS B, " + "     QUEST.CATEGORY  C, " + "     PRODUCT.TYPECATEGORY D " + "WHERE TEMPLATE = 'N' AND " + "      A.DOCIND = B.DOCIND AND " + "      B.RECNUM = 2 AND " + "      A.CHANGEDTIME > '" + this.date + "' AND " + "      A.CHANGEDTIME < '" + this.toDate + "' AND " + "      A.DOCIND = C.DOCIND AND " + "      C.TYPECATIND = D.TYPECATIND " + (this.dbUser != null ? "AND A.DBUSER = '" + this.dbUser + "' " : "") + "ORDER BY STARTDATE, A.DOCIND");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    this.rowsExported = n2;
                    this.endOutFile();
                    break;
                }
                if (resultSet.getInt(1) != n4) {
                    if (statDocRec != null) {
                        this.exportDocument(statDocRec);
                    }
                    statDocRec = null;
                    n4 = resultSet.getInt(1);
                }
                if (statDocRec == null) {
                    statDocRec = new StatDocRec(resultSet.getInt(1), resultSet.getString(2).trim());
                    statDocRec.stopDate = resultSet.getString(3);
                    statDocRec.notesId = resultSet.getString(4);
                    statDocRec.existingDocInd = resultSet.getInt(5);
                    statDocRec.title = resultSet.getString(6).trim();
                    statDocRec.owner = resultSet.getString(7).trim();
                    statDocRec.requestor = resultSet.getString(8).trim();
                    statDocRec.metricInd = resultSet.getInt(9);
                    statDocRec.docTypeInd = resultSet.getInt(10);
                    statDocRec.workInd = resultSet.getInt(11);
                    statDocRec.docClassInd = resultSet.getInt(12);
                    statDocRec.changedTime = DateSystem.prettyDateFromStamp(resultSet.getString(13));
                    statDocRec.dbUser = resultSet.getString(14).trim();
                    statDocRec.faq = resultSet.getString(15).trim();
                    statDocRec.hotNewsDate = resultSet.getString(16);
                    statDocRec.eMailable = resultSet.getString(17);
                    ++n2;
                    ++n;
                    if (++n3 > 20) {
                        this.defaultWin.setStatus("Exporting Documents. Currently exported " + n2 + " documents", false);
                        n3 = 0;
                    }
                }
                if (resultSet.getString(20).trim().equals("brand")) {
                    statDocRec.brands = statDocRec.brands + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("family")) {
                    statDocRec.family = statDocRec.family + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("subcategory")) {
                    statDocRec.machines = statDocRec.machines + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("machine")) {
                    statDocRec.machines = statDocRec.machines + resultSet.getString(19).trim() + "(All); ";
                    continue;
                }
                if (resultSet.getString(20).trim().equals("model")) {
                    statDocRec.models = statDocRec.models + resultSet.getString(19).trim() + "; ";
                    continue;
                }
                if (!resultSet.getString(20).trim().equals("partnum")) continue;
                statDocRec.models = statDocRec.models + resultSet.getString(19).trim() + "; ";
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            exception.printStackTrace();
            GUISystem.printBox(7, 202);
        }
        this.defaultWin.setStatus(null);
        return n;
    }

    private final FileOutputStream beginOutFile(String string) throws Exception {
        String string2 = "";
        this.outputStream = new FileOutputStream(new File(this.filename));
        System.out.println("Creating file " + this.filename);
        string2 = string2 + string;
        if (this.dbUser != null) {
            string2 = string2 + " for " + UserSystem.getNameFromUserId(this.dbUser);
        }
        switch (this.outputType) {
            case 1: {
                this.outputStream.write(new String("<html>\n<meta tag=\"Generated by the great Quest\">\n<body>\n<font size=2 color=black face=\"Helvetica, Arial\"><font size=3>\n" + "<b>Quest Database Export - " + string2 + "</b></font><br>\n" + "<font color=\"800080\">Date:</font><font size=2>" + DateSystem.getDate(2) + "</font><br>\n" + "<font color=\"800080\">Export Run By:</font>" + UserSystem.getUserName() + "<br><br>\n" + "<br><br>\nResults<br><br>\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n").getBytes());
                break;
            }
            case 2: {
                this.outputStream.write(new String("Quest Database Export " + string2 + "\nDate:" + DateSystem.getDate(2) + "\nExport Run By:" + UserSystem.getUserName() + "\n").getBytes());
                break;
            }
        }
        return this.outputStream;
    }

    private final void write(Vector vector, boolean bl) throws Exception {
        switch (this.outputType) {
            case 1: {
                if (this.oddLine) {
                    this.oddLine = false;
                    this.outputStream.write("   <tr bgcolor=\"#F4F4F4\">\n".getBytes());
                    break;
                }
                this.oddLine = true;
                this.outputStream.write("   <tr bgcolor=\"#FFFFFF\">\n".getBytes());
                break;
            }
        }
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            String string = null;
            while (n < n2 - 1) {
                string = (String)vector.elementAt(n);
                if (string == null) {
                    string = "";
                }
                switch (this.outputType) {
                    case 2: {
                        if (string != null && string.indexOf(",") != -1) {
                            string = Text.replaceAllStrInStr(string, ",", "");
                        }
                        this.outputStream.write((string + ",").toString().getBytes());
                        break;
                    }
                    case 1: {
                        if (bl) {
                            this.outputStream.write(("      <td><font face=\"Helvetica, Arial\" color=black size=2><b><u>" + string + "</b></u></font></td>\n").getBytes());
                            break;
                        }
                        this.outputStream.write(("      <td><font face=\"Helvetica, Arial\" color=black size=2>" + string + "</font></td>\n").getBytes());
                        break;
                    }
                }
                ++n;
            }
            string = (String)vector.elementAt(n);
            switch (this.outputType) {
                case 2: {
                    this.outputStream.write(string.toString().trim().getBytes());
                    break;
                }
                case 1: {
                    if (bl) {
                        this.outputStream.write(("      <td><font face=\"Helvetica, Arial\" color=black size=2><b><u>" + string + "</b></u></font></td>\n").getBytes());
                        break;
                    }
                    this.outputStream.write(("      <td><font face=\"Helvetica, Arial\" color=black size=2>" + string + "</font></td>\n").getBytes());
                    break;
                }
            }
        }
        switch (this.outputType) {
            case 1: {
                this.outputStream.write("   </tr>\n".getBytes());
                break;
            }
            case 2: {
                this.outputStream.write("\n".getBytes());
            }
        }
    }

    private final void createDocumentHeaders() {
        this.headers = new Vector(10, 1);
        this.headers.addElement("Classification");
        this.headers.addElement("Quest Indicator");
        this.headers.addElement("Notes Id");
        this.headers.addElement("Active Indicator");
        this.headers.addElement("Title");
        this.headers.addElement("Start Date");
        this.headers.addElement("Stop Date");
        this.headers.addElement("Age");
        this.headers.addElement("Owner");
        this.headers.addElement("Requestor");
        this.headers.addElement("Metric");
        this.headers.addElement("Doc Type");
        this.headers.addElement("Status");
        this.headers.addElement("Published User");
        this.headers.addElement("FAQ Flag");
        this.headers.addElement("Hot News Date");
        this.headers.addElement("Work Required");
        this.headers.addElement("eMailable");
        this.headers.addElement("Brands");
        this.headers.addElement("Families");
        this.headers.addElement("Machines");
        this.headers.addElement("Models");
        this.headers.addElement("Categories");
        this.headers.addElement("Last Update Date");
    }

    private final void createProductHeaders() {
        this.headers = new Vector(10, 1);
        this.headers.addElement("Brand");
        this.headers.addElement("Family");
        this.headers.addElement("Sub Category");
        this.headers.addElement("Machine");
        this.headers.addElement("Model");
        this.headers.addElement("Part Number");
        this.headers.addElement("Product Number");
        this.headers.addElement("Description");
        this.headers.addElement("Last Touched By");
        this.headers.addElement("Last Touched When");
        this.headers.addElement("Export Type");
    }

    private final void exportDocument(StatDocRec statDocRec) throws Exception {
        Vector<String> vector = new Vector<String>(10);
        vector.addElement(TypeList.getInstance().objectFromInd(statDocRec.docClassInd, 5).toString());
        vector.addElement("" + statDocRec.docInd);
        vector.addElement(statDocRec.notesId);
        vector.addElement("" + statDocRec.existingDocInd);
        vector.addElement(statDocRec.title);
        vector.addElement(statDocRec.startDate);
        vector.addElement(statDocRec.stopDate);
        vector.addElement(this.getDocumentAge(statDocRec));
        vector.addElement(UserSystem.getNameFromUserId(statDocRec.owner));
        vector.addElement(UserSystem.getNameFromUserId(statDocRec.requestor));
        vector.addElement(TypeList.getInstance().objectFromInd(statDocRec.metricInd, 11).toString());
        vector.addElement(TypeList.getInstance().objectFromInd(statDocRec.docTypeInd, 4).toString());
        vector.addElement(statDocRec.status);
        vector.addElement(UserSystem.getNameFromUserId(statDocRec.dbUser));
        vector.addElement(statDocRec.faq);
        vector.addElement(statDocRec.hotNewsDate);
        vector.addElement(TypeList.getInstance().objectFromInd(statDocRec.workInd, 14).toString());
        vector.addElement(statDocRec.eMailable);
        vector.addElement(statDocRec.brands);
        vector.addElement(statDocRec.family);
        vector.addElement(statDocRec.machines);
        vector.addElement(statDocRec.models);
        vector.addElement(statDocRec.categories);
        vector.addElement(statDocRec.changedTime);
        this.write(vector, false);
    }

    private final void exportProduct(StatProductRec statProductRec) throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.addElement(statProductRec.brand);
        vector.addElement(statProductRec.family);
        vector.addElement(statProductRec.subCategory);
        vector.addElement(statProductRec.machine);
        vector.addElement(statProductRec.model);
        vector.addElement(statProductRec.partNumber);
        vector.addElement(statProductRec.productNumber);
        vector.addElement(statProductRec.description);
        vector.addElement(statProductRec.lastTouchedBy);
        vector.addElement(statProductRec.lastTouchedOn);
        vector.addElement(statProductRec.exportType);
        this.write(vector, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getDocumentAge(StatDocRec statDocRec) {
        String string = "0";
        try {
            statDocRec.stopDate = statDocRec.stopDate.trim();
        }
        catch (Exception exception) {
            statDocRec.stopDate = null;
        }
        if (statDocRec.stopDate == null) return "" + CDate.differenceDate(new CDate().getDate(10), statDocRec.startDate, 10) + " Day(s)";
        if (statDocRec.stopDate.length() < 2) return "" + CDate.differenceDate(new CDate().getDate(10), statDocRec.startDate, 10) + " Day(s)";
        return "" + CDate.differenceDate(statDocRec.stopDate, statDocRec.startDate, 10) + " Day(s)";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endOutFile() {
        try {
            switch (this.outputType) {
                case 1: {
                    this.outputStream.write(("</table><br><br>Total: " + this.rowsExported + "</font>\n</body></html>").getBytes());
                    break;
                }
            }
            this.outputStream.close();
            return;
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getDocumentCategories(Vector vector) {
        SQLMethod sQLMethod = new SQLMethod(1, "getDocumentStatus", 5);
        String string = "";
        long l = System.currentTimeMillis();
        try {
            TypeList typeList = TypeList.getInstance();
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            boolean bl = false;
            int n = vector.size();
            String string2 = "SELECT DOCIND, DOCCATIND FROM QUEST.DOCCATEGORY " + "WHERE DOCIND IN " + this.createInClause(vector) + " FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                int n2 = resultSet.getInt(1);
                TypeDocCatRec typeDocCatRec = (TypeDocCatRec)typeList.objectFromInd(resultSet.getInt(2), 10);
                StatDocRec statDocRec = this.getStatDocRec(n2, vector);
                if (statDocRec == null) continue;
                if (statDocRec.categories == null) {
                    statDocRec.categories = typeDocCatRec.toString();
                    continue;
                }
                statDocRec.categories = statDocRec.categories + ";" + typeDocCatRec.toString();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        System.out.println("   Reading Categories Took:" + (System.currentTimeMillis() - l) + "(ms)");
        return string;
    }

    private final void getDocumentBFTM(Vector vector) {
    }

    private final StatDocRec getStatDocRec(int n, Vector vector) {
        int n2 = 0;
        int n3 = vector.size();
        StatDocRec statDocRec = null;
        while (statDocRec == null && n2 < n3) {
            if (((StatDocRec)vector.elementAt((int)n2)).docInd == n) {
                statDocRec = (StatDocRec)vector.elementAt(n2);
            }
            ++n2;
        }
        return statDocRec;
    }

    private final String createInClause(Vector vector) {
        String string = "(";
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            string = string + ((StatDocRec)vector.elementAt((int)n)).docInd;
            if (n < n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        return string + ")";
    }

    protected void setDate(String string) {
        this.date = CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 1);
    }

    protected void setToDate(String string) {
        this.toDate = CDate.createDate(CDate.parse(string, 7, 2), CDate.parse(string, 8, 2), CDate.parse(string, 9, 2), 0, 0, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int exportProducts() {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "StatsExport.exportChangedBodyDocuments", 100);
        try {
            boolean bl = false;
            boolean bl2 = false;
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            long l = System.currentTimeMillis();
            int n2 = 0;
            StatProductRec statProductRec = null;
            this.defaultWin.setStatus("Reading Initial Product List ...", false);
            this.createProductHeaders();
            this.beginOutFile("Products");
            resultSet = statement.executeQuery("SELECT A.DESCRIPTION, A.CATEGORYLEVEL,  B.DESCRIPTION, " + "       B.PRODNUM,     B.LASTTOUCHEDBY,  B.LASTTOUCHEDON, " + "       B.SOURCE,      B.PRODUCTIND,     B.TYPECANCELIND " + "FROM PRODRAFT.TYPECATEGORY A, " + "     PRODRAFT.PRODUCT B, " + "     PRODRAFT.CATEGORY C " + "WHERE B.STOPDATE IS NOT NULL AND " + "      B.TEMPLATE = 'N' AND " + "      B.PRODUCTIND = C.PRODUCTIND AND " + "      A.TYPECATIND = C.TYPECATIND AND " + "      B.LASTTOUCHEDON > '" + this.date + "' AND " + "      B.LASTTOUCHEDON < '" + this.toDate + "' " + (this.dbUser != null ? "AND A.LASTTOUCHEDBY = '" + this.dbUser + "' " : "") + "ORDER BY B.PRODUCTIND " + "FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    this.endOutFile();
                    break;
                }
                if (resultSet.getInt(8) != n2) {
                    if (statProductRec != null) {
                        this.exportProduct(statProductRec);
                    }
                    statProductRec = null;
                    n2 = resultSet.getInt(8);
                }
                if (statProductRec == null) {
                    String string = resultSet.getString(7).trim();
                    statProductRec = new StatProductRec();
                    statProductRec.description = resultSet.getString(3).trim();
                    statProductRec.productNumber = resultSet.getString(4).trim();
                    statProductRec.lastTouchedBy = resultSet.getString(5).trim();
                    statProductRec.lastTouchedOn = resultSet.getString(6).trim();
                    if (string.indexOf("OPIC/M") != -1) {
                        int n3 = resultSet.getInt(9);
                        statProductRec.exportType = !statProductRec.lastTouchedBy.equals("PRODGEN") ? "2" : "1";
                        if (n3 != 0) {
                            statProductRec.exportType = "4";
                        }
                    } else {
                        statProductRec.exportType = "3";
                    }
                }
                if (resultSet.getString(2).trim().equals("brand")) {
                    statProductRec.brand = resultSet.getString(1).trim();
                } else if (resultSet.getString(2).trim().equals("family")) {
                    statProductRec.family = resultSet.getString(1).trim();
                } else if (resultSet.getString(2).trim().equals("subcategory")) {
                    statProductRec.subCategory = resultSet.getString(1).trim();
                } else if (resultSet.getString(2).trim().equals("machine")) {
                    statProductRec.machine = resultSet.getString(1).trim();
                } else if (resultSet.getString(2).trim().equals("model")) {
                    statProductRec.model = resultSet.getString(1).trim();
                } else if (resultSet.getString(2).trim().equals("partnum")) {
                    statProductRec.partNumber = resultSet.getString(1).trim();
                }
                this.defaultWin.setStatus("Exporting " + n);
                ++n;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
        }
        this.defaultWin.setStatus(null);
        return n;
    }

    public StatsExport(AppDefaultWin appDefaultWin, StatsPanel statsPanel, String string, int n) {
        this.filename = string;
        this.outputType = n;
        this.defaultWin = appDefaultWin;
        this.statsPanel = statsPanel;
    }
}

