/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.QuestApplet;
import com.ibm.nzna.projects.qit.app.QuestAppletNotFoundException;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class AppletRec
implements AppConst,
Serializable,
MultiListRow,
MultiListSort {
    static final long serialVersionUID = 1000001L;
    private String className = null;
    private QuestApplet applet = null;

    public String getClassName() {
        return this.className;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QuestApplet createQuestApplet() throws QuestAppletNotFoundException {
        QuestApplet questApplet = null;
        try {
            return (QuestApplet)Class.forName(this.className).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QuestAppletNotFoundException("Cannot Find Quest Applet", this.className);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return questApplet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getColumnData(int n) {
        String string = null;
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            switch (n) {
                case 0: {
                    return this.applet.getSmallIcon();
                }
                case 1: {
                    return this.applet.getName();
                }
                case 2: {
                    return this.applet.getDescription();
                }
            }
            return string;
        }
        catch (QuestAppletNotFoundException questAppletNotFoundException) {
            switch (n) {
                case 0: {
                    return ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 181);
                }
                case 1: {
                    return questAppletNotFoundException.toString();
                }
                case 2: {
                    return "";
                }
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compareTo(MultiListSort multiListSort, int n) {
        AppletRec appletRec = (AppletRec)multiListSort;
        int n2 = 0;
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            switch (n) {
                case 1: {
                    return appletRec.applet.getDescription().compareTo(this.applet.getDescription());
                }
                case 2: {
                    return appletRec.applet.getName().compareTo(this.applet.getName());
                }
            }
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void prepareForSerialization() {
        this.applet = null;
    }

    public boolean equals(Object object) {
        if (object instanceof AppletRec) {
            return ((AppletRec)object).className.equals(this.className);
        }
        if (object instanceof String) {
            return ((String)object).equals(this.className);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            return this.applet.getName();
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageIcon getIcon() {
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            return this.applet.getIcon();
        }
        catch (Exception exception) {
            return ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 181);
        }
    }

    public AppletRec(String string) {
        this.className = string;
    }
}

